/* Newsletter Section */
const data_newsletter = {
    "de":
    {
        "signUpTitle": "Meld dich für den Newsletter an",
        "signUpSubTitle_FirstPart": "Du bekommst E-Mails über unsere neuesten Shop Produkte und ",
        "signUpSubTitle_SecondPart": "tolle Angebote.",
        "signUpFormPlaceholder": "Deine E-Mail-Adresse",
        "signUpButton": "Anmelden",
    },
    "en":
    {
        "signUpTitle": "Sign Up For Newsletters",
        "signUpSubTitle_FirstPart": "Get E-Mail updates about our latest shop products and ",
        "signUpSubTitle_SecondPart": "special offers.",
        "signUpFormPlaceholder": "Your email address",
        "signUpButton": "Sign Up",
    }
}

ready()

function ready() {

    const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
    dropdownLanguage_German.addEventListener('click', ()=> {
        setLanguageGerman_Newsletter()
    });
    
    
    const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
    dropdownLanguage_English.addEventListener('click', ()=> {
        setLanguageEnglish_Newsletter()
    });
    
    
    const languageCookie = getCookie("language");
    if (languageCookie != "") {
    
        if(languageCookie=="DE") {
            setLanguageGerman_Newsletter()
        }
        else {
            setLanguageEnglish_Newsletter()
        }
    }


}

/* Newsletter Section */
function setLanguageGerman_Newsletter() {
    const newsletter = document.querySelector('#newsletter');

    newsletter.querySelector("h4").textContent= data_newsletter.de.signUpTitle;
    newsletter.querySelector("p").innerHTML= data_newsletter.de.signUpSubTitle_FirstPart+'<span>'+data_newsletter.de.signUpSubTitle_SecondPart+'</span>';
    newsletter.querySelector("#language-newsletter-form-input").placeholder= data_newsletter.de.signUpFormPlaceholder;
    newsletter.querySelector("button").textContent= data_newsletter.de.signUpButton;
}

function setLanguageEnglish_Newsletter() {
    const newsletter = document.querySelector('#newsletter');

    newsletter.querySelector("h4").textContent= data_newsletter.en.signUpTitle;
    newsletter.querySelector("p").innerHTML= data_newsletter.en.signUpSubTitle_FirstPart+'<span>'+data_newsletter.en.signUpSubTitle_SecondPart+'</span>';
    newsletter.querySelector("#language-newsletter-form-input").placeholder= data_newsletter.en.signUpFormPlaceholder;
    newsletter.querySelector("button").textContent= data_newsletter.en.signUpButton;
}