const data_general = {
    "de":
    {
        /* Top bar */
        "home": "Startseite",
        "shop": "Shop",
        "about": "Über Uns",
        "contact": "Kontakt",

        /* Menu Bar */
        "menuEditProfile": "Profil bearbeiten",
        "menuSettingsPrivacy": "Einstellung & Privatsphäre",
        "menuHelpSupport": "Hilfe & Support",
        "menuLogout": "Abmelden",


        /* Bottom bar */
        "contact": "Kontakt",
        "contactAddressFirstPart": "Anschrift: ",
        "contactAddressSecondPart": "Kaiserstraße 213, 80801 München, Bayern (BY)",
        "contactPhoneFirstPart": "Telefon: ",
        "contactPhoneSecondPart": "+49 151 6284220",
        "contactAvailableFirstPart": "Erreichbarkeit: ",
        "contactAvailableSecondPart": "10:00-18:00, Montag-Samstag",
        "contactFollowUs": "Folge uns",

        "about": "About",
        "aboutUs": "Über uns",
        "aboutDeliveryInformation": "Lieferbedingungen",
        "aboutPrivacyPolicy": "Datenschutzerklärung",
        "aboutTermsConditions": "Allgemeine Geschäftsbedingungen (AGB)",
        "aboutContactUs": "Uns kontaktieren",

        "myacount": "Mein Account",
        "myacountSignIn": "Anmelden",
        "myacountViewCart": "Warenkorb anzeigen",
        "myacountMyWishlist": "Meine Wunschliste",
        "myacountTrackOrder": "Sprache ändern",
        "myacountHelp": "Hilfe",

        "installApp": "Installiere die App",
        "installAppStore": "Im App Store oder auf Google Play",
        "installSecuredPaymentGateways": "Sichere Bezahlmethoden",

    },
    "en":
    {
        /* Top bar */
        "home": "Home",
        "shop": "Shop",
        "about": "About",
        "contact": "Contact",

        /* Menu Bar */
        "menuEditProfile": "Edit Profile",
        "menuSettingsPrivacy": "Settings & Privacy",
        "menuHelpSupport": "Help & Support",
        "menuLogout": "Sign Out",

        /* Bottom bar */
        "contact": "Contact",
        "contactAddressFirstPart": "Address: ",
        "contactAddressSecondPart": "Kaiserstraße 213, 80801 Munich, Bayern (BY)",
        "contactPhoneFirstPart": "Phone: ",
        "contactPhoneSecondPart": "+01 2222 365 / (+91) 01 2345 6789",
        "contactAvailableFirstPart": "Hours: ",
        "contactAvailableSecondPart": "10:00 - 18:00, Mon - Sat",
        "contactFollowUs": "Follow us",

        "about": "About",
        "aboutUs": "About us",
        "aboutDeliveryInformation": "Delivery Information",
        "aboutPrivacyPolicy": "Privacy Policy",
        "aboutTermsConditions": "Terms & Conditions",
        "aboutContactUs": "Contact Us",

        "myacount": "My Account",
        "myacountSignIn": "Sign In",
        "myacountViewCart": "View Cart",
        "myacountMyWishlist": "My Wishlist",
        "myacountTrackOrder": "Change Language",
        "myacountHelp": "Help",

        "installApp": "Install App",
        "installAppStore": "From App Store or Google Play",
        "installSecuredPaymentGateways": "Secured Payment Gateways",

    }
}


ready();

/*
let subMenuLanguage = document.getElementById("subMenuLanguage");
function toggleMenuLanguage() {
    subMenuLanguage.classList.toggle("open-menu-language")
}

document.addEventListener('click', function(event) {
    // Überprüfen, ob das geklickte Element außerhalb des Menüs liegt
    if (!event.target.closest('#subMenuLanguage') && !event.target.closest('#language-drop-down')) {
        // Menü schließen, wenn es geöffnet ist
        if (subMenuLanguage.classList.contains('open-menu-language')) {
            toggleMenuLanguage();
        }
    }
});
*/





function ready() {
    /* set default language */
    let checkLanguageCookieExist = getCookie("language");
    if (checkLanguageCookieExist == "") {

        setCookie("language", "DE", 1)
    }

    const dropdown = document.getElementById('language-drop-down');

    const chooseLanguage_Text = document.getElementById('user-info-language-text');



    const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
    dropdownLanguage_German.addEventListener('click', ()=> {
        toggleMenuLanguage()

        dropdown.innerHTML='DE <img src="img/language/language_German.png" width="20px" style="border-radius: 2px;"><i class="ri-arrow-drop-down-fill"></i>';

        chooseLanguage_Text.textContent="Wähle Sprache";

        setLanguageGerman_Top()
        setLanguageGerman_MenuBar()
        setLanguageGerman_Bottom()

        setCookie("language", "DE", 1)
    });


    const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
    dropdownLanguage_English.addEventListener('click', ()=> {
        toggleMenuLanguage()

        dropdown.innerHTML='EN <img src="img/language/language_US.png" width="20px" style="border-radius: 2px;"><i class="ri-arrow-drop-down-fill"></i>';

        chooseLanguage_Text.textContent="Select language";

        setLanguageEnglish_Top()
        setLanguageEnglish_MenuBar()
        setLanguageEnglish_Bottom()

        setCookie("language", "EN", 1)
    });


    const languageCookie = getCookie("language");
    if (languageCookie != "") {

        if(languageCookie=="DE") {
            dropdown.innerHTML='DE <img src="img/language/language_German.png" width="20px" style="border-radius: 2px;"><i class="ri-arrow-drop-down-fill"></i>';

            chooseLanguage_Text.textContent="Wähle Sprache";

            setLanguageGerman_Top()
            setLanguageGerman_MenuBar()
            setLanguageGerman_Bottom()
        }
        else {
            dropdown.innerHTML='EN <img src="img/language/language_US.png" width="20px" style="border-radius: 2px;"><i class="ri-arrow-drop-down-fill"></i>';

            chooseLanguage_Text.textContent="Select language";

            setLanguageEnglish_Top()
            setLanguageEnglish_MenuBar()
            setLanguageEnglish_Bottom()
        }
    }
}





function setLanguageGerman_MenuBar() {
    const subMenu = document.querySelector('.sub-menu');

    subMenu.querySelector("#language-edit-profile").textContent= data_general.de.menuEditProfile;
    subMenu.querySelector("#language-settings-privacy").textContent= data_general.de.menuSettingsPrivacy;
    subMenu.querySelector("#language-help-support").textContent= data_general.de.menuHelpSupport;
    subMenu.querySelector("#language-logout").textContent= data_general.de.menuLogout;
}

function setLanguageEnglish_MenuBar() {
    const subMenu = document.querySelector('.sub-menu');

    subMenu.querySelector("#language-edit-profile").textContent= data_general.en.menuEditProfile;
    subMenu.querySelector("#language-settings-privacy").textContent= data_general.en.menuSettingsPrivacy;
    subMenu.querySelector("#language-help-support").textContent= data_general.en.menuHelpSupport;
    subMenu.querySelector("#language-logout").textContent= data_general.en.menuLogout;
}






function setLanguageGerman_Top() {
    const navbar = document.querySelector('#navbar');

    navbar.querySelector("#language_home").textContent= data_general.de.home;
    navbar.querySelector("#language_shop").textContent= data_general.de.shop;
    navbar.querySelector("#language_about").textContent= data_general.de.about;
    navbar.querySelector("#language_contact").textContent= data_general.de.contact;

    //document.getElementById("language_home").innerHTML= data.de.home;
}

function setLanguageEnglish_Top() {
    const navbar = document.querySelector('#navbar');

    navbar.querySelector("#language_home").textContent= data_general.en.home;
    navbar.querySelector("#language_shop").textContent= data_general.en.shop;
    navbar.querySelector("#language_about").textContent= data_general.en.about;
    navbar.querySelector("#language_contact").textContent= data_general.en.contact;
}

function setLanguageGerman_Bottom() {
    const footerbar = document.querySelector('#language-footer');

    footerbar.querySelector("#language-contact").textContent= data_general.de.contact;
    footerbar.querySelector("#language-contact-address").innerHTML= '<strong>'+data_general.de.contactAddressFirstPart+'</strong>'+data_general.de.contactAddressSecondPart;
    footerbar.querySelector("#language-contact-phone").innerHTML= '<strong>'+data_general.de.contactPhoneFirstPart+'</strong>'+data_general.de.contactPhoneSecondPart;
    footerbar.querySelector("#language-contact-available").innerHTML= '<strong>'+data_general.de.contactAvailableFirstPart+'</strong>'+data_general.de.contactAvailableSecondPart;
    footerbar.querySelector("#language-contact-follow-us").textContent= data_general.de.contactFollowUs;

    footerbar.querySelector("#language-about").textContent= data_general.de.about;
    footerbar.querySelector("#language-about-us").textContent= data_general.de.aboutUs;
    footerbar.querySelector("#language-about-delivery-information").textContent= data_general.de.aboutDeliveryInformation;
    footerbar.querySelector("#language-about-privacy-policy").textContent= data_general.de.aboutPrivacyPolicy;
    footerbar.querySelector("#language-about-terms-conditions").textContent= data_general.de.aboutTermsConditions;
    footerbar.querySelector("#language-about-contact-us").textContent= data_general.de.aboutContactUs;

    footerbar.querySelector("#language-myacount").textContent= data_general.de.myacount;
    footerbar.querySelector("#language-myacount-sign-in").textContent= data_general.de.myacountSignIn;
    footerbar.querySelector("#language-myacount-view-cart").textContent= data_general.de.myacountViewCart;
    footerbar.querySelector("#language-myacount-my-wishlist").textContent= data_general.de.myacountMyWishlist;
    footerbar.querySelector("#language-myacount-track-order").textContent= data_general.de.myacountTrackOrder;
    footerbar.querySelector("#language-myacount-help").textContent= data_general.de.myacountHelp;

    footerbar.querySelector("#language-install-app").textContent= data_general.de.installApp;
    footerbar.querySelector("#language-install-app-store").textContent= data_general.de.installAppStore;
    footerbar.querySelector("#language-install-secured-payment-gateways").textContent= data_general.de.installSecuredPaymentGateways;
}

function setLanguageEnglish_Bottom() {
    const footerbar = document.querySelector('#language-footer');

    footerbar.querySelector("#language-contact").textContent= data_general.en.contact;
    footerbar.querySelector("#language-contact-address").innerHTML= '<strong>'+data_general.en.contactAddressFirstPart+'</strong>'+data_general.de.contactAddressSecondPart;
    footerbar.querySelector("#language-contact-phone").innerHTML= '<strong>'+data_general.en.contactPhoneFirstPart+'</strong>'+data_general.de.contactPhoneSecondPart;
    footerbar.querySelector("#language-contact-available").innerHTML= '<strong>'+data_general.en.contactAvailableFirstPart+'</strong>'+data_general.de.contactAvailableSecondPart;
    footerbar.querySelector("#language-contact-follow-us").textContent= data_general.en.contactFollowUs;

    footerbar.querySelector("#language-about").textContent= data_general.en.about;
    footerbar.querySelector("#language-about-us").textContent= data_general.en.aboutUs;
    footerbar.querySelector("#language-about-delivery-information").textContent= data_general.en.aboutDeliveryInformation;
    footerbar.querySelector("#language-about-privacy-policy").textContent= data_general.en.aboutPrivacyPolicy;
    footerbar.querySelector("#language-about-terms-conditions").textContent= data_general.en.aboutTermsConditions;
    footerbar.querySelector("#language-about-contact-us").textContent= data_general.en.aboutContactUs;

    footerbar.querySelector("#language-myacount").textContent= data_general.en.myacount;
    footerbar.querySelector("#language-myacount-sign-in").textContent= data_general.en.myacountSignIn;
    footerbar.querySelector("#language-myacount-view-cart").textContent= data_general.en.myacountViewCart;
    footerbar.querySelector("#language-myacount-my-wishlist").textContent= data_general.en.myacountMyWishlist;
    footerbar.querySelector("#language-myacount-track-order").textContent= data_general.en.myacountTrackOrder;
    footerbar.querySelector("#language-myacount-help").textContent= data_general.en.myacountHelp;

    footerbar.querySelector("#language-install-app").textContent= data_general.en.installApp;
    footerbar.querySelector("#language-install-app-store").textContent= data_general.en.installAppStore;
    footerbar.querySelector("#language-install-secured-payment-gateways").textContent= data_general.en.installSecuredPaymentGateways;
}