const data_coupon = {
    "de":
    {
        "languageLoginHeader": "Anmelden",
        "languageLoginEmailaddress": "E-Mail-Adresse",
        "languageLoginPassword": "Passwort",
        "languageLoginbutton": "Anmelden",

        "languageLoginErrorEmailAndPassword": "Gib deine E-Mail-Adresse und Passwort ein.",
        "languageLoginErrorEmail": "Gib deine E-Mail-Adresse ein.",
        "languageLoginErrorEmailValid": "Gib eine gültige E-Mail-Adresse ein.",
        "languageLoginErrorPassword": "Gib dein Passwort ein.",
        "languageLoginErrorWrongPassword": "Falsches Passwort.",

        /* Hero Element */
        "heroFirstHeader": "Fashion Woche auf Smart Buy Online",
        "heroSecondHeader": "Finde dein perfektes Outfit",
        "heroThirdHeader": "KI unterstützte Auswahl",
        "heroFourthHeader": "Bis zu 25% Rabatt!",
        "heroButton": "Zum Shop",

        "heroCouponFirstHeader": "Hol dir deinen persönlichen",
        "heroCouponSecondHeader": "50 € Gutschein-Code",
        "heroCouponThirdHeader": "Melde dich an, um deinen persönlichen Gutscheincode zu bekommen. Nur heute gültig.",

        
        /* Sweet Alert Messages */
        "sweetAlert_LoggedInSuccessfully": "Gutscheincode erfolgreich eingelöst!<br><span style='font-size: 14px;'>Du kannst den <b>angezeigten Gutscheincode</b> im <b>Einkaufswagen <b>einlösen</b>.</span>",
    
    },
    "en":
    {
        "languageLoginHeader": "Login",
        "languageLoginEmailaddress": "Email",
        "languageLoginPassword": "Password",
        "languageLoginbutton": "Login",

        "languageLoginErrorEmailAndPassword": "Enter email address and password.",
        "languageLoginErrorEmail": "Enter email address.",
        "languageLoginErrorEmailValid": "Enter a valid email address.",
        "languageLoginErrorPassword": "Enter your password.",
        "languageLoginErrorWrongPassword": "Wrong password.",

        /* Hero Element */
        "heroFirstHeader": "Fashion week on Smart Buy Online",
        "heroSecondHeader": "Find your perfect Outfit",
        "heroThirdHeader": "Selection assisted by AI",
        "heroFourthHeader": "Save up to 25% off!",
        "heroButton": "Shop now",


        "heroCouponFirstHeader": "Get your personal",
        "heroCouponSecondHeader": "50 € Gift Card",
        "heroCouponThirdHeader": "Login to claim your individual gift card, valid for today only!",

        /* Sweet Alert Messages */
        "sweetAlert_LoggedInSuccessfully": "Coupon code successfully redeemed!<br><span style='font-size: 14px;'>You can use the <b>displayed coupon</b> code in the <b>shopping cart</b>.</span>",
        
    }
}

const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
dropdownLanguage_German.addEventListener('click', ()=> {

    setLanguageGerman_Hero_Coupon()

    setLanguageGerman_LoginPopup_Coupon()

});


const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
dropdownLanguage_English.addEventListener('click', ()=> {

    setLanguageEnglish_Hero_Coupon()

    setLanguageEnglish_LoginPopup_Coupon()

});


const languageCookie = getCookie("language");
if (languageCookie != "") {

    if(languageCookie=="DE") {

        setLanguageGerman_Hero_Coupon()

        setLanguageGerman_LoginPopup_Coupon()
    }
    else {

        setLanguageEnglish_Hero_Coupon()

        setLanguageEnglish_LoginPopup_Coupon()
    }
}

/* Hero Element */
function setLanguageGerman_Hero_Coupon() {

    const hero = document.querySelector("#hero");
    if(hero) {
        hero.querySelector('h4').textContent = data_coupon.de.heroFirstHeader;
        hero.querySelector('h2').textContent = data_coupon.de.heroSecondHeader;
        hero.querySelector('h1').textContent = data_coupon.de.heroThirdHeader;
        hero.querySelector('p').textContent = data_coupon.de.heroFourthHeader;
        hero.querySelector('button').textContent = data_coupon.de.heroButton;
    }

    const hero_coupon = document.querySelector("#hero_coupon");
    if(hero_coupon) {
        // Default
        hero_coupon.querySelector('h2').textContent = data_coupon.de.heroCouponFirstHeader;
        hero_coupon.querySelector('h1').textContent = data_coupon.de.heroCouponSecondHeader;

        if(hero_coupon.querySelector('p')) {
            hero_coupon.querySelector('p').textContent = data_coupon.de.heroCouponThirdHeader;
        }  
        if(hero_coupon.querySelector('h4')) {
            hero_coupon.querySelector('h4').textContent = `Dein Gutschein-Code:`;
        }  
    }

}

function setLanguageEnglish_Hero_Coupon() {

    const hero = document.querySelector("#hero");

    if(hero) {
        hero.querySelector('h4').textContent = data_coupon.en.heroFirstHeader;
        hero.querySelector('h2').textContent = data_coupon.en.heroSecondHeader;
        hero.querySelector('h1').textContent = data_coupon.en.heroThirdHeader;
        hero.querySelector('p').textContent = data_coupon.en.heroFourthHeader;
        hero.querySelector('button').textContent = data_coupon.en.heroButton;
    }

    const hero_coupon = document.querySelector("#hero_coupon");
    if(hero_coupon) {
        // Default (h2, h1, p)
        hero_coupon.querySelector('h2').textContent = data_coupon.en.heroCouponFirstHeader;
        hero_coupon.querySelector('h1').textContent = data_coupon.en.heroCouponSecondHeader;

        if(hero_coupon.querySelector('p')) {
            hero_coupon.querySelector('p').textContent = data_coupon.en.heroCouponThirdHeader;
        }
        if(hero_coupon.querySelector('h4')) {
            hero_coupon.querySelector('h4').textContent = `Your Coupon Code:`;
        }  
    }
}

function setLanguageGerman_LoginPopup_Coupon() {

    const loginPopup = document.querySelector('#login-page');
    if(document.body.contains(loginPopup)) {

        /* Login Popup */
        loginPopup.querySelector("#language-login-header").textContent= data_coupon.de.languageLoginHeader;
        loginPopup.querySelector("#language-login-emailaddress").textContent= data_coupon.de.languageLoginEmailaddress;
        loginPopup.querySelector("#language-login-password").textContent= data_coupon.de.languageLoginPassword;
        loginPopup.querySelector("#login-btn").textContent= data_coupon.de.languageLoginbutton;   
    }
}

function setLanguageEnglish_LoginPopup_Coupon() {
    
    const loginPopup = document.querySelector('#login-page');
    if(document.body.contains(loginPopup)) {

        /* Login Popup */
        loginPopup.querySelector("#language-login-header").textContent= data_coupon.en.languageLoginHeader;
        loginPopup.querySelector("#language-login-emailaddress").textContent= data_coupon.en.languageLoginEmailaddress;
        loginPopup.querySelector("#language-login-password").textContent= data_coupon.en.languageLoginPassword;
        loginPopup.querySelector("#login-btn").textContent= data_coupon.en.languageLoginbutton;
    }
}