const data_contact = {
    "de":
    {
        /* Header Element*/
        "headerText": "#let's_talk",
        "headerSubText": "Lass uns eine Nachricht da. Wir freuen uns von dir zu hören!",

        "contactHeader": "Besuch unseren Flagship Store oder kontaktier uns online",
        "contactSubHeader": "Flagship Store",
        "contactAddress": "Kaiserstraße 213, 80801 München, Bayern (BY)",
        "contactEmail": "support@smartbuyonline.de",
        "contactAvailability": "Montag bis Samstag: 9:00 - 16.00 Uhr",

        "contactFormHeader": "Schreib uns eine Nachricht",
        "contactFormSubHeader": "Wir freuen uns von dir zu hören",
        "contactFormPlaceholderName": "Dein Name",
        "contactFormPlaceholderEmail": "E-Mail",
        "contactFormPlaceholderSubject": "Betreff",
        "contactFormPlaceholderMessage": "Deine Nachricht",
        "contactFormSubmitButton": "Abschicken",


    },
    "en":
    {
        /* Header Element */
        "headerText": "#let's_talk",
        "headerSubText": "Leave a message. We love to hear from you!",

        "contactHeader": "Visit our flagship store or contact us online",
        "contactSubHeader": "Flagship Store",
        "contactAddress": "Kaiserstraße 213, 80801 Munich, Bayern (BY)",
        "contactEmail": "support@smartbuyonline.de",
        "contactAvailability": "Monday to Saturday: 9.00am - 16.00pm",

        "contactFormHeader": "LEAVE A MESSAGE",
        "contactFormSubHeader": "We love to hear from you",
        "contactFormPlaceholderName": "Your Name",
        "contactFormPlaceholderEmail": "Email",
        "contactFormPlaceholderSubject": "Subject",
        "contactFormPlaceholderMessage": "Your Message",
        "contactFormSubmitButton": "Submit",
    }
}

const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
dropdownLanguage_German.addEventListener('click', ()=> {

    setLanguageGerman_Header()
    setLanguageGerman_Contact()
    setLanguageGerman_Form()
});


const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
dropdownLanguage_English.addEventListener('click', ()=> {

    setLanguageEnglish_Header()
    setLanguageEnglish_Contact()
    setLanguageEnglish_Form()
});


const languageCookie = getCookie("language");
if (languageCookie != "") {

    if(languageCookie=="DE") {
        setLanguageGerman_Header()
        setLanguageGerman_Contact()
        setLanguageGerman_Form()
    }
    else {
        setLanguageEnglish_Header()
        setLanguageEnglish_Contact()
        setLanguageEnglish_Form()
    }
}

/* Header Section */
function setLanguageGerman_Header() {
    const header = document.querySelector(".about-header");

    header.querySelector('h2').textContent = data_contact.de.headerText;
    header.querySelector('p').innerHTML = data_contact.de.headerSubText;
}
function setLanguageEnglish_Header() {
    const header = document.querySelector(".about-header");

    header.querySelector('h2').textContent = data_contact.en.headerText;
    header.querySelector('p').innerHTML = data_contact.en.headerSubText;
}

/* Contact Section */
function setLanguageGerman_Contact() {
    const contact = document.querySelector("#contact-details");

    contact.querySelector('h2').textContent = data_contact.de.contactHeader;
    contact.querySelector('h3').textContent = data_contact.de.contactSubHeader;
    contact.querySelector('#language-contact-address').textContent = data_contact.de.contactAddress;
    contact.querySelector('#language-contact-email').textContent = data_contact.de.contactEmail;
    contact.querySelector('#language-contact-available').textContent = data_contact.de.contactAvailability;

    document.querySelector('#first-contact-person').innerHTML = "<span>Max Fischer</span> Head of Marketing <br> Telefon: + 49 (0) 9484 3012 75 <br> E-Mail: contact@smartbuyonline.de";
    document.querySelector('#second-contact-person').innerHTML = "<span>Leonie Becker</span> E-Commerce Manager <br> Telefon: + 49 (0) 9484 3012 76 <br> E-Mail: contact@smartbuyonline.de";

}
function setLanguageEnglish_Contact() {
    const contact = document.querySelector("#contact-details");

    contact.querySelector('h2').textContent = data_contact.en.contactHeader;
    contact.querySelector('h3').textContent = data_contact.en.contactSubHeader;
    contact.querySelector('#language-contact-address').textContent = data_contact.en.contactAddress;
    contact.querySelector('#language-contact-email').textContent = data_contact.en.contactEmail;
    contact.querySelector('#language-contact-available').textContent = data_contact.en.contactAvailability;

    document.querySelector('#first-contact-person').innerHTML = "<span>Max Fischer</span> Head of Marketing <br> Phone: + 49 (0) 9484 3012 75 <br> Email: contact@smartbuyonline.de";
    document.querySelector('#second-contact-person').innerHTML = "<span>Leonie Becker</span> E-Commerce Manager <br> Phone: + 49 (0) 9484 3012 76 <br> Email: contact@smartbuyonline.de";

}

/* Form Section */
function setLanguageGerman_Form() {
    const contactform = document.querySelector("#form-details");

    contactform.querySelector('#language-contact-form-header').textContent = data_contact.de.contactFormHeader;
    contactform.querySelector('#language-contact-form-subheader').textContent = data_contact.de.contactFormSubHeader;
    contactform.querySelector('#language-contact-form-name').placeholder = data_contact.de.contactFormPlaceholderName;
    contactform.querySelector('#language-contact-form-email').placeholder = data_contact.de.contactFormPlaceholderEmail;
    contactform.querySelector('#language-contact-form-subject').placeholder = data_contact.de.contactFormPlaceholderSubject;
    contactform.querySelector('#language-contact-form-message').placeholder = data_contact.de.contactFormPlaceholderMessage;
    contactform.querySelector('#language-contact-form-submit-btn').textContent = data_contact.de.contactFormSubmitButton;
}
function setLanguageEnglish_Form() {
    const contactform = document.querySelector("#form-details");

    contactform.querySelector('#language-contact-form-header').textContent = data_contact.en.contactFormHeader;
    contactform.querySelector('#language-contact-form-subheader').textContent = data_contact.en.contactFormSubHeader;
    contactform.querySelector('#language-contact-form-name').placeholder = data_contact.en.contactFormPlaceholderName;
    contactform.querySelector('#language-contact-form-email').placeholder = data_contact.en.contactFormPlaceholderEmail;
    contactform.querySelector('#language-contact-form-subject').placeholder = data_contact.en.contactFormPlaceholderSubject;
    contactform.querySelector('#language-contact-form-message').placeholder = data_contact.en.contactFormPlaceholderMessage;
    contactform.querySelector('#language-contact-form-submit-btn').textContent = data_contact.en.contactFormSubmitButton;
}