/* Order Section */
const data_cart= {
    "de":
    {
        "cartBannerTitle": "Dein Einkaufswagen",
        "cartBannerSubTitle": "Gib noch heute deine Bestellung auf!",

        "cartOrderTitle": "Meine kürzlichen Bestellungen",
        "cartOrderDate": "BESTELLDATUM",
        "cartOrderNumbr": "BESTELLNUMMER",
        "cartOrderProductName": "PRODUKT",
        "cartOrderProductQuantity": "MENGE",
        "cartOrderPriceTotal": "SUMME",
        "cartOrderShowAllOrders": "Zeige alle Bestellungen",
        "cartOrderMessageEmptyOrderCart": "Du hast kürzlich keine Artikel bestellt.",
        

        "cartProductRemove": "Löschen",
        "cartProductImage": "Artikelbild",
        "cartProductName": "Artikel",
        "cartProductPrice": "Preis",
        "cartProductQuantity": "Menge",
        "cartProductSubtotal": "Zwischensumme",
        "cartMessageEmptyShoppingCart": "Dein SmartBuyOnline-Einkaufswagen ist noch leer.",

        "cartCouponTitle": "Gutschein einlösen",
        "cartCouponFormPlaceholder": "Gutscheincode eingeben",
        "cartCouponApply": "Einlösen",

        "cartTotalsTitle": "Bestellübersicht",
        "cartTotalsSubtotal": "Zwischensumme",
        "cartTotalsShipping": "Verpackung & Versand (2-3 Tage)",
        "cartTotalsShippingFree": "Kostenlos",
        "cartTotalsTotal": "Gesamtbetrag",
        "cartTotalsCoupon": "Eingelöster Gutschein (Rabatt)",
        "cartTotalsProceedCheckout": "Bestellung abschließen",

        /* Sweet Alert */
        "sweetAlert_OrderConfirmationTitle": "Bestellung bestätigen",
        "sweetAlert_OrderConfirmation": "Bitte bestätige, dass du deine Bestellung abschicken willst.",
        "sweetAlert_OrderConfirmationConfirmBtn": "Bestellung abschicken",
        "sweetAlert_OrderConfirmationCancelBtn": "Abbrechen",

        "sweetAlert_OrderSuccessfullySubmitted": "Bestellung abgeschickt!",

        "sweetAlert_MessageEmptyShoppingCart": "Dein Einkaufswagen ist noch leer!",

        "sweetAlert_RegisterLoginToContinue": "Bitte registrier dich zunächst oder logge dich ein, um mit deiner Bestellung fortzufahren!",

        "sweetAlert_CouponActivatedConfirmation": "Gutscheincode Aktiviert!",
        "sweetAlert_CouponAlreadyActivated": "Gutscheincode wurde bereits genutzt.",
        "sweetAlert_CouponInvalid": "Gutscheincode ungültig!",
    },
    "en":
    {
        "cartBannerTitle": "Your shopping cart",
        "cartBannerSubTitle": "Place your first orders right now!",

        "cartOrderTitle": "My recent Orders",
        "cartOrderDate": "ORDER DATE",
        "cartOrderNumbr": "ORDER #",
        "cartOrderProductName": "PRODUCT",
        "cartOrderProductQuantity": "QUANTITY",
        "cartOrderPriceTotal": "SUBTOTAL",
        "cartOrderShowAllOrders": "Show all orders",
        "cartOrderMessageEmptyOrderCart": "You haven't ordered any articles recently.",

        "cartProductRemove": "Remove",
        "cartProductImage": "Image",
        "cartProductName": "Product",
        "cartProductPrice": "Price",
        "cartProductQuantity": "Quantity",
        "cartProductSubtotal": "Subtotal",
        "cartMessageEmptyShoppingCart": "Your SmartBuyOnline shopping cart is empty.",

        "cartCouponTitle": "Apply voucher",
        "cartCouponFormPlaceholder": "Enter voucher code",
        "cartCouponApply": "Apply",

        "cartTotalsTitle": "Order Summary",
        "cartTotalsSubtotal": "Subtotal",
        "cartTotalsShipping": "Postage & Packing (2-3 days)",
        "cartTotalsShippingFree": "Free",
        "cartTotalsTotal": "Order Total",
        "cartTotalsCoupon": "Redeemed voucher (discount)",
        "cartTotalsProceedCheckout": "Proceed to checkout",

        /* Sweet Alert */
        "sweetAlert_OrderConfirmationTitle": "Confirm order",
        "sweetAlert_OrderConfirmation": "Please confirm that you want to submit your order.",
        "sweetAlert_OrderConfirmationConfirmBtn": "Submit order",
        "sweetAlert_OrderConfirmationCancelBtn": "Cancel",

        "sweetAlert_OrderSuccessfullySubmitted": "Order submitted!",

        "sweetAlert_MessageEmptyShoppingCart": "Your shopping cart is still empty!",

        "sweetAlert_RegisterLoginToContinue": "Please register or log in first to proceed with your order!",

        "sweetAlert_CouponActivatedConfirmation": "Coupon Activated!",
        "sweetAlert_CouponAlreadyActivated": "Coupon has already been redeemed.",
        "sweetAlert_CouponInvalid": "Coupon Invalid!",


    }
}

ready()

function ready() {

    const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
    dropdownLanguage_German.addEventListener('click', ()=> {
        setLanguageGerman_CartBanner()
        setLanguageGerman_CartOrderTable()
        setLanguageGerman_CartTable()
        setLanguageGerman_CartCoupon()
        setLanguageGerman_CartTotals()
    });
    
    
    const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
    dropdownLanguage_English.addEventListener('click', ()=> {
        setLanguageEnglish_CartBanner()
        setLanguageEnglish_CartOrderTable()
        setLanguageEnglish_CartTable()
        setLanguageEnglish_CartCoupon()
        setLanguageEnglish_CartTotals()
    });
    
    
    const languageCookie = getCookie("language");
    if (languageCookie != "") {
    
        if(languageCookie=="DE") {
            setLanguageGerman_CartBanner()
            setLanguageGerman_CartOrderTable()
            setLanguageGerman_CartTable()
            setLanguageGerman_CartCoupon()
            setLanguageGerman_CartTotals()
        }
        else {
            setLanguageEnglish_CartBanner()
            setLanguageEnglish_CartOrderTable()
            setLanguageEnglish_CartTable()
            setLanguageEnglish_CartCoupon()
            setLanguageEnglish_CartTotals()
        }
    }


}


/*** Order Banner ***/
function setLanguageGerman_CartBanner() {
    const cartBanner = document.querySelector('#page-header');

    cartBanner.querySelector("h2").textContent= data_cart.de.cartBannerTitle;
    cartBanner.querySelector("p").textContent= data_cart.de.cartBannerSubTitle;



}
function setLanguageEnglish_CartBanner() {
    const cartBanner = document.querySelector('#page-header');

    cartBanner.querySelector("h2").textContent= data_cart.en.cartBannerTitle;
    cartBanner.querySelector("p").textContent= data_cart.en.cartBannerSubTitle;



}

/*** Order Table ***/
function setLanguageGerman_CartOrderTable() {
    const cartOrderTable = document.querySelector('.language-cart-order');

    cartOrderTable.querySelector("h3").textContent= data_cart.de.cartOrderTitle;
    cartOrderTable.querySelector("#language-order-date").textContent= data_cart.de.cartOrderDate;
    cartOrderTable.querySelector("#language-order-number").textContent= data_cart.de.cartOrderNumbr;
    cartOrderTable.querySelector("#language-order-productitem").textContent= data_cart.de.cartOrderProductName;
    cartOrderTable.querySelector("#language-order-productquantity").textContent= data_cart.de.cartOrderProductQuantity;
    cartOrderTable.querySelector("#language-order-pricetotal").textContent= data_cart.de.cartOrderPriceTotal;
    cartOrderTable.querySelector("#show-all-orders-page").textContent= data_cart.de.cartOrderShowAllOrders;
    

    document.querySelector('.show-message-empty-order-list').textContent= data_cart.de.cartOrderMessageEmptyOrderCart;
}
function setLanguageEnglish_CartOrderTable() {
    const cartOrderTable = document.querySelector('.language-cart-order');

    cartOrderTable.querySelector("h3").textContent= data_cart.en.cartOrderTitle;
    cartOrderTable.querySelector("#language-order-date").textContent= data_cart.en.cartOrderDate;
    cartOrderTable.querySelector("#language-order-number").textContent= data_cart.en.cartOrderNumbr;
    cartOrderTable.querySelector("#language-order-productitem").textContent= data_cart.en.cartOrderProductName;
    cartOrderTable.querySelector("#language-order-productquantity").textContent= data_cart.en.cartOrderProductQuantity;
    cartOrderTable.querySelector("#language-order-pricetotal").textContent= data_cart.en.cartOrderPriceTotal;
    cartOrderTable.querySelector("#show-all-orders-page").textContent= data_cart.en.cartOrderShowAllOrders;

    document.querySelector('.show-message-empty-order-list').textContent= data_cart.en.cartOrderMessageEmptyOrderCart;
}

/*** Cart Table ***/
function setLanguageGerman_CartTable() {
    const cartOrderTable = document.querySelector('#cart');

    cartOrderTable.querySelector("#language-cart-remove").textContent= data_cart.de.cartProductRemove;
    cartOrderTable.querySelector("#language-cart-image").textContent= data_cart.de.cartProductImage;
    cartOrderTable.querySelector("#language-cart-productname").textContent= data_cart.de.cartProductName;
    cartOrderTable.querySelector("#language-cart-productprice").textContent= data_cart.de.cartProductPrice;
    cartOrderTable.querySelector("#language-cart-productquantity").textContent= data_cart.de.cartProductQuantity;
    cartOrderTable.querySelector("#language-cart-pricesubtotal").textContent= data_cart.de.cartProductSubtotal;

    document.querySelector('.show-message-empty-shopping-basket').textContent= data_cart.de.cartMessageEmptyShoppingCart;
}

function setLanguageEnglish_CartTable() {
    const cartOrderTable = document.querySelector('#cart');

    cartOrderTable.querySelector("#language-cart-remove").textContent= data_cart.en.cartProductRemove;
    cartOrderTable.querySelector("#language-cart-image").textContent= data_cart.en.cartProductImage;
    cartOrderTable.querySelector("#language-cart-productname").textContent= data_cart.en.cartProductName;
    cartOrderTable.querySelector("#language-cart-productprice").textContent= data_cart.en.cartProductPrice;
    cartOrderTable.querySelector("#language-cart-productquantity").textContent= data_cart.en.cartProductQuantity;
    cartOrderTable.querySelector("#language-cart-pricesubtotal").textContent= data_cart.en.cartProductSubtotal;

    document.querySelector('.show-message-empty-shopping-basket').textContent= data_cart.en.cartMessageEmptyShoppingCart;
}

/*** Coupon ***/
function setLanguageGerman_CartCoupon() {
    const cartCoupon = document.querySelector('.language-coupon');

    cartCoupon.querySelector("h3").textContent= data_cart.de.cartCouponTitle;
    cartCoupon.querySelector("#language-cart-coupon-input").placeholder= data_cart.de.cartCouponFormPlaceholder;
    cartCoupon.querySelector("#language-cart-coupon-btn").textContent= data_cart.de.cartCouponApply;
}

function setLanguageEnglish_CartCoupon() {
    const cartCoupon = document.querySelector('.language-coupon');

    cartCoupon.querySelector("h3").textContent= data_cart.en.cartCouponTitle;
    cartCoupon.querySelector("#language-cart-coupon-input").placeholder= data_cart.en.cartCouponFormPlaceholder;
    cartCoupon.querySelector("#language-cart-coupon-btn").textContent= data_cart.en.cartCouponApply;
}

/*** Cart Totals ***/
function setLanguageGerman_CartTotals() {
    const cartTotals = document.querySelector('#subtotal');

    cartTotals.querySelector("h3").textContent= data_cart.de.cartTotalsTitle;
    cartTotals.querySelector("#language-cart-totals-subtotal").textContent= data_cart.de.cartTotalsSubtotal;
    cartTotals.querySelector("#language-cart-totals-shipping").textContent= data_cart.de.cartTotalsShipping;
    cartTotals.querySelector("#language-cart-totals-shipping-free").textContent= data_cart.de.cartTotalsShippingFree;
    cartTotals.querySelector("#language-cart-totals-coupon").textContent= data_cart.de.cartTotalsCoupon;
    cartTotals.querySelector("#language-cart-totals-total").textContent= data_cart.de.cartTotalsTotal;
    cartTotals.querySelector("#proceed-checkout").textContent= data_cart.de.cartTotalsProceedCheckout;
}

function setLanguageEnglish_CartTotals() {
    const cartTotals = document.querySelector('#subtotal');

    cartTotals.querySelector("h3").textContent= data_cart.en.cartTotalsTitle;
    cartTotals.querySelector("#language-cart-totals-subtotal").textContent= data_cart.en.cartTotalsSubtotal;
    cartTotals.querySelector("#language-cart-totals-shipping").textContent= data_cart.en.cartTotalsShipping;
    cartTotals.querySelector("#language-cart-totals-shipping-free").textContent= data_cart.en.cartTotalsShippingFree;
    cartTotals.querySelector("#language-cart-totals-coupon").textContent= data_cart.en.cartTotalsCoupon;
    cartTotals.querySelector("#language-cart-totals-total").textContent= data_cart.en.cartTotalsTotal;
    cartTotals.querySelector("#proceed-checkout").textContent= data_cart.en.cartTotalsProceedCheckout;
}