const data_about = {
    "de":
    {
        /* Feature Element*/
        "feature_1": "Unkomplizierte Bestellung",
        "feature_2": "Schnelle Lieferung<br>(1-2 Tage)",
        "feature_3": "Umweltbewusstsein",
        "feature_4": "Über 99.9% zufriedene Kunden",
        "feature_5": "Hochwertige Produkte",
        "feature_6": "24/7 Kundensupport",

        /* Head Section */
        "head_TopTitle": "Lern uns besser kennen",
        "head_Title": "Wer sind wir?",
        "head_Text": "Wir, das SmartBuyOnline-Team, haben uns zur Aufgabe gemacht einen kleinen Online Shop mit nachhaltigen Lieferketten und fairen Preisen zu betreiben. Wir versuchen dabei unser kleines Sortiment an Artikeln und Produkt-Kategorien stets zu erweitern.<br>Bei uns steht Umweltbewusstsein und nachhaltiger Versand unserer Produkte ganz oben. Dies erreichen wir durch unsere zu 100\% recykelten und schad-sowie plastikfreien Versandverpackungen und unsere CO2-neutralen Versandpartner.<br>Darüber hinaus steht bei uns der Kundensupport an erster Stelle. Solltest du doch mal mit einem unserer Produkte unzufrieden sein oder einfach Fragen zu einem unserer Produkte haben, geben wir dir unser Versprechen innerhalb von weniger als 24 Stunden bestmöglichst alle deine Fragen zu beantworten.",
        "head_SubText": "Vielen Dank für dein Vertrauen und deinen Einkauf auf SmartBuyOnline.de",
    },
    "en":
    {
        /* Feature Element */
        "feature_1": "Hassle-Free Order",
        "feature_2": "Fast Delivery<br>(1-2 days)",
        "feature_3": "Environmental Awareness",
        "feature_4": "Over 99.9% Satisfied Customers",
        "feature_5": "Superior Products",
        "feature_6": "24/7 Support",

        /* Head Section */
        "head_Title": "Who are we?",
        "head_TopTitle": "Get to know us better.",
        "head_Text": "We, the SmartBuyOnline team, have set ourselves the goal of operating a small online shop with sustainable supply chains and fair prices. We strive to constantly expand our small range of items and product categories.<br>Environmental awareness and sustainable shipping of our products are our top priorities. We achieve this through our 100\% recycled and non-toxic, plastic-free shipping packaging and our CO2-neutral shipping partners.<br>Additionally, customer support is paramount to us. If you are ever dissatisfied with one of our products or simply have questions about one of our products, we promise to respond to all your inquiries as best as possible within less than 24 hours.",
        "head_SubText": "Thank you for your trust and for shopping on SmartBuyOnline.de!",
    }
}

const dropdownLanguage_German = document.getElementById('sub-menu-language-link-id-german');
dropdownLanguage_German.addEventListener('click', ()=> {

    setLanguageGerman_Feature()
    setLanguageGerman_HeadText()
});


const dropdownLanguage_English = document.getElementById('sub-menu-language-link-id-english');
dropdownLanguage_English.addEventListener('click', ()=> {

    setLanguageEnglish_Feature()
    setLanguageEnglish_HeadText()
});


const languageCookie = getCookie("language");
if (languageCookie != "") {

    if(languageCookie=="DE") {
        setLanguageGerman_Feature()
        setLanguageGerman_HeadText()
    }
    else {
        setLanguageEnglish_Feature()
        setLanguageEnglish_HeadText()
    }
}

/* Feature Element */
function setLanguageGerman_Feature() {
    const feature = document.querySelector("#feature");
    
    feature.querySelector('#feature_1').textContent = data_about.de.feature_1;
    feature.querySelector('#feature_2').innerHTML = data_about.de.feature_2;
    feature.querySelector('#feature_3').textContent = data_about.de.feature_3;
    feature.querySelector('#feature_4').textContent = data_about.de.feature_4;
    feature.querySelector('#feature_5').textContent = data_about.de.feature_5;
    feature.querySelector('#feature_6').textContent = data_about.de.feature_6;
}
function setLanguageEnglish_Feature() {
    const feature = document.querySelector("#feature");

    feature.querySelector('#feature_1').textContent = data_about.en.feature_1;
    feature.querySelector('#feature_2').innerHTML = data_about.en.feature_2;
    feature.querySelector('#feature_3').textContent = data_about.en.feature_3;
    feature.querySelector('#feature_4').textContent = data_about.en.feature_4;
    feature.querySelector('#feature_5').textContent = data_about.en.feature_5;
    feature.querySelector('#feature_6').textContent = data_about.en.feature_6;
}


/* Who we are Section */
function setLanguageGerman_HeadText() {

    document.querySelector('#language-about-knowus').textContent = data_about.de.head_TopTitle;

    const headText = document.querySelector("#about-head");

    headText.querySelector('h2').textContent = data_about.de.head_Title;
    headText.querySelector('p').innerHTML = data_about.de.head_Text;
    headText.querySelector('#language-about-subtext').textContent = data_about.de.head_SubText;
}

function setLanguageEnglish_HeadText() {

    document.querySelector('#language-about-knowus').textContent = data_about.en.head_TopTitle;

    const headText = document.querySelector("#about-head");

    headText.querySelector('h2').textContent = data_about.en.head_Title;
    headText.querySelector('p').innerHTML = data_about.en.head_Text;
    headText.querySelector('#language-about-subtext').textContent = data_about.en.head_SubText;
}