const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
const screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;

const userLoggedIn = getCookie("userLoggedIn");

if(screenWidth < 910) {
        var heroElementBackgroundImage = document.querySelector('#hero');
        heroElementBackgroundImage.style.backgroundImage = 'url("img/hero4_Smartphone.png")';
}

if(screenWidth < 520 || screenHeight < 750) {

    var heroElementBackgroundImage = document.querySelector('.registrationloginsmartphone');
    heroElementBackgroundImage.style.backgroundImage = 'url("img/hero4_Smartphone.png")';
    const loginPageElements = document.querySelectorAll('.login-page-node');
    const htmlCodeSmartphone = `
    <section class="wrapper-smartphone wrapper-smartphone-fix" id="login-page">
        <div class="form-box login">
            <h2 id="language-login-header">Login</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="login-user-email" required>
                    <label id="language-login-emailaddress">Email</label>
                </div>
                <div class="input-box">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="login-user-pw" required>
                    <label id="language-login-password">Password</label>
                </div>
                <div class="remember-forgot">
                    <label><input id="language-login-rememberpwd" type="checkbox" checked>Remember me</label>
                    <a href="#" class="resetpw-link" id="language-login-forgotpwd">Forgot Password?</a>
                </div>
                <button type="submit" id="login-btn" class="btn" id="language-login-btn">Login</button>
                <div class="login-register">
                    <p id="language-login-requireaccount">Don't have an account? <a href="#"  style="padding-left: 4px" class="register-link" id="language-login-registrationlink">Register</a></p>
                </div>
                <div class="error-txt-login">
                <p></p>
            </div>
            </form>
        </div>

        <div class="form-box register sendregistermail">
            <h2 id="language-registration-header">Registration</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-user'></i></span>
                    <input type="text" id="form-registration-code" class="item" autcomplete="off">
                    <label id="language-registration-verificationcode">Registration Code</label>
                    <div class="error-txt" id="language-registration-verificationcode-error">Enter your registration code.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="form-email-address" class="item" autcomplete="off">
                    <label id="language-registration-emailaddress">Email</label>
                    <div class="error-txt" id="language-registration-emailaddress-error">Enter your email address.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-user-pw" class="item" autcomplete="off">
                    <label id="language-registration-firstpassword">Password (min 6 characters)</label>
                    <div class="error-txt" id="language-registration-firstpassword-error">Enter your password.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-user-pw" class="item" autcomplete="off">
                    <label id="language-registration-secondpassword">Re-enter password</label>
                    <div class="error-txt" id="language-registration-secondpassword-error">Re-enter your password.</div>
                </div>
                <div class="remember-forgot">
                <input id="language-registration-checkbox-text" type="checkbox">
            </div>
            <button type="submit" id="registration-btn" class="btn">Register</button>
            <div class="login-register">
                <p id="language-registration-backtologin-text">Already have an account? <a href="#" class="login-link" style="padding-left: 4px" id="language-registration-loginlink">Login</a></p>
            </div>
            </form>
        </div>

        <div class="form-box resetpw">
        <h2 id="language-resetpwd-header">Password Reset</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="reset-user-email-form" required>
                    <label id="language-resetpwd-emailaddress">Email</label>
                </div>
                <button type="submit" id="resetpw-btn" class="btn">Continue</button>
                <div class="login-register">
                    <p id="language-resetpwd-rememberpwd">Remember your password? <a href="#" class="back-to-login-link" style="padding-left: 4px" id="language-resetpwd-loginlink">Login</a></p>
                </div>
            </form>
        </div>

        <div class="form-box changepw">
        <h2 id="language-passwordreset-header">Reset Password</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-change-user-pw" class="item" autcomplete="off">
                    <label id="language-passwordreset-firstnewpassword">New Password (min 6 characters)</label>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-change-user-pw" class="item" autcomplete="off">
                    <label id="language-passwordreset-secondnewpassword">Re-enter password</label>
                </div>
                <button type="submit" id="changepw-btn" class="btn">Change Password</button>
                <div class="error-txt-changepw">
                <p></p>
                </div>
            </form>
        </div>
    </section>
    `;

    document.querySelector('#hero').style.display = "none";
    loginPageElements.forEach(element => {
        element.insertAdjacentHTML('beforeend', htmlCodeSmartphone);
    });




    
    const resetPW = document.querySelector('.form-box.resetpw');
    const changePW = document.querySelector('.form-box.changepw');

    resetPW.style.display = 'none';
    changePW.style.display = 'none';

    document.querySelector('.login').style.display = "none";
    var elements = document.querySelectorAll('.login');
    hideAllChildElements(elements);

    // Transform from registration to login
    const loginLink = document.querySelector('.login-link');
    loginLink.addEventListener('click', ()=> {
        document.querySelector('.register').style.display = 'none';
        
        document.querySelector('.login').style.display = "block";
        const showLogin = document.querySelectorAll('.login');
        showAllChildElements(showLogin);

    });
    // Transform from login to register
    const registerLink = document.querySelector('.register-link');
    registerLink.addEventListener('click', ()=> {
        document.querySelector('.login').style.display = 'none';

        document.querySelector('.register').style.display = "block";
        const showRegister = document.querySelectorAll('.register');
        showAllChildElements(showRegister);

    });

    // Transform from login to register
    const resetPWLink = document.querySelector('.resetpw-link');

    const hideRegister = document.querySelector('.form-box.register');
    const hideLogin = document.querySelector('.form-box.login');

    resetPWLink.addEventListener('click', ()=> {
        resetPW.style.display = 'block';

        hideRegister.style.display = 'none';
        hideLogin.style.display = 'none';
    });

    const backToLoginLink = document.querySelector('.back-to-login-link');
    backToLoginLink.addEventListener('click', ()=> {
        resetPW.style.display = 'none';

        hideRegister.style.display = 'none';
        hideLogin.style.display = 'block';

    });


    /* Show registration form if not already registered */
    let showRegistrationForm = getCookie("userRegistered");
    if (showRegistrationForm != "") {
        var elementsRegistration = document.querySelectorAll('.register');
        hideAllChildElements(elementsRegistration);
        //document.querySelectorAll('.register').style.display = "none";

        document.querySelector('.login').style.display = "block";
        var elementsLogin = document.querySelectorAll('.login');
        showAllChildElements(elementsLogin);

        //document.querySelectorAll('.login').style.display = "block";
    }
    /* Show login form if user is registered but not logged in*/


    /* remove login, registration form usw. AND SHOW HERO FORM */
    let userLoggedIn = getCookie("userLoggedIn");
    if (userLoggedIn != "") {
        const wrapperSmartphone = document.querySelectorAll('.wrapper-smartphone');
        wrapperSmartphone.forEach(el => el.remove());
        
    const registrationloginsmartphone = document.querySelector('.registrationloginsmartphone');
    registrationloginsmartphone.remove();

    //var elementsHero = document.querySelectorAll('#hero');
    //showAllChildElements(elementsHero);
    document.querySelector('#hero').style.display = "block";

    heroElementBackgroundImage.style.backgroundImage = 'url("img/hero4.png")';
    }



} 
/*** Desctop-PC or Laptop ***/
else {
    if (userLoggedIn == "") {
        const loginPageElements = document.querySelectorAll('.login-page-node');
        const htmlCode = `
        <section class="wrapper" id="login-page">
            <span class="icon-close">
                <ion-icon name="close"><i class='bx bx-x'></i></ion-icon>
            </span>
            
            <div class="form-box login">
                <h2 id="language-login-header">Login</h2>
                <form action="#" id="input-boxes">
                    <div class="input-box">
                        <span class="icon"><i class='bx bx-envelope'></i></span>
                        <input type="email" id="login-user-email" required>
                        <label id="language-login-emailaddress">Email</label>
                    </div>
                    <div class="input-box">
                        <span class="icon"><i class='bx bx-lock-alt'></i></span>
                        <input type="password" id="login-user-pw" required>
                        <label id="language-login-password">Password</label>
                    </div>
                    <div class="remember-forgot">
                        <label><input id="language-login-rememberpwd" type="checkbox" checked>Remember me</label>
                        <a href="#" class="resetpw-link" id="language-login-forgotpwd">Forgot Password?</a>
                    </div>
                    <button type="submit" id="login-btn" class="btn" id="language-login-btn">Login</button>
                    <div class="login-register">
                        <p id="language-login-requireaccount">Don't have an account? <a href="#" class="register-link" style="padding-left: 4px" id="language-login-registrationlink">Register</a></p>
                    </div>
                    <div class="error-txt-login">
                    <p></p>
                </div>
                </form>
            </div>

            <div class="form-box register sendregistermail">
                <h2 id="language-registration-header">Registration</h2>
                <form action="#" id="input-boxes">
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-user'></i></span>
                        <input type="text" id="form-registration-code" class="item" autcomplete="off">
                        <label id="language-registration-verificationcode">Registration Code</label>
                        <div class="error-txt" id="language-registration-verificationcode-error">Enter your registration code.</div>
                    </div>
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-envelope'></i></span>
                        <input type="email" id="form-email-address" class="item" autcomplete="off">
                        <label id="language-registration-emailaddress">Email</label>
                        <div class="error-txt" id="language-registration-emailaddress-error">Enter your email address.</div>
                    </div>
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-lock-alt'></i></span>
                        <input type="password" id="form-user-pw" class="item" autcomplete="off">
                        <label id="language-registration-firstpassword">Password (min 6 characters)</label>
                        <div class="error-txt" id="language-registration-firstpassword-error">Enter your password.</div>
                    </div>
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-lock-alt'></i></span>
                        <input type="password" id="form-confirm-user-pw" class="item" autcomplete="off">
                        <label id="language-registration-secondpassword">Re-enter password</label>
                        <div class="error-txt" id="language-registration-secondpassword-error">Re-enter your password.</div>
                    </div>
                    <div class="remember-forgot">
                        <input id="language-registration-checkbox-text" type="checkbox">
                    </div>
                    <button type="submit" id="registration-btn" class="btn">Register</button>
                    <div class="login-register">
                        <p id="language-registration-backtologin-text">Already have an account? <a href="#" class="login-link" style="padding-left: 4px" id="language-registration-loginlink">Login</a></p>
                    </div>
                </form>
            </div>

            <div class="form-box resetpw">
            <h2 id="language-resetpwd-header">Password Reset</h2>
                <form action="#" id="input-boxes">
                    <div class="input-box">
                        <span class="icon"><i class='bx bx-envelope'></i></span>
                        <input type="email" id="reset-user-email-form" required>
                        <label id="language-resetpwd-emailaddress">Email</label>
                    </div>
                    <button type="submit" id="resetpw-btn" class="btn">Continue</button>
                    <div class="login-register">
                        <p id="language-resetpwd-rememberpwd">Remember your password? <a href="#" class="back-to-login-link" style="padding-left: 4px" id="language-resetpwd-loginlink">Login</a></p>
                    </div>
                </form>
            </div>

            <div class="form-box changepw">
            <h2 id="language-passwordreset-header">Reset Password</h2>
                <form action="#" id="input-boxes">
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-lock-alt'></i></span>
                        <input type="password" id="form-change-user-pw" class="item" autcomplete="off">
                        <label id="language-passwordreset-firstnewpassword">New Password (min 6 characters)</label>
                    </div>
                    <div class="input-box input-box-register">
                        <span class="icon"><i class='bx bx-lock-alt'></i></span>
                        <input type="password" id="form-confirm-change-user-pw" class="item" autcomplete="off">
                        <label id="language-passwordreset-secondnewpassword">Re-enter password</label>
                    </div>
                    <button type="submit" id="changepw-btn" class="btn">Change Password</button>
                    <div class="error-txt-changepw">
                    <p></p>
                    </div>
                </form>
            </div>
        </section>
        `;
        loginPageElements.forEach(element => {
            element.insertAdjacentHTML('beforeend', htmlCode);
        });

        const wrapper = document.querySelector('.wrapper');
        const loginLink = document.querySelector('.login-link');
        const registerLink = document.querySelector('.register-link');

        const resetPW = document.querySelector('.form-box.resetpw');
        const changePW = document.querySelector('.form-box.changepw');

        resetPW.style.display = 'none';
        changePW.style.display = 'none';

        registerLink.addEventListener('click', ()=> {
            
            wrapper.classList.add('active');

            wrapper.style.height = '680px';
        });

        loginLink.addEventListener('click', ()=> {
            
            wrapper.classList.remove('active');

            wrapper.style.height = '440px';
        });




        const resetPWLink = document.querySelector('.resetpw-link');

        const hideRegister = document.querySelector('.form-box.register');
        const hideLogin = document.querySelector('.form-box.login');

        resetPWLink.addEventListener('click', ()=> {
            resetPW.style.display = 'block';
            wrapper.style.height = '360px';

            hideRegister.style.display = 'none';
            hideLogin.style.display = 'none';
        });

        const backToLoginLink = document.querySelector('.back-to-login-link');

        backToLoginLink.addEventListener('click', ()=> {
            resetPW.style.display = 'none';

            hideRegister.style.display = 'block';
            hideLogin.style.display = 'block';

            wrapper.style.height = '440px';
        });




        /* Show registration form by default if not already registered */
        let showRegistrationForm = getCookie("userRegistered");
        if (showRegistrationForm == "") {
            document.querySelector('.register-link').click();
        }

    }
}
    
initializeRegistrationLogin();


function hideAllChildElements(elements) {
        elements.forEach(function(element) {
            var children = element.querySelectorAll('*');

            children.forEach(function(child) {
                child.style.display = 'none';
            });
        });
}
function showAllChildElements(elements) {
        elements.forEach(function(element) {
            var children = element.querySelectorAll('*');
            children.forEach(function(child) {
                child.style.display = 'block';
            });
        });
}









const queryString_PasswordReset = window.location.search;
const urlParams_PasswordReset = new URLSearchParams(queryString_PasswordReset);


// http://127.0.0.1:5500/onlineshop/home.html?hashed_email=e3b0c44298fc&reset_password=true
if(urlParams_PasswordReset.has('hashed_email') && urlParams_PasswordReset.has('reset_password')) {

    const wrapper = document.querySelector('.wrapper');
    const changePW = document.querySelector('.form-box.changepw');
    const resetPW = document.querySelector('.form-box.resetpw');
    const hideRegister = document.querySelector('.form-box.register');
    const hideLogin = document.querySelector('.form-box.login');



    wrapper.style.height = '440px';
    changePW.style.display = 'block';
    resetPW.style.display = 'none';
    hideRegister.style.display = 'none';
    hideLogin.style.display = 'none';




        /* Change Passwort actions */
        let changePWButton = document.getElementById("changepw-btn"); 


            if(document.body.contains(changePWButton)) {
                changePWButton.addEventListener('click', async (e) => {
                  e.preventDefault();
    
            let changeUserPWForm = document.getElementById("form-change-user-pw").value;
            let confirmChangeUserPWForm = document.getElementById("form-confirm-change-user-pw").value;
    
            if(changeUserPWForm == "") {
                document.querySelector('.error-txt-changepw').innerHTML = "Enter your new password.";
            }
            else if(changeUserPWForm.length < 6) {
                document.querySelector('.error-txt-changepw').innerHTML = "A minimum of 6 characters is required.";
            }
            else if(changeUserPWForm != confirmChangeUserPWForm) {
                document.querySelector('.error-txt-changepw').innerHTML = "Passwords are not equal.";
            }
            else {
                Swal.fire({
                    text: "Password Reset Successful!",
                    timer: 3000,
                    color: "#162938",
                    icon: "success",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                  });
    
                  changePW.style.display = 'none';
                  resetPW.style.display = 'none';
                  hideRegister.style.display = 'none';
                  hideLogin.style.display = 'block';
    
                  wrapper.style.height = '440px';

                  document.querySelector('.login-link').click();
            }
        }); 
    }

    /* Enable close of password reset popup */
    var initializeCloseButton = document.querySelector('.icon-close')
    initializeCloseButton.addEventListener('click', function() {
        const loginPageElements = document.querySelector('.login-page-node');

        loginPageElements.style.display = 'none';
    });

}


verifyEmailAddressURLOpened();

async function verifyEmailAddressURLOpened() {
    
const queryString = window.location.search;

const urlParams = new URLSearchParams(queryString);

const emailAddressHashedParam = urlParams.get('hashed_email')
console.log(emailAddressHashedParam);

let userEmailVerified = getCookie("userEmailVerified");
if(urlParams.has('verified_email') && urlParams.has('hashed_email') && userEmailVerified != ("true_"+emailAddressHashedParam)) {




    let responseFirestoreDBVerifyEmailAddress=""
    await firestoreDBVerifyEmailAddress('verifyEmailAddressFM',emailAddressHashedParam, getDevice())
        .then(response => {
            console.log("Result from firestoreDBVerifyEmailAddress(): " + response);
            responseFirestoreDBVerifyEmailAddress = response
        })
        .catch(error => {
            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
        });



    if(responseFirestoreDBVerifyEmailAddress == "userRegistrationVerification_Succesful") {
        // disable further verified-mail animations
        setCookie("userEmailVerified","true_"+emailAddressHashedParam,8);
        setCookie("userRegistered", "user_Registered", 8);

        // transform from register to login
        const loginLink = document.querySelector('.login-link');
        loginLink.click();

        let language_EmailVerificationSuccessful = "E-Mail Verifizierung erfolgreich!"
        if(getLanguage() != "DE") {
            language_EmailVerificationSuccessful = "Email Verification Successful!"
        }
        
        Swal.fire({
            text: language_EmailVerificationSuccessful,
            timer: 2500,
            color: "#162938",
            icon: "success",
            showConfirmButton: false,
            background: "#e3e6f3",
          });
    }
    else if (responseFirestoreDBVerifyEmailAddress == "userRegistrationVerification_Error_WrongVerificationEmailAddress") {
        let language_EmailVerificationIncompleteLink = "E-Mail Verifizierung fehlgeschlagen. Bitte öffne den vollständigen Link (URL), die wir dir an dein E-Mail-Postfach geschickt haben."
        if(getLanguage() != "DE") {
            language_EmailVerificationIncompleteLink = "Incomplete Account Verification link. Please open the complete link (URL) sent to your mailbox in an internet browser!"
        }
        
        Swal.fire({
            text: language_EmailVerificationIncompleteLink,
            timer: 8000,
            color: "#162938",
            icon: "error",
            showConfirmButton: false,
            background: "#e3e6f3",
          });
    }
    else {
        let language_EmailVerificationIncompleteLink = "E-Mail Verifizierung fehlgeschlagen. Bitte öffne den vollständigen Link (URL), die wir dir geschickt haben."
        if(getLanguage() != "DE") {
            language_EmailVerificationIncompleteLink = "Incomplete Account Verification link. Please open the complete link (URL) sent to your mailbox in an internet browser!"
        }

        Swal.fire({
            text: language_EmailVerificationIncompleteLink,
            timer: 8000,
            color: "#162938",
            icon: "error",
            showConfirmButton: false,
            background: "#e3e6f3",
          });
    }
}
}



