function checkInputs() {

  const errorText = document.querySelector('.error-txt');

  const items = document.querySelectorAll(".item");

  for(const item of items) {
      if(item.value == "") {
          item.classList.add("error");
          item.parentElement.classList.add("error");
      }

      items[0].addEventListener("keyup", () => {
        checkVerificationCode();
    });

      if(items[1].value != "") {
          checkEmail();
      }

      items[1].addEventListener("keyup", () => {
          checkEmail();
      });

      if(items[2].value != "") {
          checkPasswordLength();

          let languageMinCharacters = "Mindestens 6 Zeichen erforderlich.";
          if(getLanguage() != "DE") {
            languageMinCharacters = "A minimum of 6 characters is required.";
          }

          items[2].parentElement.querySelector('.error-txt').innerHTML = languageMinCharacters;

          "Mindestens 6 Zeichen erforderlich."
      }

      items[2].addEventListener("keyup", () => {
          checkPasswordLength();
      });

      if(items[3].value != "") {
          checkPassword();

          let language_PasswordError_Non_Identical = "Passwörter sind nicht identisch.";
          if(getLanguage() != "DE") {
            language_PasswordError_Non_Identical = "Passwords are not equal.";
          }

          items[3].parentElement.querySelector('.error-txt').innerHTML = language_PasswordError_Non_Identical;
      }

      items[3].addEventListener("keyup", () => {
          checkPassword();
      });

      item.addEventListener("keyup", () => {
          if(item.value != "") {
              item.classList.remove("error");
              item.parentElement.classList.remove("error");
          }
          else {
              item.classList.add("error");
              item.parentElement.classList.add("error");
          }
      });
  }
}

function checkVerificationCode() {

  const formRegistrationCode = document.getElementById("form-registration-code");

  formRegistrationCode.classList.remove("error");
  formRegistrationCode.parentElement.classList.remove("error");
}

function checkEmail() {

  const formEmail = document.getElementById("form-email-address");

  const emailRegex = /^([a-zA-Z\d\._-]+)(\+[a-zA-Z\d\._-]+)?@([a-zA-Z\d-]+)\.([a-zA-Z]{2,3})(\.[a-zA-Z]{2,3})?$/;

  if(!formEmail.value.match(emailRegex)) {
      formEmail.classList.add("error");
      formEmail.parentElement.classList.add("error");

      let language_EmailError_NonValidEmailAddress = "Bitte gib deine korrekte E-Mail-Adresse ein.";
      if(getLanguage() != "DE") {
        language_EmailError_NonValidEmailAddress = "Please enter a valid email address.";
      }

      formEmail.parentElement.querySelector('.error-txt').innerHTML = language_EmailError_NonValidEmailAddress;
  }
  else {
      formEmail.classList.remove("error");
      formEmail.parentElement.classList.remove("error");
  }
}

function checkPassword() {

  const formPassword = document.getElementById("form-user-pw");
  const formConfirmPassword = document.getElementById("form-confirm-user-pw");

  if(formPassword.value != formConfirmPassword.value || formPassword.value=="" || formConfirmPassword.value=="") {

      console.log("Not Same password");

      formPassword.classList.add("error");
      formPassword.parentElement.classList.add("error");

      formConfirmPassword.classList.add("error");
      formConfirmPassword.parentElement.classList.add("error");

      let language_PasswordError_Non_Identical = "Passwörter sind nicht identisch.";
      if(getLanguage() != "DE") {
        language_PasswordError_Non_Identical = "Passwords are not equal.";
      }

      formConfirmPassword.parentElement.querySelector('.error-txt').innerHTML = language_PasswordError_Non_Identical;

  } else {

      console.log("Same password");

      formPassword.classList.remove("error");
      formPassword.parentElement.classList.remove("error");

      formConfirmPassword.classList.remove("error");
      formConfirmPassword.parentElement.classList.remove("error");
  }
}

function checkPasswordLength() {

  const formPassword = document.getElementById("form-user-pw");

  if(formPassword.value.length < 6) {
      formPassword.classList.add("error");
      formPassword.parentElement.classList.add("error");

      let languageMinCharacters = "Mindestens 6 Zeichen erforderlich.";
      if(getLanguage() != "DE") {
        languageMinCharacters = "A minimum of 6 characters is required.";
      }

      formPassword.parentElement.querySelector('.error-txt').innerHTML = languageMinCharacters;
  }
  else {
      formPassword.classList.remove("error");
      formPassword.parentElement.classList.remove("error");
  }
}