/*** set Cookie ***/
function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for(let i = 0; i <ca.length; i++) {
      let c = ca[i];
      while (c.charAt(0) == ' ') {
        c = c.substring(1);
      }
      if (c.indexOf(name) == 0) {
        return c.substring(name.length, c.length);
      }
    }
    return "";
  }

  /*** get Cookie ***/
function setCookie(key, value, time) {
    // get the current time
    let d = new Date()
    d.setTime(d.getTime() + (time*24*60*60*1000))

    let expires = "expires=" + d.toUTCString()

    document.cookie = key + "=" + value + ";" + expires + ";" + "SameSite=Strict;" + "path=/;";//";path=/"

}


  /*** get Cookie ***/
  function setCookieEmailAddress(key, value, time) {
    // get the current time
    let d = new Date()
    d.setTime(d.getTime() + (time*24*60*60*1000))

    let expires = "expires=" + d.toUTCString()

    document.cookie = key + "=" + value + ";" + expires + ";" + "path=/;" + "HttpOnly; secure;";//";path=/"

}



/*** Implemented in Qualtrics ***/
function generateVerificationPIN() {
	let result = '';
    const characters = 'ABCDEFGHIJKLMNPQRSTUVWXYZ123456789';
    const charactersLength = characters.length;
    let counter = 0;
    while (counter < 6) {
      result += characters.charAt(Math.floor(Math.random() * charactersLength));
      counter += 1;
    }

    console.log("VerificationPIN:" + result);
}


function getLanguage() {
  const languageCookie = getCookie("language");
  if(languageCookie == "") {
      languageCookie == "DE";
  }

  return languageCookie;
}


function getDevice() {
  const userAgentString = navigator.userAgent;
  if(userAgentString != "") {
      if (/Tablet|iPad/i.test(userAgentString) && navigator.maxTouchPoints > 0) {
          return "Tablet";
      }
      else if ((/Android|iPhone|Mobile/i.test(userAgentString)) && navigator.maxTouchPoints > 0) {
          return "Smartphone";   
      }
      else {
          return "Desktop";
      }
  }
  // device size
  else {
      const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
      const screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
      if ((screenWidth >= 1024 && screenHeight >= 768) || (screenWidth >= 768 && screenHeight >= 1024)) {
          return "Desktop";
      }
      else {
          return "Desktop";
      }
  }
}
    

/*** Local Node JS Server ***/
//const nodeJSConnection='http://localhost:4040';
/*** Plesk Node JS Server ***
const nodeJSConnection='https://smartbuyonline.de';

const nodeJSConnectionRegisterUser='/register-user';
const nodeJSConnectionLoginUser='/login-user';
const nodeJSConnectionUserOrderToDB='/send-order';

const nodeJSConnectionSendEmailRegistration='/send-email';
const nodeJSConnectionSendPasswortResetEmail='/send-email';





async function registerUser(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionRegisterUser, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function loginUser(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionLoginUser, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function userOrderToDB(functionName, param1, param2, param3) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionUserOrderToDB, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, param1, param2, param3}),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }


  async function sendRegistrationEmail(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendEmailRegistration, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }

  async function sendPasswordResetEmail(functionName, params) {
    try {
      const response = await fetch(nodeJSConnection+nodeJSConnectionSendPasswortResetEmail, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ functionName, params }),
      });

      const data = await response.json();
      return data.response;
    } catch (error) {
      console.error('Error Connecting to the server. Please check Domain, PORT and GET request:', error);
      throw error;
    }
  }






  function showSuccessfulRegistrationPopupAndTranslateToLogin() {
    Swal.fire({
        //title: "Success!",
        text: "Please check your mailbox to verify your email address!",
        color: "#162938",
        icon: "info",
        confirmButtonColor: "#088178",
        confirmButtonText: "Confirm",
        background: "#e3e6f3"
    }).then(function() {
        document.querySelectorAll('.swal2-container').forEach(e => e.remove());
        // function when confirm button clicked

        document.querySelectorAll('.swal2-shown').forEach(e => e.classList.remove("swal2-shown"));
        document.querySelectorAll('.swal2-height-auto').forEach(e => e.classList.remove("swal2-height-auto"));

        // Selektiere alle Elemente im DOM, die das aria-hidden-Attribut haben
        const elementsWithAriaHidden = document.querySelectorAll('[aria-hidden="true"]');

        // Iteriere durch jedes ausgewählte Element und entferne das aria-hidden-Attribut
        elementsWithAriaHidden.forEach(element => {
        element.removeAttribute('aria-hidden');
        });

        document.querySelector('.login-link').click(); 
    });
  }
  */