/* https://smartbuyonline.de/coupon.html?id=54af45685c30e04f137ee71d87d27d3a6a2d12c40e027f43a0b1f79fbaaa773b */


readyCoupon();

function readyCoupon() {
    const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;

    const screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;

    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);

    if(screenWidth < 799) {
        var heroElementBackgroundImage = document.querySelector('#hero_coupon');
        heroElementBackgroundImage.style.backgroundImage = 'url("img/hero4_Smartphone.png")';
    }

    // once on coupon.html page --> set couponEmailSend to prevent further coupon emails and prevent 
    if(getCookie("couponUsed") != "") {
        initializeCoupon();
    }
    else if(urlParams.has('id') && getCookie("couponUsed") == "") {
        let registrationCodeHashed = "";
        registrationCodeHashed = getRegistrationCode();

        // store that user with registration code hashed id has opened the (phishing) website
        let responseStoreDataCouponForged = "";
        storeDataOpenedPhishingWebsite('dataOpenedPhishingWebsiteFM',registrationCodeHashed, getDevice())
            .then(response => {
                console.log("Result from storeDataOpenedPhishingWebsite(): " + response);
                responseStoreDataCouponForged = response
            })
            .catch(error => {
                console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
            });

        document.getElementById('login-btn').addEventListener('click', async (e) => {
            e.preventDefault();
        
            let emailAddress = document.getElementById("login-user-email").value.toLowerCase();
            let password = document.getElementById("login-user-pw").value;
        
            if(emailAddress != '' && password != '' && password.length >= 6) {
                /* Login User via Node JS server (Backend)*/
                let responseLoginUser;
                await loginUser('loginUserFM', emailAddress)
                .then(response => {
                    console.log("Result from loginUser(): ", response);
                    if (response.status === "success") {
                        console.log("Login successful. User data: ", response.userData);
                        responseLoginUser = response;
                    } else {
                        console.error("Login failed: ", response.message);
                        responseLoginUser = response;
                    }
                })
                .catch(error => {
                    console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                });
        
                console.log(responseLoginUser.status);
                console.log(responseLoginUser.message);
                console.log(responseLoginUser.userData);

                if(responseLoginUser.message == "userLoginSuccessful") {
                    // Finde das Element mit der ID 'login-page'
                    const loginPageElement = document.getElementById('login-page');
        
                    document.getElementById("login-user-email").style.color = '#088178';
                    document.getElementById("login-user-pw").style.color = '#088178';
        
                    // Füge die Klasse 'hidden' hinzu, um die Animation auszulösen
                    setTimeout(function() {
                        loginPageElement.classList.add('hidden');
                    }, 1000); // 1000 Millisekunden (1 Sekunde)
        
                    // Warte auf das Ende der Transition und entferne das Element
                    loginPageElement.addEventListener('transitionend', function() {
                    loginPageElement.remove();
                    });
        
                    document.getElementById("login-icon-color").style.color = '#088178';
        
                    /*****************************/
                    /*** Set Important Cookies ***/
                    /*****************************/
                    // set login cookie, i.e., remove login form if user refreshes website (8 day valid)
                    setCookie("userLoggedIn","LoggedIn",8);
                    /*
                    let emailAddressHashed = CryptoJS.SHA256(userEmailAddress).toString().slice(0, 12);
                    console.log("Email address hasedh: " + emailAddressHashed)
                    */
                    // set user email hashed (first 12 digits)
                    setCookie("userEmailHashed", responseLoginUser.userData.email_hashed, 8);
                    // user email address
                    setCookie("userEmailAddress", emailAddress, 8);
                    // set online shop scenario (coupon)
                    setCookie("scenario", responseLoginUser.userData.scenario, 8);
                    // set online shop scenario (coupon)
                    setCookie("scenarioDomain", responseLoginUser.userData.scenario_coupon, 8);
                    // set registration code
                    setCookie("registrationCode", responseLoginUser.userData.registration_code, 8);
                    // set user verified
                    setCookie("userEmailVerified", "true", 8);
                    // user registered
                    setCookie("userRegistered","user_registered",8);
        
                    let responseStoreDataCouponForged= "";
            
                    storeDataCoupon('dataCouponFM', emailAddress, registrationCodeHashed, getDevice())
                        .then(response => {
                            console.log("Result from storeDataCouponForged(): " + response);
                            responseStoreDataCouponForged = response
                        })
                        .catch(error => {
                            // Behandele den Fehler, wenn erforderlich
                            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                        });
                        // increase order number by 1
                        //setCookie("receiveCouponAttempts", parseInt(numberOfReceiveCouponAttempts)+1, 1);
                    
                    if (responseStoreDataCouponForged == "") {
                        console.log("User data stored successfully");
                    }


                    let sweetAlert_LoggedInSuccessfully = data_coupon.en.sweetAlert_LoggedInSuccessfully;
                    if(getLanguage() == "DE") {
                        sweetAlert_LoggedInSuccessfully = data_coupon.de.sweetAlert_LoggedInSuccessfully; 
                    }
                    Swal.fire({
                        html: sweetAlert_LoggedInSuccessfully,
                        timer: 3500,
                        color: "#162938",
                        icon: "success",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                        //width: 400
                        });

                    // show coupon page and prevent from showing login window again
                    setCookie("couponUsed", "true", 8);
                    initializeCoupon();
                    // scroll to top of page
                    window.scrollTo(0,0);
                }
                /* Email verification needed */
                else if(responseLoginUser.message=='userRegistered_EmailAddressNotVerified') {
        
                    //document.querySelector('.error-txt-login').innerHTML = "Please verify your email.<br> Check your mailbox!";
        
                    document.querySelector('.error-txt-login').innerHTML = "";
        
                    Swal.fire({
                        text: "Please verify your email before opening the coupon.",
                        timer: 3000,
                        color: "#162938",
                        icon: "info",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                    });
        
                }
                else if(responseLoginUser.message=='userNotRegistered') {

                    Swal.fire({
                        text: "Your email address is currently not registered.",
                        timer: 3000,
                        color: "#162938",
                        icon: "error",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                    });
                }
                else {
                    console.log('Response from function \"loginUser\" does not exist.');
                }

            }
            else {
                // disable to prevent spam. Afterwards store wrong
                if(emailAddress != '' && password != '') {
                    document.getElementById('login-btn').disabled = true;
                    setTimeout(function(){document.getElementById('login-btn').disabled = false;},2500);

                    let registrationCodeHashed = "";
                    registrationCodeHashed = getRegistrationCode();
                    // store data
                    storeDataCoupon('dataCouponFM', emailAddress,registrationCodeHashed, getDevice())
                        .then(response => {
                            console.log("Result from storeDataCouponForged(): " + response);
                            responseStoreDataCouponForged = response
                        })
                        .catch(error => {
                            console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                        });
                    if (responseStoreDataCouponForged == "") {
                        console.log("User data stored successfully even without login");
                    }

                }

                // show error message based on user input
                if (emailAddress == '' && password == ''){
                    document.querySelector('.error-txt-login').innerHTML = "Email and password can't be empty.";
                }
                else if (emailAddress == ''){
                    document.querySelector('.error-txt-login').innerHTML = "Email can't be empty.";
                }
                else if (!emailAddress.includes("@")){
                document.querySelector('.error-txt-login').innerHTML = "Please enter a valid email address.";
                }
                else if (password == '') {
                    document.querySelector('.error-txt-login').innerHTML = "Password can't be empty.";
                }
                else if (password.length < 6) {
                    document.querySelector('.error-txt-login').innerHTML = "Wrong password!";
                }
            }

        });
    } 
    // hashed registration code is missing in the URL
    else {
        let openFullURLCoupon = "Please open the complete URL from your coupon email to redeem the coupon.";
        if(getLanguage() == "DE") {
            openFullURLCoupon = "Bitte öffne den vollständigen Link aus der Coupon E-Mail, um den Gutschein einzulösen!"
        }
        Swal.fire({
            text: openFullURLCoupon,
            timer: 10000,
            color: "#162938",
            icon: "info",
            showConfirmButton: false,
            background: "#e3e6f3",
        });

        document.getElementById('login-btn').addEventListener('click', async (e) => {
            e.preventDefault();
        
            let emailAddress = document.getElementById("login-user-email").value.toLowerCase();
            let password = document.getElementById("login-user-pw").value;
        
            if(emailAddress != '' && password != '' && password.length >= 6) {
                Swal.fire({
                    text: openFullURLCoupon,
                    timer: 10000,
                    color: "#162938",
                    icon: "info",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                });
            }
        });
    }
    


    
}


function hideAllChildElements(elements) {
        elements.forEach(function(element) {
            var children = element.querySelectorAll('*');

            children.forEach(function(child) {
                child.style.display = 'none';
            });
        });
}
function showAllChildElements(elements) {
        elements.forEach(function(element) {
            var children = element.querySelectorAll('*');

            children.forEach(function(child) {
                child.style.display = 'block';
            });
        });
}


function getRegistrationCode() {
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);

    if (urlParams.has('id')) {
        const registrationCodeHashedFromURL = urlParams.get('id');

        return registrationCodeHashedFromURL.slice(0, 12);
    }
    else {
        const invalidCouponRandom = Math.floor(Math.random() * 10000);

        const invalidCouponRandomExist = getCookie("invalid_coupon_random");
        if(invalidCouponRandomExist == "") {
            setCookie("invalid_coupon_random", "INVALID_COUPON_VALID_"+invalidCouponRandom.toString(),8);
            return ("INVALID_COUPON_VALID_" + invalidCouponRandom.toString());
        }
        else {
            return invalidCouponRandomExist.toString();
        }
    }    
}

// show coupon after login or immediately if already logged in before
function initializeCoupon() {
    // show coupon and dismiss everything else...
    //document.querySelector('.login-page-node').remove();

    // remove login smartphone
    const wrapperSmartphone = document.querySelectorAll('.wrapper-smartphone');
    wrapperSmartphone.forEach(el => el.remove());

    // remove p message and show coupon
    document.querySelector('#remove-message-claim-coupon').remove();

    let htmlCode_CouponCode = `<h4>Your Coupon Code: </h4><h5>&ldquo;OUTFIT&rdquo;</h5>`;
    if(getLanguage() == "DE") {
        htmlCode_CouponCode = `<h4>Dein Gutschein-Code: </h4><h5>&bdquo;OUTFIT&ldquo;</h5>`;
    }

    const giftcardElement = document.querySelector('#hero_coupon');

    giftcardElement.insertAdjacentHTML('beforeend', htmlCode_CouponCode);
}