/*** cart.js -> cart.html ***/
ready();

/*** ready function ***/
function ready() {
    if(getCookie("couponActivated") == "true" && getCookie("couponAlreadyUsed") == "") {
        if(getLanguage() == "DE") {
            document.querySelector("#coupon-value-euro").textContent = "- 50,00 €";
        } else {
            document.querySelector("#coupon-value-euro").textContent = "- 50.00 €";
        }
    }

    getProductsInCart();
    couponActivated();
    updateCartTotal();
    cartBadgeNumber();
    showMessageCartEmpty();

    


    var removeCarItemButtons = document.getElementsByClassName('btn-remove-article')
    console.log(removeCarItemButtons)
    
    for(var i = 0; i < removeCarItemButtons.length; i++) {
        var button = removeCarItemButtons[i]
        button.addEventListener('click', function(event) {
            console.log('clicked')
            var buttonClicked = event.target

            var parentElement = buttonClicked.closest('.parent-container');
            console.log('Parent ELement: ' + parentElement)


            let removeArticle = buttonClicked.parentElement.parentElement.parentElement


            let productName = removeArticle.getElementsByClassName('product-name')[0].innerHTML

            var currentCartCookie = cookiemonster.get('CartProducts')
            let indexToRemoveCartArticle = currentCartCookie.indexOf(productName)

            currentCartCookie.splice(indexToRemoveCartArticle, 1);
            currentCartCookie.splice(indexToRemoveCartArticle, 1);
            currentCartCookie.splice(indexToRemoveCartArticle, 1);
            currentCartCookie.splice(indexToRemoveCartArticle, 1);

            console.log('Current (updated) cart: ' + currentCartCookie)

            
            cookiemonster.set('CartProducts', currentCartCookie, 1); 



           /* remove product from card */
            buttonClicked.parentElement.parentElement.parentElement.remove()
            
            updateQuantityCookie();

            showMessageCartEmpty();

            updateCartTotal();

            cartBadgeNumber();

        })
    
    
    }
    
    var quantityInputs = document.getElementsByClassName('cart-quantity-input')
    for(var i = 0; i < quantityInputs.length; i++) {
        var input = quantityInputs[i]
        input.addEventListener("change", quantityChanged);
    }

    // update order list and show "order list empty"-message (if not empty)
    const orderCookieExist = getCookie("OrderedProductsArray");
    if (orderCookieExist == "") {
        updateMessageEmptyOrderList();
    }
    else {
        updateOrderList();
    }
}



let userLoggedIn = getCookie("userLoggedIn");
if (userLoggedIn == "") {
    initializeLoginPage();
    const loginPageElements = document.querySelector('.login-page-node-notification');

    loginPageElements.style.display = 'none';

    var initializeCloseButton = document.querySelector('.icon-close')

    initializeCloseButton.addEventListener('click', function(event) {
        const loginPageElements = document.querySelector('.login-page-node-notification');

        loginPageElements.style.display = 'none';
    });
}


function initializeLoginPage() {
    const loginPageElements = document.querySelectorAll('.login-page-node-notification');

    const htmlCode = `
    <section class="wrapper" id="login-page">
        <span class="icon-close">
            <ion-icon name="close"><i class='bx bx-x'></i></ion-icon>
        </span>
        
        <div class="form-box login">
            <h2 id="language-login-header">Login</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="login-user-email" required>
                    <label id="language-login-emailaddress">Email</label>
                </div>
                <div class="input-box">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="login-user-pw" required>
                    <label id="language-login-password">Password</label>
                </div>
                <div class="remember-forgot">
                    <label><input id="language-login-rememberpwd" type="checkbox" checked>Remember me</label>
                    <a href="#" class="resetpw-link" id="language-login-forgotpwd">Forgot Password?</a>
                </div>
                <button type="submit" id="login-btn" class="btn" id="language-login-btn">Login</button>
                <div class="login-register">
                    <p id="language-login-requireaccount">Don't have an account? <a href="#" class="register-link" style="padding-left: 4px" id="language-login-registrationlink">Register</a></p>
                </div>
                <div class="error-txt-login">
                <p></p>
            </div>
            </form>
        </div>

        <div class="form-box register sendregistermail">
            <h2 id="language-registration-header">Registration</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-user'></i></span>
                    <input type="text" id="form-registration-code" class="item" autcomplete="off">
                    <label id="language-registration-verificationcode">Registration Code</label>
                    <div class="error-txt" id="language-registration-verificationcode-error">Enter your registration code.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="form-email-address" class="item" autcomplete="off">
                    <label id="language-registration-emailaddress">Email</label>
                    <div class="error-txt" id="language-registration-emailaddress-error">Enter your email address.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-user-pw" class="item" autcomplete="off">
                    <label id="language-registration-firstpassword">Password (min 6 characters)</label>
                    <div class="error-txt" id="language-registration-firstpassword-error">Enter your password.</div>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-user-pw" class="item" autcomplete="off">
                    <label id="language-registration-secondpassword">Re-enter password</label>
                    <div class="error-txt" id="language-registration-secondpassword-error">Re-enter your password.</div>
                </div>
                <div class="remember-forgot">
                    <input id="language-registration-checkbox-text" type="checkbox">
                </div>
                <button type="submit" id="registration-btn" class="btn">Register</button>
                <div class="login-register">
                    <p id="language-registration-backtologin-text">Already have an account? <a href="#" class="login-link" style="padding-left: 4px" id="language-registration-loginlink">Login</a></p>
                </div>
            </form>
        </div>

        <div class="form-box resetpw">
        <h2 id="language-resetpwd-header">Password Reset</h2>
            <form action="#" id="input-boxes">
                <div class="input-box">
                    <span class="icon"><i class='bx bx-envelope'></i></span>
                    <input type="email" id="reset-user-email-form" required>
                    <label id="language-resetpwd-emailaddress">Email</label>
                </div>
                <button type="submit" id="resetpw-btn" class="btn">Continue</button>
                <div class="login-register">
                    <p id="language-resetpwd-rememberpwd">Remember your password? <a href="#" class="back-to-login-link" style="padding-left: 4px" id="language-resetpwd-loginlink">Login</a></p>
                </div>
            </form>
        </div>

        <div class="form-box changepw">
        <h2 id="language-passwordreset-header">Reset Password</h2>
            <form action="#" id="input-boxes">
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-change-user-pw" class="item" autcomplete="off">
                    <label id="language-passwordreset-firstnewpassword">New Password (min 6 characters)</label>
                </div>
                <div class="input-box input-box-register">
                    <span class="icon"><i class='bx bx-lock-alt'></i></span>
                    <input type="password" id="form-confirm-change-user-pw" class="item" autcomplete="off">
                    <label id="language-passwordreset-secondnewpassword">Re-enter password</label>
                </div>
                <button type="submit" id="changepw-btn" class="btn">Change Password</button>
                <div class="error-txt-changepw">
                <p></p>
                </div>
            </form>
        </div>
    </section>
    `;


    let loginPageAlreadyExists = document.getElementById('login-page')
    if(!document.body.contains(loginPageAlreadyExists)) {
        loginPageElements.forEach(element => {
            element.insertAdjacentHTML('beforeend', htmlCode);
        });
    }

    const wrapper = document.querySelector('.wrapper');
    const loginLink = document.querySelector('.login-link');
    const registerLink = document.querySelector('.register-link');
    
    const resetPW = document.querySelector('.form-box.resetpw');
    const changePW = document.querySelector('.form-box.changepw');

    resetPW.style.display = 'none';
    changePW.style.display = 'none';

    registerLink.addEventListener('click', ()=> {
        
        wrapper.classList.add('active');

        wrapper.style.height = '660px';
    });

    loginLink.addEventListener('click', ()=> {
        
        wrapper.classList.remove('active');

        wrapper.style.height = '440px';
    });

    
    

    const resetPWLink = document.querySelector('.resetpw-link');

    const hideRegister = document.querySelector('.form-box.register');
    const hideLogin = document.querySelector('.form-box.login');
    
    resetPWLink.addEventListener('click', ()=> {
        resetPW.style.display = 'block';
        wrapper.style.height = '360px';

        hideRegister.style.display = 'none';
        hideLogin.style.display = 'none';
    });

    const backToLoginLink = document.querySelector('.back-to-login-link');

    backToLoginLink.addEventListener('click', ()=> {
        resetPW.style.display = 'none';

        hideRegister.style.display = 'block';
        hideLogin.style.display = 'block';

        wrapper.style.height = '440px';
    });

    /* Show registration form by default if not already registered */
    let showRegistrationForm = getCookie("userRegistered");
    if (showRegistrationForm == "") {
        document.querySelector('.register-link').click();
    }

    initializeRegistrationLogin();
}




// Quantity Changes
function quantityChanged(event) {
    var input = event.target

    if(isNaN(input.value) || input.value <= 0) {
        input.value = 1
    }

    if(input.value >= 5) {
        input.value = 5
    }

    var cartItemContainer = document.getElementsByClassName('cart-items')[0]
    var cartItems = cartItemContainer.getElementsByClassName('cart-item')

    for(var i = 0; i < cartItems.length; i++) {
        var cartItem = cartItems[i]
        var substringToFind = cartItem.getElementsByClassName('product-name')[0].innerHTML;
        var priceElement = cartItem.getElementsByClassName('cart-price')[0]
        var quantityElement = cartItem.getElementsByClassName('cart-quantity-input')[0]

        var price = parseFloat(priceElement.innerText.replace('€', '').replace(',', '.'))
        var quantity = quantityElement.value



        if(getLanguage() == "DE") {
            cartItem.getElementsByClassName('cart-quantity-subtotal-input')[0].innerText = priceItemSubTotal(price, quantity).replace('.', ',') + " €";
        } else {
            cartItem.getElementsByClassName('cart-quantity-subtotal-input')[0].innerText = priceItemSubTotal(price, quantity) + " €";
        }
        

        // change cart-item "quantity"-cookie permanently
        let changeQuantityCookie = getCookie("CartProducts");



        const replacementCharacter = quantity;
        
        let stringWithReplacementQuantity = replaceAfterThirdComma(changeQuantityCookie, substringToFind, replacementCharacter);

        setCookie("CartProducts", stringWithReplacementQuantity, 1)

    }

    updateQuantityCookie();

    updateCartTotal();


    var cartBadgeIsVisible = document.querySelectorAll('.cart-badge');
    let numberOfCartElementsToInt = getCookie("CartNumberOfArticles");
    if(numberOfCartElementsToInt != "")
        {
            cartBadgeIsVisible.forEach(function(cartBadgeIsVisible) {
                cartBadgeIsVisible.innerHTML = numberOfCartElementsToInt;
              });
        }
}

function replaceAfterThirdComma(inputString, substring, replacement) {
    const index = inputString.indexOf(substring);
  
    if (index !== -1) {
      let commaCount = 0;
      let currentIndex = index + substring.length;
  
      while (commaCount < 3 && currentIndex < inputString.length) {
        if (inputString[currentIndex] === ',') {
          commaCount++;
        }
        currentIndex++;
      }
  
      if (commaCount === 3 && currentIndex < inputString.length) {
        const replacedString = inputString.slice(0, currentIndex) + replacement + inputString.slice(currentIndex + 1);
        return replacedString;
      }
    }
  
    return inputString;
  }
  

function getProductsInCart() {
    var tbodyRef = document.getElementById('cart').getElementsByTagName('tbody')[0];

    let cartProducts = []

    let cartProductsExist = getCookie('CartProducts')
    if (cartProductsExist != "") {
        let cartProductsCookie = cookiemonster.get('CartProducts')
        cartProducts = cartProductsCookie
    }

        console.log('Array Elements:' + cartProducts.length)

        for(let i = 0; i < cartProducts.length; i++){
            console.log(cartProducts[i]);
          }
          
        for(i=0; i < cartProducts.length; i+=4) {
            // Insert a row at the end of table
            var addProductRow = tbodyRef.insertRow();
            addProductRow.className = 'cart-item';

            console.log(i)
            var productName = cartProducts[i]
            var productImage = cartProducts[i+1]
            if(getLanguage() == "DE") {
                var productPrice = cartProducts[i+2].replace('.', ',')+" €";
            } else {
                var productPrice = cartProducts[i+2]+" €";
            }
            
            var productQuantity = cartProducts[i+3]

            // Insert a cell at the end of the row
            var removeCell = addProductRow.insertCell();
            removeCell.innerHTML='<a href="#" class="btn-remove-article"><i class="far fa-times-circle"></i></a>'
            
            var productImageCell = addProductRow.insertCell();
            var imageInnerHTMLString = '<img class="product-image" src="' + productImage + '" alt="">'
            productImageCell.innerHTML = imageInnerHTMLString
            
            var productNameCell = addProductRow.insertCell();
            productNameCell.className = 'product-name'
            var productNameTextContent = document.createTextNode(productName);
            productNameCell.appendChild(productNameTextContent);
            
            var productPriceCell = addProductRow.insertCell();
            productPriceCell.className = 'cart-price'
            var productPriceTextContent = document.createTextNode(productPrice);
            productPriceCell.appendChild(productPriceTextContent);
            
            var productQuantityCell = addProductRow.insertCell();
            var imageInnerHTMLString = '<input class="cart-quantity-input" type="number" value="' + productQuantity + '">'
            productQuantityCell.innerHTML = imageInnerHTMLString
            
            var productPriceSubTotalCell = addProductRow.insertCell();
            productPriceSubTotalCell.className = 'cart-quantity-subtotal-input';

            var priceParsed= parseFloat(productPrice.replace('€', '').replace(',', '.'))
            var productPriceSubTotalTextContent = document.createTextNode(priceItemSubTotal(priceParsed, productQuantity) + " €");
            productPriceSubTotalCell.appendChild(productPriceSubTotalTextContent);
        }

}

function cartBadgeNumber() {
    let quantityOfCartElements = getCookie("CartNumberOfArticles");
    if (quantityOfCartElements != "") {
        var quantityOfCartElementsToInt = quantityOfCartElements

        //document.getElementsByClassName('cart-badge')[0].innerHTML = quantityOfCartElementsToInt
        const cartBadge = document.getElementsByClassName('cart-badge');
        for (var i = 0; i < cartBadge.length; i++) {
            cartBadge[i].innerHTML = quantityOfCartElementsToInt;
        }
    } else {
        //document.getElementsByClassName('cart-badge')[0].innerHTML = '';
        const cartBadge = document.getElementsByClassName('cart-badge');
        for (var i = 0; i < cartBadge.length; i++) {
            cartBadge[i].innerHTML = '';
        }
    }
}


function updateCartBadgeNumber() {
    console.log('Badge Number: ' + document.getElementsByClassName('cart-badge')[0].innerHTML);

    var tbody = document.querySelector('.cart-items');

    var trElements = tbody.querySelectorAll('.cart-item');

    var numberOfRows = trElements.length;

    console.log('Anzahl der tr-Elemente: ' + numberOfRows);

    const cartBadge = document.getElementsByClassName('cart-badge');

    if(numberOfRows == 0) {
        //document.getElementsByClassName('cart-badge')[0].innerHTML = ''
        for (var i = 0; i < cartBadge.length; i++) {
            cartBadge[i].innerHTML = '';
        }
        
    } else {
        //document.getElementsByClassName('cart-badge')[0].innerHTML = numberOfRows

        let quantityOfCartElements = getCookie("CartNumberOfArticles");
        //document.getElementsByClassName('cart-badge')[0].innerHTML = quantityOfCartElements
        for (var i = 0; i < cartBadge.length; i++) {
            cartBadge[i].innerHTML = quantityOfCartElements;
        }
    }
}

function updateOrderList() {
    const orderedProductsArrayCookieMonster = cookiemonster.get('OrderedProductsArray')
    if(orderedProductsArrayCookieMonster != "") {

        var tbodyRef = document.getElementById('order').getElementsByTagName('tbody')[0];

        let showOrderProducts = []

        showOrderProducts = orderedProductsArrayCookieMonster

        console.log('Ordered ProductsArray New Elements:' + showOrderProducts)
          
        for(i=0; i < showOrderProducts.length; i+=6) {
            // Insert a row at the end of table
            var addProductRow = tbodyRef.insertRow();
            addProductRow.className = 'order-item';

            console.log(i)

            var orderDate = showOrderProducts[i]
            var orderNumber = showOrderProducts[i+1]
            var productName = showOrderProducts[i+2]
            var productPrice = showOrderProducts[i+4]+" €";

            var productQuantity = showOrderProducts[i+5]

            // Insert a cell at the end of the row

            var productOrderDate = addProductRow.insertCell();
            productOrderDate.innerHTML = orderDate

            var productOrderCell = addProductRow.insertCell();
            productOrderCell.innerHTML = orderNumber
            
            var productNameCell = addProductRow.insertCell();
            productNameCell.className = 'product-name'
            var productNameTextContent = document.createTextNode(productName);
            productNameCell.appendChild(productNameTextContent);
            
            var productQuantityCell = addProductRow.insertCell();
            productQuantityCell.innerHTML = productQuantity;
            
            var productPriceSubTotalCell = addProductRow.insertCell();
            productPriceSubTotalCell.className = 'order-quantity-subtotal-input';

            var priceParsed= parseFloat(productPrice.replace('€', '').replace(',', '.'))
            var productPriceSubTotalTextContent = document.createTextNode(priceItemSubTotal(priceParsed, productQuantity) + " €");
            productPriceSubTotalCell.appendChild(productPriceSubTotalTextContent);
        }


const orderItems = document.querySelectorAll('.order-item');

const orderNumberCountMap = new Map();

let prevItem = null;

orderItems.forEach(item => {
  const orderNumberCell = item.querySelector('td:nth-child(2)');
  const orderNumber = orderNumberCell.textContent.trim();

  const orderDateCell = item.querySelector('td:nth-child(1)');

  const isEmptyOrderNumber = orderNumber === '';

  const count = orderNumberCountMap.get(orderNumber) || 0;
  orderNumberCountMap.set(orderNumber, count + 1);
  
  if (count === 0 && !isEmptyOrderNumber) {
    prevItem = item;
  } else {
    orderNumberCell.textContent = ' ';
    orderDateCell.textContent = ' ';
    item.style.borderBottom = 'none';
    if (prevItem) {
      const prevOrderItem = prevItem.previousElementSibling;
      if (prevOrderItem && prevOrderItem.classList.contains('order-item')) {
        prevOrderItem.style.borderBottom = '1px solid #e2e9e1';
      }
    }
  }
});


    }
}



function updateQuantityCookie() {
    // calculate quantity of cart badge
    let cartProducts = cookiemonster.get("CartProducts")
    var sumQuantity = 0
    for(i=3; i <= cartProducts.length; i+=4) {
        sumQuantity += parseInt(cartProducts[i])
        console.log("For: " + cartProducts[i] + " cartProducts: " + parseInt(cartProducts[i]))
    }
    setCookie("CartNumberOfArticles", sumQuantity, 1)
}

/*** My recent orders ->button<- ***/

function updateMessageEmptyOrderList() {

    const showMessageEmptyOrderList = document.querySelector('.show-message-empty-order-list');

    showMessageEmptyOrderList.style.display = "block";
}

function addOrderNumberAfterEveryFourthComma(inputString, orderNumber) {
    const parts = inputString.split(',');

    for (let i = 4; i < parts.length; i += 5) {
        parts.splice(i, 0, orderNumber);
      }
    
      const resultString = parts.join(',');

  console.log(resultString);

  return resultString;
  }


function showMessageCartEmpty() {

    const CartNumberOfArticles = getCookie("CartNumberOfArticles")

    const showEmptyCartMessage = document.querySelector('.show-message-empty-shopping-basket');

    if(CartNumberOfArticles != "") {
        if(CartNumberOfArticles > 0) {
            showEmptyCartMessage.style.display = 'none';
        }
        else {
            showEmptyCartMessage.style.display = 'block';
        }
    }
    else {
        showEmptyCartMessage.style.display = 'none';
    }
}


/* Send user shopping cart to DB */
var proceed_checkoutIDExists = document.getElementById('proceed-checkout')
if(document.body.contains(proceed_checkoutIDExists)) {

    document.getElementById('proceed-checkout').addEventListener('click', async (e) => {
        e.preventDefault();

        const userLoggedInCheck = getCookie('userLoggedIn');
        const cartNotEmptyCheck = getCookie('CartNumberOfArticles');

        if (userLoggedInCheck != "") {
            if(cartNotEmptyCheck != "") {
                if(cartNotEmptyCheck > 0) {

                    let sweetAlert_OrderConfirmationTitle = data_cart.en.sweetAlert_OrderConfirmationTitle;
                    let sweetAlert_OrderConfirmation = data_cart.en.sweetAlert_OrderConfirmation;
                    let sweetAlert_OrderConfirmationConfirmBtn = data_cart.en.sweetAlert_OrderConfirmationConfirmBtn;
                    let sweetAlert_OrderConfirmationCancelBtn = data_cart.en.sweetAlert_OrderConfirmationCancelBtn;
                    if(getLanguage() == "DE") {
                        sweetAlert_OrderConfirmationTitle = data_cart.de.sweetAlert_OrderConfirmationTitle;
                        sweetAlert_OrderConfirmation = data_cart.de.sweetAlert_OrderConfirmation;
                        sweetAlert_OrderConfirmationConfirmBtn = data_cart.de.sweetAlert_OrderConfirmationConfirmBtn;
                        sweetAlert_OrderConfirmationCancelBtn = data_cart.de.sweetAlert_OrderConfirmationCancelBtn;
                    }
                    Swal.fire({
                        title: sweetAlert_OrderConfirmationTitle,
                        text: sweetAlert_OrderConfirmation,
                        //showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: sweetAlert_OrderConfirmationConfirmBtn,
                        cancelButtonText: sweetAlert_OrderConfirmationCancelBtn, // cancel
                        //denyButtonText: `Abbrechen`,
                        confirmButtonColor: "#088178",
                        reverseButtons: "true",
                        color: "#162938",
                        background: "#e3e6f3",
                      }).then(async (result) => {
                        if (result.isConfirmed) {
                          //Swal.fire("Saved!", "", "success");

                        const totalPrice = document.querySelector('.cart-total-price').textContent.replace(',', '.');

                          // update ordered products
                        const orderNumberForEmail = updateOrderedProducts();

                        let cartProducts = []
            
                        let cartProductsOneClickExist = getCookie('CartProducts')
                        if (cartProductsOneClickExist != "") {
                            let cartProductsOneClick = cookiemonster.get('CartProducts')
                            cartProducts = cartProductsOneClick
                        }
                        cartProducts.unshift(getOrderDate());

                        let orderItems = document.querySelectorAll('.order-items .order-item');

                        // Iteriere durch jedes gefundene Element und entferne es
                        orderItems.forEach(item => {
                            item.remove();
                        });

                        updateOrderList();

                            const emailAddressHashed = getCookie("userEmailHashed")

                            if(emailAddressHashed != "") {
                                let numberOfOrders = getCookie("numberOfOrders");

                                if(numberOfOrders == "") {
                                    setCookie("numberOfOrders", 1, 1)
                                    numberOfOrders = "1"
                                }


                                let couponActivated = false;
                                if(getCookie("couponActivated") == "true") {
                                    couponActivated = true;
                                    // do not allow coupon use again
                                    setCookie("couponAlreadyUsed", "true", 8);
                                    document.querySelector("#coupon-value-euro").textContent = "-";
                                }

                                let registrationCode = "";
                                if(getCookie("registrationCode") != "") {
                                    registrationCode = getCookie("registrationCode");
                                }

                                var orderTimer = "";
                                try {
                                    orderTimer = ((Date.now()-1711642572222) / 1000).toString();
                                    orderTimer = orderTimer.split(".")[0];
                                } catch (error) {
                                    orderTimer = "error_timer";
                                }
                                // console.log("Seconds:" + seconds);

                                let responseUserOrderToDB = "";
                                await userOrderToDB('userShoppingCardOrderFM', emailAddressHashed, registrationCode, numberOfOrders, cartProducts, totalPrice, couponActivated, getDevice(), orderTimer)
                                    .then(response => {
                                        console.log("Result from userOrderToDB(): " + response);
                                        responseUserOrderToDB = response
                                
                                    })
                                    .catch(error => {
                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                    });

                                console.log(responseUserOrderToDB);



                                // increase order number by 1
                                setCookie("numberOfOrders", parseInt(numberOfOrders)+1, 1);


                                const emailAddress = getCookie("userEmailAddress");
                                
                                if(responseUserOrderToDB == "shoppingCardUpdatedSuccessully" || responseUserOrderToDB == "shoppingCardUpdatedSuccessullyCouponAlreadySend") {
                                    // get language for emails...
                                    const languageCookie = getCookie("language");
                                    if(languageCookie == "") {
                                        languageCookie == "DE";
                                    }
                                    

                                    // send order confirmation if firestore db order update successfully
                                    sendEmailOrderConfirmation('emailOrderConfirmationFM', emailAddress, orderNumberForEmail, cartProducts, totalPrice, couponActivated, languageCookie)
                                    .then(response => {
                                        console.log("Result from emailOrderConfirmationFM(): " + response);
                                    })
                                    .catch(error => {
                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                    });
                                }
                                /***************************/
                                /*** Send Coupon to user ***/
                                /***************************/
                                if(responseUserOrderToDB == "shoppingCardUpdatedSuccessully") {

                                    
                                    // prevent from sending multiple coupons to one user
                                    if(getCookie("couponEmailSend") == "") {
                                        const registrationCode = getCookie("registrationCode");
                                        const study_scenario = getCookie("scenario");
                                        const study_scenario_domain = getCookie("scenarioDomain"); // used to differentiate between coupon domain smartbuyonline.de and couponcampaign.org

                                        if(study_scenario != "") // != ""
                                            var responseSendEmailCouponValid = "";
                                            /*** SCENARIO 1 - HYPERLINK VALID ***/
                                            if(study_scenario == "1") {
                                                sendEmailCoupon('emailCouponValidHyperlinkFM', emailAddress, registrationCode, languageCookie)
                                                .then(response => {
                                                    console.log("Result from emailCouponValidHyperlinkFM(): " + response);
                                                    responseSendEmailCouponValid = response;
                                            
                                                })
                                                .catch(error => {
                                                    console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                });
                                            }
                                            /*** SCENARIO 2 - QR Code VALID ***/
                                            else if (study_scenario == "2") {
                                                sendEmailCoupon('emailCouponValidQRCodeFM', emailAddress, registrationCode, languageCookie)
                                                .then(response => {
                                                    console.log("Result from emailCouponValidQRCodeFM(): " + response);
                                                    responseSendEmailCouponValid = response;
                                            
                                                })
                                                .catch(error => {
                                                    console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                });
                                            }
                                            /*** SCENARIO 3 - HYPERLINK PHISHING ***/
                                            else if (study_scenario == "3") {
                                                if(study_scenario_domain == "1") {
                                                    sendEmailCoupon_Smart_Buy_Online('emailCouponPhishingHyperlinkSmart_Buy_OnlineFM', emailAddress, registrationCode, languageCookie)
                                                    .then(response => {
                                                        console.log("Result from emailCouponPhishingHyperlinkSmart_Buy_OnlineFM(): " + response);
                                                        responseSendEmailCouponValid = response;
                                                
                                                    })
                                                    .catch(error => {
                                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                    });
                                                }
                                                else if (study_scenario_domain == "2") {
                                                    sendEmailCoupon_CouponCampaign('emailCouponPhishingHyperlinkCouponCampaignFM', emailAddress, registrationCode, languageCookie)
                                                    .then(response => {
                                                        console.log("Result from emailCouponPhishingHyperlinkCouponCampaignFM(): " + response);
                                                        responseSendEmailCouponValid = response;
                                                
                                                    })
                                                    .catch(error => {
                                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                    });
                                                }

                                            }
                                            /*** SCENARIO 4 - QR Code PHISHING ***/
                                            else if (study_scenario == "4") {
                                                if(study_scenario_domain == "1") {
                                                    sendEmailCoupon_Smart_Buy_Online('emailCouponPhishingQRCodeSmart_Buy_OnlineFM', emailAddress, registrationCode, languageCookie)
                                                    .then(response => {
                                                        console.log("Result from emailCouponPhishingQRCodeSmart_Buy_OnlineFM(): " + response);
                                                        responseSendEmailCouponValid = response;
                                                
                                                    })
                                                    .catch(error => {
                                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                    });
                                                }
                                                else if (study_scenario_domain == "2") {
                                                    sendEmailCoupon_CouponCampaign('emailCouponPhishingQRCodeCouponCampaignFM', emailAddress, registrationCode, languageCookie)
                                                    .then(response => {
                                                        console.log("Result from emailCouponPhishingQRCodeCouponCampaignFM(): " + response);
                                                        responseSendEmailCouponValid = response;
                                                
                                                    })
                                                    .catch(error => {
                                                        console.error('Fehler beim Verarbeiten des Ergebnisses:', error);
                                                    });
                                                }
                                            }
                                            // prevent from sending further coupon emails
                                            setCookie("couponEmailSend", "true", 8);
                                    }
                                }
                            }


                                

                            // empty cart products and number of articles
                            setCookie('CartProducts', '', 1)
                            setCookie("CartNumberOfArticles","0",1)
                    

                            // remove all products from html element tree
                            document.querySelectorAll(".cart-item").forEach(el => el.remove());
                    
                            // show empty shopping cart message
                            const showEmptyCartMessage = document.querySelector('.show-message-empty-shopping-basket');
                            showEmptyCartMessage.style.display = 'block';


                            //updateQuantityCookie()
                    
                            cartBadgeNumber()

                            // update cart
                            updateCartTotal()
                    


                            let sweetAlert_OrderSuccessfullySubmitted = data_cart.en.sweetAlert_OrderSuccessfullySubmitted;
                            if(getLanguage() == "DE") {
                                sweetAlert_OrderSuccessfullySubmitted = data_cart.de.sweetAlert_OrderSuccessfullySubmitted;
                            }
                            Swal.fire({
                                text: sweetAlert_OrderSuccessfullySubmitted,
                                timer: 3000,
                                color: "#162938",
                                icon: "success",
                                showConfirmButton: false,
                                background: "#e3e6f3",
                            });
                            
                            }
                        });

                    

                }
                else {
                    let sweetAlert_MessageEmptyShoppingCart = data_cart.en.sweetAlert_MessageEmptyShoppingCart;
                    if(getLanguage() == "DE") {
                        sweetAlert_MessageEmptyShoppingCart = data_cart.de.sweetAlert_MessageEmptyShoppingCart;
                    }
                    Swal.fire({
                        text: sweetAlert_MessageEmptyShoppingCart,
                        timer: 2000,
                        color: "#162938",
                        icon: "error",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                    });
                }
            }
            else {
                let sweetAlert_MessageEmptyShoppingCart = data_cart.en.sweetAlert_MessageEmptyShoppingCart;
                if(getLanguage() == "DE") {
                    sweetAlert_MessageEmptyShoppingCart = data_cart.de.sweetAlert_MessageEmptyShoppingCart;
                }
                Swal.fire({
                    text: sweetAlert_MessageEmptyShoppingCart,
                    timer: 2000,
                    color: "#162938",
                    icon: "error",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                });
            }
        }
        // else userLoggedIN=="" 
        else {            
            let sweetAlert_RegisterLoginToContinue = data_cart.en.sweetAlert_RegisterLoginToContinue;
            if(getLanguage() == "DE") {
                sweetAlert_RegisterLoginToContinue = data_cart.de.sweetAlert_RegisterLoginToContinue;
            }
            Swal.fire({
                text: sweetAlert_RegisterLoginToContinue,
                timer: 3000,
                color: "#162938",
                icon: "info",
                showConfirmButton: false,
                background: "#e3e6f3",
            });
            
            
            const screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
            const screenHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
            if(screenWidth < 520 || screenHeight < 750) {
                setTimeout(function() {
                    // go to home.html
                    document.location.href = "https://www.smartbuyonline.de/index.html";
                }, 1500);

            } else {

                
                const loginPageElements = document.querySelector('.login-page-node-notification');
                loginPageElements.style.display = 'block';
            }



        }
    });
}


const couponButtonClickEvent = document.querySelector('.applyCouponButton');
if(document.body.contains(couponButtonClickEvent)) {

    couponButtonClickEvent.addEventListener('click', async (e) => {
        e.preventDefault();

        let couponButtonForm = document.querySelector("#language-cart-coupon-input").value;

        if(couponButtonForm != "") {
            if(couponButtonForm=="OUTFIT" || couponButtonForm=="Outfit" || couponButtonForm=="outfit") {

                if(getCookie("couponActivated") == "") {
                    if(getLanguage() == "DE") {
                        document.querySelector("#coupon-value-euro").textContent = "- 50,00 €";
                    } else {
                        document.querySelector("#coupon-value-euro").textContent = "- 50.00 €";
                    }
                    

                    updateCartTotal();

                    setCookie("couponActivated", "true", 1);

                    document.getElementById("language-cart-coupon-input").value = '';

                    let sweetAlert_CouponActivatedConfirmation = data_cart.en.sweetAlert_CouponActivatedConfirmation;
                    if(getLanguage() == "DE") {
                        sweetAlert_CouponActivatedConfirmation = data_cart.de.sweetAlert_CouponActivatedConfirmation;
                    }
                    Swal.fire({
                        text: sweetAlert_CouponActivatedConfirmation,
                        timer: 2000,
                        color: "#162938",
                        icon: "success",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                    });
                }
                
                else {
                    console.log("Coupon already used");

                    let sweetAlert_CouponAlreadyActivated = data_cart.en.sweetAlert_CouponAlreadyActivated;
                    if(getLanguage() == "DE") {
                        sweetAlert_CouponAlreadyActivated = data_cart.de.sweetAlert_CouponAlreadyActivated;
                    }
                    Swal.fire({
                        text: sweetAlert_CouponAlreadyActivated,
                        timer: 2000,
                        color: "#162938",
                        icon: "info",
                        showConfirmButton: false,
                        background: "#e3e6f3",
                    });
                }
            }
            else {
                console.log("Coupon invalid");

                let sweetAlert_CouponInvalid = data_cart.en.sweetAlert_CouponInvalid;
                if(getLanguage() == "DE") {
                    sweetAlert_CouponInvalid = data_cart.de.sweetAlert_CouponInvalid;
                }
                Swal.fire({
                    text: sweetAlert_CouponInvalid,
                    timer: 2000,
                    color: "#162938",
                    icon: "error",
                    showConfirmButton: false,
                    background: "#e3e6f3",
                });
            }
        }
    });
}


function couponActivated() {
    if(getCookie("couponActivated") != "" && getCookie("OrderedProductsArray") == "") {
        if(getLanguage() == "DE") {
            document.querySelector("#coupon-value-euro").textContent = "- 50,00 €";
        } else {
            document.querySelector("#coupon-value-euro").textContent = "- 50.00 €";
        }

    }
}


/* !!!!! FIX FUNCTION !!!!! */
function updateCartTotal() {
    var cartItemContainer = document.getElementsByClassName('cart-items')[0]
    var cartItems = cartItemContainer.getElementsByClassName('cart-item')

    var total = 0;
    for(var i = 0; i < cartItems.length; i++) {
        var cartItem = cartItems[i]
        var priceElement = cartItem.getElementsByClassName('cart-price')[0]
        var quantityElement = cartItem.getElementsByClassName('cart-quantity-input')[0]
        console.log(priceElement, quantityElement)

        var price = parseFloat(priceElement.innerText.replace('€', '').replace(',', '.'))
        console.log(price)

        var quantity = quantityElement.value
        console.log(price * quantity)

        total = total + (price * quantity)
        total = Math.round(total * 100) / 100;
    }


    try {
        total = (Math.round(total * 100) / 100).toFixed(2);
    } catch (error) {
        total = Math.round(total * 100) / 100;
    }

    if(getLanguage() == "DE") {
        total = total.toString().replace('.', ',');
    }
    document.getElementsByClassName('cart-subtotal-price')[0].innerText = total + " €";

    // coupon
    total = total.toString().replace(',', '.');
    if(document.querySelector('#coupon-value-euro').textContent.toString()!="-") {
        try {
            total = (Math.round((parseFloat(total) - 50.00)* 100) / 100).toFixed(2);
        } catch (error) {
            total = (Math.round(parseFloat(total) * 100) / 100)-50.00;
        }
    }
    

	if((Math.round((parseFloat(total))* 100) / 100).toFixed(2) < 0.0) {
		total = "0.00";
    }

    if(getLanguage() == "DE") {
        total = total.toString().replace('.', ',');
    } else {
        total = total.toString().replace(',', '.');
    }
    document.getElementsByClassName('cart-total-price')[0].innerText = total + " €";

}


/*** My recent orders (also in "cart_script.js")***/
function updateOrderedProducts() {

    // remove empty order list message
    const showMessageEmptyOrderList = document.querySelector('.show-message-empty-order-list');
    showMessageEmptyOrderList.style.display = "none";


    let cardProductsArray = getCookie('CartProducts').replace('<#&type=ArrayVals>,','');

    let orderedProductsArray = getCookie('OrderedProductsArray');
    // ordered Products already exist

    // add orderNumber
    let orderNumber = "";
    // change orderNumber if multiple logins or number of orders > 1
    // just to be sure set numbers of orders to zero...
    if(getCookie("numberOfOrders") == "") {
        setCookie("numberOfOrders", 0, 8);
    }
    let numberLogins = getCookie("numberLogins");
    if ((numberLogins != "" && parseInt(numberLogins) > 1) || (getCookie("numberOfOrders") > 0)) {
        // second order (potentially with coupon)
        orderNumber = "53914" + (Math.floor(Math.random() * (9999 - 1000 + 1) ) + 1000).toString();
    }
    else {
        // first order
        orderNumber = "10752" + (Math.floor(Math.random() * (9999 - 1000 + 1) ) + 1000).toString();
    }

    const orderDate = getOrderDate();
    if (orderedProductsArray != "") {
        let orderedProductsArray_modified = orderedProductsArray.replace('<#&type=ArrayVals>,','');

        const cardProductsArray_modified = '<#&type=ArrayVals>,' + orderDate + "," + orderNumber + "," + addOrderNumberAfterEveryFourthComma(cardProductsArray, orderDate+","+orderNumber); // and order date
        const orderedProductsArray_addedCard =  cardProductsArray_modified + "," + orderedProductsArray_modified;

        setCookie("OrderedProductsArray",orderedProductsArray_addedCard,1);
    }
    else {
        cardProductsArray = '<#&type=ArrayVals>,' + orderDate + "," + orderNumber + "," + addOrderNumberAfterEveryFourthComma(cardProductsArray, orderDate+","+orderNumber); // and order date

        //const orderNumber = "10752" + (Math.floor(Math.random() * (9999 - 1000 + 1) ) + 1000).toString()
        //cardProductsArray = '<#&type=ArrayVals>,' + cardProductsArray.replace(/€,/g, "€," + orderNumber + ",");

        setCookie("OrderedProductsArray",cardProductsArray,1);
    }

    return orderNumber;
}


function priceItemSubTotal (price, quantity) {
    let priceItemSubTotalInt = price * quantity;
    try {
        priceItemSubTotalInt = (Math.round(priceItemSubTotalInt * 100) / 100).toFixed(2);
    } catch (error) {
        priceItemSubTotalInt = Math.round(priceItemSubTotalInt * 100) / 100;
    }
    let priceItemSubTotal = priceItemSubTotalInt.toString()
    if(getLanguage() == "DE") {
        priceItemSubTotal = priceItemSubTotal.toString().replace('.', ',');
    }
    let decimalSeparator = priceItemSubTotal.includes(',') ? ',' : '.';
    let decimalPart = priceItemSubTotal.split(decimalSeparator)[1];
    if (decimalPart && decimalPart.length === 1) {
        priceItemSubTotal += '0';
    }

    return priceItemSubTotal;
}


function getOrderDate() {
    let orderDate = "2024";
    try {
        var currentdate = new Date(); 
        /*var datetime = "Last Sync: " + currentdate.getDate() + "/"
            + (currentdate.getMonth()+1)  + "/" 
            + currentdate.getFullYear() + " @ "  
            + currentdate.getHours() + ":"  
            + currentdate.getMinutes() + ":"    
            + currentdate.getSeconds(); */

        const month = ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];

        // Führende Null für Minuten hinzufügen, wenn sie kleiner als 10 sind
        const minutes = (currentdate.getMinutes() < 10 ? '0' : '') + currentdate.getMinutes();

        orderDate = currentdate.getDate() + "." 
                    + month[currentdate.getMonth()] + " "
                    + currentdate.getFullYear() + " - "
                    + currentdate.getHours() + ":"  
                    + minutes; // currentdate.getMinutes(); //+ ":";
                    //+ currentdate.getSeconds();

    } catch (error) {
        console.error(error);
    }

  return orderDate;
}

