const { uploadProcessedData, getData, registerUser, loginUser, verifyEmailAddress, userShoppingCardOrder, dataCoupon, dataOpenedPhishingWebsite } = require('./firebase');
const { emailRegistration,
        emailLoginNotification,
        emailPasswordReset,

        emailOrderConfirmation,

        emailCouponValidHyperlink,
        emailCouponValidQRCode,
      } = require('./email');

/* Firebase Function Calls */
async function registerUserFM(params) {
  
  const userEmailAddress = params[0];
  const userRegistrationCode = params[1];
  const userDevice = params[2];
  const registrationTimer = params[3];

    const response = await registerUser(userEmailAddress, userRegistrationCode, userDevice, registrationTimer);
    return response;
  }
  
async function loginUserFM(param) {

  const response = await loginUser(param);
  return response;
}

async function verifyEmailAddressFM(param1, param2) {

  const response = await verifyEmailAddress(param1, param2);
  return response;
}


async function userShoppingCardOrderFM(param1, param2, param3, param4, param5, param6, param7, param8) {

  const response = await userShoppingCardOrder(param1, param2, param3, param4, param5, param6, param7, param8);
  return response;
}


/***** Firestoe DB Coupon Calls *****/
async function dataCouponFM(param1, param2, param3) {

  const response = await dataCoupon(param1, param2, param3);
  return response;
}

async function dataOpenedPhishingWebsiteFM(param1, param2) {

  const response = await dataOpenedPhishingWebsite(param1, param2);
  return response;
}




/***** Email Function Calls *****/

/* Registration Email */
async function emailRegistrationFM(param1, param2) {
  try {
    await emailRegistration(param1, param2);
    
    return "SendEmail_Registration_Successfully";
  }
  catch (error) {
    return "SendEmail_Registration_Error";
  }
}

/* Login Notification Email */
async function emailLoginNotificationFM(param1, param2) {
  try {
    await emailLoginNotification(param1, param2);
    
    return "SendEmail_LoginNotification_Successfully";
  }
  catch (error) {
    return "SendEmail_LoginNotification_Error";
  }
}

/* Reset Password Email */
async function emailPasswordResetFM(param1, param2) {
  try {
    await emailPasswordReset(param1, param2);
    
    return "SendEmail_ResetPasswort_Successfully";
  }
  catch (error) {
    return "SendEmail_ResetPasswort_Error";
  }
}

/* Order Confirmation Email */
async function emailOrderConfirmationFM(param1, param2, param3, param4, param5, param6) {
  try {
    await emailOrderConfirmation(param1, param2, param3, param4, param5, param6);
    
    return "SendEmail_Order_Confirmation_Successfully";
  }
  catch (error) {
    return "SendEmail_Order_Confirmation_Error";
  }
}

/* Valid Hyperlink Coupon (Scenario 1) */
async function emailCouponValidHyperlinkFM(param1, param2, param3) {
  try {
    await emailCouponValidHyperlink(param1, param2, param3);
    
    return "SendEmail_Coupon_ValidHyperlink_Successfully";
  }
  catch (error) {
    return "SendEmail_Coupon_ValidHyperlink_Error";
  }
}

/* Valid QR Code Coupon (Scenario 2) */
async function emailCouponValidQRCodeFM(param1, param2, param3) {
  try {
    await emailCouponValidQRCode(param1, param2, param3);
    
    return "SendEmail_Coupon_ValidQRCode_Successfully";
  }
  catch (error) {
    return "SendEmail_Coupon_ValidQRCode_Error";
  }
}

  function funktion3() {
    return 'Success! Funktion 3 ohne Parameter';
  }
  
  
  async function testServerAlive(param1) {

    const data = "*** NodeJS Server is running ***";

    console.log(data);

    return `${data}`;
  }
  
  module.exports = {
    registerUserFM,
    loginUserFM,
    verifyEmailAddressFM,

    emailOrderConfirmationFM,

    userShoppingCardOrderFM,

    dataCouponFM,
    dataOpenedPhishingWebsiteFM,

    emailRegistrationFM,
    emailLoginNotificationFM,
    emailPasswordResetFM,

    emailCouponValidHyperlinkFM,
    emailCouponValidQRCodeFM,

    funktion3,
    testServerAlive,
  };