var SHA256 = require("crypto-js/sha256");

const { errorHandler } = require('./helpers');

const { initializeApp } = require('firebase/app');
const { getFirestore, doc, setDoc, getDoc, updateDoc } = require('firebase/firestore');

require('dotenv').config();
const {
    FIREBASE_API_KEY,
    FIREBASE_AUTH_DOMAIN,
    FIREBASE_PROJECT_ID,
    FIREBASE_STORAGE_BUCKET,
    FIREBASE_MESSAGE_SENDER_ID,
    FIREBASE_APP_ID,

    FIREBASE_COLLECTION_REGISTERED_USERS,
    FIREBASE_COLLECTION_REGISTRATION_CODES,
    FIREBASE_COLLECTION_REGISTRATION_CODES_HASHED,
} = process.env;


const firebaseConfig = {
    apiKey: FIREBASE_API_KEY,
    authDomain: FIREBASE_AUTH_DOMAIN,
    projectId: FIREBASE_PROJECT_ID,
    storageBucket: FIREBASE_STORAGE_BUCKET,
    messagingSenderId: FIREBASE_MESSAGE_SENDER_ID,
    appId: FIREBASE_APP_ID,
};

const onlineShopRegistrationCodeCollection = FIREBASE_COLLECTION_REGISTRATION_CODES;
const onlineShopRegistrationCodeHashedCollection = FIREBASE_COLLECTION_REGISTRATION_CODES_HASHED;
const onlineShopRegisteredUsersCollection = FIREBASE_COLLECTION_REGISTERED_USERS;

let app;
let firestoreDB;
/* Initialize Firebase App DB */
const intitializeFirebaseApp = () => {
    try {
        app =initializeApp(firebaseConfig);
        firestoreDB = getFirestore();
        return app;
    } catch (error) {
        errorHandler(error, "Error when connectiong to fireabase.");
    }
};


/* Register (new) User with email address */
const registerUser = async (userEmailAddress, userRegistrationCode, userDevice, registrationTimer) => {

    try {
        const docRef_RegistrationCode = doc(firestoreDB, onlineShopRegistrationCodeCollection, userRegistrationCode);
        const docExist_RegistrationCode = await getDoc(docRef_RegistrationCode);

        if (docExist_RegistrationCode.exists()) {

            var hash = SHA256(userEmailAddress).toString();
            hash = hash.slice(0, 12);
        
            const docRef_RegisteredUsers = doc(firestoreDB, onlineShopRegisteredUsersCollection, hash);
            const docExist_RegisteredUsers = await getDoc(docRef_RegisteredUsers);
            
            // User Email Address already exist
            if (docExist_RegisteredUsers.exists()) {
            console.log("User email address (12 digit email hash) already registered!");
        
            return "userEmailAddressAlreadyExist";
        
            // User Email Address Successfully registered
            }
            else {
                const scenario = docExist_RegistrationCode.get("scenario");
                const scenarioCoupon = docExist_RegistrationCode.get("scenario_domain");

                const userRegistrationCodeHashed = SHA256(userRegistrationCode).toString().slice(0, 12);

                const registration_device = userDevice;
                await setDoc(doc(firestoreDB, onlineShopRegisteredUsersCollection, hash), {
                    registration_code: userRegistrationCode,
                    registration_code_hashed: userRegistrationCodeHashed,
                    scenario: scenario,
                    scenario_domain: scenarioCoupon,
                    email_address: userEmailAddress,
                    email_hashed: hash,
                    coupon_order_activated: false,
                    coupon_used: false,
                    registration_verified: false,
                    number_logins: 0,
                    user_device_registration: registration_device,       //user_devices: [registration_device]
                    registration_timer: registrationTimer
                    });

                // set qualtrics coupon used and website opened fields...
                try {
                    setDoc(doc(firestoreDB, onlineShopRegistrationCodeHashedCollection, userRegistrationCodeHashed), {
                        registration_code_hashed: userRegistrationCodeHashed,
                        coupon_website_opened: false,
                        coupon_email_opened: false,
                        coupon_used: false,
                        coupon_order_activated: false
                    });
                } catch (error) {
                    errorHandler(error, "Error updating registration code hashed in DB.");
                }

                return "userEmailAddressRegistered";
            }
        }
        // Registration Code does not exist in DB
        else {
            return "userWrongRegistrationCode";
        }
    } catch (error) {
        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
    }
};

const loginUser = async (userEmailAddress) => {
    let userEmailAddressHashed = SHA256(userEmailAddress).toString().slice(0, 12);
    console.log("User Address Hashed: " + userEmailAddressHashed);
    try {
        const docRef_LoginUser = doc(firestoreDB, onlineShopRegisteredUsersCollection, userEmailAddressHashed);
        const docSnapshot = await getDoc(docRef_LoginUser);
        if (docSnapshot.exists()) {
            console.log('Dokument existiert:', docSnapshot.data());
            const registrationMailVerified = docSnapshot.get("registration_verified");
            if(registrationMailVerified) {

                let numberLogins = docSnapshot.get("number_logins");
                numberLogins += 1;
                let updateData = {};
                updateData["number_logins"] = numberLogins;

                await updateDoc(docRef_LoginUser, updateData)
                .catch((error) => {
                    errorHandler(error, "Error updating number of user login attempts in DB.")
                });


                console.log("User email address is verified. Continue login...");
                const returnLoggedInSuccessful_RegistrationCode = "userLoginSuccessful";
                return { status: "success", message: returnLoggedInSuccessful_RegistrationCode, userData: docSnapshot.data() };
            } else {
                console.log("User email address exist, but is not verified yet.");
                return { status: "error", message: "userRegistered_EmailAddressNotVerified", userData: null };
            }
        } else {
            console.log('User Email address is not registered.');
            return { status: "error", message: "userNotRegistered", userData: null };
        }
    } catch (error) {
        errorHandler(error, "Error connecting or retrieving data from Firestore DB.");
        throw error;
    }
};


/* set user email address verified, i.e., update registered user */
const verifyEmailAddress = async (userEmailAddressHashed, userDevice) => {
    try {
        const docRef_RegisteredUsers = doc(firestoreDB, onlineShopRegisteredUsersCollection, userEmailAddressHashed);
        
        const verification_device = userDevice;
        await updateDoc(docRef_RegisteredUsers, {
            "registration_verified": true,
            user_device_emailverification: verification_device
        });
        return "userRegistrationVerification_Succesful";

    } catch (error) {
        console.log("Update Firestore DB registration status failed. User hash does not exist");

        return "userRegistrationVerification_Error_WrongVerificationEmailAddress";
    }
};

/* Send user order to Firestore DB */
const userShoppingCardOrder = async (userEmailAddressHashed, registrationCode, userOrderNumber, userOrderItems, totaPrice, couponActivated, userDevice, registrationTimer) => {

    try {
        const docRef_shoppingCardOrder = doc(firestoreDB, onlineShopRegisteredUsersCollection, userEmailAddressHashed);
        
            const docSnapshot = await getDoc(docRef_shoppingCardOrder);
            if (docSnapshot.exists()) {
                console.log('Dokument existiert:', docSnapshot.data());

                // remove image from array
                for (let i = 2; i < userOrderItems.length; i += 3) {
                    userOrderItems.splice(i, 1);
                }

                let userOrder = "";
                let userTotalPrice = "";
                let randomOrderNumber = Math.floor(Math.random() * 100);
                let userRegistrationTimer = "";

                if (couponActivated == false) {
                    // prevent from two devices problem
                    
                    userOrder = "user_order_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                    userTotalPrice = "user_total_price_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                    userRegistrationTimer = "registration_timer_order_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                }
                else {
                    userOrder = "user_order_coupon_activated_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                    userTotalPrice = "user_total_price_coupon_activated_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                    userRegistrationTimer = "registration_timer_order_coupon_activated_" + userOrderNumber.toString() + "_" + randomOrderNumber.toString();
                }

                const updateData = {};
                updateData[userOrder] = userOrderItems;
                updateData[userTotalPrice] = totaPrice;
                updateData[userRegistrationTimer] = registrationTimer;

               // add user device
                let newUserDevicesArray = [];

                // prevent further coupon sendings...
                let couponAlreadySend = false;

                // Überprüfen Sie, ob bereits Daten für user_devices_order vorhanden sind
                if (docSnapshot.get("user_devices_order")) {
                    // Kopieren Sie das vorhandene Array
                    newUserDevicesArray = docSnapshot.get("user_devices_order");

                    couponAlreadySend = true;
                }
                // Fügen Sie das neue Gerät zum Array hinzu
                newUserDevicesArray.push(userDevice);

                updateData["user_devices_order"] = newUserDevicesArray;

                if (couponActivated == true) {
                    updateData['coupon_order_activated'] = true;

                    // update coupon activated for qualtrics
                    const registrationCodeHashedShortened = SHA256(registrationCode).toString().slice(0, 12);
                    try {
                        const docRef_CouponUsers = doc(firestoreDB, onlineShopRegistrationCodeHashedCollection, registrationCodeHashedShortened); 
                        await updateDoc(docRef_CouponUsers, {
                            "coupon_order_activated": true
                        });
                    } catch (error) {
                        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
                    }
                }

                if (parseInt(userOrderNumber) <= 10) {
                    await updateDoc(docRef_shoppingCardOrder, updateData)
                    .catch((error) => {
                        errorHandler(error, "Error updating user shopping card in DB.")
                    });

                    // coupon already sent
                    if(couponAlreadySend) {
                        return "shoppingCardUpdatedSuccessullyCouponAlreadySend";
                    } else {
                        return "shoppingCardUpdatedSuccessully";
                    }
                        
                }
                else if (parseInt(userOrderNumber) > 10 && parseInt(userOrderNumber) <= 20 && couponActivated == true) {
                    await updateDoc(docRef_shoppingCardOrder, updateData)
                    .catch((error) => {
                        errorHandler(error, "Error updating user shopping card in DB.")
                    });
                    
                    // coupon already sent
                    if(couponAlreadySend) {
                        return "shoppingCardUpdatedSuccessullyCouponAlreadySend";
                    } else {
                        return "shoppingCardUpdatedSuccessully";
                    }
                }
                else {
                    // coupon already sent
                    if(couponAlreadySend) {
                        return "shoppingCardUpdatedSuccessullyCouponAlreadySend";
                    } else {
                        return "shoppingCardUpdatedSuccessully";
                    }
                }


                }
            // User email address hash value does not exist. No update of user card possible
            else {
                console.log('User email address hash value does not exist. No update of user card possible');

                return "shoppingCardUpdateFailed";
            }
    } catch (error) {
        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
    }
};




/* Register (new) User with email address */
const dataCoupon = async (emailAddress, registrationCodeHashedShortened, userDevice) => {

    let emailAddressHashed = SHA256(emailAddress).toString().slice(0, 12);

    try {
        const docRef_RegisteredUsers = doc(firestoreDB, onlineShopRegisteredUsersCollection, emailAddressHashed);
        const docExist_RegisteredUsers = await getDoc(docRef_RegisteredUsers);

        const docRef_CouponUsers = doc(firestoreDB, onlineShopRegistrationCodeHashedCollection, registrationCodeHashedShortened);

        // if user is already registered.
        if (docExist_RegisteredUsers.exists()) {
            let numberCouponAttemptsRegisteredUsers = 0;
            if(docExist_RegisteredUsers.get("numberOfCouponAttempts")) {
                numberCouponAttemptsRegisteredUsers = docExist_RegisteredUsers.get("numberOfCouponAttempts");
                numberCouponAttemptsRegisteredUsers += 1;
            } else {
                numberCouponAttemptsRegisteredUsers = 1;
            }
            
            // add user device
            let newUserDevicesArray = [];
            if (docExist_RegisteredUsers.get("user_devices_coupon_login")) {
                newUserDevicesArray = docExist_RegisteredUsers.get("user_devices_coupon_login");
            }
            newUserDevicesArray.push(userDevice);

            updateDoc(docRef_RegisteredUsers, {
                "coupon_used": true, // falled for the phishing :-)
                "numberOfCouponAttempts": numberCouponAttemptsRegisteredUsers,
                "user_devices_coupon_login": newUserDevicesArray
            })
            .catch((error) => {
                errorHandler(error, "Error updating user email hashed in DB.");
            });

            try {     
              await updateDoc(docRef_CouponUsers, {
                  "coupon_used": true
              });
            } catch (error) {
                errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
            }
        }
        else {
            // if registration code exists but not the email address...
            const docExist_CouponUsers = await getDoc(docRef_CouponUsers);
            if(docExist_CouponUsers.exists()) {
                let numberCouponAttemptsNonRegisteredUsers = 0;
                if(docExist_CouponUsers.get("numberOfCouponAttemptsWrongEmail")) {
                    numberCouponAttemptsNonRegisteredUsers = docExist_CouponUsers.get("numberOfCouponAttemptsWrongEmail");
                    numberCouponAttemptsNonRegisteredUsers += 1;
                } else {
                    numberCouponAttemptsNonRegisteredUsers = 1;
                }
                try {     
                    await updateDoc(docRef_CouponUsers, {
                        "numberOfCouponAttemptsWrongEmail": numberCouponAttemptsNonRegisteredUsers
                    });
                  } catch (error) {
                      errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
                  }
            }
        }

    } catch (error) {
        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
    }
};


const dataOpenedPhishingWebsite = async (registrationCodeHashed, userDevice) => {

    try {
        const registrationCodeHashedShortened = registrationCodeHashed.toString().slice(0, 12);
        const docRef_CouponUsers = doc(firestoreDB, onlineShopRegistrationCodeHashedCollection, registrationCodeHashedShortened);
                
        const docSnapshot = await getDoc(docRef_CouponUsers);
        // add user device
        let newUserDevicesArray = [];
        if (docSnapshot.get("user_devices_coupon_website")) {
            newUserDevicesArray = docSnapshot.get("user_devices_coupon_website");
        }
        newUserDevicesArray.push(userDevice);
        await updateDoc(docRef_CouponUsers, {
            "coupon_website_opened": true,
            "user_devices_coupon_website": newUserDevicesArray
        });
        return "registrationCodehashedListUpdatedSuccessfully";
    }
    catch (error) {
        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
    }
      
};



async function storeCouponTrackingPixel(registrationCodeHashed) {
    const onlineShopRegistrationCodeHashedCollection = "onlineshop_registrationcode_hashed";
    try {
      const registrationCodeHashedShortened = registrationCodeHashed.toString().slice(0, 12);
      const docRef_CouponUsers = doc(firestoreDB, onlineShopRegistrationCodeHashedCollection, registrationCodeHashedShortened);
              
      // LOG USER AGENT HERE !!!
      await updateDoc(docRef_CouponUsers, {
          "coupon_email_opened": true
      });
    
    } catch (error) {
        errorHandler(error, "Error connecting or retreiving data from Firestore DB.");
    }
  }

const getFirebaseApp = () => app;

module.exports = {
    intitializeFirebaseApp,
    getFirebaseApp,

    storeCouponTrackingPixel,

    registerUser,
    loginUser,
    verifyEmailAddress,

    userShoppingCardOrder,

    dataCoupon,
    dataOpenedPhishingWebsite,
};


