var SHA256 = require("crypto-js/sha256");

/* QR Code and store as .PNG modules */
const QRCode = require('qrcode');
const Jimp = require('jimp');

const nodemailer = require("nodemailer");

const { errorHandler } = require('./helpers');

const { bodyMessage_Registration_DE,
        bodyMessage_Registration_EN,
        bodyMessage_PasswortReset_DE,
        bodyMessage_PasswortReset_EN,
        bodyMessage_LoginNotification_DE,
        bodyMessage_LoginNotification_EN,
        bodyMessage_OrderConfirmation_DE,
        bodyMessage_OrderConfirmation_EN,

        bodyMessage_CouponValidHyperlink_DE,
        bodyMessage_CouponValidHyperlink_EN,
        bodyMessage_CouponValidQRCode_DE,
        bodyMessage_CouponValidQRCode_EN,
} = require('./email_body');

require('dotenv').config();
const {
    SECURITY_TOKEN_MAILTRAP_TESTING_USER,
    SECURITY_TOKEN_MAILTRAP_TESTING_PASSWORD,

    SECURITY_TOKEN_MAILTRAP_SMARTBUYONLINE_PASSWORD,
    EMAIL_DOMAIN_MAILTRAP_ACCOUNT_UPDATE_SMARTBUYONLINE_DE_LANG_DE,
    EMAIL_DOMAIN_MAILTRAP_ORDER_CONFIRMATION_SMARTBUYONLINE_DE_LANG_EN,
    EMAIL_DOMAIN_MAILTRAP_ORDER_CONFIRMATION_SMARTBUYONLINE_DE_LANG_DE,
    EMAIL_DOMAIN_MAILTRAP_INFO_SMARTBUYONLINE_DE_LANG_ENDE,
    EMAIL_DOMAIN_MAILTRAP_NO_REPLY_SMARTBUYONLINE_DE_LANG_ENDE,
} = process.env;

/* ##### Test purpose only - Mailtrap Testing ##### */
const securityTokenMailtrapUser_TESTING = SECURITY_TOKEN_MAILTRAP_TESTING_USER;
const securityTokenMailtrapPassword_TESTING = SECURITY_TOKEN_MAILTRAP_TESTING_PASSWORD;

const securityTokenMailtrapPassword_smartbuyonline = SECURITY_TOKEN_MAILTRAP_SMARTBUYONLINE_PASSWORD;
const emailDomainMailtrap_smartbuyonline_account_update_de = EMAIL_DOMAIN_MAILTRAP_ACCOUNT_UPDATE_SMARTBUYONLINE_DE_LANG_DE;
const emailDomainMailtrap_smartbuyonline_order_confirmation_en = EMAIL_DOMAIN_MAILTRAP_ORDER_CONFIRMATION_SMARTBUYONLINE_DE_LANG_EN;
const emailDomainMailtrap_smartbuyonline_order_confirmation_de = EMAIL_DOMAIN_MAILTRAP_ORDER_CONFIRMATION_SMARTBUYONLINE_DE_LANG_DE;
const emailDomainMailtrap_smartbuyonline_info_ende = EMAIL_DOMAIN_MAILTRAP_INFO_SMARTBUYONLINE_DE_LANG_ENDE
const emailDomainMailtrap_smartbuyonline_no_reply_ende = EMAIL_DOMAIN_MAILTRAP_NO_REPLY_SMARTBUYONLINE_DE_LANG_ENDE




/*******************************************************/
/***** Initialize Nodemailer transport connection ******/
/*******************************************************/
let transport_testing;
const initializeNodemailerTransportConnection_testing = () => {
  try {
    transport_testing = nodemailer.createTransport({
        host: "sandbox.smtp.mailtrap.io",
        port: 2525,
        auth: {
            user: securityTokenMailtrapUser_TESTING,
            pass: securityTokenMailtrapPassword_TESTING
        }
    });
    } catch (error) {
        errorHandler(error, "Nodemailer create transport failed (see email.js).");
    }
};

/***** XXX@smartbuyonline.de *****/
let transport_smartbuyonline;
const initializeNodemailerTransportConnection_smartbuyonline = () => {
    try {
        transport_smartbuyonline = nodemailer.createTransport({
            host: "live.smtp.mailtrap.io",
            port: 587,
            auth: {
              user: "api",
              pass: securityTokenMailtrapPassword_smartbuyonline
            }
        });
    } catch (error) {
        errorHandler(error, "Nodemailer create transport failed (see email.js).");
    }
};

/***********************************/
/******* Email Registration ********/
/***********************************/
const emailRegistration = async (emailAddress, language) => {
    // http://127.0.0.1:5500/onlineshop/index.html?hashed_email=7acb1d84e5e2&verified_email=true#
    //const bodyMessage = `<br><b>Please confirm your email</b>.<br><br> Hi ${userEmailAddress}. To verify your <a href="https://www.google.com" target="_blank">SmartBuyOnline</a> account you must click on the link below:<br><br><a href="http://127.0.0.1:5500/onlineshop/index.html?hashed_email=${userEmailAddressHashed}&verified_email=true" target="_blank">http://127.0.0.1:5500/onlineshop/index.html?hashed_email=${userEmailAddressHashed}&verified_email=true</a><br><br><br>Please also check your spam!`;
    //const bodyMessage_Registration = `<p>Test Mail: Verify your email address: http://127.0.0.1:5500/onlineshop/index.html?hashed_email=${userEmailAddressHashed}&verified_email=true</p>`;

    const emailAddressHashed = SHA256(emailAddress).toString().slice(0, 12);
    const verifyEmailAddressURL = `https://www.smartbuyonline.de/home.html?hashed_email=${emailAddressHashed}&verified_email=true`;

    let bodyMessage_Registration = "";
    let subjectEmail = "";
    if(language == "DE") {
      bodyMessage_Registration = bodyMessage_Registration_DE(verifyEmailAddressURL);
      subjectEmail = "Bestätige deine Registrierung für SmartBuyOnline.de";
    } else {
      bodyMessage_Registration = bodyMessage_Registration_EN(verifyEmailAddressURL);
      subjectEmail = "Verify your account for SmartBuyOnline.de";
    }

    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: emailDomainMailtrap_smartbuyonline_account_update_de, // "account-update@smartbuyonline.de"
            to: emailAddress, // "qrcodestudies@gmail.com", // add emailAddress
            subject: subjectEmail,
            html: bodyMessage_Registration
        };

        // transport_smartbuyonline
        transport_smartbuyonline.sendMail(mail_configs, function(error) {
            if(error) {
                errorHandler(error, "An error has occured in emailRegistration()");
                return reject({message: 'An error has occured'});
            }
            console.log("Registration Email sent successfully");
            return resolve({ message: 'Email sent successfully' });
        });
    });
}

/* Login Notification Email */
const emailLoginNotification = async (emailAddress, language) => {

    let bodyMessage_LoginNotification= "";
    let subjectEmail = "";
    let fromEmail = "";
    if(language == "DE") {
        fromEmail = emailDomainMailtrap_smartbuyonline_no_reply_ende;
        bodyMessage_LoginNotification = bodyMessage_LoginNotification_DE();
        subjectEmail = "Login Benachrichtigung";
    } else {
        fromEmail = emailDomainMailtrap_smartbuyonline_no_reply_ende;
        bodyMessage_LoginNotification = bodyMessage_LoginNotification_EN();
        subjectEmail = "Login Notification";
    }
    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: fromEmail,
            to: emailAddress, // "qrcodestudies@gmail.com", // add emailAddress
            subject: subjectEmail,
            html: bodyMessage_LoginNotification
        };
        // transport_smartbuyonline
        transport_smartbuyonline.sendMail(mail_configs, function(error) {
            if(error) {
                errorHandler(error, "An error has occured in emailLoginNotification()");
                return reject({message: 'An error has occured'});
            }
            console.log("Login Notification Email sent successfully");
            return resolve({ message: 'Email sent successfully' });
        });
    });
}

/***********************************/
/******* Email Password Reset ******/
/***********************************/
const emailPasswordReset = async (emailAddress, language) => {
    // http://127.0.0.1:5500/onlineshop/home.html?hashed_email=7acb1d84e5e2&verified_email=true#
    /*
    const bodyMessage_PasswortReset = `<br>Hi,<br>Forgot your password?<br>
    We received a request to resert the password for your account.<br><br>

    To reset your password, click on the button below:<br>
    \[ADD BUTTON\]<br><br>

    Or click on the following URL / copy and paste the URL into your browser:<br>
    <a href="http://127.0.0.1:5500/onlineshop/home.html?hashed_email=${userEmailAddressHashed}&reset_password=true" target="_blank">http://127.0.0.1:5500/onlineshop/home.html?hashed_email=${userEmailAddressHashed}&reset_password=true</a>`;
    */

    const emailAddressHashed = SHA256(emailAddress).toString().slice(0, 12);
    const passwordResetURL = `https://www.smartbuyonline.de/home.html?hashed_email=${emailAddressHashed}&reset_password=true`;

    let bodyMessage_PasswordReset= "";
    let subjectEmail = "";
    if(language == "DE") {
      bodyMessage_PasswordReset = bodyMessage_PasswortReset_DE(passwordResetURL);
      subjectEmail = "Passwort Unterstützung";
    } else {
      bodyMessage_PasswordReset = bodyMessage_PasswortReset_EN(passwordResetURL);
      subjectEmail = "Passwort Support";
    }
    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: "info@smartbuyonline.de",
            to: emailAddress, // "qrcodestudies@gmail.com", // add emailAddress
            subject: subjectEmail,
            html: bodyMessage_PasswordReset
        };
        // transport_smartbuyonline
        transport_smartbuyonline.sendMail(mail_configs, function(error) {
            if(error) {
                errorHandler(error, "An error has occured in emailPasswordReset()");
                return reject({message: 'An error has occured'});
            }
            console.log("Reset Email sent successfully");
            return resolve({ message: 'Email sent successfully' });
        });
    });
}



/***********************************/
/***** Order Confirmation Email ****/
/***********************************/
const emailOrderConfirmation = async (emailAddress, userOrderNumber, userOrderItems, totaPrice, couponActivated, language) => {

    // remove date from order array
    let orderitems = userOrderItems;
    orderitems.shift();

    console.log(userOrderItems);

    let bodyMessage_OrderConfirmation= "";
    let subjectEmail = "";
    let fromEmail = "";
    if(language == "DE") {
        fromEmail = emailDomainMailtrap_smartbuyonline_order_confirmation_de;
        bodyMessage_OrderConfirmation = bodyMessage_OrderConfirmation_DE(userOrderNumber, orderitems, totaPrice.replace('.', ','), couponActivated);
        subjectEmail = "Deine SmartBuyOnline.de Bestellung";
    } else {
        fromEmail = emailDomainMailtrap_smartbuyonline_order_confirmation_en;
        bodyMessage_OrderConfirmation = bodyMessage_OrderConfirmation_EN(userOrderNumber, orderitems, totaPrice, couponActivated);
        subjectEmail = "Your SmartBuyOnline.de Order";
    }
    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: fromEmail,
            to: emailAddress, // "qrcodestudies@gmail.com", // add emailAddress
            subject: subjectEmail,
            html: bodyMessage_OrderConfirmation
        };
        // transport_smartbuyonline
        transport_smartbuyonline.sendMail(mail_configs, function(error) {
            if(error) {
                errorHandler(error, "An error has occured in emailLoginNotification()");
                return reject({message: 'An error has occured'});
            }
            console.log("Login Notification Email sent successfully");
            return resolve({ message: 'Email sent successfully' });
        });
    });
}


/* Delay email coupon send */
const DELAY = 10000;
/* Set email subject based on language */
const subjectEmailCoupon_DE = "Persönlicher 50€ Gutschein für SmartBuyOnline.de";
const subjectEmailCoupon_EN = "Personal 50€ Coupon for SmartBuyOnline.de";

/*** smartbuyonline.de ***/

/* Email Coupon Valid Hyperlink */
/* Scenario 1 */
const emailCouponValidHyperlink = async (emailAddress, registrationCode, language) => {

    const registrationCodeHashed = SHA256(registrationCode).toString();
    const registrationCodeHashedShortened = registrationCodeHashed.slice(0, 12);
    const hyperlinkURL = `tinyurl.com/mpbp4vky?id=` + registrationCodeHashed;
    // Tracking Pixel
    // Local URL: http://localhost:3000/api/track/
    // example: http://localhost:3000/api/track/2c7a6f1048a7
    const trackingPixelURL = `<img src="https://smartbuyonline.de/api/track/`+registrationCodeHashedShortened+`" height="1" width="1" alt="tracking-pixel"></img>`;

    let bodyMessage_couponValidHyperlink= "";
    let subjectEmail = "";
    if(language == "DE") {
        bodyMessage_couponValidHyperlink = bodyMessage_CouponValidHyperlink_DE(hyperlinkURL, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_DE;
    } else {
        bodyMessage_couponValidHyperlink = bodyMessage_CouponValidHyperlink_EN(hyperlinkURL, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_EN;
    }
        return new Promise((resolve, reject) => {
            const mail_configs = {
                from: emailDomainMailtrap_smartbuyonline_info_ende, // "info@smartbuyonline.de"
                to: emailAddress, // "qrcodestudies@gmail.com", // add emailAddress
                subject: subjectEmail,
                html: bodyMessage_couponValidHyperlink
            };
            setTimeout(function() {
                // transport_smartbuyonline
                transport_smartbuyonline.sendMail(mail_configs, function(error) {
                    if(error) {
                        errorHandler(error, "An error has occured in emailCouponValidHyperlink()");
                        return reject({message: 'An error has occured'});
                    }
                    console.log("Coupon Valid Hyperlink Email sent successfully");
                    return resolve({ message: 'Email sent successfully' });
                });
            }, DELAY);
        });
}

/* Email Coupon Valid QR Code */
/* Scenario 2 */
/* https://dashboard.uniqode.com/qr-codes/add?trial_first=true&orgID=492527#customize */
const emailCouponValidQRCode = async (emailAddress, registrationCode, language) => {

    const registrationCodeHashed = SHA256(registrationCode).toString();
    const registrationCodeHashedShortened = registrationCodeHashed.slice(0, 12);
    // Tracking Pixel
    // Local URL: http://localhost:3000/api/track/
    // example: http://localhost:3000/api/track/2c7a6f1048a7
    const trackingPixelURL = `<img src="https://smartbuyonline.de/api/track/`+registrationCodeHashedShortened+`" height="1" width="1" alt="tracking-pixel"></img>`;

    const qrCodeURL = `https://www.smartbuyonline.de/coupon.html?id=` + registrationCodeHashed;
    // `website/img/emails/qrcodes/qrcode_smartbuyonline_id_` + registrationCodeHashed + `.png`;
    const qrCodeStoragePath = `website/img/emails/qrcodes/qrcode_smartbuyonline_id_` + registrationCodeHashed + `.png`;
    const qrCodeImage = `https://smartbuyonline.de/img/emails/qrcodes/qrcode_smartbuyonline_id_` + registrationCodeHashed + `.png`;

    generateQRCode(qrCodeURL, qrCodeStoragePath);

    let bodyMessage_CouponValidQRCode= "";
    let subjectEmail = "";
    if(language == "DE") {
      bodyMessage_CouponValidQRCode = bodyMessage_CouponValidQRCode_DE(qrCodeImage, trackingPixelURL);
      subjectEmail = subjectEmailCoupon_DE;
    } else {
      bodyMessage_CouponValidQRCode = bodyMessage_CouponValidQRCode_EN(qrCodeImage, trackingPixelURL);
      subjectEmail = subjectEmailCoupon_EN;
    }
    // send email
    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: emailDomainMailtrap_smartbuyonline_info_ende, // "info@smartbuyonline.de"
            to: emailAddress, // "qrcodestudies@gmail.com", // add userEmailAddress
            subject: subjectEmail,
            html: bodyMessage_CouponValidQRCode
        };
        // delay email sending...
        setTimeout(function() {
          // transport_smartbuyonline
          transport_smartbuyonline.sendMail(mail_configs, function(error) {
              if(error) {
                  errorHandler(error, "An error has occured in emailCouponValidQRCode()");
                  return reject({message: 'An error has occured'});
              }
              console.log("Coupon Valid QR Code Email sent successfully");
              return resolve({ message: 'Email sent successfully' });
          });
        }, DELAY);
    });
}
/*** Misc Functions ***/

/* Generate QR Codes */
async function generateQRCode(qrCodeURL, qrCodeStoragePath) {
    try {
        const qrCodeBuffer = await QRCode.toBuffer(qrCodeURL, {
            color: {
                dark: '#000000',
                light: '#e3e6f3'
            },
            width: 800,
            errorCorrectionLevel: 'H',
            margin: 2,
            transparent: true
        });
  
        const logo = await Jimp.read('img/Group_transparent.png');
  
        const qrCode = await Jimp.read(qrCodeBuffer);
  
        const qrCodeWithoutLogoSize = qrCode.bitmap.width;
        const logoSize = 100;
  
        const x = (qrCodeWithoutLogoSize - logoSize) / 2;
        const y = (qrCodeWithoutLogoSize - logoSize) / 2;
  
        qrCode.composite(logo.resize(logoSize, logoSize), x, y, {
            mode: Jimp.BLEND_SOURCE_OVER,
            opacitySource: 1,
            opacityDest: 1
        });
        qrCode.write(qrCodeStoragePath);
  
        console.log(`QR-Code für ${qrCodeURL} wurde erfolgreich generiert und gespeichert als ${qrCodeStoragePath}`);
    } catch (err) {
        console.error(err, "Path to load Group1_192_192 or to storage location for qr code does not exist.");
    }
  }
  
  
  module.exports = {
      initializeNodemailerTransportConnection_testing,
  
      initializeNodemailerTransportConnection_smartbuyonline,
  
      emailRegistration,
      emailLoginNotification,
      emailPasswordReset,
  
      emailOrderConfirmation,
  
      emailCouponValidHyperlink,
      emailCouponValidQRCode,
  };