const app = express();
app.use(express.json());

/* CLIENT --> Running on localhost */
// --------------
app.use(cors());
// --------------

/* SERVER --> Running live on Plesk */
/*
// ------------------------------------------------------------------------------------
app.use(cors({
  //origin: '*' // Erlaubt Anfragen von allen Ursprüngen
  origin:  'https://smartbuyonline.de,
            https://www.smart-buy-online.de,
            https://couponcampaign.org',
}));
// ------------------------------------------------------------------------------------
*/


/*
const app = express();
app.use(express.json({ limit: "25mb" }));
app.use(express.urlencoded({ extended: true }));
app.use((req, res, next) => {
  //origin: 'https://smartbuyonline.de,http://smartbuyonline.de' // Erlaubt Anfragen von allen Ursprüngen

  res.setHeader("Access-Control-Allow-Origin", "*");
  next();
});
*/


// initialize Firebase DB
//let firestoreDB;
intitializeFirebaseApp();

initializeNodemailerTransportConnection_testing();
initializeNodemailerTransportConnection_smartbuyonline();

app.post('*', async (req, res) => {
  console.log(req.body);
  //res.send(await handler(req, res, "POST"));
  await handler(req, res, "POST");
});

app.get('/api/track/:id', (req, res) => {
  console.log("TRACKING PIXEL");
  const { id } = req.params;

  storeCouponTrackingPixel(id);

  console.log(`Received tracking request - ID (registration code hashed): ${id}`);
  const trackImg = Buffer.from('R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7', 'base64');

  res.writeHead(200, {
    'Content-Type': 'image/gif',
    'Content-Length': trackImg.length
  });
  res.end(trackImg);
});

app.listen(PORT, function (err) {
  if(err) console.log(err);
  console.log(`Server listening on http://localhost:${PORT}`);
});


/* Log Application running */
/*
function logToFile2(message) {
  const logStream = fs.createWriteStream('logs/logs_nodejs_smartbuyonline.txt', { flags: 'a' });
  logStream.write(`${message}\n`);
  logStream.end();
}
*/