/* Source: https://www.abstractapi.com/guides/node-js-send-email-from-your-server */

var SHA256 = require("crypto-js/sha256");

/* QR Code and store as .PNG modules */
const QRCode = require('qrcode');
const Jimp = require('jimp');

const nodemailer = require("nodemailer");

const { errorHandler } = require('./helpers');

const { bodyMessage_CouponPhishingHyperlinkCouponCampaign_DE,
        bodyMessage_CouponPhishingHyperlinkCouponCampaign_EN,
        bodyMessage_CouponPhishingQRCodeCouponCampaign_DE,
        bodyMessage_CouponPhishingQRCodeCouponCampaign_EN } = require('./email_body');

require('dotenv').config();
const {
    SECURITY_TOKEN_MAILTRAP_TESTING_USER,
    SECURITY_TOKEN_MAILTRAP_TESTING_PASSWORD,

    SECURITY_TOKEN_MAILTRAP_COUPONCAMPAIGN_PASSWORD,
} = process.env;

/* !!! Test purpose only - Mailtrap Testing !!! */
const securityTokenMailtrapUser_TESTING = SECURITY_TOKEN_MAILTRAP_TESTING_USER;
const securityTokenMailtrapPassword_TESTING = SECURITY_TOKEN_MAILTRAP_TESTING_PASSWORD;

const securityTokenMailtrapPassword_couponcampaign = SECURITY_TOKEN_MAILTRAP_COUPONCAMPAIGN_PASSWORD;

/*******************************************************/
/***** Initialize Nodemailer transport connection ******/
/*******************************************************/

/***** *****/

let transport_testing;
const initializeNodemailerTransportConnection_testing = () => {
  try {
    transport_testing = nodemailer.createTransport({
        host: "sandbox.smtp.mailtrap.io",
        port: 2525,
        auth: {
            user: securityTokenMailtrapUser_TESTING,
            pass: securityTokenMailtrapPassword_TESTING
        }
    });
    } catch (error) {
        errorHandler(error, "Nodemailer create transport failed (see email.js).");
    }
};

/***** XXX@coupon@coupon-info-smartbuyonline.couponcampaign.org (XXX@couponcampaign.org) *****/
let transport_couponcampaign;
const initializeNodemailerTransportConnection_couponcampaign = () => {
    try {
        transport_couponcampaign = nodemailer.createTransport({
            host: "live.smtp.mailtrap.io",
            port: 587,
            auth: {
              user: "api",
              pass: securityTokenMailtrapPassword_couponcampaign
            }
        });
    } catch (error) {
        errorHandler(error, "Nodemailer create transport failed (see email.js).");
    }
};


/* Delay email coupon send */
const DELAY = 10000;
/* Set email subject based on language */
const subjectEmailCoupon_DE = "Persönlicher 50€ Gutschein für SmartBuyOnline.de";
const subjectEmailCoupon_EN = "Personal 50€ Coupon for SmartBuyOnline.de";

/*** coupon-info-smartbuyonline.couponcampaign.org (couponcampaign.org) ***/

/* Email Coupon Phishing Hyperlink */
/* Scenario 3_2 */
const emailCouponPhishingHyperlinkCouponCampaign = async (emailAddress, registrationCode, language) => {

    const registrationCodeHashed = SHA256(registrationCode).toString();
    const registrationCodeHashedShortened = registrationCodeHashed.slice(0, 12);
    const hyperlinkURL = `tinyurl.com/55kku82j?id=` + registrationCodeHashed;
    // Tracking Pixel
    // Local URL: http://localhost:3000/api/track/
    // example: http://localhost:3000/api/track/2c7a6f1048a7
    const trackingPixelURL = `<img src="https://smartbuyonline.de/api/track/`+registrationCodeHashedShortened+`" height="1" width="1" alt="tracking-pixel"></img>`;

    let bodyMessage_CouponPhishingHyperlinkCouponCampaign= "";
    let subjectEmail = "";
    if(language == "DE") {
        bodyMessage_CouponPhishingHyperlinkCouponCampaign = bodyMessage_CouponPhishingHyperlinkCouponCampaign_DE(hyperlinkURL, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_DE;
    } else {
        bodyMessage_CouponPhishingHyperlinkCouponCampaign = bodyMessage_CouponPhishingHyperlinkCouponCampaign_EN(hyperlinkURL, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_EN;
    }
        return new Promise((resolve, reject) => {
            const mail_configs = {
                from: "info@coupon-info-smartbuyonline.couponcampaign.org",
                to: emailAddress, // add emailAddress
                subject: subjectEmail,
                html: bodyMessage_CouponPhishingHyperlinkCouponCampaign
            };
            // delay email sending...
            setTimeout(function() {
                transport_couponcampaign.sendMail(mail_configs, function(error) {
                    if(error) {
                        errorHandler(error, "An error has occured in emailCouponPhishingHyperlinkCouponCampaign()");
                        return reject({message: 'An error has occured'});
                    }
                    console.log("Coupon Phishing Hyperlink CouponCampaign Email sent successfully");
                    return resolve({ message: 'Email sent successfully' });
                });
            }, DELAY);
        });
}
/* Email Coupon Phishing QR Code */
/*** Scenario 4_2 ***/
const emailCouponPhishingQRCodeCouponCampaign = async (emailAddress, registrationCode, language) => {

    const registrationCodeHashed = SHA256(registrationCode).toString();
    const registrationCodeHashedShortened = registrationCodeHashed.slice(0, 12);
    // Tracking Pixel
    // Local URL: http://localhost:3000/api/track/
    // example: http://localhost:3000/api/track/2c7a6f1048a7
    const trackingPixelURL = `<img src="https://smartbuyonline.de/api/track/`+registrationCodeHashedShortened+`" height="1" width="1" alt="tracking-pixel"></img>`;

    const qrCodeURL = `https://www.coupon-info-smartbuyonline.couponcampaign.org/coupon.html?id=` + registrationCodeHashed;
    const qrCodeStoragePath = `website/img/emails/qrcodes/qrcode_couponcampaign_id_` + registrationCodeHashed + `.png`;
    const qrCodeImage = `https://www.coupon-info-smartbuyonline.couponcampaign.org/img/emails/qrcodes/qrcode_couponcampaign_id_` + registrationCodeHashed + `.png`;

    generateQRCode(qrCodeURL, qrCodeStoragePath);

    let bodyMessage_CouponPhishingQRCodeCouponCampaign= "";
    let subjectEmail = "";
    if(language == "DE") {
        bodyMessage_CouponPhishingQRCodeCouponCampaign = bodyMessage_CouponPhishingQRCodeCouponCampaign_DE(qrCodeImage, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_DE;
    } else {
        bodyMessage_CouponPhishingQRCodeCouponCampaign = bodyMessage_CouponPhishingQRCodeCouponCampaign_EN(qrCodeImage, trackingPixelURL);
        subjectEmail = subjectEmailCoupon_EN;
    }
    return new Promise((resolve, reject) => {
        const mail_configs = {
            from: "info@coupon-info-smartbuyonline.couponcampaign.org",
            to: emailAddress, // add userEmailAddress
            subject: subjectEmail,
            html: bodyMessage_CouponPhishingQRCodeCouponCampaign
        };
        // delay email sending...
        setTimeout(function() {
            transport_couponcampaign.sendMail(mail_configs, function(error) {
                if(error) {
                    errorHandler(error, "An error has occured in emailCouponPhishingQRCodeCouponCampaign()");
                    return reject({message: 'An error has occured'});
                }
                console.log("Coupon Valid Hyperlink Email sent successfully");
                return resolve({ message: 'Email sent successfully' });
            });
        }, DELAY);
    });
}



/*** Misc Functions ***/

/* Generate QR Codes */
async function generateQRCode(qrCodeURL, qrCodeStoragePath) {
    try {
        const qrCodeBuffer = await QRCode.toBuffer(qrCodeURL, {
            color: {
                dark: '#000000',
                light: '#e3e6f3'
            },
            width: 800,
            errorCorrectionLevel: 'H',
            margin: 2,
            transparent: true
        });
  
        const logo = await Jimp.read('img/Group_transparent.png');
  
        const qrCode = await Jimp.read(qrCodeBuffer);
  
        const qrCodeWithoutLogoSize = qrCode.bitmap.width;
        const logoSize = 100;
  
        const x = (qrCodeWithoutLogoSize - logoSize) / 2;
        const y = (qrCodeWithoutLogoSize - logoSize) / 2;
  
        qrCode.composite(logo.resize(logoSize, logoSize), x, y, {
            mode: Jimp.BLEND_SOURCE_OVER,
            opacitySource: 1,
            opacityDest: 1
        });
        qrCode.write(qrCodeStoragePath);
  
        console.log(`QR-Code für ${qrCodeURL} wurde erfolgreich generiert und gespeichert als ${qrCodeStoragePath}`);
    } catch (err) {
        console.error(err, "Path to load Group1_192_192 or to storage location for qr code does not exist.");
    }
  }










module.exports = {
    initializeNodemailerTransportConnection_testing,
    initializeNodemailerTransportConnection_couponcampaign,

    emailCouponPhishingHyperlinkCouponCampaign,
    emailCouponPhishingQRCodeCouponCampaign
};