const logger = require('./logger');
logger.info('Application started');
logger.warn('This could be risky');
logger.error('Something went wrong');

const express = require('express');
const cors = require('cors');

const { handler } = require('./index');

const { initializeNodemailerTransportConnection_testing,
        initializeNodemailerTransportConnection_smart_buy_online
      } = require('./email');

require('dotenv').config();
console.log(process.env);
const PORT = process.env.PORT || 3000;






const app = express();
app.use(express.json());

/* CLIENT --> Running on localhost */
// --------------
//app.use(cors());
// --------------

/* SERVER --> Running live on Plesk */

// ------------------------------------------------------------------------------------
app.use(cors({
  "origin": "*",
  "methods": "GET,HEAD,PUT,PATCH,POST,DELETE",
}));
// ------------------------------------------------------------------------------------
// initialize Nodemailer transport connection
initializeNodemailerTransportConnection_testing();
initializeNodemailerTransportConnection_smart_buy_online();


app.post('*', async (req, res) => {
  console.log(req.body);
  //res.send(await handler(req, res, "POST"));
  await handler(req, res, "POST");
});

app.get('*', async (req, res) => {
  console.log(req.body);
  res.send(await handler(req, "GET"));
});

app.listen(PORT, function (err) {
  if(err) console.log(err);
  console.log(`Server listening on http://localhost:${PORT}`);
});