package de.rubmobsec.humancentredstudies.ui.imprint;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;

import de.rubmobsec.humancentredstudies.databinding.FragmentImprintBinding;

public class ImprintFragment extends Fragment {

    private FragmentImprintBinding binding;

    public View onCreateView(@NonNull LayoutInflater inflater,
                             ViewGroup container, Bundle savedInstanceState) {
        ImprintViewModel imprintViewModel =
                new ViewModelProvider(this).get(ImprintViewModel.class);

        binding = FragmentImprintBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        final TextView textView = binding.textImprint;
        imprintViewModel.getText().observe(getViewLifecycleOwner(), textView::setText);
        return root;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }
}