package de.rubmobsec.humancentredstudies;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;

import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.FirebaseFirestore;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link TransferManuallySummaryFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class TransferManuallySummaryFragment extends Fragment {

    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    public TransferManuallySummaryFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment TransferManuallySummaryFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static TransferManuallySummaryFragment newInstance(String param1, String param2) {
        TransferManuallySummaryFragment fragment = new TransferManuallySummaryFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transfer_manually_summary, container, false);
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TransferManuallyActivity tmActivity = (TransferManuallyActivity) getActivity();
        String[] values = tmActivity.getValues();

        EditText editReceiver = (EditText) getActivity().findViewById(R.id.editTextTransferSummaryReceiver);
        editReceiver.setText(values[0]);
        editReceiver.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.RECEIVER);
            }
        });

        ImageView imageReceiver = (ImageView) getActivity().findViewById(R.id.imageViewTransferSummaryReceiver);
        imageReceiver.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.RECEIVER);
            }
        });

        EditText editAccount = (EditText) getActivity().findViewById(R.id.editTextTransferSummaryAccount);
        editAccount.setText(values[1]);
        editAccount.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.RECEIVER);
            }
        });

        ImageView imageAccount = (ImageView) getActivity().findViewById(R.id.imageViewTransferSummaryAccount);
        imageAccount.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.RECEIVER);
            }
        });



        EditText editAmount = (EditText) getActivity().findViewById(R.id.editTextTransferSummaryAmount);
        editAmount.setText(values[2]+" €");
        editAmount.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.AMOUNT);
            }
        });

        ImageView imageAmount = (ImageView) getActivity().findViewById(R.id.imageViewTransferSummaryAmount);
        imageAmount.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.AMOUNT);
            }
        });

        EditText editSubject = (EditText) getActivity().findViewById(R.id.editTextTransferSummarySubject);
        editSubject.setText(values[3]);
        editSubject.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.SUBJECT);
            }
        });

        ImageView imageSubject = (ImageView) getActivity().findViewById(R.id.imageViewTransferSummarySubject);
        imageSubject.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                tmActivity.clickEdit(TransferManuallyActivity.ContinueBtn.SUBJECT);
            }
        });

        Button btnFinalizeTransaction = (Button) getActivity().findViewById(R.id.btnFinalizeTransaction);
        btnFinalizeTransaction.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                FragmentTransaction tx = ((TransferManuallyActivity) getActivity()).getSupportFragmentManager().beginTransaction();
                tx.replace(R.id.fragment_placeholder, new TransferManuallyPinFragment());

                tx.addToBackStack(null);
                tx.commit();
            }
        });

        Button btnCancelTransaction = (Button) getActivity().findViewById(R.id.btnCancelTransaction);
        btnCancelTransaction.setBackgroundColor(getResources().getColor(R.color.red_medium));


    }




}