package de.rubmobsec.humancentredstudies;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import org.w3c.dom.Text;

import java.math.BigInteger;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link TransferManuallyReceiverFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class TransferManuallyReceiverFragment extends Fragment {

    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    public Button btnContinue;
    public TextView txtReceiverIncorrect, txtAccountIncorrect;
    public EditText editTextReceiver, editTextAccount;


    public TransferManuallyReceiverFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment TransferManuallyReceiverFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static TransferManuallyReceiverFragment newInstance(String param1, String param2) {
        TransferManuallyReceiverFragment fragment = new TransferManuallyReceiverFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transfer_manually_receiver, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TransferManuallyActivity tmActivity = (TransferManuallyActivity) getActivity();
        String[] values = tmActivity.getValues();

        editTextReceiver = getActivity().findViewById(R.id.editTextTransferDataReceiver);
        txtReceiverIncorrect = getActivity().findViewById(R.id.textViewTransferDataReceiverIncorrect);

        editTextAccount = getActivity().findViewById(R.id.editTextTransferDataAccount);
        txtAccountIncorrect = getActivity().findViewById(R.id.textViewTransferDataAccountIncorrect);


        TransferManuallyActivity.ContinueBtn srcBtn = TransferManuallyActivity.ContinueBtn.RECEIVER;

        btnContinue = getActivity().findViewById(R.id.btnTransferDataReceiver);
        btnContinue.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String prettyIBAN = formatPrettyIBAN(editTextAccount.getText().toString());


                tmActivity.updateValue(0, editTextReceiver.getText().toString());
                tmActivity.updateValue(1, prettyIBAN);

                tmActivity.clickBtnContinue(srcBtn);


            }
        });





        editTextReceiver.setText(values[0]);
        editTextReceiver.setOnFocusChangeListener(new View.OnFocusChangeListener(){


            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if(hasFocus==false) {
                    if(editTextReceiver.getText().toString().length() < 1) {
                        txtReceiverIncorrect.setVisibility(View.VISIBLE);
                        btnContinue.setEnabled(false);
                    }
                }
            }
        });

        editTextReceiver.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(charSequence.length() > 0) {
                    txtReceiverIncorrect.setVisibility(View.INVISIBLE);
                    if(isValidIBAN(editTextAccount.getText().toString())) {
                        btnContinue.setEnabled(true);
                    }
                } else {
                    txtReceiverIncorrect.setVisibility(View.VISIBLE);
                    btnContinue.setEnabled(false);
                }

            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });


        editTextAccount.setText(values[1]);
        editTextAccount.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if(hasFocus==false) {
                    if(!isValidIBAN(editTextAccount.getText().toString())) {
                        txtReceiverIncorrect.setVisibility(View.VISIBLE);
                        btnContinue.setEnabled(false);
                    }


                }
            }
        });

        editTextAccount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(charSequence.length() > 9) {
                    if(!isValidIBAN(editTextAccount.getText().toString())) {
                        txtAccountIncorrect.setVisibility(View.VISIBLE);
                        btnContinue.setEnabled(false);
                    } else {
                        txtAccountIncorrect.setVisibility(View.INVISIBLE);
                        if(editTextReceiver.getText().toString().length() > 0) {
                            btnContinue.setEnabled(true);
                        }
                    }
                } else {
                    txtAccountIncorrect.setVisibility(View.INVISIBLE);
                    btnContinue.setEnabled(false);
                }


            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });

        if(editTextReceiver.getText().toString().length() > 0 && isValidIBAN(editTextAccount.getText().toString())) {
            btnContinue.setEnabled(true);
        } else {
            btnContinue.setEnabled(false);
        }

    }

    public String formatPrettyIBAN(String iban) {
        if(iban.length()<1) {
            return "";
        }

        String nospaceIBAN = iban.replace(" ","");
        String prettyIBAN = "";

        for(int len=4; len<40; len+=4) {
            if(len < nospaceIBAN.length()) {
                prettyIBAN+=nospaceIBAN.substring(len-4,len);
                prettyIBAN+=" ";
            } else {
                prettyIBAN+=nospaceIBAN.substring(len-4);
                break;
            }
        }

        return prettyIBAN;

    }

    public boolean isValidIBAN(String iban) {
        if(iban.length()<1) {
            return false;
        }

        String nospace = iban.replace(" ","");
        String cc = nospace.substring(0,2);

        switch(cc){
            case "BE":
                if(nospace.length()!=16) {
                    return false;
                }
                break;
            case "CY":
                if(nospace.length()!=28) {
                    return false;
                }
                break;
            case "DE":
            case "GB":
                if(nospace.length()!=22) {
                    return false;
                }
                break;
            default:
                return false;
        }

        int checksum = Integer.parseInt(nospace.substring(2,4));
        String tail = nospace.substring(4);

        String numericalString = "";


        for(int i=0; i<tail.length(); i++) {
            char c = tail.charAt(i);
            int val = tail.charAt(i);

            // If (ASCII minus 48) matches the numeric representation
            // it is a number,
            // otherwise we treat it as a letter (ASCII minus 55)
            // no matter what it actually is
            if(Integer.parseInt(String.valueOf(c))==(val-48)) {
                numericalString+=String.valueOf(Math.max(0,val-48));
            } else {
                numericalString+=String.valueOf(Math.max(0,val-55));
            }

        }

        int cc0 = cc.charAt(0)-55;
        int cc1 = cc.charAt(1)-55;

        numericalString += (String.valueOf(cc0) + String.valueOf(cc1) + "00");
        BigInteger bigNum = new BigInteger(numericalString);
        BigInteger bigDiv = new BigInteger("97");

        int moduloSum = 98-Integer.parseInt(String.valueOf(bigNum.mod(bigDiv)));

        if(moduloSum==checksum+1) {
            return true;
        }

        return false;
    }
}