package de.rubmobsec.humancentredstudies;

import android.content.Context;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link TransferManuallyPinFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class TransferManuallyPinFragment extends Fragment {

    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    EditText edit_txt;
    Button btnConfirm;

    TransferManuallyActivity tmActivity;
    int wrongPinCounter;

    public TransferManuallyPinFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment TransferManuallyPinFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static TransferManuallyPinFragment newInstance(String param1, String param2) {
        TransferManuallyPinFragment fragment = new TransferManuallyPinFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transfer_manually_pin, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        wrongPinCounter = 0;

        tmActivity = (TransferManuallyActivity) getActivity();

        btnConfirm = tmActivity.findViewById(R.id.btnConfirmTransfer);
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String enteredPIN = edit_txt.getText().toString();
                verifyPINandProceed(view, enteredPIN);
            }
        });

        edit_txt = tmActivity.findViewById(R.id.editTextTransferConfirmPIN);

        edit_txt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(charSequence.length()!=6) {
                    btnConfirm.setEnabled(false);
                } else {
                    btnConfirm.setEnabled(true);
                }

            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });

        edit_txt.setOnEditorActionListener(new EditText.OnEditorActionListener() {

            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                String enteredPIN = edit_txt.getText().toString();

                if (actionId == EditorInfo.IME_ACTION_DONE) {



                    if (enteredPIN.length() != 6) {
                        Toast toast = Toast.makeText(tmActivity.getApplicationContext(), R.string.text_login_shortpin, Toast.LENGTH_LONG);
                        toast.show();
                        wrongPinCounter++;

                    } else {
                        verifyPINandProceed(view, enteredPIN);
                    }

                    return true;
                }

                return false;
            }
        });

        InputMethodManager imm = (InputMethodManager) ((TransferManuallyActivity)getActivity()).getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(edit_txt, 0);

    }

    public void verifyPINandProceed(View view, String enteredPIN) {
        String realPIN = tmActivity.getAppPIN();

        if(!enteredPIN.equals(realPIN)) {
            Toast toast = Toast.makeText(tmActivity.getApplicationContext(), R.string.text_login_invalidpin, Toast.LENGTH_LONG);
            toast.show();
            wrongPinCounter++;
        } else {
            String timestampTransferred = TimestampService.getCurrentTimestamp();
            ((TransferManuallyActivity) getActivity()).writeDataToDB(timestampTransferred);
            ((TransferManuallyActivity) getActivity()).writeDataLocally();
            ((TransferManuallyActivity) getActivity()).finalizeTransaction(view);
        }
    }
}