package de.rubmobsec.humancentredstudies;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import android.text.Editable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link TransferManuallyAmountFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class TransferManuallyAmountFragment extends Fragment {

    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    Button btnContinue;

    public TransferManuallyAmountFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment TransferManuallyAmonutFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static TransferManuallyAmountFragment newInstance(String param1, String param2) {
        TransferManuallyAmountFragment fragment = new TransferManuallyAmountFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transfer_manually_amount, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        TransferManuallyActivity tmActivity = (TransferManuallyActivity) getActivity();
        String[] values = tmActivity.getValues();
        TransferManuallyActivity.ContinueBtn srcBtn = TransferManuallyActivity.ContinueBtn.AMOUNT;

        btnContinue = getActivity().findViewById(R.id.btnTransferDataAmount);
        btnContinue.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String amountValue = ((EditText) getActivity().findViewById(R.id.editTextTransferDataAmount)).getText().toString();
                double amountVal = Double.parseDouble(amountValue.replace(',','.'));
                String amountParsed = String.format("%.2f",amountVal).replace('.',',');

                tmActivity.updateValue(2, amountParsed);
                tmActivity.clickBtnContinue(srcBtn);
            }
        });

        TextView textViewTransferSourceAmount = getActivity().findViewById(R.id.textViewTransferSourceAmount);
        double amountValD = Double.parseDouble(((TransferManuallyActivity) getActivity()).getTransferMaxAmount());

        textViewTransferSourceAmount.setText(String.format("%.2f",amountValD)+" €");

        EditText editTextAmount = getActivity().findViewById(R.id.editTextTransferDataAmount);
        editTextAmount.setText(values[2]);
        editTextAmount.setFilters(new InputFilter[]{new CurrencyFilter()});
        editTextAmount.requestFocus();

        editTextAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(charSequence.length() > 0 &&  ((TransferManuallyActivity) getActivity()).amountOK(charSequence.toString())) {
                    btnContinue.setEnabled(true);
                    textViewTransferSourceAmount.setTextColor(getResources().getColor(R.color.text_default));
                } else {
                    btnContinue.setEnabled(false);

                    try {
                        if (!((TransferManuallyActivity) getActivity()).amountOK(editTextAmount.getText().toString())) {
                            textViewTransferSourceAmount.setTextColor(getResources().getColor(R.color.red_medium));
                        }
                    } catch (Exception e) {

                    }
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });


        if(editTextAmount.getText().toString().length() > 0 && ((TransferManuallyActivity) getActivity()).amountOK(editTextAmount.getText().toString())) {
            btnContinue.setEnabled(true);
            textViewTransferSourceAmount.setTextColor(getResources().getColor(R.color.text_default));

        } else {
            btnContinue.setEnabled(false);

            try {
                if (!((TransferManuallyActivity) getActivity()).amountOK(editTextAmount.getText().toString())) {
                    textViewTransferSourceAmount.setTextColor(getResources().getColor(R.color.red_medium));
                }
            } catch (Exception e) {

            }
        }

    }

}