package de.rubmobsec.humancentredstudies;

import static de.rubmobsec.humancentredstudies.TransferManuallyActivity.ContinueBtn.*;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.google.android.gms.tasks.Task;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;

import java.util.HashMap;
import java.util.Map;

public class TransferManuallyActivity extends AppCompatActivity {

    enum EntryMode {SUMMARY, MANUAL}

    EntryMode mode;

    enum ContinueBtn {RECEIVER, AMOUNT, SUBJECT}

    Button btnReceiver, btnAmount, btnSubject;
    EditText editName;

    boolean txComplete;
    String appPIN, scenarioNumber, validationCode, txSuccessful, studyIncomplete, transferMaxAmount;
    String timestampQualtrics, timestampStart, timestampLogin;
    String[] values;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_transfer_manually);

        Intent intent = getIntent();
        String entryMode = intent.getStringExtra("entryMode");
        appPIN = intent.getStringExtra("appPIN");
        scenarioNumber = intent.getStringExtra("scenarioNumber");
        validationCode = intent.getStringExtra("validationCode");
        txSuccessful = intent.getStringExtra("transactionSuccessful");
        studyIncomplete = intent.getStringExtra("studyIncomplete");
        transferMaxAmount = intent.getStringExtra("transferMaxAmount");
        timestampLogin = intent.getStringExtra("timestampLogin");
        timestampStart = intent.getStringExtra("timestampStart");
        timestampQualtrics = intent.getStringExtra("timestampQualtrics");

        txComplete = Boolean.parseBoolean(txSuccessful);


        values = new String[4];

        FragmentTransaction tx = getSupportFragmentManager().beginTransaction();

        if (entryMode.equals("manual")) {
            mode = EntryMode.MANUAL;
            tx.replace(R.id.fragment_placeholder, new TransferManuallyReceiverFragment());
        } else {
            if(entryMode.equals("qr")) {
                updateValue(0,intent.getStringExtra("dataTransferReceiver"));
                updateValue(1,intent.getStringExtra("dataTransferAccount"));
                updateValue(2,intent.getStringExtra("dataTransferAmount"));
                updateValue(3,intent.getStringExtra("dataTransferSubject"));
            }

            mode = EntryMode.SUMMARY;


            tx.replace(R.id.fragment_placeholder, new TransferManuallySummaryFragment());
        }

        tx.addToBackStack(null);
        tx.commit();


    }

    public void clickBtnContinue(ContinueBtn src) {
        FragmentTransaction tx = getSupportFragmentManager().beginTransaction();
        if (mode == EntryMode.MANUAL) {
            if (src == RECEIVER) {
                tx.replace(R.id.fragment_placeholder, new TransferManuallyAmountFragment());
            } else if (src == AMOUNT) {
                tx.replace(R.id.fragment_placeholder, new TransferManuallySubjectFragment());
            } else {
                mode = EntryMode.SUMMARY;
                tx.replace(R.id.fragment_placeholder, new TransferManuallySummaryFragment());
            }
        } else {
            tx.replace(R.id.fragment_placeholder, new TransferManuallySummaryFragment());
        }


        tx.addToBackStack(null);
        tx.commit();
    }

    public void clickEdit(ContinueBtn target) {
        FragmentTransaction tx = getSupportFragmentManager().beginTransaction();

        if(target==RECEIVER) {
            tx.replace(R.id.fragment_placeholder, new TransferManuallyReceiverFragment());
        } else if (target==AMOUNT) {
            tx.replace(R.id.fragment_placeholder, new TransferManuallyAmountFragment());
        } else if (target==SUBJECT) {
            tx.replace(R.id.fragment_placeholder, new TransferManuallySubjectFragment());
        }

        tx.addToBackStack(null);
        tx.commit();
    }

    public String[] getValues() {
        return values;
    }

    public void updateValue(int idx, String value) {
        values[idx] = value;
    }

    public void finalizeTransaction(View view) {

        FragmentTransaction tx = getSupportFragmentManager().beginTransaction();
        tx.replace(R.id.fragment_placeholder, new TransferManuallyConfirmedFragment());
        tx.addToBackStack(null);
        tx.commit();

        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setTitle(validationCode);
        builder.setMessage(R.string.text_validation_code_description);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // User clicked OK button
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();

    }

    public void writeDataLocally() {
        SharedPreferences sharedPreferences = getSharedPreferences("banking", MODE_PRIVATE);
        boolean statusRec = sharedPreferences.edit().putString("transferReceiver",values[0]).commit();
        boolean statusAmo = sharedPreferences.edit().putString("transferAmount",values[2]).commit();
        boolean statusSub = sharedPreferences.edit().putString("transferSubject",values[3]).commit();

    }

    public void writeDataToDB(String timestampTransferred) {

        FirebaseFirestore db = FirebaseFirestore.getInstance();

        String tLogin = TimestampService.getTimeDelta(timestampStart, timestampLogin);
        String tTransfer = TimestampService.getTimeDelta(timestampStart, timestampTransferred);



        String collectionName = "app_onlinebanking_scenario"+scenarioNumber;
        if(txComplete==true) {
            collectionName+="_backup";
        } else {
            CollectionReference surveyData = db.collection("qualtrics_onlinebanking");
            DocumentReference docRef = surveyData.document(appPIN);
            docRef.update("lockAppPIN_SurveyIncomplete",true);
            docRef.update("lockDBForScenarioAppPIN_TransactionSuccessful",true);



            studyIncomplete = "true";
            txSuccessful = "true";
            txComplete = true;
        }

        CollectionReference scenarioData = db.collection(collectionName);

        Map<String,String> docData = new HashMap<>();

        docData.put("appPIN",appPIN);
        docData.put("device","Android");
        docData.put("timestampAppTransaction",timestampTransferred);
        docData.put("timestampQualtrics",timestampQualtrics);
        docData.put("userID","");
        docData.put("userTotalLoginTime",tLogin);
        docData.put("userTotalTransactionTime",tTransfer);
        docData.put("userTransactionAmount",values[2]);
        docData.put("userTransactionIBAN",values[1]);
        docData.put("userTransactionPurpose",values[3]);
        docData.put("userTransactionRecipient",values[0]);
        docData.put("userTransactionTyposIBAN","");
        docData.put("userWrongPINCounter","");

        scenarioData.add(docData);

    }

    public void backToMenu(View view) {
        Intent intent = new Intent(TransferManuallyActivity.this, OnlineBankingMenuActivity.class);
        intent.putExtra("appPIN",appPIN);
        intent.putExtra("scenarioNumber",scenarioNumber);
        intent.putExtra("validationCode",validationCode);
        intent.putExtra("transactionSuccessful",txSuccessful);
        intent.putExtra("studyIncomplete",studyIncomplete);
        intent.putExtra("timestampQualtrics",timestampQualtrics);
        intent.putExtra("timestampStart",timestampStart);
        intent.putExtra("timestampLogin",timestampLogin);
        startActivity(intent);
    }

    public String getAppPIN() {
        return appPIN;
    }

    public boolean amountOK(String s) {
        double value = Double.parseDouble(s.replace(',','.'));
        double transferMax = Double.parseDouble(transferMaxAmount.replace(',','.'));

        return value <= transferMax;

    }

    public String getTransferMaxAmount() {
        return transferMaxAmount;
    }

    @Override
    public void onBackPressed() {
        cancelDialog();
    }

    public void cancelButton(View view) {
        cancelDialog();
    }

    void cancelDialog() {


        AlertDialog.Builder builder = new AlertDialog.Builder(TransferManuallyActivity.this);
        builder.setMessage(R.string.dialog_transfer_cancel_content)
                .setTitle(R.string.dialog_transfer_cancel_title);

        builder.setPositiveButton(R.string.dialog_transfer_cancel_positive, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {

            }
        });

        builder.setNegativeButton(R.string.dialog_transfer_cancel_negative, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                backToMenu(null);
            }
        });

        AlertDialog alertDialog = builder.create();

        alertDialog.show();
    }




}