package de.rubmobsec.humancentredstudies;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class TimestampService {

    static String getCurrentTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

        Timestamp ts = new Timestamp(new Date().getTime());

        return sdf.format(ts);
    }

    static String getTimeDelta(String s1, String s2) {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

        try {
            Date t1 = sdf.parse(s1);
            Date t2 = sdf.parse(s2);
            long elapsed = t2.getTime()- t1.getTime();

            int seconds = (int)(elapsed*0.001);

            return String.valueOf(seconds);
        } catch (ParseException e) {
            return "-1";
        }



    }
}
