package de.rubmobsec.humancentredstudies;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.FragmentTransaction;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Camera;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.vision.CameraSource;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;

import java.io.IOException;

import de.rubmobsec.humancentredstudies.databinding.ActivityOnlineBankingMenuBinding;

public class QrActivity extends AppCompatActivity {

    SurfaceView cameraView;
    BarcodeDetector barcodeDetector;
    CameraSource cameraSource;

    String appPIN, validationCode, scenarioNumber, txSuccessful, studyIncomplete, transferMaxAmount;
    String timestampQualtrics, timestampStart, timestampLogin;

    public final int REQUEST_CODE_CAMERA = 1042;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qr);

        cameraView = (SurfaceView) findViewById(R.id.camera_view);

        barcodeDetector = new BarcodeDetector.Builder(this).setBarcodeFormats(Barcode.ALL_FORMATS).build();
        cameraSource = new CameraSource.Builder(this, barcodeDetector).setAutoFocusEnabled(true).build();

        if (ActivityCompat.checkSelfPermission(getApplicationContext(),Manifest.permission.CAMERA)!=PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.CAMERA}, REQUEST_CODE_CAMERA);
        }



        cameraView.getHolder().addCallback(new SurfaceHolder.Callback() {

            @SuppressLint("MissingPermission")
            @RequiresApi(api = Build.VERSION_CODES.M)
            @Override
            public void surfaceCreated(SurfaceHolder holder) {
                try {
                    cameraSource.start(cameraView.getHolder());
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {

            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
                cameraSource.stop();
            }

        });



        barcodeDetector.setProcessor(new Detector.Processor<Barcode>() {

            @Override
            public void release() {

            }

            @Override
            public void receiveDetections(Detector.Detections<Barcode> detections) {

                final SparseArray<Barcode> barcodes = detections.getDetectedItems();

                if(barcodes.size()> 0) {
                    TextView textViewQrHint = findViewById(R.id.textViewQrHint);

                    Barcode barcode = barcodes.valueAt(0);

                    String[] barcodeLines = barcode.rawValue.split("\n");

                    String tmpRes = barcodeLines[7] +";" + barcodeLines[8] +";"+ barcodeLines[9] +";"+ barcodeLines[10];


                    if(barcodeLines.length > 8 && barcodeLines[0].equals("BCD")&&barcodeLines[1].equals("002")&&barcodeLines[2].equals("2")&&barcodeLines[3].equals("SCT")) {
                        String qrReceiver = barcodeLines[5];
                        String qrAccount = barcodeLines[6];
                        String qrAmount = barcodeLines[7].split("EUR")[1];
                        String qrSubject = barcodeLines[10];

                        startManualTransfer(qrReceiver,qrAccount,qrAmount,qrSubject);


                    } else {
                        //textViewQrHint.setText(tmpRes);
                        textViewQrHint.setText(R.string.text_qr_invalid);
                    }

                }
            }

        });

        Intent intent = getIntent();
        appPIN = intent.getStringExtra("appPIN");
        scenarioNumber = intent.getStringExtra("scenarioNumber");
        validationCode = intent.getStringExtra("validationCode");
        txSuccessful = intent.getStringExtra("transactionSuccessful");
        studyIncomplete = intent.getStringExtra("studyIncomplete");
        transferMaxAmount = intent.getStringExtra("transferMaxAmount");
        timestampStart = intent.getStringExtra("timestampStart");
        timestampLogin = intent.getStringExtra("timestampLogin");
        timestampQualtrics = intent.getStringExtra("timestampQualtrics");


    }

    @SuppressLint("MissingPermission")
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {

        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if(requestCode==REQUEST_CODE_CAMERA) {
            if(grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Intent intent = new Intent(QrActivity.this, QrActivity.class);
                startActivity(intent);


            }
        }
    }

    public void startManualTransfer(String rec, String acc, String eur, String subject) {
        Intent intent = new Intent(QrActivity.this, TransferManuallyActivity.class);
        intent.putExtra("entryMode","qr");
        intent.putExtra("appPIN",appPIN);
        intent.putExtra("scenarioNumber",scenarioNumber);
        intent.putExtra("validationCode",validationCode);
        intent.putExtra("transactionSuccessful",txSuccessful);
        intent.putExtra("studyIncomplete",studyIncomplete);
        intent.putExtra("transferMaxAmount",transferMaxAmount);
        intent.putExtra("timestampQualtrics",timestampQualtrics);
        intent.putExtra("timestampStart",timestampStart);
        intent.putExtra("timestampLogin",timestampLogin);
        intent.putExtra("dataTransferReceiver",rec);
        intent.putExtra("dataTransferAccount",acc);
        intent.putExtra("dataTransferAmount",eur);
        intent.putExtra("dataTransferSubject", subject);
        startActivity(intent);
    }


}