package de.rubmobsec.humancentredstudies;

import androidx.appcompat.app.AppCompatActivity;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;

import com.google.android.material.bottomnavigation.BottomNavigationView;

import java.util.Random;

import de.rubmobsec.humancentredstudies.databinding.ActivityMainBinding;
import de.rubmobsec.humancentredstudies.databinding.ActivityOnlineBankingMenuBinding;


public class OnlineBankingMenuActivity extends AppCompatActivity {

    private ActivityOnlineBankingMenuBinding binding;

    String appPIN, scenarioNumber, validationCode, txSuccessful, studyIncomplete;
    String timestampQualtrics, timestampStart, timestampLogin;

    boolean txComplete, studyIncompleteBoolean;





    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_online_banking_menu);

        binding = ActivityOnlineBankingMenuBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        BottomNavigationView navView = findViewById(R.id.navbar_online_banking_menu);
        // Passing each menu ID as a set of Ids because each
        // menu should be considered as top level destinations.
        AppBarConfiguration appBarConfiguration = new AppBarConfiguration.Builder(
                R.id.navigation_menu_overview, R.id.navigation_menu_transfer_money, R.id.navigation_menu_settings)
                .build();
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_activity_online_banking_menu);
        NavigationUI.setupActionBarWithNavController(this, navController, appBarConfiguration);
        NavigationUI.setupWithNavController(binding.navView, navController);

        Intent intent = getIntent();
        appPIN = intent.getStringExtra("appPIN");
        scenarioNumber = intent.getStringExtra("scenarioNumber");
        validationCode = intent.getStringExtra("validationCode");
        txSuccessful = intent.getStringExtra("transactionSuccessful");
        studyIncomplete = intent.getStringExtra("studyIncomplete");
        timestampStart = intent.getStringExtra("timestampStart");
        timestampLogin = intent.getStringExtra("timestampLogin");
        timestampQualtrics = intent.getStringExtra("timestampQualtrics");

        txComplete = Boolean.parseBoolean(txSuccessful);
        studyIncompleteBoolean = Boolean.parseBoolean(studyIncomplete);

        if(txComplete && studyIncompleteBoolean) {
            startFinalizeStudy();
        }

    }

    public void startTransfer(View view) {
        if(scenarioNumber.contains("3")||scenarioNumber.contains("4")) {
            startTransferQR(view);
        } else {
            startTransferManually(view);
        }


    }

    public void startTransferManually(View view) {
        Intent intent = new Intent(OnlineBankingMenuActivity.this, TransferManuallyActivity.class);
        intent.putExtra("entryMode","manual");
        intent.putExtra("appPIN",appPIN);
        intent.putExtra("scenarioNumber",scenarioNumber);
        intent.putExtra("validationCode",validationCode);
        intent.putExtra("transactionSuccessful",txSuccessful);
        intent.putExtra("studyIncomplete",studyIncomplete);
        intent.putExtra("transferMaxAmount",String.valueOf(getAccountValues()[0]));
        intent.putExtra("timestampLogin",timestampLogin);
        intent.putExtra("timestampStart",timestampStart);
        intent.putExtra("timestampQualtrics",timestampQualtrics);
        startActivity(intent);

    }

    public void startTransferQR(View view) {
        Intent intent = new Intent(OnlineBankingMenuActivity.this, QrActivity.class);
        intent.putExtra("appPIN",appPIN);
        intent.putExtra("scenarioNumber",scenarioNumber);
        intent.putExtra("validationCode",validationCode);
        intent.putExtra("transactionSuccessful",txSuccessful);
        intent.putExtra("studyIncomplete",studyIncomplete);
        intent.putExtra("transferMaxAmount",String.valueOf(getAccountValues()[0]));
        intent.putExtra("timestampLogin",timestampLogin);
        intent.putExtra("timestampStart",timestampStart);
        intent.putExtra("timestampQualtrics",timestampQualtrics);
        startActivity(intent);
    }

    public double[] getAccountValues() {
        SharedPreferences sharedPreferences = getSharedPreferences("banking",MODE_PRIVATE);
        String transferredBefore = sharedPreferences.getString("transferAmount","0");

        double amountTransferred = Double.parseDouble(transferredBefore.replace(',','.'));
        double depotOffset = new Random().nextInt(3000)*0.01;

        double balanceAccount = 4309.14 - amountTransferred;
        double balanceSavings = 500.22;
        double balanceDepot = 2763.35 + depotOffset;

        return new double[]{balanceAccount, balanceSavings, balanceDepot};
    }

    public String getPref() {
        SharedPreferences sharedPreferences = getSharedPreferences("banking",MODE_PRIVATE);
        String transferredBefore = sharedPreferences.getString("transferAmount","0");
        transferredBefore = transferredBefore.replace(',','.');

        return transferredBefore;
    }

    public void startFinalizeStudy() {
        Intent intent = new Intent(OnlineBankingMenuActivity.this, FinalizeStudyActivity.class);
        intent.putExtra("validationCode",validationCode);
        startActivity(intent);
    }

    public void logout() {
        Intent intent = new Intent(OnlineBankingMenuActivity.this, MainActivity.class);
        startActivity(intent);
    }

    @Override
    public void onBackPressed() {
        logoutDialog();

    }

    void logoutDialog() {


        AlertDialog.Builder builder = new AlertDialog.Builder(OnlineBankingMenuActivity.this);
        builder.setMessage(R.string.dialog_logout_content)
                .setTitle(R.string.dialog_logout_title);

        builder.setPositiveButton(R.string.dialog_logout_positive, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                logout();
            }
        });

        builder.setNegativeButton(R.string.dialog_logout_negative, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {

            }
        });

        AlertDialog alertDialog = builder.create();

        alertDialog.show();
    }

}