package de.rubmobsec.humancentredstudies;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.type.DateTime;

import java.time.Instant;
import java.util.Map;

public class OnlineBankingLoginActivity extends AppCompatActivity {

    private DatabaseReference mDatabase;
    private String timestampStart;
    CollectionReference surveyData;
    EditText edit_txt;
    Button btnLogin;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_online_banking_login);

        Intent intent = getIntent();
        timestampStart = intent.getStringExtra("timestampStart");

        FirebaseFirestore db = FirebaseFirestore.getInstance();

        surveyData = db.collection("qualtrics_onlinebanking");


        edit_txt = (EditText) findViewById(R.id.editTextNumberPassword);
        btnLogin = (Button) findViewById(R.id.btnLogin);

        btnLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String enteredPIN = edit_txt.getText().toString();
                fetchData(enteredPIN);
            }
        });

        edit_txt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if(charSequence.length()!=6) {
                    btnLogin.setEnabled(false);
                } else {
                    btnLogin.setEnabled(true);
                }

            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });

        edit_txt.setOnEditorActionListener(new EditText.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                String enteredPIN = edit_txt.getText().toString();



                if (actionId == EditorInfo.IME_ACTION_DONE) {

                    if(enteredPIN.length()!=6) {
                        Toast toast = Toast.makeText(getApplicationContext(), R.string.text_login_shortpin, Toast.LENGTH_LONG);
                        toast.show();

                    } else {
                        fetchData(enteredPIN);


                    }






                    return true;
                }
                return false;
            }
        });

        edit_txt.requestFocus();


    }

    protected void onResume() {
        super.onResume();

        EditText edit_txt = (EditText) findViewById(R.id.editTextNumberPassword);

        InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(edit_txt, 0);



    }



    public void alertRegistration(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setTitle(R.string.text_login_register_heading);
        builder.setMessage(getResources().getString(R.string.text_login_register_explanation)
                +"\n\n"+getResources().getString(R.string.text_login_register_surveylink)
                +"\n\n"+getResources().getString(R.string.text_login_register_disclaimer));
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // User clicked OK button
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void alertDone(View view, String pin, String text) {
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setTitle("PIN eingegeben: "+pin);
        builder.setMessage(text);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // User clicked OK button
            }
        });

        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void fetchData(String enteredPIN) {
        DocumentReference docRef = surveyData.document(enteredPIN);

        docRef.get().addOnCompleteListener(new OnCompleteListener<DocumentSnapshot>() {
            @Override
            public void onComplete(@NonNull Task<DocumentSnapshot> task) {
                if (task.isSuccessful()) {
                    DocumentSnapshot document = task.getResult();
                    if (document.exists()) {
                        Map<String, Object> docData = document.getData();

                        String appPin = docData.get("appPIN").toString();
                        String scenarioNumber = docData.get("scenario").toString();
                        String validationCode = docData.get("validationCode").toString();
                        String txSuccessful =docData.get("lockDBForScenarioAppPIN_TransactionSuccessful").toString();
                        String studyIncomplete = docData.get("lockAppPIN_SurveyIncomplete").toString();
                        String timestampQualtrics = docData.get("timestamp_Qualtrics").toString();

                        //alertDone(v, enteredPIN, appPin+", "+scenario+", "+validationCode);
                        startOnlineBanking(appPin, scenarioNumber, validationCode, txSuccessful,studyIncomplete,timestampQualtrics);
                    } else {
                        Toast toast = Toast.makeText(getApplicationContext(), R.string.text_login_invalidpin, Toast.LENGTH_LONG);
                        toast.show();

                    }
                } else {
                    Log.d("0", "get failed with ", task.getException());
                }
            }
        });
    }


    public void startOnlineBanking(String appPin, String scenarioNumber, String validationCode, String txSuccessful, String studyIncomplete, String timestampQualtrics) {
        String timestampLogin = TimestampService.getCurrentTimestamp();

        Intent intent = new Intent(OnlineBankingLoginActivity.this, OnlineBankingMenuActivity.class);

        intent.putExtra("appPIN",appPin);
        intent.putExtra("scenarioNumber",scenarioNumber);
        intent.putExtra("validationCode",validationCode);
        intent.putExtra("transactionSuccessful",txSuccessful);
        intent.putExtra("studyIncomplete",studyIncomplete);
        intent.putExtra("timestampQualtrics",timestampQualtrics);
        intent.putExtra("timestampStart",timestampStart);
        intent.putExtra("timestampLogin",timestampLogin);
        startActivity(intent);

    }
}