package de.rubmobsec.humancentredstudies;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;

import com.google.android.material.bottomnavigation.BottomNavigationView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.IntentCompat;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;

import de.rubmobsec.humancentredstudies.databinding.ActivityMainBinding;

public class MainActivity extends AppCompatActivity {

    private ActivityMainBinding binding;
    String timestampStart;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (getIntent().getBooleanExtra("EXIT", false)) {
            finish();
        }



        timestampStart = TimestampService.getCurrentTimestamp();


        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        BottomNavigationView navView = findViewById(R.id.nav_view);

        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_activity_main);
        NavigationUI.setupWithNavController(binding.navView, navController);

        SharedPreferences sharedPreferences = getSharedPreferences("general",MODE_PRIVATE);

        //sharedPreferences.edit().clear().commit();

        boolean privacyTermsAccepted = sharedPreferences.getBoolean("privacyTermsAccepted",false);

        if(privacyTermsAccepted==false) {
            showPrivacyTerms();
        }

    }

    public void alertUnavailable(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
        builder.setTitle(R.string.hint);
        builder.setMessage(getResources().getString(R.string.text_studies_error_unavailable));
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // User clicked OK button
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public void startOnlineBankingLogin(View view) {
        Intent intent = new Intent(MainActivity.this, OnlineBankingLoginActivity.class);
        intent.putExtra("timestampStart",timestampStart);
        startActivity(intent);

    }

    public void showPrivacyTerms() {
        Intent intent = new Intent(MainActivity.this, ConsentActivity.class);
        startActivity(intent);
    }

    @Override
    public void onBackPressed() {
        Intent intent = new Intent(MainActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        intent.putExtra("EXIT", true);
        startActivity(intent);
    }


}