package de.rubmobsec.humancentredstudies;

import java.util.regex.Pattern;

public class IBANChecker {

    public IBANChecker() {

    }

    public boolean checkFormat(String iban) {
        String nospace = iban.replace(" ","");
        String cc = nospace.substring(0,2);

        switch(cc){
            case "BE":
                if(nospace.length()!=16) {
                    return false;
                }
                break;
            case "CY":
                if(nospace.length()!=28) {
                    return false;
                }
                break;
            case "DE":
            case "GB":
                if(nospace.length()!=22) {
                    return false;
                }
                break;
            default:
                return false;
        }

        String checksum = nospace.substring(2,4);
        String tail = nospace.substring(4);

        String numericalString = "";

        for(int i=0; i<tail.length(); i++) {
            char c = tail.charAt(i);
            int val = tail.charAt(i);

            if(Integer.parseInt(String.valueOf(c))==(val-48)) {
                numericalString+=val-48;
            } else {
                numericalString+=val-55;
            }

        }

        int cc0 = cc.charAt(0)-55;
        int cc1 = cc.charAt(1)-55;

        numericalString += String.valueOf(cc0)+String.valueOf(cc1)+"00";

        if(98-(Integer.parseInt(numericalString)%97)==Integer.parseInt(checksum)) {
            return true;
        }

        return false;
    }
}
