package de.rubmobsec.humancentredstudies;

import android.text.InputFilter;
import android.text.Spanned;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurrencyFilter implements InputFilter {

    Pattern amountPattern = Pattern.compile("(0|[1-9]+[0-9]*)?([\\.,]{1,1}[0-9]{0,2})?");
    //Pattern amountPattern = Pattern.compile("(0|[1-9]+[0-9]*)?(\\.[0-9]{0,2})? €?");


    @Override
    public CharSequence filter(CharSequence charSequence, int start, int end, Spanned spanned, int dStart, int dEnd) {
        String result =
                spanned.subSequence(0,dStart)
                        + charSequence.toString()
                        + spanned.subSequence(dEnd,spanned.length());

        Matcher matcher = amountPattern.matcher(result);

        //String finalText = spanned.subSequence(dStart,dEnd).toString();

        //if (!finalText.contains(" €")) finalText+=" €";
        //if (!matcher.matches()) return (CharSequence) finalText;

        if (!matcher.matches()) return spanned.subSequence(dStart,dEnd);

        return null;
    }
}
