(* proofs/adversarial/missing_step2.v *)
(*
  File: missing_step2.v
  Description: Deliberately remove one crucial proof step for Coq stress test.
  Author: PSBigBig
  Last Modified: 2025-06-XX
*)

Require Import Reals.
Open Scope R_scope.

Theorem broken_coq (x k eps alpha : R) :
  (x + k * eps ^ alpha) - x = _.
Proof.
  simpl.
  (* Deliberately skip proof step *)
Abort.  (* Coq 在此处应当报错 *)
