# QC Failure Case Study – Clinical Chemistry Scenario Trainer

**Author:** Claire L. Price  
🔗 [QC Failure](https://claireprice.github.io/Failing-QC/))

---

## Overview

**QC Failure** is an interactive educational tool designed to simulate a **quality control failure investigation** in a clinical chemistry laboratory setting.

Learners are guided through the process of:
- Recognizing QC failure in patient test results
- Evaluating potential technical and clinical causes
- Making decisions to accept or reject results
- Exploring follow-up actions and implications

This case-based tool promotes critical thinking and practical decision-making for those learning about laboratory quality assurance and error handling.

---

## Learning Objectives

- Understand the principles of internal quality control (IQC)
- Identify patterns that suggest QC failure
- Explore common causes of analytical errors
- Practice evaluating whether results can be reported
- Reinforce the link between lab data, clinical context, and lab protocols

---

## Features

- Realistic clinical chemistry case with interactive decision points
- Multiple-choice reasoning steps with feedback
- Visual cues and structured logic for interpretation
- Final outcome summary based on user choices
- Fully browser-based, no installation required

---

## How to Use

1. Open `index.html` in any modern browser.
2. Read the patient scenario and QC context.
3. Follow the prompts to interpret data and make decisions.
4. At the end, review your interpretation and reasoning path.

---

## Intended Audience

- Biomedical science students
- Clinical chemistry trainees
- Medical laboratory assistants and technologists
- Educators running practical QC or error analysis workshops

---

## License
Creative Commons Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)

© Claire Price, 2025.

You are free to:
- Share — copy and redistribute the material in any medium or format
- Adapt — remix, transform, and build upon the material for educational purposes

Under the following terms:
- Attribution — You must give appropriate credit and indicate if changes were made.
- NonCommercial — You may not use the material for commercial purposes.

License details: https://creativecommons.org/licenses/by-nc/4.0/


