# Henderson-Hasselbalch Tutorial

**Author:** Claire L. Price  
🔗 [Henderson-Hasselbalch Tutorial](https://claireprice.github.io/Henderson-Hasselbalch-Tutorial/)

---

## Overview

This interactive workshop tool helps learners understand and apply the **Henderson-Hasselbalch equation** in clinical scenarios. It allows users to calculate:
- **pH**
- **Bicarbonate (HCO₃⁻)**
- **pCO₂**

Each calculation comes with step-by-step explanations, example values, a quiz prompt, and clinical relevance summaries — making it ideal for classroom use, self-study, or medical training sessions.

---

## Features

- Select from three calculation types: pH, HCO₃⁻, or pCO₂
- Load example cases (e.g., respiratory acidosis, metabolic alkalosis)
- Step-by-step breakdown of each calculation
- Built-in quiz prompts for learning reinforcement
- Clinical relevance provided for interpretation and context
- Responsive, browser-based design — no installation required

---

## Henderson-Hasselbalch Equation

The core equation used in this tool is:

pH = 6.1 + log₁₀([HCO₃⁻] / (0.03 × pCO₂))

The equation is rearranged internally depending on the user’s choice of unknown variable.

---

## Getting Started

1. **Open the `index.html` file** in any modern browser.
2. Choose what you want to calculate: **pH**, **HCO₃⁻**, or **pCO₂**.
3. Optionally, load a sample case to explore clinical examples.
4. Enter the known values.
5. Click **Calculate** to view:
   - Result
   - Calculation explanation
   - Quiz question
   - Clinical summary

---

## Clinical Scenarios Included

- Normal acid-base balance
- Respiratory acidosis
- Respiratory alkalosis
- Metabolic acidosis (Winter’s formula)
- Metabolic alkalosis

---

## License
Creative Commons Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)

© Claire Price, 2025.

You are free to:
- Share — copy and redistribute the material in any medium or format
- Adapt — remix, transform, and build upon the material for educational purposes

Under the following terms:
- Attribution — You must give appropriate credit and indicate if changes were made.
- NonCommercial — You may not use the material for commercial purposes.

License details: https://creativecommons.org/licenses/by-nc/4.0/


