# Tactile X-Rays: 3D-Printed Radiographs for Inclusive Anatomy Education

**Author:** Claire Louise Price  
**Affiliation:** Swansea University Medical School, Swansea SA2 8PP UK  

**Co-Author:** Hayley Pincott  
**Affiliation:** See Science, Cardiff CF10 3DD UK  

---

## Overview

This project involves the conversion of standard medical radiographs (X-rays) into 3D-printable models that allow for tactile exploration of anatomical structures. The aim is to create accessible, hands-on teaching aids for use in educational settings, particularly where conventional imaging technology may not be available.

---

## Key Features

- Converts 2D radiographic images (e.g., hands, teeth, joints) into 3D-printable STL files  
- Designed for tactile use by students, educators, and visually impaired users  
- Enhances understanding of anatomical features and clinical conditions through physical interaction  
- Ideal for classroom demonstrations, public science outreach, and informal learning environments  

---

## Use Cases

- Anatomy and health science education  
- Outreach events and exhibitions  
- Inclusive learning for visually impaired or neurodiverse students  
- Medical communication and patient education  

---

## Getting Started

1. Open the STL or 3MF files in your preferred 3D printing software (e.g., Cura, PrusaSlicer, Bambu Slicer).
2. For best results (that mimic real X-rays), use [eSun Cold White PLA+](https://www.amazon.co.uk/eSUN-Filament-Material-Dimensional-Refills%EF%BC%8CBlack/dp/B07FQ98RNP).
3. Printer settings:
   - **Nozzle:** 0.4 mm  
   - **Layer Height:** 0.20  
   - **Wall Loops:** 2  
   - **Infill Density:** 15%  
   - **Brim:** Outer Brim  
   - **Brim Width:** 15 mm  
4. Shine a bright light behind the print to get the full X-ray effect.  
5. Use printed models in lessons, outreach, or personal study.  

---

## Requirements

- Basic familiarity with 3D printing workflows  
- 3D printer (FDM recommended for affordability)  

---

## Attribution

This project was developed as part of a broader effort to enhance inclusivity and accessibility in science education. It was funded by a grant from the IBMS. Please credit the author when reusing or adapting materials.

---

## Feedback and Contributions

Feedback, collaboration, and contributions are welcome. Please contact:  
📧 c.l.price@swansea.ac.uk  

---

## License

**Creative Commons Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)**  
© Claire Price, 2025

**You are free to:**
- **Share** — copy and redistribute the material in any medium or format  
- **Adapt** — remix, transform, and build upon the material for educational purposes  

**Under the following terms:**
- **Attribution** — You must give appropriate credit and indicate if changes were made.  
- **NonCommercial** — You may not use the material for commercial purposes.  

🔗 [License details](https://creativecommons.org/licenses/by-nc/4.0/)
