To further the goals and motivations of the NSF grant supporting the Imageomics Institute, and to fulfill the requirements from the Data Management Plan (DMP) associated with the grant, all data, model, and code products generated or augmented under the auspices and support of the Institute should adhere to [FAIR principles](https://www.go-fair.org/fair-principles/). Datasets that include Indigenous data should also adhere to [CARE principles](https://www.gida-global.org/care).

This means the following policy applies for digital products of the Imageomics Institute:
1. All digital products (code, data, models, documentation, tutorials, etc) are to be released such that it is accessible to the public, at the latest at the conclusion of the event, under an [Open Content](https://en.wikipedia.org/wiki/Free_content) license or terms of use.
2. Code is to be released under an [OSI-approved open source license](https://opensource.org/licenses/), or to the public domain (for example, by applying a [CC-Zero](https://creativecommons.org/choose/zero/) waiver).
    - Scripts can simply be added to this GitHub repository. For more complex codebases, we recommend using a version control repository on GitHub, Gitlab, etc.
3. Data, documents, tutorials, etc are to be released either to the public domain (for example, by applying a [CC-Zero](https://creativecommons.org/choose/zero/) waiver), or under terms no more restrictive than requiring attribution (such as [CC-BY](https://creativecommons.org/licenses/by/2.0/)).
    - For image and video datasets, this only applies to items that are not already licensed by (and thus used under license from) a third party.
    - For datasets that include Indigenous data, see [Carroll et al (2020)](https://doi.org/10.5334/dsj-2020-043) and [Carroll et al (2021)](https://doi.org/10.1038/s41597-021-00892-0) for reconciling FAIR and CARE principles for scientific data.
    - Datasets collected in whole or in part from regions that harbor Indigenous researchers are to at least adhere to the Collective Benefit principle (the C in CARE), even if they have been expressly released from or are otherwise entirely unencumbered by Indigenous rights. Specifically, at a minimum they are to be made available to respective Indigenous researchers with the least obstacles possible.
    - For ML-ready datasets, for storage, version control, and sharing we recommend using [Hugging Face Dataset Hub](https://huggingface.co/docs/hub/datasets-overview), which provides for rich metadata description in the form of a [Dataset Card](https://huggingface.co/docs/hub/datasets-cards).
4. ML models are to be released under an [OSI-approved open source license](https://opensource.org/licenses/), or a [Responsible AI License](https://www.licenses.ai/ai-licenses) (RAIL) (in particular [Open RAIL-M](https://www.licenses.ai/blog/2022/8/18/naming-convention-of-responsible-ai-licenses)), or to the public domain (for example, by applying a [CC-Zero](https://creativecommons.org/choose/zero/) waiver).
    - For further guidance, consider the [discussion at the Open Source Initiative](https://opensource.org/deepdive), [White et al (2024)](https://arxiv.org/abs/2403.13784), and the chapter on [Machine Learning Model Licenses](https://book.the-turing-way.org/reproducible-research/licensing/licensing-ml) from The Turing Way.
    - For storage, version control, sharing, and publishing (including DOI provision), we recommend using [Hugging Face Model Hub](https://huggingface.co/docs/hub/models), which provides for rich metadata description in the form of a [Model Card](https://huggingface.co/docs/hub/model-cards). (See [Imageomics models](https://huggingface.co/imageomics) published there as examples.)