# Essence - the Games: The Hot Seat
One thing I like about Essence is that, despite the fact that under the surface it has a rigourous theoretical basis, it is easily approachable and learnable. The cards (mentioned in my last article) provide an easy entry point, and the games provide an easy way to get an idea of all the things you can do with the cards.
For example, I would like to show you my variation on a game I picked up from Simon Girvan at the Essence Exploration Day. I call it The Hot Seat, and I'll illustrate it using the elements of Scrum.

First, take the cards for all the elements, and put them in (sort of) a circle.

The cards can be: dev team, product-increment, product backlog, sprint backlog, sprint goal, openness, courage, respect, focus, commitment, sprint retrospective, sprint review, daily scrum, backlog refinement, sprint planning, the sprint, scrum master and product owner.

Then choose one of the cards (any card), and put it in the middle. This is the Hot Seat, and this card represents the context for the exercise. For our example, we'll use the Sprint Review.

Next, choose any other card, which represents a Role. For our example, we'll choose the Product Owner. Draw a line or find some other way of symbolically connecting the card to the one on the Hot Seat.

Your job is to describe the role that the element plays in the context of the card on the Hot Seat. You can do this by answering the following four questions:
1. What goes in? What does this element contribute to the element in the Hot Seat? In our example, the question would be what the Product Owner's role and responsibility is in the Sprint Review.
2. What comes out? What does the element get from the element in the Hot Seat? In our example, the question would be what the Product Owner gets out of the Sprint Review.
3. What must happen for this to be a success? What is needed from both cards to this connection to be mutually beneficial? In our example, the question would be what the Product Owner needs to contribute to the Sprint Review for it to be a success.
4. What might happen for this to be a failure? What is needed from either card for this connection to break? In our example, the question would be what the Product Owner could potentially do to sabotage the Sprint Review. And of course, what must be done to avoid this happening?

This gets more interesting when you use not only the roles of Scrum, but also the values. It's easy enough to explain the Product Owner's role in the Sprint Review, but e.g. what role does Respect play?
And it gets even more interesting when you add the Essence alphas to the game, and start thinking outside the Scrum box.

How do Requirements, Stakeholders, Opportunity etc. fit into the Sprint Review?
How can you use this exercise?

It serves as a great basis for conversation and discussion, and probably for arguments as well. It will bring to the surface differences of opinions and viewpoints. I'll be using it when doing Scrum training. You might use it as part of a retrospective, not only to refresh your team's knowledge of Scrum, but also as a diagnostic tool to review what's working well and what needs to improve. And this exercise is an excellent source of questions for interviewing potential candidates for ScrumMaster and Agile Coach roles.
In fact, I think that this game has so much potential that I'm considering developing a small app that will randomly choose the context and role cards for a round of the game, so that people won't choose cards based on their personal preferences.