# Introduction to Scrum
Lesson objectives:
- Introduction to the agile Scrum method
- Roles - PO, SM, Dev
- Artifacts: product and sprint backlogs
- Rituals (meetings)
- Variants of Scrum
Relay or scrum package?
“The. ʻrelay raceʼ approach to product development...may conflict with the goals of maximum speed and flexibility. Instead a holistic or ʻrugbyʼ approach-where a team tries to go the distance as a unit, passing the ball back and forth-may better serve todayʼs competitive requirements.”
# Scrum in 100 words
- Scrum is a process model for producing software while getting the most useful value in the least amount of time
- The customer defines the functions to be implemented and their priorities
- The development team decides on a daily basis the best way to produce the highest priority functions.
- At the end of each sprint, a new version is born that is reviewed by the customer to decide whether to continue development with another sprint and/or produce a release
Scrum: pig roles and chicken roles.
# The main iteration: the sprint.
- A Scrum process is a series of sprints (iterations)
- Duration of each sprint 2 to 4 weeks (team+PO's choice)
- Duration of each sprint: constant (improves the team's pace)
- Each sprint includes: design, coding and testing
- Each sprint pulls “Ready” features from product backlog and adds “Done” code to product, to show to customer
# Scrum: roles events artifacts
Roles:
- Product owner
- ScrumMaster
- Team
Events:
- Sprint planning
- Sprint review
- Sprint retrospective
- Daily scrum meeting
Artifacts:
- Product backlog
- Sprint backlog
- Burndown charts
# Major roles in Scrum
Roles in Scrum:
- **Product Owner (PO)**: represents stakeholders (the voice of the customer), writes the _product backlog_ in the form of _user stories;_ is responsible for defining “Done”.
- **Development team**: 3-9 members with different skills, collectively responsible for delivering a PSI (Potentially Shippable Increment)
- **Scrum Master (SM)**: facilitates proper execution of the process, removes obstacles
- Product Owner and Scrum Master must be different people; can collaborate on development
- SM does not have personnel or project management responsibilities in “traditional” sense - e.g., does not give rewards or sanctions
# Product Owner (PO)
- Responsible for the value of the product (Return On Investment - ROI).
- Defines the features (functions) of the product
- Decides on releases: dates and content
- Prioritizes features over market value
- For each iteration reviews list of features and their priority where necessary
- Accepts or rejects development results by defining “Done”
The Product Owner in Essence:
- “Owns” the product
- Manages the product vision and its evolution
- Shows the product to stakeholders
- Acquires acceptance of the product
# The development team
- Self-organizing
- Changes to the team only in different sprints: is stable throughout the sprint
- All present in the same workspace
- Includes a Scrum Master as coach and mentor
Team members:
- 5 - 9 people
- Small team communicates better
- Various specialties: Programmers, testers, user experience designers, database administrators, etc.
- Full-time commitment. With exceptions (e.g., database administrator, expensive).
# Scrum team characteristics.
The team includes developers capable of producing a “Done” product increment at the end of each sprint.
The team is self-managing and has the following characteristics:
- Members are self-organizing; no one, not even the Scrum Master, can tell the team how to turn the Product Backlog into potentially releasable feature increments;
- Teams are cross-functional, that is, they include all the skills needed to create a product increment;
- Team members are all equal Developers, with no exceptions;
- The Team is unitary and does not include subgroups, with no exceptions for particular activities or domains;
- Team members may have some personal specialization, but the entire Team remains responsible for development.
The Team in Essence
The team is self-organizing
Includes a facilitator (called a Scrum Master)
Chooses a way of working
Collaborates and shares knowledge
Keeps a sustainable pace
# Scrum Master
- Serves the team, not directs it
- Responsible for agile values and practices
- Is the “Process Owner”: coordinates meetings and removes impediments to the Scrum process
- Ensures the well-being of the team
- Supports cooperation of roles and functions
- Protects the team from outside interference
- Does not necessarily have to be a programmer
## Scrum roles: responsibilities
Product owners: Build the right product
Developers: Build the product well
Scrum master: Avoiding stumbles and ensuring speed
## The definition of Ready.
A story is Ready when:
- All team members understand it
- It is detailed enough that it can then be tested
- The Product Ownermust understand its value in order to prioritize it with others
- The Team must be able to estimate it so that it can be completed within a sprint
- The story is independent of the others: the Team can work on it having full control over it
# The Definition of Done.
The Definition of Done describes the status of the Increment when it meets the required quality metrics for the product.
The Definition of Done creates transparency by providing everyone with a shared understanding of what work has been completed as part of the Increment.
If an item does not meet the Definition of Done, it cannot be released or even submitted during the Sprint Review: it returns to the Product Backlog. 
Example of Definition of Done:
The processing of a feature that makes a user story is not finished unless it meets the PO: The Definition of Done is agreed by the Team with the Product Ownerat the beginning of the process.
A possible definition of Done:
i. Coding of the required feature: completed
ii. Unit testing: written and performed
iii. Integration testing: passed
iv. Performance test: passed
v. Documentation (minimal): written
vi. Approved: by OP
# Sprint planning.
- The team chooses from the product backlog the elements that will certainly be implemented in the sprint
- High-level architecture study
- The sprint backlog is created: the tasks to be done
    - Identification and estimation of each task (1-16 hours)
    - Use of Planning Poker
Planning poker can be played with Essence cards to plan the sprint.
“Speed” is the amount of story points the team completed during a sprint.
Speed is calculated at the end of a sprint and is useful for predicting (estimating) how much work will be accomplished in the next sprint.
Speed can be measured:
- For each individual task
- For each sprint
# Daily Scrum
- Modality
    - Looking at the board
    - 15 - minutes max
    - Standing
    - Anyone can watch
    - Only pigs can speak: team members, ScrumMaster, Product Owner
    - Why standing: avoid too long duration
Daily scrum: Three questions for everyone
1. What did you do yesterday?
2. What are you going to do today?
3. Do you anticipate problems?
Answers are promised to teammates
# The Product Owner(Product Owner) in the daily scrum.
The Product Ownerparticipates in the daily scrum meeting, but.
- It does not matter if the Product Owneris absent (the meeting starts anyway)
- The Product Ownermay not enter new User Stories (this is done only at the beginning of the sprint)
- The Product Ownerdoes not claim to have clear statuses: developers self-manage
- The Product Ownerparticipates to make constructive suggestions
# Sprint review: the product demo.
- The team presents to the Product Ownerwhat it has achieved with the sprint: it is necessary to show how the product has “grown”
- It is a demo of the new features
- It is used to check the status of the product backlog
- Informal meeting
    - 2 h preparation, no slides
- The whole team participates
- Invite everyone
# Sprint retrospective.
- Retrospective is about the process (not the product): how is the development going?
- Need to periodically analyze what is going and what is not going in each sprint
- When: at the end of each sprint, after the review
- Everyone participates:
    - ScrumMaster (retrospective coordinator)
    - Product Owner
    - Team
    - Maybe committers, users and other stakeholders
Retrospective: Start / Stop / Continue
The team discusses what they would like to do:
Start doing
Stop doing
Continue doing
There are several alternative ways to define a retrospective.
The purpose of the retrospective
- To examine how the last sprint went with regard to
    people, relationships, processes and tools;
- Review the key architectural drivers with respect to the
    stakeholder expectations
- Identify and sort the key elements that went
    gone well and potential improvements;
- Create a plan to implement improvements to the way the
    Team's way of working
# Cancel a sprint.
- The Product Owner can cancel a sprint during its progress if the sprint objective becomes obsolete
- e.g., if market conditions have changed or if the organization undergoes a change
- It usually does not make sense to cancel a sprint
# Product backlog
- Product backlog = List of requirements in the form of user stories.
- Defined in such a way that each item has value to the users or principals of the product
- Prioritized by the Product Owner
- Priorities redefined at the beginning of 
The product backlog is a list of stories ordered by the Product Ownerere estimated by the team.
The product backlog is sorted
- The sorting (prioritization) of user stories is the task of the PO
- The breakdown of which stories will be implemented in the next sprint is up to the team, based on development estimates
- (user stories are requirements)
The product backlog is an iceberg
- The top of the iceberg are the stories ready to be implemented
- The stories below the top are planned in the release schedule, even if they are still unclear
- Below the surface are the future releases, not yet agreed upon or even imagined
Prioritizing user stories
User story map: how to slice the product backlog
Mapping user stories to features
# Sprint goal (sprint goal).
Brief description of the work to be done during the sprint. Examples:
- Database Application: Support features needed for population genetics studies.
- Financial services: Support more technical indicators than company ABC with real-time, streaming data.
- Life Sciences: Make the application run on SQL Server in addition to Oracle.
Sprint backlog management:
- Team members book work to be done on personal choice.
- Work is not assigned, but requested on a “voluntary” basis
- Estimated work to be done in terms of effort is updated daily
From product backlog to sprint backlog.
The decomposition of User Stories into tasks.
# Managing the sprint backlog.
- Each team member can edit the sprint backlog, which is usually kept in a board called a “taskboard” or “kanban”
- The work to be done in each sprint “emerges” on the board
- If the work to be done is unclear, it is better to define a sprint backlog item with a higher estimate and decompose it later
- It is necessary to update the work to be done as it comes up
The cycle of tasks in a sprint.
A burndown chart of a sprint.
Ideal velocity on the burndown chart VS. Actual velocity on the burndown chart
# Continuous estimation of remaining effort.
Each participant chooses a task and estimates the time remaining.
E.g., after the first day 6 h were spent on task 1. The scheduler estimates that another 6 h remain (thus 2 h beyond the 10 h estimate).
The burn-down chart is updated and compared to the ideal (blue vs. red).
Other agile metrics:
Besides burndown and velocity, the following are relevant:
- Release burndown
- Control chart
- Cumulative flow chart
# Scrum variants
Multiple Scrums:
- Some Scrum projects have involved more than 500 people
- Scaling to large systems with scrums of scrums
- Factors driving process structuring with multiple scrums
- Type of application
- Project duration
- Dispersion of teams
Single team, multiple product owners
Multiple teams, single product
Scrum of scrum
Scrum of scrum of scrum
# Typical problems with Scrum.
1. Ignorance of agile and Scrum values.
2. Untested software product at the end of the sprint (bad definition of _“Done”_ )
3. Backlog not ready at the beginning of the sprint (bad definition of _Ready_ )
4. Lack of facilitation (or bad facilitation)
5. Lack of support from managers
6. Lack of support from stakeholders
7. Chaotic management of scrums of scrums
XP or Scrum?
XP:
- Quality oriented (test driven)
- Iteration: 1-2 weeks
- Requirements always editable
- Customer orders the stories 
- Informal coaching
- Typical XP best practices: TDD, Pair programming, planning game, refactoring
Scrum:
- Project management oriented
- Sprint: 2-4 weeks
- Reqs editable at end of sprint
- Team orders stories
- Certified Scrum master
- Typical Scrum best practices: post-mortem retrospective, use of PM tools, planning poker
Please note: XP and Scrum can coexist.
# The requirements forms.
Lesson Objectives:
- What are software requirements?
- The form of requirements:
    - Structured sentences, scenarios, use cases, user stories
- Insight into user stories
Requirement:
definition from Italian vocabulary
- Each of the qualities necessary and required for a given purpose.
- Example: _has all the requirements to become a good computer scientist_.
Requirements are desires!
How are desires expressed from a software development perspective?
Functional requirement:
“ _The system will allow you to book a cab and have an estimate of the waiting time_ ”
Scenario:
_Customer: “I need a cab at 33 Zamboni Street”_.
_System: “Strawberry 33 will arrive in 3 minutes”_
User story:
_Paolo wants to be able to call a cab from an app and get response with estimated time of arrival, to calculate if he will arrive on time to his appointment_.
But what is a wish?
# Humphrey's Law.
The requirements of a new software product will not be clear until users start using it, i.e., a problem is not well understood until a solution is developed.
Why are there so many forms for requirements?
The user-centered form
The form centered on the usage scenario
The contractual form
The developer-appropriate form
# Requirements analysis
Requirements **analysis** is a preliminary activity to the development of a software product, and is used to define the functionality to be offered, i.e., the _requirements to be met_ by the developed software.
Requirements analysis is a phase present in all software life cycle models, albeit with different emphases and different connotations.
In ours it corresponds to the definition and modification of the product backlog.
Example:
- A library handles loans of 100,000 volumes to 5,000 subscribers.
- The library is equipped with a book cataloging system.
- The volumes are cataloged with the usual bibliographic metadata (author, title, publisher, year, etc.) and identified by their ISBN and a copy counter.
- There are two types of users: the librarian and the subscriber; the former can update the database, while the latter can only consult book data. All users will be provided with a standard Web interface that can also be used from home.
- A subscriber requests the library to lend one or more volumes at a time using a Web browser; the library sends the customer a list of available volumes.
- Books are loaned to library subscribers, and subscribers are identified both by a numerical code and by their last name, first name, and date of birth.
- The librarian has password access to update operations, while the subscriber has free access to reference operations
- The application to be designed must allow data entry of new acquisitions, enrollment of new users, loan registration, book return, loan control, and consultation of available books using bibliographic metadata.
- What does this text describe?
- Would you know how to write software based on it, without further interaction with the client?
# The drafting of requirements.
- Establish **what** the customer requires of a software system (purpose)
- Without defining **how** the system will be built (functions)
Requirements for the library example
(written in functional format)
1. The system will handle two types of users: the library operator and the “normal” user
2. The system will allow the user to borrow a book
3. The system will allow the user to return a book
4. The system will allow the librarian to place a new book in the catalog
5. The system will allow the librarian to dispose of a book from the catalog
6. The system will allow the librarian to enter a new registered user
7. The system will allow the librarian to delete a user
8. The system will allow the librarian to approve a book loan
9. The system will allow the librarian to solicit the return of a book
10. The system will allow the librarian to compile statistics on loans
11. .... etc.
12. ...(continued) ...
# Example scenario for use case “borrowing”
**Use Case Title**: Lending a Book.
**Main Actors**: User
- **Main Scenario**
1. User starts the library application.
2. User logs into his/her account, providing login credentials.
3. The user searches for the desired book using the search function within the app.
4. The user selects the book they want from the list of search results.
5. The app checks the availability of the book. If the book is available, it proceeds with the loan;
if not, it displays a warning message.
6. The user confirms the loan request.
7. The application registers the loan of the book on behalf of the user.
8. The application provides a confirmation of the loan, including the loan due date
9. The user can now view the book in their account as a borrowed book.
- **Alternative Scenario**
6a. If the book is not available, the application displays an error message and the user can
decide whether to search for another book or exit the app.
# Requirements.
- Requirements are descriptions of what is needed and should be accomplished.
- They are descriptions of 1) what the system should do, or 2) a property or attribute of the system
- They can also be 3) a constraint on the system's development process
Example:
- What the system should do: allow me to buy a train ticket
- System attribute: the purchase should take no more than a minute
- Constraint: the purchase must take place on an Android phone
A requirement says <who> wants <what> and <why>.
A requirement says **what** a system should do, but not **how**.
Requirements can be:
- business
- of user
- of the software
Examples:
- Business requirement: the ticketing system must handle at least 1M tickets per day
- User requirement: as a traveler I want to buy a ticket from Bologna to Milan for my mom to travel.
- Software requirement: the Ticket record will contain the field Person of type string vector.
There are many types of requirements and many ways to specify them.
# The form of the requirement.
- **Epic**: “ _The library needs an app for borrowing and returning books”_.
- **User story**: “ _As a subscriber I want to consult the catalog to borrow a volume”_
- **Use case**: “ _A subscriber queries the Catalog function to look up a volume, the Catalog asks the subscriber for the data needed to search, the subscriber enters the data, the Catalog responds...”_
- **Functional**: “ _The application will manage the lending of volumes to subscribers”_
Epics:
- The _epic_ represents a set of high-level features required in a product vision
- The epic helps identify the main requirements of a product and provides an overview of what needs to be developed.
- Typically, an epic is too large to be implemented in a single development iteration and must be decomposed into multiple user stories.
- The user story represents a single feature that can be implemented in a single iteration.
Refining the backlog.
# Requirements with user stories.
The agile form of requirements: user stories.
In agile development models, requirements are written through user stories, which have this form:
Like <type of user> _(role)_
I want to <do something> _(function)_
To <achieve a goal> _(purpose)_
Examples:
As a library user
I want to check out the catalog
To borrow a volume
As a librarian
I want to consult the catalog
To add a new book
# Steps
1. Identify users.
- A user story describes how qualcunousa a product
- If you do not yet know who the users will be or how they will use the product DO NOT write user stories
2. use ideal users ( _personae_ )
_personae_ are fictional characters that are based on direct knowledge of the product's target audience.
They usually consist of: a name and image; some relevant characteristics and behaviors; and a personal goal.
The goal is the benefit the person wants to get, or the problem they want to solve by using the product.
3. create User Stories by collaborating with devs.
User Stories are a tool and a product of conversations not only with users but also with devs
4. user stories are simple and concise
As < _people_ > I want < _what_?> so that < _why_ >
Please note : This outline is useful but not mandatory
On the next slide we will see a permissible though different form.
# Situational form of user story.
When____ I want to be able to______so that_______
Situation. Rationale. Expected result.
When I need a book I want to be able to reserve it to get it as soon as possible
When I change phones I want to use the old one to set up the new one
When I take a train I want to be able to buy a ticket to leave early
# Conclusion.
- User stories are a favorite way to write requirements for a digital product
- Product management comes to define user stories after a market analysis that includes characterizing _personae_ ideal users of the product
Self-assessment questions:
- What does Humphrey's law assert?
- What is a user requirement?
- What is the standard form of user stories?
- What is an epic?
- What are the states of a requirement in the Essence model?
# The Product Owner
Agenda:
- The Product Owner: who he is and what he does
- Duties of the Product Ownerin Scrum
- Setting priorities
    - Game: desert survival
- Essence Cards of Product Ownership.
The OP, stakeholders, and the team.
The Product Ownerrepresents the stakeholders on the team.
The Product Owneris a member of the team.
The main competencies of the Product Ownerare:
- See the product from the customer's point of view and understand the customer's needs.
- Establish priorities and decide which features to create and which to delay or eliminate (this is called: _maximizing the value of product releases_ )
- The Product Ownerrarepresents the customer on the team, and reports back to the customer the team's questions that they cannot answer
- Mediate between stakeholders and team members.
- Have flexibility and adapt to market and product change
- Collect, analyze, and evaluate data on the product being used, to improve it at subsequent iterations
The Product Ownermaximizes value:
- The Product Owneris responsible for _maximizing the value_ of the product resulting from the work done by the Team
- This “maximization” is understood from a stakeholder perspective, particularly often to improve the attractiveness of the product to users
- How this is done can depend very much on the organization, the Team, and the individual stakeholders involved in the product building project
# Maximizing value.
The Product Owneris responsible for the backlog
- The Product Owneris responsible for managing the product, including:
    - defining and communicating the Product Goal to the team;
    - creating the elements of the Product Backlog and making sure they are visible and understandable to everyone; and
    - ordering (prioritizing) the elements of the Product Backlog;
    - defining the Sprint Goal
    - Help the team define the Sprint Backlog.
    - Agree with the team on the Definition of Done
    - decide on releases
- The Product Ownermay do all of the above activities or may delegate some of them to others. However, even if he delegates, the Product Ownerremains responsible for
The Product Ownerin the Scrum guide:
- In order for the Product Ownerto act successfully within the organization, everyone must respect his decisions.
- These decisions are visible in the content and priority order of the Product Backlog, and through the Inspection of Increment during the Sprint Review.
- The Product Owneris a single person and not a Group.
- The Product Ownermay express the needs of different stakeholders in the Product Backlog.
- Those who would like to change the Product Backlog can do so by trying to convince the PO.
# Tasks of the Product Owner.
- Creates the product vision: one Product Ownerper product
- Represents stakeholders on the team
- Creates the product backlog
- Maximizes the value of what is produced, sprint by sprint
- Defines functional priorities and product roadmap
- For each sprint defines the sprint goal
- Builds with the help of the team the “Definition of Ready” and “Definition of Done”
- Reviews the product together with the team (in the meeting called: _demo review_ ) and accepts or rejects the work done
The product backlog is a list of stories ordered by the Product Ownere estimated by the team.
The product backlog is sorted:
- The sorting (prioritization) of user stories is the task of the PO.
- The sorting of which stories will be implemented in the next sprint is the task of the team, based on the development estimates
- (user stories are requirements)
# How the Product Owner organizes sprint planning.
Prepare a summary of stakeholder needs.
Select and sort the User Stories proposed at the next sprint.
Review the User Stories so that they carry all the necessary information: description, acceptance criteria, link to the function to be implemented, dependencies on other User Stories.
Review the Definition of Ready and ensure that the User Stories chosen for the next sprint are ready.
Prepare a sprint goal and agenda for the sprint review.
Help the team define the tasks associated with each User Story.
# The Definition of Ready and The Definition of Done.
A story is Ready when:
- All team members understand it
- It is detailed enough that it can then be tested
- The Product Ownermust understand its value in order to prioritize it with others
- The Team must be able to estimate it so it can be completed within a sprint
- The story is independent of the others: the Team can work on it having full control over it
The Definition of Donedescribes the status of the Incrementwhen it meets the quality metrics required for the product.
The Definition of Donecreates transparency by providing everyone with a shared understanding of what work has been completed as part of the Increment.
If an item does not meet the Definition of Done, it cannot be released or even submitted during the Sprint Review-it goes back into the Product Backlog.
Example of Definition of Done:
The processing of a feature that makes a user story is not finished unless it meets the PO: The Definition of Done is agreed by the Team with the Product Ownerat the beginning of the process.
A possible definition of Done:
i. Coding of the required feature: completed
ii. Unit testing: written and performed
iii. Integration testing: passed
iv. Performance test: passed
v. Documentation (minimal): written
vi. Approved: by OP
# Types of Product Owner.
- Backlog administrator
- Domain expert
- Business analyst
- Twin of the product manager
Every organization is different.
The Product Owner does not work in isolation, but in the team.
The iron triangle consists of scope, cost, and time, which make quality.
- The _scope_ is the set of functions required of the product (in the form of requirements or code)
- The goal of the Product Owner and team is to build the product while staying within the constraints of budget, money, and time
The revised Iron Triangle instead of scope has people.
- The cost of the product is a function of the total effort spent by the people involved in production
- Cost = People x Time
- The Product Owner's goal is to get the best solution that one can afford to build with the available budget
# The Product Owner in Essence
In this figure:
- Where is the customer?
- Where is the product owner?
- Where is Scrum?
- Where is the backlog?
- Where is the product?
# The product backlog.
Lesson Objectives:
- What are product requirements?
- Analysis and classification of the elements of the product backlog
- “grooming” of the product backlog
- Estimates: poker
- Game: product owner value game
- Essence Cards
How a digital product is born:
1. Market research: the first phase involves a series of market research to understand the needs, market trends, competition, opportunities and challenges in the industry.
2. Product ideation: based on the information gathered in the market research phase, we begin to ideate the digital product, defining its main features, target audience and the unique value it can offer: we crive the “Product Vision” document
3. Product specification: the product specification phase involves defining a detailed plan that specifies the product's functionality, user interface design, and user experience: these are the** _requirements_** of the product.
# Communication and stakeholders
- Defining the requirements of a digital product is a communication issue
- Those who want the new product must communicate with those who will build it
- If one side prevails over the other, the project will fail
    - Those who want the productwill have budget and time constraints, and will demand functionality regardless of the developers' limitations
    - Developers use technical language that is difficult for stakeholders to understand, and if they do not listen they will miss the opportunity to learn what is needed
# Requirements
- When someone asks someone else to create a software product it is necessary to establish the _requirements_ of what will be built
- Requirements will be the basis for design, coding, testing/verification, and validation
Evolution of the backlog:
There is no standard form of backlog representation (e.g., some use Excel, others post-it notes on the wall).
The MOSCOW method of prioritizing User Stories.
MOSCOW : acronym for Must/Should/Could/Won't.
(MUST/SHOULD/COULD/WOULD NOT).
- Must: functions that SHOULD be in the product
- Should: functions that SHOULD be there
- Could: functions that COULD be there
- Wont: functions that WON'T be in the current version
# User Story of a to-do app
- As a user, I want to add new tasks to my list of
    to-do list so that I can keep track of what I need to do.
- As a user, I want to mark a task as
    completed, so that I can keep track of the tasks I have completed.
- As a user, I would like to organize tasks into different lists, so
    so that I can better manage the different areas of my life.
- As a user, I would like to be able to set deadlines for tasks, so
    so that I can be notified when I need to complete them.
- As a user, I would like to share a to-do list with
    other people, so that I can collaborate on shared tasks.
- As a user, I would like to play games within the app.
MUST HAVE:
1. As a user, I want to add new tasks to my list of things
    to do, so that I can keep track of what I need to do.
2. As a user, I want to mark a task as completed, so that I can
    so that I can keep track of the tasks I have completed.
SHOULD HAVE:
3. As a user, I would like to organize tasks into different lists, so that I can
    be able to better manage the different areas of my life.
4. As a user, I would like to be able to set deadlines for tasks, so
    I can be notified when I need to complete them.
COULD HAVE:
5. As a user, I would like to share a to-do list with other
    people, so as to collaborate on shared tasks.
WON'T HAVE:
6. As a user, I would like to play games within the app.
# User story “completed”
As <user_type>
I want to be able to <do something>
Why/why <get value>.
- Additional criteria (e.g., user must fill in all form fields)
- DoD: final validation (e.g. passed all unit tests).
# Update the backlog.
- The backlog first contains the User Stories, i.e., the future of the product.
- Updating the backlog involves modifying it to reflect new information and needs that emerge over time.
- This might involve adding new User Stories or changing priorities based on new needs 
- Thus, updating the backlog is an ongoing practice during development
Updating the backlog:
The simplest division of the backlog is between activities:
- To Do (the backlog)
- Ongoing
- Done
# Estimates
- During sprint planning it is necessary to estimate the effort needed for users' stories
- Planning poker technique: team members make independent estimates over several rounds; at each round the estimate can be changed based on the results of the previous round, seeking consensus (Delphi method).
A deck for planning poker.
Example:
- User story: “someone wants to manage purchase orders using an electronic shopping cart.”
- Development team with 7 members
- First round of estimates (value history points):
- P3 and P6 participants explain their estimates
- Second round:
- All estimates converge except the third one:
    - Other round, or
    - Use 3 or 5 as estimates
# Backlog grooming
- _grooming_ involves reviewing and reorganizing the backlog to maintain the order and priority of activities to reflect stakeholder needs.
- This may include eliminating obsolete tasks, breaking down complex tasks into smaller ones, and estimating the time and resources needed for each task.
- Grooming is performed at regular intervals (at each sprint start) to keep the backlog organized and manageable
# Game: Product Owner value game
- Product Owner value game is a game that simulates the choices a PO must make.
- See the game's website
# How to write user stories
Lesson Objectives:
- Working with user stories
    - User stories are fragments of conversations
    - The additional conditions
    - The specification of tests
    - Definition of Ready, Definition of Done
- INVEST Principles
- MoSCoW method for prioritizing user stories
- User story mapping
- Checklist Essence cards
Product Ownerdevelops the product backlog and uses it to collaborate with the team
When.
The Product Ownerdevelops the backlog, with the help of the Devs:
- At the beginning of development
- During development:
    - During sprint planning
    - During sprint review (demo)
# What the user stories are for.
- The Product Owner writes stories in the backlog and collaborates with the team, to share their understanding and acceptance criteria
- A story is “Ready” if it is small enough to be implemented in one or two weeks
- The Product Ownerconcords with the team the “Definition of Done,” i.e., the criteria for acceptance of a “well” worked story
- The development team chooses the stories to be made, defines the tests, and prepares everything necessary for the PO to accept the resulting software as required by the Definition of Done
# How User Stories are created.
- User Stories are natural language descriptions of the “ _Functional Requirements_ ” of a software product or system
- User Stories are simple, non-definitive, and the result of a multi-step dialogue between those who know the requirement and those who know how to solve it with a software product
- User Stories must refer to specific functional needs and not general statements (e.g., “ I want a product that solves my money problems ” is not good)
- User Stories can be collected or created through dedicated workshops, questioning users and other stakeholders. 
User Stories are fragments of conversations
- User: how can I describe my needs/desires?
- Stakeholder: how can I make the product successful?
- PM: how do I track and plan this task?
- BA: what are the details of this feature?
- UX: what are the user's needs?
- Developer: what tasks do I need to perform today?
- QA: how do I validate this completed task?
# Level of detail of User Stories.
- Stories with too general a level tend to lose meaning and usefulness.
- Stories with too much “implied” content need unpacking and can generate work that requires more “Sprint”.
Attribution of stories to a virtual user:
If many stories relate to a single user profile, it may be useful to use a “ _person_ ‘, i.e., a simulacrum of a virtual user (a kind of ’avatar”) to help in the creation of User Stories.
Example: in a municipal register management app, analyze the people Mayor, alderman, manager, employee, citizen.
Additional conditions to a User Story:
Each story should be accompanied by a description of additional conditions and how they will be considered fulfilled.
Example with additional conditions:
_As a library user I want to consult the catalog to borrow a volume_.
Add details about the conditions under which the User Story will take place:
- Consider whether the desired volume is already on loan
- Consider whether the subscriber already has too many volumes on loan
- Consider whether the desired volume is ordered but has not arrived
- Consider whether the desired volume should be purchased
Why the additional conditions are needed:
- User Stories are very simple, often many more details are needed
- How can a user story be tested?
- How to manage the tracking (i.e., translation) of user stories in source code and testing?
# INVEST principles.
User stories should be:
- Independent
- Negotiable
- Valuable
- Estimable
- Small
- Testable
I: Independent
- Stories must be independent or only minimally interdependent.
N: Negotiable
- Stories are always editable
- Editing them implies an assumption of responsibility on the part of the user
- The amount of work required for editing is taken away from the development of other stories
V: Value
- Stories must have real value to the User, the Developer, or both
- It is usually convenient to include non-functional aspects
E: Estimates
- Stories must allow estimation of the work (cost) required to complete them in code
- The estimate is needed by the Team to understand the _effort_ needed and by the Product Ownerto assess its appropriateness and priority
- Usually the most difficult and expensive User Stories should be done first
- Difficulty in making an estimate may be an indication of too high a level of story or inability of the team
S: Succinct (short)
- Short stories are of immediate accomplishment in a single sprint: they are therefore preferred
- A story that cannot be summarized in succinct form is not necessarily bad, but one should limit the number of stories and submit them for review for simplification when possible
- Complex stories are called “Epics”
T: Testable
- Each story should be accompanied with a set of binary (ok-nok) validation criteria
- The test criteria are necessary for the Definition of “Done” ( _Definition-of-Done_ ), which concludes the development cycle related to the individual story or stories in a sprint
# User stories “completed”
As <user_type>
I want to be able to <do something>
Why/why <get value>.
- Additional criteria (e.g., user must fill in all form fields)
- DoD: final validation (e.g., passed all unit tests).
# The MoSCoW method.
The MoSCoW method is a user story analysis technique for choosing the most important product features (i.e., prioritizing them).
MoSCoW stands for Must Have, Should Have, Could Have, and Won't Have.
- **Must Have** (must have): these are the user stories that represent the functionality
    essential and non-negotiable features of the product. Without these features, the product
    cannot be considered satisfactory to users.
- **Should Have** (should have): these are the user stories that represent the
    important but non-essential functionalities of the product. They are important, but
    can be deferred to a later version of the product if necessary.
- **Could Have** (could have): these are the user stories that represent the
    desirable but nonessential features of the product. These are features
    that could improve the user experience but are not essential to the
    product.
- **Won' t  Have** (must not have): these are the user stories that represent the
    features that are not required and can be considered for a
    future version of the product or discarded permanently.
# Story mapping
Before starting with the mapping, it is necessary to identify who is the target person or **typology of user**.
The map consists of two axes:
- **horizontal axis**: this dimension represents the “workflow,” that is, the user's interaction with our product.
- **vertical axis**: here the activities (but also the software components, if necessary) are mapped with the corresponding workflow step. Each activity, corresponds to a user story in our product backlog.
- In addition to expressing the activities, the vertical axis also reflects what are the priorities
- You can delineate with **horizontal lines** each release or increment, so as to give visibility into “when” certain features will be made available
- Each participant can suggest actions to be included in the workflow, and the Product Owner can later reorder those actions by business value and assign them to certain releases
- The Story Mapping event should involve a diverse group of people. In addition to developers, who have technical expertise, it would be useful to include people who are experts in the product domain
- A useful tool for story mapping is Miro
# Game: User Story mapping
- Your alarm clock goes off at 8 a.m., you must be out within 30 minutes
- Write down at least 30 different actions you take to get ready and go out
- Put a time label on each action
- When finished, group them by theme
You can use a specialized User Story mapping product.
Examples:
- Turn off the alarm clock 8.00.01
- Get out of bed 8.00.05
- Get in the shower 8.00.30
- ...
Subsequent shifts:
- 2 shift: you only have 15 minutes
- 3 shift: you have only 10 minutes
- Shift 4: you only have 5 minutes
# It's not easy to write user stories
- We often partition a product backlog _horizontally,_ layering the functional architecture to be built
- Developers prefer to work this way for efficiency reasons: the lower layers are designed to be reused by the upper layers
- However, if you work this way, it is more difficult to write user stories from the users' point of view
# “Vertical” user stories:
- They allow individual features to be packaged and delivered quickly
- Continuous feedback from the customer
Advantages of vertical stories:
- **Ambiguity** Disambiguation of vague terms can help articulate stories.
- **Conjunctions** A feature described by a conjunction can easily be decomposed
- **Acceptance** Acceptance testing can prompt slicing up a story so it can be more easily tested
- **Segmentation** A complex task is broken into several simple steps
# Use cases and scenarios.
Define requirements.
In order to have a clear and shared vision among all stakeholders about what needs to be created, it is important to define therequirements of a digital product.
The main techniques for gathering new requirements are:
- User interviews: to understand needs and expectations with respect to an existing or new digital product.
- Competitor analysis: the analysis of the features of similar digital products on the marketto identifyimportant features to include in your own product.
- Requirements analysis: studying the needs of users, the context of the product, and the functionality useful to meet those needs.
- Brainstorming: idea generation by the team through brainstorming sessions
- Prototyping: creating prototypes of thedigital product to test functionality and gather feedback from users.
# Forms of requirements documents.
1. Requirements specification document: the traditional form of requirements specification,
    in which a structured document is created according to the standard. This
    document, called a Software Requirement Specification (SRS) includes the
    description of the product, its objectives, description of the required functionality,
    non-functional requirements and test conditions.
2. User Stories: User stories are an agile form of requirements specification. A
    user story is a concise description of a software feature, written from the
    user's point of view. It may include some conditions of acceptance
3. Use cases: a combination of graphics+text that describes how the requested software
    interacts with the user and other systems. They integrate well with user stories
4. Prototypes and Mockups: Prototypes and mockups are digital tools that help
    visually describe software functionality. A prototype is a
    simple product that provides an idea of how it will work, while a mockup
    is a drawing that proposes a mock interface of the functions that will be
    implemented.
Lesson Objectives:
- What are use cases? What are scenarios?
- How do they integrate with user stories?
- The graphics of use cases
- The text of a use case: the scenario
- Examples
- Essence charts of use cases

# Modeling use cases (Use Case).
- Proposed by Ivar Jacobson in 1992
- Researching use cases ( _use cases_ ) is the study of the operational scenarios of users of a product
- Scenarios are the “ways” in which the product can be used--that is, they define the operations or functions that the product makes available to its users
User story VS. use case
**User story**: Defines the who, what and why of a product function. Short and simple description, often incomplete. Encourages conversation and creativity.
**Use case**: Defines who wants what from the product-in some context, called a scenario. Complete and concrete detailed description.
Use case: graphical representation: A use case is represented graphically with an actor using a function of the system.
Association between actor and use case: A use case is represented with an actor using a function of the system. We will say that the actor “is associated” with that particular use case.
Use cases represent functionality required of a system.
A use case can have multiple actors.
# The scenario of interactions.
Use case graphics are very basic, poor in detail.
A use case is detailed in the form of an **interaction scenario** - that is, a dialogue - between a user and the system.
**Example**:
- citizen requests list of services
    - the system responds with list of available services
- the citizen chooses from the list the service he/she wants
    - the system responds with the total cost of the selected service
- the citizen accepts and confirms the service request
    - the system notifies the administration of the request
The “narrative” of the dialogue focuses on the interaction, not on the internal activities of the system.
# Actor
- **Role** that someone or something plays with respect to the system.
- Actors are external to the system
- Actors perform use cases
    - Actors are sought first, then their use cases
- Actors “get value” from or participate in the use case
- Actors may NOT be people (ex: other systems, hardware devices)!
An actor can be another system.
How to find actors:
- Who or what is interested in the system?
- Who or what will modify data in the system?
- Who or what wants information from the system?
- Who or what will interface with the system?
Finding actors: useful questions
- Who is interested in this requirement?
- Who will use this feature?
- Which actors are related to the Use Cases?
- Does an actor have multiple roles? Is the same role assigned to multiple actors?
- Where in the organization is the system used?
- Who will provide, use, and remove information from the system?
- Who will support and maintain the system?
- Will the system use an external resource?
# What does a use case represent?
A use case is a description of how a person actually using that system will achieve a goal.
Use Case:
- Represents a **functional requirement**
- Explains what is expected of a system (“what?”)
- Conceals the behavior of the system (“how?”)
- Is a sequence of **actions** (with variations) that produce a result observable by an **actor**.
It is used to:
- Describe user requirements (initial analysis)
- Check whether the system is working well (testing)
- Each sequence of actions of an actor on the system (a sequence called a scenario) represents the interaction of an entity external to the system ( actor ) with the system itself or its
components
- The use case has a _main flow_ and zero or more _alternative (optional or anomalous)_ variants .
# Scenario description.
- This is a generic and sequential description of the flow of events of a use case.
- Describe the precondition (initial state of the system)
- List the sequence of steps
- Include interactions with actors and describe which entities are exchanged
- Description must be clear, precise, and brief
Search for use cases:
Useful questions:
- What are the tasks of this actor?
- Will the actor manage information in the system?
- What Use Cases will create, modify, read this information?
- Does the actor need to inform the system of sudden changes?
- Does the actor need to be informed of certain situations?
- Does the system support the business with correct behavior?
- What Use Cases support and maintain the system?
- Are all functional requirements covered by the Use Cases we found?

# Sources of information for the Use Cases.
- System specification documents
- System domain bibliography
- Interviews with domain experts
- Personal knowledge of the domain
- Existing similar systems
Use case documentation:
- Use cases are documented by
    - A brief description
       - The purpose of the use cases in a few lines
    - Detailed flow of events
       - A description of the primary and alternative event flows that follow the start-up of the use case
    - Use case documentation reports the dialogue between the actor and the system
- All documents are written in a way that is understandable to the client (who validates them)

# Flow of events.
Each use case:
- Has a main sequence of actions
- Can have some optional alternative sequences
- Has some special action sequences for handling erroneous or abnormal situations
A use case has a base scenario plus some alternative scenarios.
**Basic scenario**: is the one that involves the _success_ of the use case, and a linear unfolding.
**Alternative scenarios**: can be success or failure, with various complications.
- it is not necessary (and would be very expensive) to analyze in detail all the possible scenarios of a use case.
- instead, it is necessary to identify the individual possible variants that may lead to failure of the use case, or that involve special treatments.
- Describes only the events related to the use case.
- Avoid the use of vague terms such as “for example,”“ etc.” or “information.”
- The flow of events should describe
    - How and when the use case begins and ends
    - When the use case interacts with actors
    - What information is exchanged between an actor and the use case
          - The details of the user interface are left out.
    - The basic flow of events
    - Any alternative flow of events

# How to write a use case
- Assign a name to the use case
- Describe the primary actor and any companions
- Describe the initial condition of the system
- Describe the main flow of events
- Describe the output condition
- Describe possible anomalies and exceptions
- Describe the quality requirements (non-functional)
Example: current account opening
1 customer comes to the bank to open a new checking account
2 the officer receives the customer and provides explanations
3 if the customer accepts, he provides his data
4 the clerk verifies whether the customer is registered in the registry
5 the clerk creates the new current account
6 the clerk reports the account number to the customer
Variants:
3 (a) if the customer does not accept the use case ends
3 (b) if the account is to be in the name of more than one person, the details of all of them must be provided
4 (a) if the customer (or one of several account holders) is not accounted for the clerk shall register the customer, request the customer to sign the specimen, and store it via scanner
(5) the clerk creates the new checking account.
1 the clerk requests the new account entry transaction from the system
2 the system requests the codes of the account holders
3 the clerk provides the codes to the system
4 the system provides the corresponding master codes, and requests the conditions to be applied to the account
5 the clerk specifies the conditions and requests the insertion
6 the system prints the contract with the number assigned to the account
Variants:
3 (a) if the system does not recognize the customer, or if it provides an unexpected master data,
the clerk can make corrections or terminate the entry
# “Business” and “service” actors.
In defining actors, two different views can be taken that correspond to different levels of abstraction:
- one independent of particular organizational and technological solutions ("business ” scope model)
- one dependent on a particular organizational and technological solution (the “information services” scope model)
# Special relationships
- One use case “includes” another use case
- One use case “extends” another use case
- One actor specializes another actor
Include a use case:
- A use case “includes” the behavior of another use case
- (similar to “procedure call”)
- Note the direction of the arrow: “Deposit” and “Withdrawal” include “Identify”

Extend a use case:
- A use case “extends” the behavior of another use case
- (similar to “optional function”)
- Note the direction of the arrow: “Log error” extends “Identify”