# The retrospective in Scrum with Essence.
Agenda:
- The retrospective of agile teams
- Essence: a language for processes and practices
- Using Essence for retrospectives.
## Putting a software development process in place.
When multiple people collaborate, it is necessary to follow a discipline of collaboration, which we call a “development process model” (some call them “methods,” others “methodologies”).
Development process models are sets of roles, artifacts and “good” practices.
Agile models are designed for small teams (3-7 people).
Please note: When there is a large software system to be built, they need to be “scaled” i.e., adapted to coordinate larger teams or many more programmers.
## Goal: consolidate the competence of teams.
Frequent reason for failure of agile projects:
Lack of sufficient competence in applying basic techniques of the agile vision.
Competence:
- Learning a new practice
- Guidance in learning the practice
- Adoption of the practice
- Modifying the practice
The double cycle of the agile team involves learning and developing.
- Agile values: transparency, adaptation.
- Scrum values: team self-organization, cross-functional team, continuous process improvement.
# Development process and retrospective
A development process governs:
- Who should do What.
- When to do it
- How to achieve a particular goal
A retrospective is a periodic team meeting that reviews how the process is going; it is one of the most common agile practices.
The retrospective is one of the events in the Scrum model.
Scrum consists of objects (Product Backlog, Sprint Backlog, Increment), events (Backlog Refinement, Sprint Planning, Daily Scrum, Sprint Review, Retrospective) and roles (Product Owner, Scrum Master, Team).
When is the retrospective done? At the end of each sprint.
# What is a retrospective.
12 Agile principle: At regular intervals, the team reflects on how to become more efficient, then reviews and modifies its behavior accordingly.
The retrospective is a team meeting where the outcome of the sprint is analyzed from a process perspective.
It is held as the last act of the sprint.
The ScrumMaster _facilitates_ the retrospective, as SM is the _processowner_ and must help team colleagues review what went right and what went wrong during the last sprint.
Questions to all:
- What went well? What did you like?
- What went wrong? What did you NOT like?
- What do we need to do differently?
- What worked well?
- How do we improve?
- What do we improve?
- Team Promises.
The Starfish Retrospective divides the comments into five categories:
- Stop: something that is not bringing value, or is a roadblock.
- Less: something already being done that could be reduced.
- Keep: something the team is doing well and should be acknowledged.
- More: something already being done that could bring more value if done even more.
- Start: a new idea, or something that could help improve.
# Objectives of the retrospective.
1. Identify constraints and waste in the sprint process (by analyzing available data).
2. Identify what works or does not work.
3. Foster conversation among team members.
4. Get ideas for improvement.
5. Draft an action plan for implementing collected solutions.
Model a retrospective:
- Input: Product (backlog + release), old recommendations, process data (burndown + logger)
- Sprint retrospective
- Output: new recommendations for the next sprint
# Roles involved.
The **Product Owner**:
1. Summarizes his or her assessments of the results obtained.
2. Requests suggestions from the team to improve performance.
3. Offers support to solve organizational problems.
The **ScrumMaster (process owner)**:
1. Organizes and moderates the meeting.
2. Identifies the main issues to be addressed.
3. Recalls the results of previous sprints.
4. Keeps track of proposals that emerge from the discussion.
The **Development Team**:
1. Proposes ideas/solutions
2. Prioritizes the ideas / solutions to be implemented.
3. Agrees on how to implement the most important proposals.
4. Identifies tasks for implementing selected proposals.
# Structured conversations
The team chooses practices to be used during development.
Then practice by practice is analyzed and evaluated by individuals (red=bad, green=good).
Chosen practices can be changed from sprint to sprint (but better not to change them _during_ the sprint).
Essence can help the team form an opinion (see next slides).
**Example of First Retrospective**
Too little time spent on helping and managing work distribution by the Scrum Master.
Devshave spent too little time developing the chosen features.
Shallow planning of work during Sprint Planning.
Daily Scrum done without consistency.
Sprint Goal defined at beginning of sprint unclear.
Poor communication during work.
**Example of Last Retrospective**.
Increased time spent on this phase (from less than an hour to more than 3 hours).
General improvement in grades awarded.
Previous retrospective discussions resulted in a tangible improvement in the team's collaborative spirit.
Improvement in the management of the retrospective phase.
Self-criticism of a DEV.
# Retrospectives: use of Essence.
To help the Scrum Master (SM) we will use Essence.
Essence is a (meta)language for describing development methods and practices.
Technical description:
- Focuses on the essentials
- Components:
    - The Essence Language
    - The Essence Kernel
    - Essentialized practices (egTDD)
    - Method (egScrum): combination of practices
Purpose:
- Serves to reflect on process
- Creates opportunities for conversation
- Set of “serious” games related to software development
Kernel + Language = Essence
Essentialized methods use essentialized practices which use the Essence kernel which uses the Essence language.
# The focus of Essence
- Essencesi focuses on the essentials of development, i.e., good practices.
- It supports self-training through poker-sized cards that allow the team to play “serious games.”
- Practices are made independent of the method in which they are defined.
- Teams can build their own method by composing their preferred practices.
Methods are compositions of practices.
# The basic elements of Essence and their relationships.
Example of essentializing a minimal process:
This diagram shows an “essentialized” process.
The relationship between the two alpha Requirements and Software System is described by the activity of writing code ( _Write Code_ ), which produces the artifact Code ( _Code_ ), and which requires two skills: Development and Testing.
Example of essentializing user story writing:
Another “essentialized” process. Requirements become User Stories, which are analyzed (“Understand the requirements” activity) and prepared for System testing (“accept a user story”). The “splitting user story” pattern is also mentioned.
# The basic elements of Scrum.
The basic elements of Scrum are Product Owner, Product Backlog, Scrum Master, Sprint Planning, Sprint Backlog, Scrum Team, Sprint, Daily Standup, Sprint Retrospective, Sprint Review, and Potentially Shippable Increment.
The essentialized Scrum elements are:
- Product Owner: pattern
- Product Backlog: work product
- Scrum Master: pattern
- Sprint Planning: activity
- Sprint Backlog: work product
- Scrum team: pattern
- Product Backlog item: alpha
- Sprint: alpha
- Daily Scrum: activity
- Sprint Review: activity
- Sprint retrospective: activity
- Increment: work product
A description of Scrum with Essence:
The alpha Work is described by the Product Backlog and includes the alpha Sprint.
The alpha Requirement includes the alpha Product Backlog item.
The alpha Software System evolution is described by the work product Increment.
The alpha Sprint is described by the Sprint Backlog.
The work product Product Backlog is prioritized by the work product Sprint Backlog and lists the alpha Product Backlog Item.
The work product Sprint Backlog tags the alpha Product Backlog Item.
The alpha Product Backlog Item is delivered by the work product Increment.
The Sprint Planning and Daily scrum activities are part of the activity space Coordinate Activity.
The Sprint Review activity is part of the Track Progress activity space.
The Sprint Retrospective activity is part of the Support the Team activity space.
# Agile practices.
Product backlog
Agile development
Agile timeboxing
Product Ownership
Agile retrospective
Agile teaming
Daily stand-up
# Scrum Cards.
Cards can be divided into Practices (things to do, activity) and Artifacts (things to work with, alpha and work product).
# Essence card: retrospective
Retrospective is a meeting that is an opportunity for the team to inspect itself and create a plan for improvements to be executed in the next sprint.
Retrospective is a time-boxed meeting of up to 3 hours if the sprint lasts a month.
The retrospective is shorter if the sprints are shorter.
The Activity Sprint Retrospective paper is structured as follows:
- Title: Sprint Retrospective
- Description: An opportunity for the Scrum Team to inspect itseld and create a plan for Improvements to be enacted in the next Sprint. A time-boxed event of no more than 3 hours for a one-month Sprint (shorter for shorter Sprints).
- Activity Space: Support the Team
- Competencies required: Leadership level 3, Management level 2, and all other competencies.
- Output: Improvement Alpha state moves to ready or beyond.
Essence Cards: activities of a Retrospective.
Other cards related to Retrospective practice are:
- Hold a Retrospective (activity)
- Mad, Sad, Glad (pattern)
- Improvement (alpha) whose states are: identified, prioritized, action agreed, trialed, results evaluated, in use.
# Retrospective Game: Progress Poker.
Depending on the phase, some alpha cards and their status cards are chosen and the team tries to decide “what has been done.”
Each team member gives an evaluation and explains his or her opinions when the evaluation differs from that of teammates.
Each team member must reflect and explain why they evaluated the state in that way.
**Examples - Scenario 1 Bad Team**
Badteam had a difficult life. The people in the group have split into two subgroups who rarely talk to each other.
“Leader” took a position of power, and did all the setup work of the project alone, while the second group just wrote about ten userstories, without asking anything from the others; with no estimation of any kind so it is not given to have estimates of delivery or result.
The Scrumble game was rushed, it was “lost,” and the group got into a bit of a fight.
The development system has been sketched out, in the sense that taiga is active, but there are no documents.
**Average team**
Averageteam has essentially done its homework. “Leader” was elected as coordinator, and was able to take back some members of the group who tended to ‘slip up’; two subteams were created, one of more web compentencies and one of more classical compentencies (Java). A
carried out a multihanded test project using git.
The development system has been prepared, with Taiga online, Gitlab, and mattermost; communications are quite frequent.
The Scrumble game was lost, but it was useful, according to the participants.
The backlog consists of about ten items that follow the classic pattern, and some of them, the most important ones, were estimated using a Planning Poker under the directive of “Analyst” who proved to be the most attentive to capture the domain issues.
**Dream team**
For Dream Team everything is going swimmingly. Under Leader's “enlightened dictatorship,” the development system has been developed in its entirety, even identifying the technology to be used.
The Scrumble match has been revealing, and has helped identify the best people for the particular roles.
The team did a collegial analysis and created two Epics and a dozen user stories, working online via meet, mattermoste slack. An initial version of these were submitted to stakeholders, who provided interesting feedback, and provoked modification from a couple of stories. As a result, all of the first 8 stories are estimated and prioritized.
Two products have been produced on gitlabs so far: a program that collects all tweets related to a #tag, and a Java program to test the user interface of a subsection of the program.
#Background games
**Background game: we define the state of the alphas**.
The initial positions of the states of all the alphas are prepared.
You discuss and advance the states of the alphas if all items on the next state checklist have been met.
This is continued for all alphas until the current state of all alphas is found.
**Background game: good mad sad**.
You create a table divided into three columns (happy face, indifferent face and unhappy face) and three rows (very important, medium important, unimportant).
You place the various Essence cards in the grid according to how they did during the last iteration. Then you add post-its with comments on how to improve them.
**Background games with Essence**
- Progress Poker- Use this game to determine the state of any particular Alpha
- Chase the State- Use this game to determine the state of your software development efforts.
- Objective Go- Use this game to identify high-level goals and objectives for your team.
- Checkpoint Construction- Use this game to define practice independent check points with automatically generated practice independent checklists. 
- Lifecycle Layout- Use this game to visualize your software development lifecycle to form a starting point for team planning.
- Milestone Mapping-Use this game to visualize your milestones and form light-weight roadmap for your software development.
- Health Monitoring-Use this game to visually track the health of your endeavor regardless of the practices or method being used.
# Agile at a Scale in Essence: practices for multiple teams.
Practices that can be used to scale Agile:
- Product Management
- Shared Backlog
- Agile Architecture
- Adaptive Funding
- Release Management
- Development Support
- DevOps
- Agile Governance
- Team-of-teams
- Periodic Alignment