# La produzione del software
Obiettivi di questa lezione:
- Fare software
- La nozione di prodotto software
- Varietà di tipi di prodotti software
- L'industria del software
- Lo sviluppo del software
Discussione
- Cos'è il software?
- Chi crea il software?
- Cos'è un prodotto sw? Cos'è un servizio sw?
- Esistono tipi diversi di software?
# Alan Turing - sugli ingegneri del software
In linea di massima, coloro che lavorano in connessione con il Motore di Calcolo Automatico
Automatico si divideranno in padroni e servitori. I padroni
I suoi padroni pianificheranno le tabelle di istruzioni per il motore, pensando a modi sempre più
sempre più profondi modi di usarlo. I suoi servitori lo alimenteranno con le carte quando le richiederà.
le richiede. Sistemeranno le parti che si guastano... Con il tempo la calcolatrice stessa assumerà le funzioni
Con il passare del tempo il calcolatore stesso assumerà le funzioni sia di padrone che di servitore...
I maestri sono suscettibili di essere sostituiti, perché non appena una qualsiasi tecnica diventa
tecnica diventa stereotipata, diventa possibile ideare un sistema di tabelle di istruzioni che
sistema di tabelle di istruzioni che permetterà al computer elettronico di
di farlo da solo.
Tuttavia, può accadere che i maestri si rifiutino di farlo. Potrebbero
non sono disposti a farsi rubare il lavoro in questo modo. In tal caso
in questo caso circonderebbero di mistero l'intero lavoro...
(da una sua conferenza del 1947)
# Steve Jobs - sul software
“Il problema è che nell'hardware
non si può costruire un computer
che sia due volte più buono di quello
di chiunque altro. Troppe persone
persone sanno come farlo.
Sei fortunato se riesci a farne uno
che sia una volta e un terzo
migliore o una volta e mezza
migliore. E poi passano solo sei
mesi prima che tutti gli altri
si mettano al passo. Ma si può fare
nel software”. (1994)
I tipi di software si dividono in prodotti software e servizi software.
# (nuove?) categorie di software:
- Applicazioni ed ecosistemi software
- Servizi software
- Nuovi strumenti di sviluppo
- Software sociale
- Scraping/analisi dei big data
- Software incorporato, IoT
- ...
# Ecosistemi software
- Gli ecosistemi software sono mercati, in cui si
    vendono prodotti (es. AppStore o PlayStore) o
    componenti e servizi (es. Amazon Elastic Computing)
- La caratteristica principale è quella di una collezione
    di prodotti software, su piattaforma definita da
    un'azienda, che vengono sviluppati ed evolvono nello
    stesso ambiente
- Es. Appstore (al 2016): 100 miliardi di download, utili
    oltre 40miliardi di dollari; 20 “grandi” sviluppatori incassano il
    50% degli utili.
# Software come servizio
Google: 2 miliardi di linee
di codice
25.000 sviluppatori
45.000 commit al giorno
Chrome: 17,4 milioni di
linee di codice
3.700 sviluppatori
380 impegni al giorno
# Software embedded (“nascosto”)
Il software si trova negli smartphone, nelle macchine, ecc.
# Software sociale (Web 2.0)
- Software che supporta la “conversazione” di
comunità di utenti. Es. Facebook, X (Twitter),
LinkedIn, Instagram, Pinterest, T2, ecc.
- Wiki, chat, forum, blog, ecc.
# Software libero (non gratis!)
0. Un programma può essere eseguito per qualsiasi
    scopo
1. Un programma può essere studiato e
    cambiare per adattarlo a nuove esigenze
2. Un programma può essere distribuito liberamente
3. Un programma può essere migliorato liberamente
    e questi miglioramenti possono essere
    distribuiti liberamente
# Interfaccia di programmazione delle applicazioni (API)
- Amazon API: commercio sw driven
- PhilipsHue API: sw per l'illuminazione
- API di Facebook: sw di social network
- API di GoogleMaps: mappe guidate da sw
- Stanford API
- API CNN
- Walmart API
# Aspetti economici dei prodotti sw
- Ambito d'uso (dimensione in righe)
- Piano di sviluppo (durata)
- Sforzo di sviluppo (costo)
- Produttività del team
- Qualità (difetti)
# Videogiochi
- Sforzo tipico: 100÷500 anni/persona
- Team: di solito 50 ÷ 100 persone
(Assassin Creeds 2009: 450 persone)
- Vendere un milione di copie è ok ma non eccellente
# I sw sono sempre più grandi e costosi
Costerebbe più di 1 miliardo di dollari sviluppare REDHat 7.1 GNU/Linux
con mezzi proprietari convenzionali negli Stati Uniti (in dollari del 2000).
dollari americani).
Confrontate questo dato con i 600 milioni di dollari stimati per la versione 6.2 di Red Hat Linux.
6.2 (che era stata rilasciata circa un anno prima).
Red Hat Linux 7.1 include oltre 30 milioni di linee di codice sorgente fisico (SLOC), rispetto alla versione 6.2.
di codice fisico (SLOC), rispetto ai 17 milioni di SLOC della versione 6.2.
Utilizzando il modello di costo COCOMO, si stima che questo sistema abbia
di sviluppo ha richiesto circa 8.000 anni-persona (contro i 4.500 anni-persona della versione 6.2).
rispetto ai 4.500 anni-persona per lo sviluppo della versione 6.2).
Red Hat Linux 7.1 rappresenta un aumento di oltre il 60% in termini di dimensioni, impegno e costi di sviluppo tradizionali rispetto a Red Hat Linux 6.1.
costi di sviluppo tradizionale rispetto a Red Hat Linux 6.2. Ciò è dovuto a un
numero di programmi open source/liberi, maturi e in via di maturazione, disponibili in tutto il mondo (D.Wheeler).
programmi open source/liberi disponibili in tutto il mondo (D.Wheeler, 2002).
# Alcune cifre
Prodotti e SLOC (righe di codice sorgente):
- NASA Space Shuttle Flight Control 430K (shuttle) + 1,4M (terra)
- Sun Solaris 1998-2000 7-8M
- Microsoft Windows 3.1 (1992) 3M
- Microsoft Windows 95 14M
- Microsoft Windows 98 18M
- Microsoft Windows NT (1992) 4M
- Microsoft Windows NT5.0 (1998) 20M
- RedHatLinux 6.2 (2000) 17M
- macOS 10.4 (2005) 86M
- Linux kernel 4.2 (2016) 20.2M
- Debian 7.0 (2012) 119M
# Software
- **Invisible, intangible, easily
duplicable but very expensive: work
of ingenuity protected by laws
- **Component** of a computing system:
can be widely distributed ( off the shelf ) or
commissioned by a single developer
- **Abstract machine**; offers useful functions for
some purpose, has an 'architecture (made up of
components and connectors)
- **Service**; has an _interface_ and is based on an _infrastructure_. 
Sw is an industrial product.
Software is always the product of a process of
development, which begins with an idea and ends when the
software is withdrawn.
The world sw industry is growing at rates of 5 to 10 percent
annually.
The cost of developing a software product tends to
grow in proportion to the _square_ of its size.
# Products, systems, services
- Generic products (OTS: off the shelf)
    - Products created by a few software manufacturers and sold
       on the market to multiple (many) customers
    - Ex: video game
- Commissioned (“customized”) systems.
    - Systems commissioned by a specific customer and developed
       on purpose by some vendor
    - Ex: universityʼs portal
- Services in perpetual development
    - Systems that offer 24/7 services that are constantly changing
    - Ex: Facebook, Amazon
# Software requirements and features
- Software requirement: function or quality
controllable (testable) that must be possessed by
the implementation of a software product.
It is important to the customer
- Software feature: set of functions that
allow a software product to be used in
a service or product.
It is important to the supplier
Example:
- Feature: shopping cart for electronic store
- Requirements of an e-commerce service: user must be able to register, add or remove items to cart specify alternate addresses, pay
Dependencies:
- Each sw product depends on other sw products,
which in turn depend on other sw
- We associate each product or system
software a **dependencies graph**
- The nodes in the dependency graph are
software packages (e.g., libraries) in different
versions
**Software is a special product**.
- **It is invisible and intangible**
- **Each product has many dependencies**
- It is easily duplicated and distributed over a network
- In Europe it is not patentable (but protected)
- Consumer software is not guaranteed
- It is acquired under license
    - Proprietary (regular, shareware, freeware)
    - Public domain
    - Open source
Legal protection of sw
- **Author protection:** Software is a work
    of the intellect: the person who produces it is an author who is entitled to
    compensation
Copying software  illegally is **illegal** (even if you don't
    you do it for profit) and is a criminal offense in Italy:
Italian Law 248 / 2000 punishes with imprisonment from 6 months
    to 3 years who illegally duplicates software
- For information on the patentability of software in the
    USA.
Software licenses
# SIAE: the public sw registry
- Sw that meet requirements for
    of originality and creativity such that they can be
    identified as works of 'ingenuity.
- It is possible to register all acts that transfer in
    all or part of the rights of economic use
    relating to programs for which the
    registration
- To register a program, the applicant must
    transmit to SIAE a “declaration” and a
    “description” in addition, of course, to a copy
    of the program to be deposited recorded on a
    non-rewritable digital
# Decompiling a sw
- Can a software be decompiled?
- For example, can someone who bought it and has only the object code decompile it to correct a defect?
Software warranty.
**Buyer protection:**
What protection does the buyer have
from product defects?
In consumer software in theory
There is NO warranty.
The software is sold “as
as is,” and if there are defects the
manufacturer does not take responsibility for them:
it says so in the contract that you display
when you use for the first time
an application
Software warranties
- Verification guarantees adherence to a specification
- Validation guarantees acceptance by the customer
- Certification guarantees adherence to legally defined specifications
NB: commercial sw is usually sold without warranties (” _as is_ ”)
Risks:
- Software systems development risks
- Defects in operational software
- Operational risks of software systems
Operational risks
July 2015: **Fiat recalls 1.4 million Jeeps**
- New twist after the infamous case in which hackers had breached the
UConnetc multimedia system of a Jeep Cherokee: FCA, after having
immediately released a software update has decided to
recall 1.4 million cars to the workshop for a free inspection to permanently fix the in-vehicle computer system
- “All industries are potential targets for a hacker, and the
automotive industry has been no exception,” said Gualberto Ranieri,
head of communications FCA markets NAFTA going on to explain that “there has not
been a single incident in the real world involving any
FCA vehicle as a result of a hacked intrusion into its software.”
# Some qualities of the software
- **Robustness**: sw capable of withstanding errors during execution
- **Sustainability**: durable software capable of being modified economically
- **Reproducibility**: version control
Some data
Number of defects (faults) detected during operation
- Worst military systems: 55 faults/KLoC
- Best military systems: 5 faults/KLoC
- Products achieved with agile development (XP): 1.4 faults/KLoC
- Apache web server (open source): 0.5 faults/KLoC
- NASA space shuttle: 0.1 faults/KLoC
Self-test questions
- What is software? How many types of sw are there?
- Why is it expensive to produce?
- What are the risks of using software? What about those of development?
- What is a software defect?
- How much software can one person produce in a year? An organization? A nation?
# Software Engineering
Objectives of this lesson:
- What is software engineering?
- The software life cycle
- The software development process
- Myths and legends of sw production
From programming to development
Which is more difficult: writing software, or reading it (e.g., to modify it)?
How is software developed?
- Sw engineering (software engineering) is a
    _methodological discipline,_ that is, it studies the _methods_ of
    production, the _theories_ underlying the methods, and the
    _tools_ for developing and measuring the _quality_ of
    software systems
- It is also an  empirical _discipline_, i.e. based
on experience and the history of past projects
- NB: a THEORY of sw engineering is lacking.
- In Anglo-Saxon countries “ _software engineer_ ” is a recognized profession
- More than half of all US engineers are “sw engineers”
# Productivity
- Productivity is the ratio of the quantity of goods or services
    produced and the cost of labor required to produce them
       - Output/Input.
Example: I produce 1000 candies at a cost of 100 euros.
Productivity is: 10 candies for each euro spent
Developer Productivity
- Software development productivity is the ratio of
    software produced (measured in LoC: Lines of Code) and the
    cost of effort (effort, measured in days/person) to
    produce it. LoC/effort (example: 50 LoC per day/person)
Productivity in software
Measuring productivity: do it fast, do it right, do it on time, keep doing it.
Productivity in the sw industry is low
- From an analysis of 13,522 projects of
    sw construction:
       - 66% of all projects **fail** (do not
          have useful result)
       - 82% of projects exceed schedule
       - 48% of projects produce systems without
          the functions required by customers
       - 55 billion $ of waste considering only the
          US projects
# Why sw projects fail: the risks
What are the main risks of software developers?
- Lack of feedback from the customer/user
- Turnover of staff and especially the development team
- Realizing unsolicited features
- Delays in delivery
- Exceeding the project budget
- Realizing an unusable system
- Realize a system unable to work together with other existing systems
Staff turnover
Average lengths of employment (2017):
Facebook 2.02 years
Google 1.90 years
Oracle 1.89 years
Apple 1.85 years
Amazon 1.84 years
Twitter 1.83 years
Microsoft 1.81 years
AirBnb 1.64 years
Snap Inc. 1.62 years
Uber: 1.23 years
# Guiding principles of software development:
Develop iteratively
Control changes
Use component architectures
Manage requirements
Model graphically
Verify quality
# Develop iteratively
The software life cycle
- Requirements: analysis and specification
- Design: modeling the architecture and individual components
- Coding and debugging
- The testing and verification
- The deployment (= the implementation)
- Maintenance
Software costs:
- Because of the impact of risk, costs
    software often **dominate** the costs of
    production of a system; in particular, the
    sw costs are often greater than the costs
    of the underlying hardware
- It is more expensive to maintain software than to develop it : in the case of systems with a life
enduring, maintenance costs are a multiple of development costs (e.g., 3 times)
- Software engineering is concerned with producing software with “acceptable” costs
# Development Costs (Boehm cited by Schach).
Maintenance 67%
Integration
6%
Design
6%
Module
coding
5%
Module
testing
7%
Problem Def
3%
Requirements
4%
Planning
2 %
The cost of change
If we accept this graph, which shows that any change in the
sw is the more expensive the later
late it happens, then it is necessary to
make all decisions
important ones as early as possible
at the beginning or early stages of
development (ellowwaterfall model).
But is it really?
# Doing the right thing
Of all the features in an application sw:
- 7% is used continuously
- 13% is used often
- 16% is used occasionally
- 19% are used infrequently
- 45% is never used
Maintenance
- All products need maintenance due to change
- The main types of maintenance:
    - **Perfective or preventive** (65%): improving the product
    - **Adaptive** (18%): responding to environmental changes
    - **Corrective** (17%): correct errors found after the
       delivery
**The world is constantly changing maintenance is “normal ”**
# Attributes of software products.
- **External** attributes (visible to the user)
    - Cost (and type of license)
    - Performance
    - Warranty
- **Internal** attributes (visible to designers)
    - Size ( _size_ )
    - Production effort ( _effort_ )
    - Duration of production (from inception to delivery)
    - Maintainability
    - Modularity
       
# Software development standards.
IEEE main software engineering standards:
- IEEE 610 Standard glossary sw engineering
- IEEE 828 Sw configuration management
- IEEE 829 Sw test documentation
- IEEE 830 Recommended practice for sw requirements specifications
- IEEE 1008 Sw unit testing
- IEEE 1219 Sw maintenance
- IEEE 1471 Recommended practice for sw Architectural Descriptions
- IEEE 1517 Sw reuse processes
# Development activities
- Software development activities differ depending on the developing organization and the sw to be produced, but usually include:
- **Specification** of the required functionality (requirements).
- **Design** of the modular structure and interfaces.
- **Implementation**: module coding and integration.
- **Verification** and **validation**
- **Evolution** and maintenance
- In order to manage them, they must be explicitly modeled
GANTT diagram
The sw development process:
- **Software process**: set of roles, activities, and documents required to create a software system.
# Examples: roles activities documents
- Examples of roles: stakeholder, designer, developer, tester, maintainer, etc.
- Examples of activities: schedule, test, have a meeting, demo, document
- Document examples: source code, executable code, specification, comments, test results, etc.
# Essence: toward a theory of sw engineering.
Stakeholders (Stakeholders).
Types of stakeholders:
- Professional designers
- Management
- Technical staff
- Decision makers
- Users
- Funders
- ...
Each stakeholder corresponds to at least one specific point of view (view) and various decisions
# Myths and legends of sw engineering.
- The “silver bullet” is the silver bullet that kills werewolves
- “ _Finding a silver bullet_ ‘ is synonymous with ’finding a final solution” to a problem
- Building software is hard: what is the silver bullet of sw engineering?
Myths and legends:
- If the project delays, we can add programmers and meet delivery
- **Brooks' Law: “Adding staff to a delayed project delays it even more. ”**
- To begin writing a program, all that is needed is a generic idea of its goals--the details are thought of later
- **Mis-defined requirements specification is the biggest cause of project failures**
- If a project's requirements change, it is not a problem to take them into account because software is flexible
# Summary
- Producing software is expensive
- Productivity in the sw industry is low
- Deliveries are often late
- Software costs often go over budget
- Documentation is inadequate
- Software is often difficult to use
- Solution: improve the software process
Self-test questions:
- What are the typical stages in the life cycle of a software system? What about those of development?
- Which phase is usually the most expensive?
- At what stage of development is it most dangerous to make a mistake?
- At what stage of development is it easiest to correct an error?
- What is a software development process?
- What are the typical documents produced during a software process?
- What is Brooks' law?
# Process models for software development: planned (linear or iterative) models.
Objectives of this lesson:
- What is a software development process
- What is a software process model
- Linear models
- Iterative models
- Agile models
- Quality-oriented process models
- Open source models
The “natural” stages of software development
- Enthusiasm
- Disillusionment
- Panic
- Search for the culprit
- Punishment of the innocent
- Praise and honors to those who did not get involved
Not all developments unfold this way: in the ones that are
successful ones, the difference is always made by the people and
the rules (the development process) they follow
# Life cycle and development process
- The **development process** is a part of the software life cycle
- The **software lifecycle** (software lifecycle), designates the various stages of a software's life, from its conception to its retirement
- Usually the development process starts from conception and ends with the final release and subsequent deployment
The team includes multiple roles
- Team development is very different from “personal” development
- In the team, there are people with different experiences, who hold
    different **roles having different skills**:
       - How to design the software product (architects)
       - How to build the sw product (programmers)
       - What the sw product is for (domain experts)
       - How the user interface should be made (interface designers)
       - How the quality of the sw product should be checked (testers)
       - How to use project resources (project managers)
       - How to reuse existing software (configuration managers)
# Discussion.
- If you have to create a system of 100 KLOCs,
    - How many _people_ are needed? For how long?
    - What do they need to do?
    - How do you organize them?
    - What documents must they produce? When?
# What is a development process.
A development process defines Who does What , When , and How , in order to
achieve a certain result
Why study the sw development process?
- The software systems we build must be reliable and
    secure: the software development process influences these
    **qualities**
- There are several models of software processes,
    suitable for **different** products, organizations and markets.
- Some **development sw** tools** are effective only in the context
    of specific processes
- The software development process impacts the organization
    that develops it
- The organization performing the development impacts the structure
    of the product **(Conway's law)**   
# Conway's Law.
Organizations that design systems design their structure by reproducing their communication structures (e.g., organizational chart)
**Example**: If 4 teams collaborate to build a compiler,
the final structure will be on 4 pipelined processes
**Principle**: some important properties of a system
depend on its construction process
Consequences of Conway's law
Conway's law has as a consequence that developers who
work on the same components must be able to communicate without
obstacles.
That is, they must be close to each other from an organizational point of view.
- If the parts of an organization (teams, departments, divisions)
    do not reflect the essential parts of the product/service, or if their
    their relationships are not reflected in the relationships between the parts of the
    product/service, then the project will have problems
- It is necessary to make sure that the organization of development and then of
    production is compatible with the architecture of the product
- Example: an organization that produces a portal or site
    whose structure and content reflect the internal interests
    of the organization rather than the needs of the users
- Moral: To innovate through ICT services (internal or external)
    change your organization first, otherwise it is a
    losing battle!
**Software is a social construct.
- **Software is the product of a social process**,
    involving many people with different roles and interests
    different
- Moreover, often, when software is put into
    operates it changes the social relationships between people - e.g.
    example in a bank, or in a public institution
- Many qualities of software can be judged only
    in “social” terms
Software process
- A software development process (or “ software process ”) is a set of
activities of people who build a software product
- The product can be built **from scratch** or by reusing existing software (assets) that is modified or integrated
# Categories of processes
- In-the-small programming:
    a developer, a module (e.g., edit-compile-debug)
- Programming in-the-large:
    one developer, multiple modules, multiple versions, multiple configurations
    (e.g., personal software process)
- Programming-in-the-many:
    Multiple developers, coordinated through a development process
    (e.g., Scrum)
Minimal process: “program and debug”
Writing a program and removing errors
- **Programming is a personal activity**
one does not usually define a generic sequence
of “creative” programming steps.
- **Debugging is a form of verification**
to discover and remove errors in the program
# The edit-compile-debug process
edit -> compile -> test
- **Very fast cycle, rapid feedback**
- **Availability of many tools**
- **Specialized for coding**
- **Does not encourage documentation**
- **Process does not scale: in-the-large, in-the-many**
- **Unmanageable during maintenance**
- **Debugging needs a specific process** 
Programming in the many:
- In a large company, sw development is often divided among several teams.
- Teams need to be coordinated, and a hierarchical social structure is usually used
- In each team, the Product Owner is the figurehead who defines the team's development goals
# Process models.
- A sw process is a structured set of activities required to develop a sw system: the **roles**, the **activities** and the **documents** to be produced
- A sw process model is a **representation** of a **family of processes**
       - It provides a description from perspectives
          particular
             - to capture important features of the
                sw processes
                   - useful for various purposes, such as to
                      evaluate, criticize, or extend them
                         
Describing a process:
- You need to describe/assign the **roles** (e.g., stakeholders).
- It is necessary to describe/monitor the **activities**
- The **tools** need to be described/assembled .
- The **events** need to be described/monitored .
- There is a need to describe/validate the **documents** (e.g., requirements)
- There is a need to describe/verify the **quality criteria**
Example
- **Process model**: **waterfall**, i.e., planned linear
- **Process**: instance of a waterfall model that is “executed” to create a system. Creates a series of artifacts as prescribed by the model.

# Why describe a sw process
Software process :
The structured set of activities, events,
documents and procedures necessary for the
construction of a software system
Benefits of sw process modeling:
- Everyone knows what they need to do, day to day
- Better team coordination
- Accumulation of experience
- Adherence to international standards
- “Improve the process to improve the product”
    
# Generic process sw models.
- **Cascade model (example: Waterfall)**
    - Specification and development are separate and distinct
- **Iterative model (example: UP)**
    - Specification and development are cyclic and overlapping
- **Agile model**
    - Unplanned, user-driven, and test-driven
- **Formal development (example: B method)**
    - The mathematical model of a system is
       transformed into an implementation
The waterfall model (Royce):
- Rigid sequential steps
- Strongly planned model
- Document-driven 
Waterfall model: positive and negative aspects?
- Fits well with projects with stable, well-defined requirements
- Issues:
    - Customer needs to know how to define requirements
    - Working version of software only at the end
    - Difficult “running” changes
    - Strongly interconnected and blocking phases
Problem: Process does not respond to market changes that are faster than its execution.
A more flexible model: overlapping phases
**Features**
- Based on **learning** and **adaptation** vs. _planning_ and _execution_
- Iterative process
# Dimensions of time
- Linear time
    - Linked to an intuitive notion of progress
    - “More today than yesterday and less than tomorrow”
- Cyclical time
    - Hours, days, weeks, months, seasons...
    - Cyclical time apparently repeats itself without
       progress, it needs indications of progress
    - “ _Sentinel, at what point is the night_? ‘The sentinel replies, ’ _Morning comes, and comes_.
       _The night also. If you want to question, question away; come back another time_ “Isaiah, 21
Software is built in cycles
(and cycles within cycles)
Cycles within cycles
Waterfall vs iterative
Spiral model (Boehm):
- Risk assessment/reduction (Risk Analysis)
- Development and Verification (Engineering)
- Review and Planning (Evaluation)
- Goal Setting (Planning)
# The areas of the spiral model.
I. Goal setting
- Each round identifies its own objectives
II. Assessing and reducing risks
- Prioritization of risks
- Each risk must be addressed
III. Development and validation
- The development model can be generic
- Each round includes development and validation
IV. Planning
- Review of the project and planning for its future
Spiral model:
- Suitable if unstable requirements
- Nonlinear but **planned**
- Flexible, adapts to user needs
- Assesses risk for each iteration
- Can support different process models
- Requires customer involvement
- Difficult to assess risk
- Costly: ROI (Return On Investment)?
Iterations
- This figure represents an iterative process of more than 5 iterations
- By the end of the fourth iteration, 90% of the requirements are stable but only 10% of the software has been built
Cascading vs. iterative: effort
- Distribution of effort in the stages of a cascading process: testing absorbs much more effort than the other stages
- Segmentation of effort in the stages of an iterative process
Iterative: incremental testing
Iterative processes:
- RUP
- Open UP
- RUP and MSF variants
- Synch and stabilize
# Quality of software processes.
1. Visibility - process rules and artifacts are known to all stakeholders
2. Measurability/accuracy - the outcome of the process can be estimated and/or evaluated (KPI: Key Performance Indicator). Examples
       I. Leadtime: time taken from idea to software
       II. Cycletime: time required to make a change to the
          software and make it operational
       III. Open/closerate: issues-that is, problems-found in the swe solved in a
          unit of time
3. Accuracy -the process describes task roles and artifacts in a way that is clear and understandable to those who must execute it
4. Repeatability -the process can also be repeated by different people, achieving the same result
       
# Conclusions.
- Waterfall processes: planned, rigid
- Iterative processes: planned, flexible
- Agile processes: unplanned, adaptive
- There are many variations
- Each organization defines the model it prefers, possibly adapting it for
classes of products or software projects
Self-testing:
- What is a software process?
- What are the typical steps in the development process?
- What are the main differences between linear processes
    and iterative processes?
- How do you recognize a waterfall process?
- What are the main performance indicators of
    software process?
# Process models for software development: agile models.
Objectives of this lesson:
- The agile process models
- The agile manifesto
- Extreme Programming (XP)
Developing software is a social activity:
- Almost all difficult problems in software development are about people, not technologies.
- Writing software is not difficult.
- However, writing the *right* software is very difficult, because you have to understand users' needs, negotiate delivery times, distribute tasks, make trade-offs
- People who can do software well are rare: when they succeed they usually demonstrate both technical skill and good interpersonal relationship skills
# Planning often fails:
- Some problems are complex, solution requires input from many people
- The solution at the beginning is not clear
- Solution requirements during development will change because users are not sure what they want
- The product can be delivered in incremental versions later, but we don't know how many increments it will take
- Close collaboration and rapid, continuous feedback from end users is required
Volatility of requirements:
Every six months-or less-about half of a software product's requirements lose interest
Therefore:
- The user must be part of the game from the beginning
- Waste of time must be avoided
- Need to adapt to changing user requirements
Improve iterative processes
- Iterative processes must produce value for stakeholders incrementally and without waste
- Agile philosophy aims to avoid waste and wasted time - unnecessary activities
# Ethics of the Agile Movement
We are discovering better ways to build software by doing it and helping others do it. We attribute value to:
- Individuals and interactions more than processes and tools
- Software that works more than complete documentation
- Customer collaboration more than contract negotiations
- Reacting to change more than following a plan
Values on the right are important, but we prefer those on the left
# The agile principles
1. Our priority is to satisfy the customer through early and continuous delivery
    Of valuable software
2. The company's people and developers must work daily
    together throughout the project
3. Changes to requirements are welcome, even in the later stages of development
4. Deliver frequently working software
5. Working software is the first measure of progress
6. Projects are built around motivated individuals. Give them the environment and the
    support they need, and trust them to do their work
7. The best architectures, requirements, and designs emerge from self-organizing teams
8. The most effective and efficient method of conveying information to and within
    of a development is through face-to-face conversations
9. Agile processes promote sustainable development
10. Constant attention to technical excellence and good design enhance agility
11. Simplicity is essential
12. Development teams evaluate their effectiveness at regular intervals and modify
    their behavior accordingly       
Agile methods:
Agile methods are a family of development methods that
have in common:
- **Frequent** release** of the incrementally developed product.
- **Continuous** collaboration** of the development team with the **customer**.
- **Documentation** of **reduced** development.
- **Systematic and continuous  assessment** of **values** and **risks** of **changes**
Minimal Viable Product**.
**Agile methods--there are many of them!
- Extreme Programming (XP)
- Scrum
- Feature-Driven Development (FDD)
- Adaptive Software Process
- Crystal Light Methodologies
- Dynamic Systems Development Method (DSDM)
- Lean Development
- DevOps
- SAFe
- Less
# eXtreme Programming (XP)
“Extreme Programming is a software development discipline based on the values of.
- _simplicity_,
- _communication_,
- _feedback_, and
- _courage_ ”
The XP team
- The development team, usually consisting of fewer than ten people, is assembled in the same room
- A customer representative is always present, able to answer questions from the
team regarding requirements
- The team must use simple development behaviors , at the same time able to
inform everyone about the status of the project but also to adapt behaviors to the
specific situation
Extreme Programming practices:
- Requirements are “user stories”
- The “planning game”
- Small releases
- Customer On-site
- “Test first, code later”
- The reference metaphor
- Continuous integration
- Collective ownership of the code
- 40-hour work week
- Systematic use of coding standards
- Pair programming
- Refactoring
- Simple design
# Requirements are “user stories”
User stories:
- Short sentences, used instead of detailed requirements specification documents
- Written together with customers: what they expect from the system
- a story is described by one or two sentences in natural text, using customer terminology
- useful for the team to estimate the time/cost of releasing the new version (increment)
Examples of user stories:
- A student can purchase a parking pass online
- Parking subscriptions can be paid for by credit card
- Parking subscriptions can be paid with Paypal
- A professor can enter grades online
- A student can view a class schedule
- A student can get a recording of the lecture
- A student can register for a course if he or she meets prerequisites
- A recording of a course can be viewed through a browser
# Preferred format for User stories:
- As a student (user type)
- I want to be able to buy a monthly parking pass online (goal)
- to not pull out money every day (motivation)
Product backlog = set of US
Stories and iterations:
- High priority
- Low priority
# The “Planning game”
- User Stories allow you to do short-term planning
       - A story is a brief description of something the
          customer
       - The description can be enriched by other stories during
          development
       - The **priorities** among stories are defined by the **customer**
       - **Resources** needed ( **story points** ) and risks are assessed
          by the **developers**
- “The **Planning Game** ”
    - Stories of highest risk and priority are addressed
       first, in “ _time boxed_ ” increments .
    - The Planning Game is replayed for each iteration
       
Client presence:
- The client (a representative of the client) is always
available to clarify stories and to
make critical decisions quickly
- Developers do not have to make assumptions: the client responds directly
- Developers do not have to wait for the client's decisions
- “Face-to-face” communication minimizes the possibility of ambiguity and misunderstanding
The MOSCOW method for prioritizing user stories
MOSCOW : acronym for Must/Should/Could/Won't
(MUST/SHOULD/COULD/WOULD NOT)
- Must: functions that SHOULD be in the product
- Should: functions that SHOULD be there
- Could: functions that COULD be there
- Wont: functions that WON'T be in the current version
# User story example:
- User will be able to log in with username and passwd
- User will be able to register a new account
- User will be able to see all Word documents included in the file system
- The user will be able to delete all Word documents
- User will be able to access every document within the file system
- User will be able to log in with dual authentication
Example:
- User SHOULD log in with username and passwd
- The user SHOULD register a new account
- The user SHOULD see all Word documents included in the
    file system
- The user MAY delete all Word documents
- The user SHOULD access every document within the file system
- User MAY NOT log in with dual authentication
# Test-driven development
Test-Driven Development (TDD)
- Choose a user story and define itest before code
- TDD is a programming technique
- Automate tests (e.g., use xUnit)
- Must run everything before continuing with more code
- _Unit test_ vs _acceptance test_.
Classic testing vs test driven
Acceptance testing (customer tests)
Acceptance testing:
- Driven by user stories
- Written with the customer
- Function as a “contract”
- Measureof progress
Small releases
- Timeboxed (i.e., of predetermined “short” duration)
- Minimal, but still useful (microincreases)
    - Never things like ʻimplementing the databaseʼ
- Get customer feedback early and often
- Run the “planning game” after each
    iteration
       - Was something different wanted?
       - Did priorities change?
# The metaphor.
- XP planners develop a common vision of how the program will work, called a “ system metaphor ”
- Example: “ _this program works like_ a swarm of bees, which searches for pollen and
brings it into the hive “ (agent-based information retrieval system).
- The metaphor is not always poetic. In any case, the team should use a common glossary
of entity names relevant to the project
Design Simple:
- No Big Design Up Front (BDUF)
- “Do the simplest thing that will work.”
    - Include Documentation
- “You Aren't Gonna Need It” (YAGNI).
- Option: use CRC boards
    (see the lessons on requirements and design for an introduction to CRC boards)
# Refactoring (refactoring).
- Refactoring: improving existing code without changing its functionality
- Have the courage to throw out code
    - Simplify code
    - Remove redundant code
    - Look for opportunities for abstraction
- Refactoring uses testing to ensure that no
errors
# Pair programming
Pair programming:
- Two designers work on the same task on one computer
- One of them, the driver, controls the keyboard and mouse and writes code
- The other, the navigator, observes the code looking for defectsand participates in
    brainstorming on demand
- The roles of driver and navigator are exchanged between the two designers
    periodically (e.g., in the middle of the day)
- The pairings change daily: the goal isfor everyone to become
    familiarity with the code (see: collective ownership of code)
Pair programming is typical of eXtreme Programming (XP).
Pair programming improves quality.
# Continuous integration.
- Pair writes tests and code for a task (= part of a user story)
- Pair performs all unit testing
- Pair performs integration of new unit with others
- The pair performs all regression testing
- The pair moves on to the next task with a clear mind (happens once or twice a day)
- The goal is to prevent the “ _Integration Hell_ ”
# Collective ownership of code.
- Code belongs to the project, not to an individual
- During development everyone can observe and **modify** any class
- One of the effects of _collective ownership_ is that code that is too complex does not survive for long
- For this strategy to work, “continuous integration” is needed
Sustainable step
- Kent Beck says, “...fresh and eager every morning, tired and satisfied every evening.”
- Working late into the night hurts performance: a tired developer makes more
errors, and in the long run the game is not worth the candle
- If the project harms participants' personal lives, the project itself pays the price in the long run
Coding conventions
- Using coding conventions
    - Because of Pair Programming, refactoring, and the
       collective ownership of code, it is necessary to be able to delve
       quickly into other people's code
- Commenting on code
    - Prioritize code that “reveals” its purpose
       - If the code requires commenting, rewrite it
       - If you cannot explain the code with a comment, rewrite it
# The Thirteenth Principle: The standing meeting.
- Each day begins with a 15-minute meeting
    - Everyone stands (so the meeting lasts less) in a
       circle
    - Each person in turn says:
       - What did you do the day before
       - What he plans to do today
       - What obstacles it is encountering
    - This may be the time when the
       pairs         
# Conclusion.
Agile methods, and XP in particular, prefer:
- Small teams
- The customer is on the team - the Product Owner
- They accept changes in requirements
- Short Iterations and frequent delivery
- They practice continuous integration
Self-testing:
- What is an MVP (minimum viable product)?
- What are agile values?
- What is a user story?
- What is the purpose of the MOSCOW method?
- What is collective ownership of code?
- What is refactoring?
Tools
- Trello/Taiga
- Slack/Mattermost
- Ant, XDoclet, JUnit, Cactus, Maven
- Git/GitLab
- Atlassian Jira
- agiletrack.net

