# AGILE Retrospective

Use the Agile Retrospective practice to gather insight into a period of activity or event, and to generate actions for improvement.

It includes basic instructions on the performance of retrospectives and a catalogue or useful techniques that can be use to keep the retrospectives focused, productive and entertaining.

Make incremental improvements to the way of working through regular, repeated retrospectives.

The retrospective practice, in Essence, creates one activity which is Hold a Retrospective, one alpha which is Improvement, a few patterns which are Feedback, Mad Sad Glad, 5 whys, 4 Ls, Where are we, one work product which is the Action List and two competencies which are Leadership level 2 and management level 2.

## Contents

### Things to do:
- Hold Retrospective

### Competencies:
- Leadership

### Things to work with:
- Action List

### Patterns:
- Mad, Sad, Glad
- 5 Whys
- 4 Ls
- Where Are We?

## Key Resources
Agile Retrospectives – Ester Derby .....


# Hold Retrospective (Activity of Retrospective Practice)
Agile Retrospectives

## On Entry
- Alpha: Things to be considered known
- Tools: Cards, boards and other tools available
- Work Product: Action list

## Competencies:
- Leadership (3)
- Analysis, Development, Testing
- Stakeholder Representation

## On Exit
- Work Product: Action list (updated)

## Description:
A facilitated session where a team reflects on all aspects of their way-of-working including:
- How have we done since the last retrospective?
- How can we do better?

## Participants:
- Facilitator, who will run the session
- Team Members and selected Stakeholders

## Typical duration:
- A time-boxed activity of 1 – 3 hours with a preference for the lower

## Approaches:
- Workshop (preferred approach)

## This activity produces:
A list of actions the team agrees to implement in the next period

## Patterns:
- Sad, mad, glad
- 5 whys
- ...

## Resources:
- Agile Retrospectives by Ester Derby

Parent: Undefined
Sub-activities: None

# Hold Retrospective: Workshop Checklist (Activity of Retrospective Practice)

Agile Retrospectives

## Before Starting
(with Facilitator)

Are the entry criteria met?
- [ ] Things to be considered are known
- [ ] Cards, boards and other tools available

Are the participants prepared?
- [ ] The purpose of the re trospective is clear
- [ ] The attendees have been determined and notified
- [ ] Relevant data gathered and available

Are the tools / facilities available?
- [ ] Facilitation techniques selected
- [ ] Opener / Ice-Breaker
- [ ] Information Generators
- [ ] Close / Action Generators
- [ ] Cards, boards etc available
- [ ] Suitable room booked

Have relevant stakeholders been invited?
- [ ] Yes
- [ ] No, but the team can be trusted to represent them

## During
(with whole team)

Focus on actionable improvements:
- [ ] Review progress on existing action items
- [ ] Review data on the last period:
- [ ] Metrics
- [ ] Personal reflections
- [ ] External feedback
- [ ] Identify highest priority problem areas
- [ ] Analyze root causes
- [ ] Generate actions:
- [ ] SMART
- [ ] Owned

Are the participants working together in an open and honest way (with no hidden agendas)?
- [ ] Yes
- [ ] No

Are all team members participating?
- [ ] Yes
- [ ] No

Is the group getting to the real issues?
- [ ] Yes
- [ ] No

Is the group generating actions as well as ideas?
- [ ] Yes
- [ ] No

## Before completion
(with the whole team)

Are the exit criteria achieved?
- [ ] Action list updated

Was the retrospective worthwhile?
- [ ] Were insights generated?
- [ ] Was the team engaged and involved?
- [ ] Are the participants satisfied with the results?

Are the team members committed to taking action?
- [ ] Have actions been agreed?
- [ ] Have the actions been prioritized?
- [ ] Do all the actions have owners committed to driving them forward?

# Five Whys (Pattern of Retrospective Practice)

A (serious) game to play during retrospectives.

Source: Agile Retrospectives
Ester Darby
Tags: ???
Insight Generation Technique

## Participants:
- 7 + or – 2 team members
- A facilitator (could be team member)
- A customer rep/product owner 

## Equipment:
- Whiteboard or flip chart
- Sticky notes

## Basic instructions of the Five Whys:
1. Facilitator selects issue for discussion
2. Facilitator generates discussion by asking why issue has occurred
3. Discussion continues with multiple rounds of why, why, why questioning until root cause is identified or until group knowledge has been exhausted
4. Facilitator captures results

## Description:
A simple technique that enables a team to quickly generate insights.

## Use when:
- During a retrospective
- After SAD, GLAD, MAD technique, or when an issue has been identified that needs further discussion
- To generate insights related to cause of an issue
- Limit to 15-20 minutes

## Applied to:
- Any issue raised by team

## Applied By:
- Team

## Related To:
- SAD, MAD, GLAD

## Resources:
- None

# MAD, SAD, GLAD (Pattern of Retrospective Practice)

A (serious) game to play during retrospectives.

Source: Agile Retrospectives
Ester Darby
Tags: ???
Data Gathering Technique

## Participants:
- 7 + or – 2 team members
- A facilitator (could be team member)
- A customer rep/product owner 

## Equipment:
- Sticky Notes

## Basic instructions of Mad Sad Glad:
1. Facilitator asks group to each write down on sticky notes at least 1 or 2 issues that made them feel GLAD, MAD, and SAD during the previous Sprint
2. Facilitator create headings for MAD, SAD, GLAD on whiteboard
3. Team members place sticky notes under appropriate area
4. Facilitator clusters common sticky notes. Facilitator asked group to name each cluster
6. Group agrees on top 2-3 areas for further discussion/insight generation

## Description:
A simple technique that enables a team to quickly gather data about potential issues to resolve.

## Use when:
- During a retrospective
- After review of how we did addressing issues from last retrospective
- To generate issues for discussion/insight generation
- Limit to 15-20 minutes

## Applied to:
- Sprint retrospective

## Applied By:
- Team

## Related To:
- 5 Whys

## Resources:
- None

# Where are we? (Pattern of Retrospective Practice)

A (serious) game to play during retrospectives.

Source: Agile Retrospective
Tags: Serious Games
Workshop Techniques

## Participants:
- 7 +-2
- A facilitator (who can also participate)

## Equipment:
- Alpha State Cards
- Large, flat work area

## Basic instructions of Where are we?:
1. Lay out the cards for each Alpha in a row on the table with the first state on the left and the final state on the right
2. Starting with the first state of the first Alpha, walkthrough the checklist and ask if the state has been achieved.
3. If the state has been achieved move the card to the left. Continue until you reach a state that the team has not yet achieved, or you run out of states.
4. If it is not clear which state one of the Alphas is in then a quick round of Progress Poker can be used to help reach consensus.
5. Repeat for all Alphas.
6. Consider the overall position of the cards:
    1. Are any Alphas lagging?
    2. What are the next states to be achieved.

## Description:
A SEMAT game that helps a team to understand where they are and contrast this wit where they need to be. The game uses the SEMAT Alphas and Alpha State Card to: 
- Assess where the team is
- Identify gaps between the current state and the desired state

## Use when:
- You want to get a holistic, method independent view of where you are and identify areas for improvement
- Duration – up to 30 minutes

## Applied to:
- Any software development endeavor

## Applied By:
- Retrospect

## Related To:
- Progress Poker

## Resources:
- Alpha State Cards
- Alpha State Card Games: Chase the State
- Essence Quick Reference Guide

# The 4L’s: Liked, Learned, Lacked, Longed For (Pattern of Retrospective Practice)

A (serious) game to play during retrospectives.

Source: Agile Retrospective
Tags: Serious Games
Workshop Techniques

## Participants:
- Unlimited
- A facilitator (who can also participate)

## Equipment:
- Flip chart paper
- Post-it notes
- Pens

## Basic instructions of the 4L's:
1. Hang an appropriately titled poster for each L on the walls of the room.
2. Ask the participants to write down the things they Liked, Learned, Lacked and Longed For and stick then on the appropriate poster. Allow 3 – 4 minutes.
3. Assign participants to groups – 1per poster – to red and group the notes.
4. Each group reports their highlights and themes
5. As a group explore action possibilities to exploit what was liked and learned, and address what was lacked and longed for.

## Description:
A brain-storming technique developed by Mary Gorman and Ellen Gottesdener.
We ***liked*** it when a good thing took on a life of its own.
We ***learned*** that it really resonated with many folks.
We ***lacked*** sharing the full understanding of the technique.
We ***longed*** for more sharing.

## Use when:
- You want to elicit feedback, share experiences, and explore action possibilities
- Duration 30 minutes

## Also known as:
- The 3L’s – where typically the learned category is dropped.

## Applied to:
- Any event or time period

## Applied By:
- Retrospect

## Related To:
- Mad, Sad, Glad

## Resources:
- http://www.ebgconsulting.com/blog/the-4l’s-a-retrospective-technique/

# Action List (Work Product of Retrospective Practice)

Agile Retrospective

## Level of detail:
From Pile of Post-Its to Action Backlog

## Description:
A prioritized list of all the improvement actions identified for a team. The actions should be prioritized and those for immediate action clearly identified.

Each actions should be:
- SMART- Specific, Measurable, Achievable, Relevant, and Time-Bound
- Assigned a specific owner

## Essential Content:
- 1.N Actions

## Describes:
- Work

## Patterns:
- None

## Resources:
- None

## Input to:
- Hold Retrospective

## Output from:
- Hold Retrospective

# Other patterns that could be added to the of Retrospective Practice
Other than:
- Mad, Sad, Glad
- 5 Whys
- 4 Ls
- Where Are We?
These are two more (Essence) patterns that can be added to Retrospectives:
- SEMAT Method SWOT
- Speedboat / Sailing Ship