# Alpha State Cards

This a list of all the Essence Kernel Alpha cards.

Each card has:
- a title
- a brief description (optional)
- a list of states (optional)
- a state (optional)
- a checklist (optional)

# Stakeholder Alpha State cards

Title: Stakeholder Alpha
Description: The people, groups or organizations who affect or are affected by a software system
States: recognized, represented, involved, in agreement, satisfied for deployment, satisfied in use.

Title: Stakeholders State 1
State: Recognized
Description: Stakeholders have been identified.
Checklist: Stakeholder groups identified, key stakeholder groups represented, responsabilities defined.

Title: Stakeholders State 2
State: Represented
Description: The mechanisms for involving the stakeholders are agreed and the stakeholder representatives have been appointed.
Checklist: Responsabilities agreed, representatives authorized, collaboration approach agreed, way of working supported & respected.

Title: Stakeholders State 3
State: Involved
Description: The stakeholder representatives are actively involved in the work and fulfilling their responsibilities.
Checklist: Representatives assist the team, timely feedback and decisions, changes promptly communicated.

Title: Stakeholders State 4
State: In Agreement
Description: The stakeholder representatives are in agreement.
Checklist: Minimal expectations agreed, rep's happy with their involvement, rep's input valued, team's input valued, priorities clear & perspectives balances.

Title: Stakeholders State 5
State: Satisfied for deployment
Description: The minimal expectations of the stakeholder representatives have been achieved.
Checklist: Stakeholder feedback provided, system ready for deployment.

Title: Stakeholders State 6
State: Satisfied in use
Description: The system has met or exceeds the minimal stakeholder expectations.
Checklist: Feedback on system use available, system meets expectations.

# Opportunity Alpha State cards

Title: Opportunity Alpha
Description: The set of circumstances that makes it appropriate to develop or change a software system.
States: Identified, Solution Needed, Value Established, Viable, Addressed, Benefit Accrued.

Title: Opportunity State 1
State: Identified
Description: A commercial, social or business opportunity has been identified that could be addressed by a software-based solution.
Checklist: Idea behind opportunity identified, At least one investing stakeholder interested, Other stakeholders identified

Title: Opportunity State 2
State: Solution Needed
Description: The need for a software-based solution has been confirmed.
Checklist: Solution identified, Stakeholders' needs established, Problems and root causes identified, Need for a solution confirmed, At least one solution proposed

Title: Opportunity State 3
State: Value Established
Description: The value of a successful solution has been established.
Checklist: Opportunity value quantified, Solution impact understood, System value understood, Success criteria clear, Outcomes clear and quantified

Title: Opportunity State 4
State: Viable
Description: It is agreed that a solution can be produced quickly and cheaply enough to successfully address the opportunity.
Checklist: Solution outlined, Solution possible within constraints, Risks acceptable & manageable, Solution profitable, Reasons to develop solution understood, Pursuit viable

Title: Opportunity State 5
State: Addressed
Description: A solution has been produced that demonstrably addresses the opportunity.
Checklist: Opportunity addressed, Solution worth deploying, Stakeholders satisfied

Title: Opportunity State 6
State: Benefit Accrued
Description: The operational use or sale of the solution is creating tangible benefits.
Checklist: Solution accrues benefits, ROI acceptable

# Requirements Alpha State cards

Title: Requirements Alpha
Description: What the software system must do to address the opportunity and satisfy the stakeholders.
States: Conceived, Bounded, Coherent, Acceptable, Addressed, Fulfilled.

Title: Requirements State 1
State: Conceived
Description: The need for a new system has been agreed.
Checklist: Stakeholders agree system is to be produced, Users identified, Funding stakeholders identified, Opportunity clear

Title: Requirements State 2
State: Bounded
Description: The purpose and theme of the new system are clear.
Checklist: Development stakeholders identified, System purpose agreed, System success clear, Shared solution understanding exists, Requirement's format agreed, Requirements management in place, Prioritization scheme clear, Constraints identified & considered, Assumptions clear

Title: Requirements State 3
State: Coherent
Description: The requirements provide a coherent description of the essential characteristics of the new system.
Checklist: Requirements shared, Requirements' origin clear, Rationale clear, Conflicts addressed, Essential characteristics clear, Key usage scenarios explained, Priorities clear, Impact understood, Team knows & agrees on what to deliver

Title: Requirements State 4
State: Acceptable
Description: The requirements describe a system that is acceptable to the stakeholders.
Checklist: Acceptable solution described, Change under control, Value to be realized clear, Clear how opportunity addressed, Testable

Title: Requirements State 5
State: Addressed
Description: Enough of the requirements have been addressed to satisfy the need for a new system in a way that is acceptable to the stakeholders.
Checklist: Enough addressed to be acceptable, Requirements and system match, Value realized clear, System worth making operational

Title: Requirements State 6
State: Fulfilled
Description: The requirements that have been addressed fully satisfy the need for a new system.
Checklist: Stakeholders accept requirements, No hindering requirements, Requirements fully satisfied

# Software System Alpha State cards

Title: Software System Alpha
Description: A system made up of software, hardware, and data that provides its primary value by the execution of the software.
States: Architecture selected, Demonstrable, Usable, Ready, Operational, Retired.

Title: Software System State 1
State: Architecture selected
Description: An architecture has been selected that addresses the key technical risks and any applicable organizational constraints.
Checklist: Architecture selection criteria agreed, HW platforms identified, Technologies selected, System boundary known, Decisions on system organization made, Buy, build, reuse decisions made, Key technical risks agreed to

Title: Software System State 2
State: Demonstrable
Description: An executable version of the system is available that demonstrates the architecture is fit for purpose and supports functional and non-functional testing.
Checklist: Key architectural characteristics demonstrated, System exercised & performance measured, Critical HW configurations demonstrated, Critical interfaces demonstrated, Integration with environment demonstrated, Architecture accepted as fit-for-purpose

Title: Software System State 3
State: Usable
Description: The system is usable and demonstrates all of the quality characteristics of an operational system.
Checklist: System can be operated, System functionality tested, System performance acceptable, Defect levels acceptable, System fully documented, Release content known, Added value clear

Title: Software System State 4
State: Ready
Description: The system (as a whole) has been accepted for deployment in a live environment.
Checklist: User documentation available, System accepted as fit-for-purpose, Stakeholders want the system, Operational support in place

Title: Software System State 5
State: Operational
Description: The system is in use in an operational environment.
Checklist: System available for use, System live, Agreed service levels supported

Title: Software System State 6
State: Retired
Description: The system is no longer supported.
Checklist: Replaced or discontinued, No longer supported, No authorized users, Updates stopped

# Team Alpha State cards

Title: Team Alpha
Description: A group of people actively engaged in the development, maintenance, delivery or support of a specific software system.
States: Seeded, Formed, Collaborating, Performing, Adjourned.

Title: Team State 1
State: Seeded
Description: The team's mission is clear and the know-how needed to grow the team is in place.
Checklist: Mission defined, Constraints known and defined, Growth mechanisms in place, Composition defined, Responsibilities outlined, Required commitment level clear, Required competencies identified, Size determined, Governance rules defined, Leadership model selected

Title: Team State 2
State: Formed
Description: The team has been populated with enough committed people to start the mission.
Checklist: Enough members recruited, Roles understood, How to work understood, Members introduced, Individual responsibilities accepted and aligned to competencies, Members accepting work, External collaborators identified, Communication mechanisms defined, Members commit to team

Title: Team State 3
State: Collaborating
Description: The team members are working together as one unit.
Checklist: Works as one unit, Communication open and honest, Focused on mission, Members know each other

Title: Team State 4
State: Performing
Description: The team is working effectively and efficiently.
Checklist: Consistently meeting commitments, Continuously adapting to change, Addresses problems, Rework and backtracking minimized, Waste continuously eliminated

Title: Team State 5
State: Adjourned
Description: The team is no longer accountable for carrying out its mission.
Checklist: Responsibilities fulfilled, Members available to other teams, Mission concluded

# Work Alpha State cards

Title: Work Alpha
Description: Activity involving mental or physical effort done in order to achieve a result.
States: Initiated, Prepared, Started, Under Control, Concluded, Closed.

Title: Work State 1
State: Initiated
Description: The work has been requested.
Checklist: Required result clear, Constraints clear, Funding stakeholders known, Initiator identified, Accepting stakeholders known, Source of funding clear, Priority clear

Title: Work State 2
State: Prepared
Description: All pre-conditions for starting the work have been met.
Checklist: Commitment made, Cost and effort estimated, Resource availability understood, Risk exposure understood, Acceptance criteria established, Sufficiently broken down to start, Tasks identified and prioritized, Credible plan in place, Funding in place, At least one team member ready, Integration points defined

Title: Work State 3
State: Started
Description: The work is proceeding.
Checklist: Development started, Progress monitored, Definition of done in place, Tasks being progressed

Title: Work State 4
State: Under Control
Description: The work is going well, risks are under control, and productivity levels are sufficient to achieve a satisfactory result.
Checklist: Tasks being completed, Unplanned work under control, Risks under control, Estimates revised to reflect performance, Progress measured, Re-work under control, Commitments consistently met

Title: Work State 5
State: Concluded
Description: The work to produce the results has been concluded.
Checklist: Only admin tasks left, Results achieved, Resulting system accepted

Title: Work State 6
State: Closed
Description: All remaining housekeeping tasks have been completed and the work has been officially closed.
Checklist: Lessons learned, Metrics available, Everything archived, Budget reconciled & closed, Team released, No outstanding, uncompleted tasks

# Way of Working Alpha State cards

Title: Way of Working Alpha
Description: The tailored set of practices and tools used by a team to guide and support their work.
States: Principles Established, Foundation Established, In Use, In Place, Working Well, Retired.

Title: Way of Working State 1
State: Principles Established
Description: The principles, and constraints, that shape the way-of-working are established.
Checklist: Team actively support principles, Stakeholders agree with principles, Tool needs agreed, Approach recommended, Operational context understood, Practice & tool constraints known

Title: Way of Working State 2
State: Foundation Established
Description: The key practices, and tools, that form the foundation of the way of working are selected and ready for use.
Checklist: Key practices & tools selected, Practices needed to start work agreed, Non-negotiable practices & tools identified, Gaps between available and needed way of working understood, Gaps in capability understood, Integrated way of working available

Title: Way of Working State 3
State: In Use
Description: Some members of the team are using, and adapting, the way-of-working.
Checklist: Practices & tools in use, Regularly inspected, Adapted to context, Supported by team, Feedback mechanisms in place, Practices & tools support collaboration

Title: Way of Working State 4
State: In Place
Description: All team members are using the way of working to accomplish their work.
Checklist: Used by whole team, Accessible to whole team, Inspected and adapted by whole team

Title: Way of Working State 5
State: Working Well
Description: The team's way of working is working well for the team.
Checklist: Predictable progress being made, Practices naturally applied, Tools naturally support way-of-working, Continually tuned

Title: Way of Working State 6
State: Retired
Description: The way of working is no longer in use by the team.
Checklist: No longer in use, Lessons learned shared

# Essence Kernel Competencies cards

These are the competencies that are defined by the Essence Kernel. They should apply to all software projects.

Title: Stakeholder Representation
Description: The ability to gather, communicate and balance the needs of other stakeholders, and accurately represent their views.

Title: Analysis
Description: The ability to understand opportunities and their related stakeholder needs, and transform them into an agreed and consistent set of requirements.

Title: Development
Description: The ability to design and program effective software systems following the standards and norms agreed by the team.

Title: Testing
Description: The ability to test a system, verifying that it is usable and that it meets the requirements.

Title: Leadership
Description: The ability to inspire and motivate a group of people to achieve a successful conclusion to their work and to meet their objectives.

Title: Management
Description: The ability to coordinate, plan and track the work done by a team.

Every competency has five levels:
1. assists
2. applies
3. masters
4. adapts
5. innovates

# Essence Kernel Activity Spaces cards

The Kernel Activity Spaces contain the activities specific to a cartain practice.

For each area of concern they are in a sequential order.

The Kernl Activity Spaces are:
- Explore Possibilities: Explore the possibilities presented by the creation of a new or improved software system. This includes the analysis of the opportunity to be addressed and the identification of the stakeholders.
- Understand Stakeholder needs: Engage with the stakeholders to understand their needs and ensure that the right results are produced. This includes identifying and working with the stakeholder representatives to progress the opportunity.
- Ensure stakeholder satisfaction: Share the results of the development work with the stakeholders to gain their acceptance of the system produced and verify that the opportunity has been successfully addressed.
- Use the system: Observe the use of the system in an operational environment and how it benefits the stakeholders.
- Understand the Requirements: Establish a shared understanding of what the system to be produced must do.
- Shape the system: Shape the system so that it is easy to develop, change and maintain, and can cope with current and expected future demands. This includes the overall design and architecting of the system to be produced.
- Implement the system: Build a system by implementing, testing and integrating one or more system elements. This includes bug fixing and unit testing.
- Test the system: Verify that the system produced meets the stakeholders’ requirements.
- Deploy the system: Take the tested system and make it available for use outside the development team.
- Operate the system: Support the use of the software system in the live environment.
- Prepare to do the work: Set up the team and its working environment. Understand and commit to completing the work.
- Coordinate activity: Co-ordinate and direct the team’s work. This includes all ongoing planning and re-planning of the work, and adding any additional resources needed to complete the formation of the team.
- Support the team: Help the team members to help themselves, collaborate and improve their way of working.
- Track the progress: Measure and assess the progress made by the team.
- Stop the work: Shutdown the software engineering endeavor and handover the team’s responsibilities.

# Essence Kernel Activity Space cards in the Customer Area of Concern

Title: Explore Possibilities
Description: Explore the possibilities presented by the creation of a new or improved software system. This includes the analysis of the opportunity to be addressed and the identification of the stakeholders.
Achieves:
- Stakeholders: Recognized
- Opportunity: Identified
- Opportunity: Solution Needed
- Opportunity: Value Established

Title: Understand Stakeholder Needs
Description: Engage with the stakeholders to understand their needs and ensure that the right results are produced. This includes identifying and working with the stakeholder representatives to progress the opportunity.
Before starting: 
- Stakeholders: Recognized
- Opportunity: Value Established
Achieves: 
- Stakeholders: Represented
- Stakeholders: Involved
- Stakeholders: In Agreement
- Opportunity: Viable

Title: Ensure Stakeholder Satisfaction
Description: Share the results of the development work with the stakeholders to gain their acceptance of the system produced and verify that the opportunity has been successfully addressed.
Before starting:
- Stakeholders: In Agreement
- Opportunity: Value Established
Achieves:
- Stakeholders: Satisfied for Deployment
- Opportunity: Addressed

Title: Use the System
Description: Observe the use of the system in an operational environment and how it benefits the stakeholders.
Before starting: 
- Stakeholders: Satisfied for Deployment
- Opportunity: Addressed
Achieves:
- Stakeholders: Satisfied in Use
- Opportunity: Benefit Accrued

# Essence Kernel Activity Space cards in the Solution Area of Concern: first three (Understand the Requirements, Shape the System, Implement the System)

Title: Understand the Requirements
Description: Establish a shared understanding of what the system to be produced must do.
Achieves:
- Requirements: Conceived
- Requirements: Bounded
- Requirements: Coherent

Title: Shape the System
Description: Shape the system so that it is easy to develop, change and maintain, and can cope with current and expected future demands. This includes the overall design and architecting of the system to be produced.
Before starting:
- Requirements: Coherent
Achieves:
- Requirements: Acceptable
- Software System: Architecture Selected

Title: Implement the System
Description: Build a system by implementing, testing and integrating one or more system elements. This includes bug fixing and unit testing.
Before starting:
- Software System: Architecture Selected
Achieves:
- Software System: Demonstrable
- Software System: Usable
- Software System: Ready

# Essence Kernel Activity Space cards in the Solution Area of Concern: last three (Test the System, Deploy the System, Operate the System)

Title: Test the System
Description: Verify that the system produced meets the stakeholders’ requirements.
Before starting:
- Requirements: Acceptable
- Software System: Architecture Selected
Achieves:
- Requirements: Addressed
- Requirements: Fulfilled
- Software System: Demonstrable
- Software System: Usable
- Software System: Ready

Title: Deploy the System
Description: Take the tested system and make it available for use outside the development team.
Before starting:
- Software System: Ready
Achieves:
- Software System: Operational

Title: Operate the System
Description: Support the use of the software system in the live environment.
Before starting:
- Software System: Ready
Achieves:
- Software System: Retired

# Essence Kernel Activity Space cards in the Endeavor Area of Concern

Title: Prepare to do the work
Description: Set up the team and its working environment. Understand and commit to completing the work.
Achieves:
- Team: Seeded
- Work: Initiated
- Work: Prepared
- Way of Working: Principles Established
- Way of Working: Foundation Established

Title: Coordinate Activity
Description: Co-ordinate and direct the team’s work. This includes all ongoing planning and re-planning of the work, and adding any additional resources needed to complete the formation of the team.
Before starting:
- Team: Seeded
- Work: Prepared
Achieves:
- Team: Formed
- Work: Started
- Work: Under Control

Title: Support the team
Description: Help the team members to help themselves, collaborate and improve their way of working.
Before starting:
- Team: Formed
- Way of Working: Foundation Established
Achieves:
- Team: Collaborating
- Way of Working: In Use
- Way of Working: In Place

Title: Track Progress
Description: Measure and assess the progress made by the team.
Before starting:
- Team: Collaborating
- Work: Started
- Way of Working: In Place
Achieves:
- Team: Performing
- Work: Under Control
- Work: Concluded
- Way of Working: Working Well

Title: Stop the work
Description: Shutdown the software engineering endeavor and handover the team’s responsibilities.
Before starting: 
- Team: Performing
- Work: Concluded
- Way of Working: Working Well
Achieves:
- Team: Adjourned
- Work: Closed
- Way of Working: Retired