# Essence Kernel

# Software Engineering Method And Theory
- A common ground for software engineering
- Moving away from SE methods “fashion” industry.
- Founded in 2009 by:
- Ivar Jacobson
- Bertrand Meyer
- Richard Soley
- OMG Standard under the name Essence
- The SEMAT Kernel - manifestation of the common ground

# The Kernel
- comprises the central elements for all SE methods;
- provides a common language for comparing, applying, and improving methods; supports progress monitoring;
- works in small- and large-scale projects;
- works for well documented and less documented projects;
- comes with a language and tool for developing practices.
- Uptake in China, Russia, South Africa, Japan, Silicon Valley, Florida, Mexico, Germany

# What’s in it for us?
- It is highly probable that this will be used much more in the future.
- By focusing on the Essentials, the project groups have more freedom and responsibility.
- Our students will not become “methodists”.
- Taught in TDDE46 Software quality.

# Areas of concern
Use and exploitation of the system: Customer.
Specification and development: Solution.
The team and approach of work: Endeavor.

# What is an ALPHA?
- Alpha is an acronym for an Abstract-Level Progress Health Attribute.
- A critical indicator of things that are most important to monitor and progress.

# The Kernel ALPHAs
Opportunity = a reason for developing the system. Ex: user need.
Stakeholders = an agent affected by the system. Ex. customer, project team.
Requirements = what the system must do. Ex. store data, be usable.
Software System = the system of hardware, data and software item. Ex. a TV.
Work = activity performed. Ex. test a GUI.
Team = the people engaged in the project. Ex. group 4.
Way of working = tailored set of practices. Ex. TDD, kick-off meeting.

# The structure of an ALPHA
An Alpha has different states, each state has a checklist of items that must be completed in other for the alpha to get to that state.

# Requirements- one of the alphas
What the software system must do to address the opportunity and satisfy the stakeholders.

# Requirements - states
Conceived = The need for a new system has been agreed.
Bounded = The purpose and theme of the new system are cileatr.
Coherent = The requirements provide a coherent description of the essential characteristics of the new system.
Acceptable = The requirements describe a system that is acceptable to the stakeholders.
Addressed = Enough of the requirements have been addressed to satisfy the need for a new system in a way that is acceptable to the stakeholders.
Fulfilled = The requirements have been addressed to fully satisfy the need for a new system.

# Checklist for requirements states
Requirements conceived:
- The initial set of stakeholders agrees that a system is to be produced.
- The stakeholders that will use the new system are identified.
- The stakeholders that will fund the initial work on the new system are identified.
- There is a clear opportunity for the new system to address.

# Software system States
- Architecture Selected: Architecture selected that address key technical risks and any applicable organizazional constraints.
- Demonstrable:
- Usable:
- Ready:
- Operational:
- Retired:

# Stakeholders States
- Recognized:
- Represented:
- Involved:
- In agreement:
- Satisfied for deployment:
- Satisfied in use:

# Opportunity States
- Identified:
- Solution needed:
- Value established:
- Viable:
- Addressed:
- Benefit accrued:

# Team States
- Seeded:
- Formed:
- Collaborating:
- Performing:
- Adjourned:

# Work States
- Initiated:
- Prepared:
- Started:
- Under control:
- Concluded:
- Closed:

# Way of working states:
- Principles established
- Foundation established
- In use
- In place
- Working well
- Retired

# What is the real situation
The plan is to determine the current state of the Alphas by checking if the states have been achieved or not.
You identify states by applying state cards.

# Tasks and Sub-Alphas
- Objectives
- To Do
- Doing
- Done

# Classification of concrete Activities
From earlier practice and/or theoretical studies
- Some are specified in a document
- Some are specified on a card
- Some are just mentioned
- Some are unspoken, common-ware

# Kernel competencies
- Stakeholder Representation
- Analysis
- Development
- Testing 
- Management
- Leadership

# Levels of competencies
Assists: Demonstrates a basic understanding of the concepts and can follow instructions.
Applies: Able to apply the concepts in simple contexts by routinely applying the experience gained so far. 
Masters: Able to apply the concepts in most contexts and has the experience to work without supervision. 
Adapts: Able to apply judgment on when and how to apply the concepts to more complex contexts. Can enable others to apply the concepts.
Innovates: A recognized expert, able to extend the concepts to new contexts and inspire others.

# Practical usage
- Make a rating of competency levels needed for the roles
- Make an (honest) individual rating
- Assign the best-fit roles
- Make a gap analysis
- Develop an education plan

# Steps to Essentialize a practice
- A repeatable approach to doing something with a specific purpose in mind
- Identify elements
- Identify things to watch, the alphas
- Draft relationships
- Add details
- Produce cards

For example, you could describe the practice of automated unit testing or having a kick-off meeting.

# Patterns describe (complex) solutions to typical problems
- Structure, e.g. organization of working space
- Resources, e.g. tools
- Roles, e.g programmer
- Checkpoints, e.g. a mile stone