# Essence - Alpha State Card Games - INSTRUCTIONAL GUIDE SEVEN GAMES

## INTRODUCTION
This instructional guide provides a brief introduction to the Alphas and presents seven different games that can be played with the Alpha State Cards by software development teams.
### What are Alphas?
Essence is a standard that defines the smallest set of concepts that are common to all software projects, aiming to help teams assess the health of their software endeavor and to improve their way of work- ing. The Essence Kernel manifests itself in practical tools and assets such as Alpha State Cards. Alphas represent key performance indicators for a software development project. They are entirely method, life-cycle, process, practice and even philosophy independent, so it doesn’t matter what your personal belief system is - they can apply to any type of software project.
The use of the Alphas, and the Alpa State Cards, has many benefits for individuals, teams and organiza- tions. These include helping you to:
- Understand where you are
- Understand what needs to be addressed
- Track progress and health
- Keep projects in balance and avoid catastrophic failures
- Form good sprint goals and other objectives
- Define practice independent checkpoints, milestones and lifecycles
The Alphas are incredibly powerful as they:
1) capture the key concepts involved in software engineering.
2) allow the progress and health of any software engineering endeavour to be tracked and assessed.
3) provide the common ground for the definition of software engineering methods and practices.
To read more about the Alphas, please refer to the Alpha State Card Reference Guide found under White Papers at www.ivarjacobson.com
### Alpha State Card Games
We typically use them on a wall or whiteboard to visually display where we are and what we want to focus on next.
Have a go yourself - this guide provides a selection of games that you can play to help your team and add a new dimension to your workshops. They include:
Progress Poker, Chase the State, Objective Go, Checkpoint Construction, Lifecycle Layout, Milestone Mapping, Health Monitoring

# Alpha State Card Game: Progress Poker
## Object of Play
Team members may have different opinions on where they are, or where they need to go next. The idea behind Progress Poker is simple. Individual Alphas are presented for assessment. After a period of discussion, each participant chooses from his or her own deck the numbered card that represents his or her estimate of the state that the Alpha is currently in. All estimates are kept private until each participant has chosen a card. At that time, all estimates are revealed and discussion can begin again.
Use this game to determine the state of any particular Alpha.
## Variations
The game can also be played with only one set of cards:
1) Lay the state cards for the Alpha under consideration out on the table, in order, in front of the players.
2) Each player considers the set of states and identifies the state that they believe the Alpha to be in.
3) The players then simultaneously raise their hands with the correct number of fingers raised to indicate the state they have selected. A closed fist is used to indicate the sixth state.
4) If all players have selected the same state card then there is consensus.
5) If the selected cards are different then the players with the least and most advanced states explain their reasoning.
6) Repeat from 3 until consensus emerges
Or without the cards at all. As for the previous variation but in this case each player has a copy of the Reference Guide to consult when identifying the appropriate state.
## Number of Players
Any, but typically teams of 3 to 9 will be the most effective.
## Equipment Needed
- Essential: 1 set of Alpha State Cards for each player
- Optional: An Alpha State Card Reference Guide
## Duration of Play
2 – 10 minutes.
## How to Play
1. Each player is given a set of state cards for the Alpha under consideration.
2. The Alpha card for the Alpha under consideration is placed in the center of the table.
3. Each player selects the state card that he or she thinks best represents the current state of the Alpha.
4. All members put their selected state card face down on the table.
5. When all are ready, they turn the state card face up.
If all players have selected the same state card then there is consensus.
7. If the selected cards are different then the players with the least and most advanced states explain their reasoning.
8. Repeat from 3 until consensus emerges
Optional step: @ state 6 then the players might want to consider the full checklists found in the Reference Guide.
## Strategy
Progress Poker is a good way to come to a consensus without spending too much time on any one topic. It allows, or forces, people to voice their opinions, thoughts and concerns. Pick the Alphas of concern to the group and focus on them. This game can be used in conjunction with “Chase the State” to determine the overall state of any software development effort. Once the current state of an Alpha is known then the next state to be achieved is obvious.

# Alpha State Card Game: Chase the State
## Object of Play
Often when developing software teams lose sight of the big picture, and don’t truly understand where they are.
This fast, structured retrospective enables a team to quickly understand where they are with regards to their software development. It does it in a holistic fashion that will complement any other progress measures in use, whether they are burn-ups, burn-downs or some form of earned value. It takes the blinkers off and forces the team to review all aspects of software development.
Use this game to determine the state of your software development efforts.
## Variations
The game can also be played by turning the cards over as the states are achieved. This enables the game to be played on a smaller surface.
## Strategy
The goal of this game is to quickly find out where the team thinks it is.
One strategy is to do two passes:
1. First pass – just intuitively reflect on each card with the team. Don’t worry too much about the detail of the checklist items on the cards.
2. Second pass – working backwards check off the individual items on the check lists.
## Number of Players
Any, but typically small teams will be the most effective.
## Equipment Needed
Essential: 1 set of Alpha State Cards
Optional: An Alpha State Card Reference Guide for each player
## Duration of Play
Up to 30 minutes, the further into the development the team are the longer the game will take as there will be more states to be considered.
## How to Play
1. Lay out the cards for each Alpha in a row on the table with the first state on the left and the final state on the right.
2. Starting with the first state of the first Alpha, walkthrough the checklist and ask the players if the team has achieved the state.
3. If the state has been achieved move the state card to the left. Continue with the next state until you reach a state that the team has not yet achieved, or you run out of states.
4. If it is not clear which state one of the Alphas is in then a quick round of Progress Poker can be used to help reach consensus.
5. Repeat for all Alphas.

# Alpha State Card Game: Objective Go
## Object of Play
Teams sometimes neglect to consider the overall health of their endeavor when setting the objectives for the next time period.
The idea behind Objective Go is simple – use the states of the Alphas as an aide memoir when considering where to go next. After establishing where the team is by playing “Chase the State”, candidate objectives can be identified by considering and selecting from the remaining states.
Use this game to identify high-level goals and objectives for your team.
## Number of Players
1 to 15.
## Equipment Needed
1 set of Alpha State Cards.
## Duration of Play
15 – 30 minutes.
## How to Play
1. Determine where you are by playing “Chase the State”. The end result should be that the states already achieved have been moved to the left and those remaining to be achieved moved to the right.
2. For each Alpha consider whether or not the current state is appropriate and whether or not it should be explicitly advanced during the next time period.
3. For each state change under consideration consider which of the check list items remain to be achieved and discuss what it would take to achieve them.
4. Where the team agrees to advance the state during the time period under consideration move the state into the middle. Rotate the card 90 degrees if the state is to act as stretch goal or if the team believes that the time period is too short to enable the state to be fully achieved.
## Variations
None that we have thought of – yet!
## Strategy
Objective Go is a simple way to ensure that a team’s objectives are balanced and that important aspects of software development are not overlooked when setting the teams short and long term objectives.
Be careful not to take on too much or expect the states to be progressed too quickly. Many of the state changes will take time to achieve but making the objective clear will accelerate the team’s progress and make sure that all the aspects of software development are given the attention they deserve.

# Alpha State Card Game: Checkpoint Construction
## Object of Play
Defining important check points in the conception, evolution, funding or deployment of a software system can be difficult to do in a practice-independent way. This often leads to checkpoints that focus on the way the team does its work and the documentation it produces rather than the results that it achieves. The use of the Alpha State Cards to define check points makes the checkpoints result focused, light-weight and practice independent. It also enables them to be used by any and all teams regardless of the development approach they are using.
Use this game to define practice independent checkpoints with automatically generated practice independent checklists.
## Number of Players
3-10.
## Equipment Needed
Essential: 1 set of Alpha State Cards
Optional: An Alpha State Card Reference Guide
## Duration of Play
5 – 15 minutes.
## How to Play
The players assume one of two roles when playing this game:
- Facilitator: leads the game and the resulting discussions
- Contributor: plays the game with the facilitator
The game is set up by the facilitator and played in two rounds.
Set Up:
1. The facilitator lays out the Alpha State cards on the table in front of the team.
2. The facilitator stands up and describes the check point to be constructed.
3. The team names the checkpoint.
Round 1 – Select the Alphas that will be inspected at the checkpoint:
4. Each player considers the set of Alphas and notes down which of them they believe should be checked at the checkpoint
5. The facilitator selects the first Alpha.
6. Using “thumbs up / thumbs down” the players indicate whether or not they believe the Alpha should be part of the checkpoint.
7. Where there isn’t a unanimous vote, on whether or not the Alpha should be included in the checkpoint, the facilitator selects one player from each camp to explain their reasoning and then the team votes again.
8. Repeat step 7 until consensus emerges or the facilitator steps in to close-down the discussion and accept the majority vote.
9. If the Alpha is not selected it is removed from the table.
10. The facilitator repeats steps 5 to 8 until all the Alphas have been considered.
Round 2 – Checkpoint definition:
11. The facilitator lays out the Alpha state cards, for the selected Alphas, in rows on the table with the first state on the left and the final state on the right.
12. Each player considers the set of states and, without informing the other players, identifies the state that they believe the Alpha needs to be in to pass the checkpoint.
13. The players then simultaneously raise their hands with the correct number of fingers raised to indicate the state they have selected. A closed fist is used to indicate the sixth state.
14. If all players have selected the same state then there is consensus.
15. If the selected states are different then the players with the least and most advanced states explain their reasoning.
16. Repeat from 12 until consensus emerges
17. The facilitator removes all the other cards to the left and right of the selected state from the row.
18. Once the state is identified then the facilitator leads a review of the checklist items to 1) identify whether or not the individual checklist items are appropriate and 2) identify any additional checklist items need to be added. This allows the generic checklist provided by the cards to be tailored to the specific context within which the check point will be applied.
19. Add any additional checklist items to the card.
## Strategy
Checkpoint Construction is a great way to analyze any of the organizationally defined checkpoints, phase gates, or pre-defined lifecycle milestones such as Decision to Fund, Initial Operational Capability, or Ready to Release. Focus on those checkpoints that are integral to the governance and/or quality assurance of your software development activities.

# Alpha State Card Game: Lifecycle Layout
## Object of Play
Organizations often require teams to use a standard software development or application management lifecycle. Often these are defined in a way that overly restricts the freedom of the development teams, and focus on the specific work products to be produced rather than the results or state to be achieved. Using the Alpha State cards this can be done in a lightweight, result focused way that is independent of the practice that the team selects to achieve the goals.
Use this game to visualize your software development lifecycle to form a starting point for team planning.
## Number of Players
3-10.
## Equipment Needed
1 set of Alpha State Cards.
## Duration of Play
15 – 30 minutes.
## How to Play
This is a composite game involving several rounds of Checkpoint Construction to define a series of checkpoints that represent the review points in the lifecycle. In this case though all Alphas must be considered.
The players assume one of two roles when playing this game:
- Facilitator: leads the game and the resulting discussions
- Contributor: plays the game with the facilitator
The game is set up by the facilitator and played in over a number of rounds.
Set Up:
1. The facilitator lays out the Alpha State cards on the table in front of the team.
2. The facilitator stands up and describes the lifecycle to be constructed, clearly identifying the point at which the lifecycle starts and any checkpoints inherent in the proposed lifecycle.
Round 1 – Define the start of the lifecycle:
3. The facilitator leads the team through a game of Checkpoint Construction to establish the starting point / entry criteria for the lifecycle.
4. The state cards subsequent to the starting point / entry criteria are then moved to the right. Make sure that there is clear white space left between the two sets of cards.
5. For each state to be achieved at the checkpoint review whether or not it is mandatory or just recommended. In this case mandatory means that the lifecycle could not be started if the state is not achieved. If the state is not mandatory rotate the card 90 degrees to indicate that it is a “nice-to-have”.
Rounds 2-N – Define the remaining checkpoints that make up the lifecycle:
6. The facilitator leads the team through a game of Checkpoint Construction to establish the exit criteria for the next checkpoint in the lifecycle.
7. The state cards to be achieved after the checkpoint is reached are moved to the right. Make sure that there is clear white space left between the two sets of cards.
8. Tidy up the state cards that represent the checkpoint (those left in the middle) so that the right hand edges of all the final states to be achieved at the milestone are aligned.
9. For each state to be achieved at the checkpoint review whether or not it is mandatory or just recommended. In this case mandatory means that the lifecycle could not be started if the state is not achieved. If the state is not mandatory rotate the card 90 degrees to indicate that it is a “nice-to-have”.
Final Round:
10. Review the lifecycle as a whole and adjust as necessary.
## Variations
The game can be simplified by preparing a simple game board out of flip chart paper. Stick two or three sheets of flip chart paper together to form an extra long sheet. .Divide the paper by drawing a number of equally spaced lines to represent the checkpoints and / or phases in your lifecycle. The cards can then be aligned with these pre-drawn lines to layout your lifecycle.
# Strategy
This is a variation on the game Checkpoint Construction where instead of just identifying a single checkpoint the team uses the cards to identify a series of checkpoints to define a specific lifecycle, or variation on a lifecycle. Unlike Checkpoint Construction all of the Alphas must be considered at every checkpoint.

# Alpha State Card Game: Milestone Mapping
## Object of Play
When given a major piece of development work teams may want to identify some intermediate milestones to help improve their estimates and plans. This is particularly useful when the development involves high levels of innovation such as new teams, new ways of working, new technologies, new business domains, or new business partners.
Use this game to visualize your milestones and form a light-weight roadmap for your software development.
## Number of Players
Any, but typically teams of 3 to 9 will be the most effective.
## Equipment Needed
1 set of Alpha State Cards.
## Duration of Play
15 – 45 minutes.
## How to Play
1. Determine where you are by playing “Chase the State”. The end result should be that the states already achieved have been moved to the left and clearly separated from those remaining to be achieved.
2. Start with the next milestone to be reached.
3. For each Alpha identify the state that the Alpha should be in when the milestone is achieved:
a. If the state is not the final state of the Alpha move all the remaining state cards to the right
b. If the state at the next milestone is the same as the current state move all the Alpha states cards to the right.
4. Tidy up the state cards that represent the milestone (those left in the middle) so that the right hand edges of all the final states to be achieved at the milestone are aligned.
5. For each state to be achieved by the milestone, review whether or not it is mandatory or just recommended. In this case mandatory means that the milestone would be failed if the state is not achieved. If the state is not mandatory rotate the card 90 degrees to indicate that it is a “nice-to-have”.
6. Repeat steps 3 to 5 for all subsequent milestones.
7. Review the set of milestones as a whole and adjust to balance the work to be done against the proposed time-table.
## Variations
None that we have thought of – yet!
## Strategy
This is a variation on the game Objective Go where instead of just identifying the next objective the team uses the cards to identify a series of milestones for inclusion in their project or release plan.

# Alpha State Card Game: Health Monitoring
## Object of Play
Information radiators are a great way to help everyone understand what is going on, what is important, and how the team is progressing. The Alpha State Cards can be used to create a simple, intuitive state board that helps a team monitor its progress and health. Use this game to visually track the health of your endeavor regardless of the practices or method being used.
## Number of Players
3-10.
## Equipment Needed
- 1 set of Alpha State Cards
- A “board” to mount the cards on
## Duration of Play
Set Up: Up to 30 minutes.
Update: 30 minutes every 2 weeks
Overall: the board is in play until the work is completed
## How to Play
This is a composite game that involves setting up a permanent state board as shown below and 1) playing “Chase the State” to set the initial state and then 2) regularly revisiting the board to keep the state visualization up to date.
Setting up the board:
1. Using a white board or two sheets of flip chart paper set up the full deck of cards as shown above, with all state cards on the far right.
2. Play “Chase the State” to establish the current state of the development. Moving the completed states to the left of the board.
Keeping the board up to date
3. At regular periods, possibly as part of the daily stand up, a retrospective or completing a piece of work the team should check off the check list items on the cards and whenever a state is completed move it to the left of the board.
Highlighting areas of concern:
4. At regular periods, typically as part of a retrospective, the team should evaluate how healthy they think each Alpha is.
5. If the team thinks an Alpha is healthy and in appropriate state, adorn the alpha card with a green sticker or sticky note.
6. If the team thinks an Alpha is unhealthy or in an inappropriate state, adorn the alpha card with a red sticker or sticky note. If a sticky note is used write the reason why the team thinks the Alpha is unhealthy onto it.
7. If the team can’t agree whether or not the Alpha is healthy then adorn the Alpha card with an orange sticker or sticky note. If a sticky note is used write the reasons why the team thinks the Alpha isn’t healthy on it.
Showing the next objective:
8. If desired the team can highlight their next objective by playing “Objective Go” using the cards on the board and positioning the target states in the middle between those achieved and those remaining.
## Variations
The game can be combined with the results of other games to do:
- Checkpoint Checking – at any time the state shown on the board can be compared against any applicable checkpoint that has been defined by playing “Checkpoint Construction”.
- Lifecycle Tracking – at any time the state on the board can be compared against any applicable lifecycle that has been defined by playing “Lifecycle Layout”.
- Milestone Tracking - at any time the state on the board can be compared against any applicable milestones that have been defined by playing “Milestone Mapping”.
## Strategy
This game builds on the results of many of the other games to provide teams with a simple intuitive information radiator showing the progress and health of the development effort.