import createScatterplot from "./node_modules/regl-scatterplot/dist/regl-scatterplot.esm.js";
import { decompress } from "compress-json";
import chroma from "chroma-js";

document.addEventListener("DOMContentLoaded", () => {
  console.info("EvoScat v0.99");

  const canvas = document.querySelector("canvas");

  const { width, height } = canvas.getBoundingClientRect();

  const CLASS_COLORS = `
#FF4A46
#FF34FF
#FFFF00
#008941
#1966FF
#1CFFD9
#C00069
#FFDBE5
#FF9900
#8148D5
#FF0066
#00C2A0
#FFA6FE
#A42400
#320033
#00AEFF
#D16100
#B6FF00
#6C00E8
#f2c0a2
#e98472
#d82323
#98183c
#1fcb23
#126d30
#26dddd
#1867a0
#934226
#6c251e
#f7e26c
#edb329
#e76d14
#7f7fc3
#6a5fa0
#161423
`
    .split("\n")
    .map((c) => c.trim())
    .filter((c) => c.length > 0);

  const CLASS_COLORS_NEW = CLASS_COLORS;

  const DELTA_COLORS_9 = `
  #98183c
#FF4A46
#6C00E8
#FFA6FE
#00AEFF
#edb329
#B6FF00
#1fcb23
#126d30
`
    .split("\n")
    .map((c) => c.trim())
    .filter((c) => c.length > 0);

  const DELTA_COLORS = `
#FF4A46
#00AEFF
#1fcb23
`
    .split("\n")
    .map((c) => c.trim())
    .filter((c) => c.length > 0);

  const META_METADATA = ["Metric", "Year", "File Extension", "Metric Delta"];

  //index into the metadata to be used for coloring
  let METADATA = 3;

  let scale = chroma
    .scale(["green", "blue", "yellow", "black", "orange", "red", "purple"])
    .domain([0, 1, 16, 32, 128, 512, 1024]);

  let col_ranges = { min: 0, max: 1024 };

  const scatterplot = createScatterplot({
    canvas,
    width,
    height,
    aspectRatio: width / height,
    pointSize: 1,
    //   pointColor: Array.from({length:512}).map((_,i)=>scale(i).hex()),
    // pointColor: CLASS_COLORS,
    colorBy: "valueZ",
    opacityBy: "density",
    pointColor: "#000000",
    //   pointColor: ['#FFFFFF', '#FF0000', '#00FF00'],
    //   pointSize: [1,2],
    //   opacity: 0.5,
  });

  scatterplot.set({ showReticle: true, reticleColor: [1, 0, 0, 0.66] });
  scatterplot.set({ cameraTarget: [1, 0.5], cameraDistance: 0.5 });

  // SS: Camera zoom-out limit .. comment out to disable limiting the zoom-out
  const MAX_ZOOM_OUT = 1.0;
  scatterplot.subscribe("view", (view) => {
    if (view.cameraDistance > MAX_ZOOM_OUT) {
      scatterplot.set({ cameraDistance: MAX_ZOOM_OUT });
    }
  });

  let points = [];
  let index = 0;

  //let source = ["points_age_wave_filtered_2.json","points_age_wave.json", "points_age.json", "points_wave_filter_10.json", "points_wave_filter_5.json", "points_wave_filter_4.json", "points_wave_filter_3.json", "points_wave_filter_2.json", "points_wave_filter_1.json", "points_wave.json", "points_first.json", "points_last.json", "points_wave_last.json", "points_count.json", "points_ndatesum.json", "points_methods_count.json"];

  // let source = ["points_first.json", "points_last.json", "points_count.json", "points_methods_count.json", "points_wave.json", "points_ndatesum.json"];

  // [1,5,10,20].forEach(MIN_COMMITS=>{
  //     source.push(`points_age_filtered_${MIN_COMMITS}.json`);
  // });

  // [1,2,3,4,5,10,20].forEach(MIN_COMMITS=>{
  //     source.push(`points_wave_filtered_${MIN_COMMITS}.json`);
  // });

  // generate the possible precomputed points arrays from the select box
  let source = Array.from(document.querySelector("#artifact").options)
    .map((o) => o.value)
    .sort()
    .map((v) => [
      `points_${v}.json`,
      `points_${v}_normage.json`,
      `points_${v}_normage_center.json`,
      `points_${v}_normage_reverse.json`,
      `points_${v}_normtime.json`,
    ])
    .flat();
  /*
  let source = `points_age.json
points_age_normage.json
points_age_normage_center.json
points_age_normage_reverse.json
points_age_normtime.json
points_commit_similar_age.json
points_commit_similar_age_normage.json
points_commit_similar_age_normage_center.json
points_commit_similar_age_normage_reverse.json
points_commit_similar_age_normtime.json
points_commit_similar_date.json
points_commit_similar_date_normage.json
points_commit_similar_date_normage_center.json
points_commit_similar_date_normage_reverse.json
points_commit_similar_date_normtime.json
points_commit_similar_hc_date.json
points_commit_similar_hc_date_normage.json
points_commit_similar_hc_date_normage_center.json
points_commit_similar_hc_date_normage_reverse.json
points_commit_similar_hc_date_normtime.json
points_commit_similar_normalage.json
points_commit_similar_normalage_normage.json
points_commit_similar_normalage_normage_center.json
points_commit_similar_normalage_normage_reverse.json
points_commit_similar_normalage_normtime.json
points_count.json
points_count_normage.json
points_count_normage_center.json
points_count_normage_reverse.json
points_count_normtime.json
points_delta_methods_wave2_count.json
points_delta_methods_wave2_count_normage.json
points_delta_methods_wave2_count_normage_center.json
points_delta_methods_wave2_count_normage_reverse.json
points_delta_methods_wave2_count_normtime.json
points_delta_methods_wave_count.json
points_delta_methods_wave_count_normage.json
points_delta_methods_wave_count_normage_center.json
points_delta_methods_wave_count_normage_reverse.json
points_delta_methods_wave_count_normtime.json
points_first.json
points_first_normage.json
points_first_normage_center.json
points_first_normage_reverse.json
points_first_normtime.json
points_index.json
points_index_normage.json
points_index_normage_center.json
points_index_normage_reverse.json
points_index_normtime.json
points_last.json
points_last_normage.json
points_last_normage_center.json
points_last_normage_reverse.json
points_last_normtime.json
points_methods_count.json
points_methods_count_avg.json
points_methods_count_avg_normage.json
points_methods_count_avg_normage_center.json
points_methods_count_avg_normage_reverse.json
points_methods_count_avg_normtime.json
points_methods_count_first.json
points_methods_count_first_normage.json
points_methods_count_first_normage_center.json
points_methods_count_first_normage_reverse.json
points_methods_count_first_normtime.json
points_methods_count_last.json
points_methods_count_last_normage.json
points_methods_count_last_normage_center.json
points_methods_count_last_normage_reverse.json
points_methods_count_last_normtime.json
points_methods_count_normage.json
points_methods_count_normage_center.json
points_methods_count_normage_reverse.json
points_methods_count_normtime.json
points_methods_similar_hc_count.json
points_methods_similar_hc_count_normage.json
points_methods_similar_hc_count_normage_center.json
points_methods_similar_hc_count_normage_reverse.json
points_methods_similar_hc_count_normtime.json
points_methods_similar_count.json
points_methods_similar_count_normage.json
points_methods_similar_count_normage_center.json
points_methods_similar_count_normage_reverse.json
points_methods_similar_count_normtime.json
points_methods_wave_count.json
points_methods_wave_count_normage.json
points_methods_wave_count_normage_center.json
points_methods_wave_count_normage_reverse.json
points_methods_wave_count_normtime.json
points_delta_class_number.json
points_delta_class_number_normage.json
points_delta_class_number_normage_center.json
points_delta_class_number_normage_reverse.json
points_delta_class_number_normtime.json
points_double_delta.json
points_double_delta_normage.json
points_double_delta_normage_center.json
points_double_delta_normage_reverse.json
points_double_delta_normtime.json
points_double_delta2.json
points_double_delta2_normage.json
points_double_delta2_normage_center.json
points_double_delta2_normage_reverse.json
points_double_delta2_normtime.json
points_mid.json
points_mid_normage.json
points_mid_normage_center.json
points_mid_normage_reverse.json
points_mid_normtime.json
points_ndatesum.json
points_ndatesum_normage.json
points_ndatesum_normage_center.json
points_ndatesum_normage_reverse.json
points_ndatesum_normtime.json
points_ext_path.json
points_ext_path_normage.json
points_ext_path_normage_center.json
points_ext_path_normage_reverse.json
points_ext_path_normtime.json
points_file_path.json
points_file_path_normage.json
points_file_path_normage_center.json
points_file_path_normage_reverse.json
points_file_path_normtime.json
points_short_extension.json
points_short_extension_normage.json
points_short_extension_normage_center.json
points_short_extension_normage_reverse.json
points_short_extension_normtime.json
points_wave.json
points_wave_normage.json
points_wave_normage_center.json
points_wave_normage_reverse.json
points_wave_normtime.json
`.trim().replaceAll("_middle", "_center").split("\n");

*/

  // source = ["points_first.json"];

  // let normtime = source.map(f=>f.replace(".json","_normtime.json"));
  // let normage = source.map(f=>f.replace(".json","_normage.json"));

  // source = source.concat(normtime).concat(normage);

  // source = source.sort().map(f=>`output/icwe2021/${f}`);
  // source = source.sort().map(f=>`output/wfgh3/${f}`);

  // let DATAURL = "output/apis/";
  // let DATAURL = "output/oas5/";
  // let DATAURL = "output/vscode/";
  // let DATAURL = "output/bitcoin/";
  // let DATAURL = "output/wfgh3/";
  // let DATAURL = "output/node/";

  //extract dataset from URL parameter first
  let LINK_DATASET = new URL(window.location).searchParams.get("dataset");

  const wurl = window.location.href.replace("#", "?");
  const wparams = new URL(wurl).searchParams;
  const DATASET = LINK_DATASET || wparams.get("dataset") || "bitcoin";
  const TSORT = wparams.get("time");
  const ASORT = wparams.get("artifact");
  const COLOR = wparams.get("color");

  if (TSORT != null) {
    document.querySelector("#time").value = TSORT ? TSORT : 'absolute';
  }
  if (ASORT != null) {
    document.querySelector("#artifact").value = ASORT ? ASORT : "age";
  }
  if (COLOR != null) {

    let color2radio = {
      "year": "radio_echart_years",
      "ext": "radio_echart_extensions",
      "delta": "radio_echart_delta",
      "metric": "radio_echart_methods_count",
    }

    let radio = document.querySelector("#"+color2radio[COLOR]);

    if (radio != null) {
      document.addEventListener("loaded", () => {
        radio.checked = true;
        radio.dispatchEvent(new Event('change', { bubbles: true }));
      }, { once: true });
    } else {
      if (COLOR !== "null") {
        document.addEventListener("loaded", () => {
          scatterplot.set({ pointColor: COLOR }); //a bit risky to inject the color like this
        }, { once: true });
      } else {
        scatterplot.set({ pointColor: "#000" });
      }
    }
  }

  // https://stackoverflow.com/questions/14068002/chrome-chromium-gives-404-for-page-that-exists
  const DATAURL = `output-compressed/${DATASET}/`;

  source = source.sort().map((f) => `${DATAURL}${f}`);

  let points_map;
  let points_t;
  let points_metadata;

  function done(opt = makeTransitionOpt()) {
    let current_index = index;

    if (points[current_index] !== undefined && points_metadata !== undefined) {
      really_done(opt);
      return;
    }
    // document.querySelector("h1").innerHTML = "Loading " + source[index] + " " + index + "/" + source.length;

    let url = source[current_index];
    fetch(url)
      .then((res) => res.json())
      .then((p) => {
        let points_data = decompress(p);

        // fetch(url.replace("_map.json", "_metadata.json")).then(res => res.json()).then(p => {
        fetch(DATAURL + "metadata.json")
          .then((res) => res.json())
          .then((p) => {
            points_metadata = decompress(p);

            points[current_index] = rescale(points_data, points_metadata);

            // console.log(points[current_index]);
          }).catch((e) => {
            points[current_index] = rescale(points_data, []); //try to plot without metadata
          }).finally(() => {
            really_done(opt);
          });
        // scatterplot.set({pointColor: colorify(points[i]).reverse(), colorBy: 'valueA', opacityBy: 'density'});

        // scatterplot.draw(points[index]);
      });

    // reduce to _map.json
    url = url
      .replace(".json", "_map.json")
      .replace("_normage_reverse", "")
      .replace("_normage_center", "")
      .replace("_normtime", "")
      .replace("_normage", "");

    fetch(url)
      .then((res) => res.json())
      .then((p) => {
        points_map = decompress(p);
        //used by the mouseover
      });

    fetch(url.replace("_map.json", "_t.json"))
      .then((res) => res.json())
      .then((p) => {
        points_t = decompress(p);
        //used by the mouseover
      });
  }

  // let p = source.map((f,i)=>{

  //     return fetch(f).then(res=>res.json()).then(p=>{

  //         points[i] = rescale(p);

  //         document.querySelector("h1").innerHTML = f + " " + i + "/" + source.length;
  //         // scatterplot.set({pointColor: colorify(points[i]).reverse(), colorBy: 'valueA', opacityBy: 'density'});

  //         // scatterplot.draw(points[index]);
  //     });

  // });

  //make the year start from 0
  function rescale(points, points_metadata) {
    let { min, max } = points_metadata.reduce(
      (acc, val) => ({
        min: Math.min(acc.min, val[METADATA]),
        max: Math.max(acc.max, val[METADATA]),
      }),
      { min: Infinity, max: -Infinity }
    );

    // console.log(min, max);

    let shifted = points_metadata.map((p) => p[METADATA] - min);

    let normalized = points_metadata.map(
      (p, i) => (p[METADATA] - min) / (max - min)
    );

    // {

    //     let {min,max} = points.reduce((acc, val) => ({
    //       min: Math.min(acc.min, val[2]),
    //       max: Math.max(acc.max, val[2]),
    //     }), { min: Infinity, max: -Infinity });

    //     console.log(min,max);

    //     document.querySelector("#threshold").min = min;
    //     document.querySelector("#threshold").max = max;

    //     document.querySelector("#thresholdMin").min = min;
    //     document.querySelector("#thresholdMin").max = max;

    //     document.querySelector("#thresholdMax").min = min;
    //     document.querySelector("#thresholdMax").max = max;

    //     col_ranges.min = min;
    //     col_ranges.max = max;

    // }

    return {
      x: points.map((p) => p[0]),
      y: points.map((p) => p[1]),
      z: points.map((p, i) => shifted[i]),
      w: points.map((p, i) => normalized[i]),
    };
  }

  function switchMetadata(i) {
    if (METADATA == i) return;

    METADATA = i;

    let points_data = points[index].x.map((x, i) => [x, points[index].y[i]]);

    points[index] = rescale(points_data, points_metadata);

    really_done();
  }

  // Promise.all(p).then(done);

  function really_done(opt = makeTransitionOpt()) {
    // document.querySelector("h1").innerHTML = index + "/" + points.length + " " + source[index];

    // scatterplot.set({pointColor: colorify(points[index]).reverse(), colorBy: 'valueA', opacityBy: 'density'});

    if (opt.transition == undefined) {
      // console.log(points[index]);

      scatterplot.draw(points[index]);
    } else {
      scatterplot.draw(points[index], opt);
    }

    let tselect = document.getElementById("time");
    tselect.value = "absolute";
    for (let option of tselect.options) {
      if (source[index].includes(option.value)) {
        option.selected = true;
        break;
      }
    }

    let aselect = document.getElementById("artifact");
    let ao = Array.from(aselect.options).sort(
      (a, b) => a.value.length - b.value.length
    );
    ao.forEach((option) => {
      if (source[index].includes(option.value)) {
        option.selected = true;
      }
    });

    document.getElementById("loading").style.display = "none";

    const loadedEvent = new Event("loaded");
    document.dispatchEvent(loadedEvent);
  }

  function makeTransitionOpt() {
    let opt = {};

    opt.transitionDuration =
      1 + document.querySelector("#transition").value * 500;

    opt.transition = opt.transitionDuration > 0;

    return opt;

    // return {transition: true, transitionDuration: document.querySelector("#transition").value * 500};
  }

  function switchPoints() {
    document.getElementById("loading").style.display = "flex";

    let tselect = document.getElementById("time");
    let selectedT = tselect.value;

    let aselect = document.getElementById("artifact");
    let selectedA = aselect.value;

    if (selectedT == "absolute") selectedT = "";
    else selectedT = "_" + selectedT;

    let src = "points_" + selectedA + selectedT;

    index = source.findIndex((s) => s.includes(src));

    if (index !== -1) {
      done();

      saveState();
    } else {
      console.error("No source found for " + src);
    }
  }

  document.querySelector("#time").addEventListener("input", switchPoints);
  document.querySelector("#artifact").addEventListener("input", switchPoints);

  document.querySelector("#next").addEventListener("click", () => {
    index = (index + 1) % points.length;

    done();
  });

  let color_maps = [CLASS_COLORS, CLASS_COLORS_NEW];
  let color_map_index = 0;

  document.querySelector("#col").addEventListener("click", () => {
    console.log(scatterplot.get("colorBy"));

    if (scatterplot.get("colorBy") == "valueZ") {
      color_map_index = (color_map_index + 1) % color_maps.length;
      let CLASS_COLORS = color_maps[color_map_index];
      scatterplot.set({ colorBy: "valueW", pointColor: CLASS_COLORS });
    } else {
      scatterplot.set({
        colorBy: "valueZ",
        pointColor: Array.from({ length: 1024 }).map((_, i) => scale(i).hex()),
      });
    }
  });

  document.querySelector("#prev").addEventListener("click", () => {
    index = (index - 1) % points.length;

    if (index < 0) {
      index += points.length;
    }

    done();
  });

  document.querySelector("#zoom_home").addEventListener("click", () => {
    // scatterplot.zoomToOrigin();
    scatterplot.zoomToLocation([1, 0.5], 0.5, makeTransitionOpt());
  });

  function colorify(points) {
    let a = Array.from(new Set(points.map((p) => p[2])));

    const { min, max } = a.reduce(
      (acc, val) => ({
        min: Math.min(acc.min, val),
        max: Math.max(acc.max, val),
      }),
      { min: Infinity, max: -Infinity }
    );

    let scale = chroma.scale(["red", "blue", "white"]).domain([min, max]);

    let colors = a.map((p) => scale(p).hex());

    // console.log(colors);

    points.forEach((p) => {
      p[3] = a.indexOf(p[2]);
    });

    // console.log(points);

    return colors;
  }

  function downloadBlob(blob, name, done) {
    const link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = name;

    document.body.appendChild(link);

    link.dispatchEvent(
      new MouseEvent("click", {
        bubbles: true,
        cancelable: true,
        view: window,
      })
    );

    document.body.removeChild(link);

    done();
  }

  function saveAsPng(done) {
    const imageObject = new Image();
    imageObject.onload = () => {
      scatterplot.get("canvas").toBlob((blob) => {
        downloadBlob(
          blob,
          "evoscat-" +
            DATASET +
            "-" +
            document.querySelector("#artifact").value +
            "-" +
            document.querySelector("#time").value +
            ".png",
          done
        );
      });
    };
    imageObject.src = scatterplot.get("canvas").toDataURL();
  }

  document.querySelector("#png").addEventListener("click", (event) => {
    saveAsPng(() => {
      console.log("done");
    });
  });

  //Color picker

  let colorMap = (e) => {
    let colorMin = document.querySelector("#colorMin").value;
    let colorMax = document.querySelector("#colorMax").value;
    let colorThreshold = document.querySelector("#colorThreshold").value;

    let threshold = parseInt(document.querySelector("#threshold").value);
    let thresholdMin = parseInt(document.querySelector("#thresholdMin").value);
    let thresholdMax = parseInt(document.querySelector("#thresholdMax").value);

    if (e.target.id == "threshold_txt") {
      threshold = parseInt(document.querySelector("#threshold_txt").value);
      document.querySelector("#threshold").value = threshold;
    }
    if (e.target.id == "threshold_Min_txt") {
      thresholdMin = parseInt(
        document.querySelector("#threshold_Min_txt").value
      );
      document.querySelector("#thresholdMin").value = thresholdMin;
    }
    if (e.target.id == "threshold_Max_txt") {
      thresholdMin = parseInt(
        document.querySelector("#threshold_Max_txt").value
      );
      document.querySelector("#thresholdMax").value = thresholdMin;
    }

    scale = chroma
      .scale([colorMin, colorThreshold, colorMax])
      .domain([thresholdMin, threshold, thresholdMax]);

    scatterplot.set({
      colorBy: "valueZ",
      pointColor: Array.from({ length: thresholdMax }).map((_, i) =>
        scale(i).hex()
      ),
    });

    if (e.target.type == "range") {
      document.querySelector("#threshold_Min_txt").value = thresholdMin;
      document.querySelector("#threshold_txt").value = threshold;
      document.querySelector("#threshold_Max_txt").value = thresholdMax;
    }
  };

  document.querySelector("#threshold").addEventListener("input", colorMap);
  document.querySelector("#colorMin").addEventListener("input", colorMap);
  document.querySelector("#colorMax").addEventListener("input", colorMap);
  document.querySelector("#colorThreshold").addEventListener("input", colorMap);
  document.querySelector("#thresholdMin").addEventListener("input", colorMap);
  document.querySelector("#thresholdMax").addEventListener("input", colorMap);
  document
    .querySelector("#threshold_Min_txt")
    .addEventListener("input", colorMap);
  document.querySelector("#threshold_txt").addEventListener("input", colorMap);
  document
    .querySelector("#threshold_Max_txt")
    .addEventListener("input", colorMap);

  fetch(DATAURL + "stats.json")
    .then((res) => res.json())
    .then((stats) => {
      renderStats(stats);
    });

  function formattedNumber(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, "'");
  }

  function renderStats(stats) {
    let statsDiv = document.querySelector("#stats-content");

    let name = DATASET;

    let link = document.querySelector("#"+DATASET);
    if (link != null) {
      let provenance = link.dataset.src;
      name = `<a href="${provenance}" target="_blank">${link.textContent}</a>`;
    }

    statsDiv.innerHTML = `
  <div><span class="stats-title">Name</span><span class="stats-description">${name}</span></div>
  <div><span class="stats-title">Number of Events</span><span class="stats-description">${formattedNumber(
    stats.commit_count
  )}</span></div>
  <div><span class="stats-title">Number of Commits</span><span class="stats-description">${formattedNumber(
    stats.distinct_dates
  )}</span></div>
  <div><span class="stats-title">Number of Artifacts</span><span class="stats-description">${formattedNumber(
    stats.api_count
  )}</span></div>
  <div><span class="stats-title">Age Range</span><span class="stats-description">${formattedNumber(
    Math.trunc(stats.range_date)
  )} days / ${formattedNumber(
      Math.trunc(stats.range_date / 365)
    )} years</span></div>
  <div><span class="stats-title">First Timestamp</span><span class="stats-description">${new Date(
    stats.min_date
  ).toLocaleString("en-us", {
    dateStyle: "medium",
    timeStyle: "medium",
    hour12: false,
  })}</span></div>
  <div><span class="stats-title">Last Timestamp</span><span class="stats-description">${new Date(
    stats.max_date
  ).toLocaleString("en-us", {
    dateStyle: "medium",
    timeStyle: "medium",
    hour12: false,
  })}</span></div>
    `;
    // console.log(Number(formattedNumber(Math.trunc(stats.range_date))));
    // console.log(formattedNumber(Math.trunc(stats.range_date)));
  }

  scatterplot.subscribe("pointOver", (e) => {
    const toFixed = (n, fixed) =>
      `${n}`.match(new RegExp(`^-?\\d+(?:\.\\d{0,${fixed}})?`))[0];

    let track = document.querySelector("#mousetrack");

    let pp = points[index];
    let p = [pp.x[e], pp.y[e], pp.z[e], pp.w[e]];
    let pFormatted = [
      `X: ${toFixed(pp.x[e], 6)}`,
      `Y: ${toFixed(pp.y[e], 6)}`,
      toFixed(pp.z[e], 4),
      toFixed(pp.w[e], 4),
    ];

    // console.log(points[index][e]);

    track.innerHTML = pFormatted.join(", ");

    let artifact = document.querySelector("#mouseartifact");

    artifact.innerHTML = points_map.find((p2) => p2[0] === p[0])[1];

    let timestamp = document.querySelector("#timestamp");

    timestamp.innerHTML = parseDate(points_t[e], "dd/mm/yyyy hh:rr:ss");

    let metric = document.querySelector("#mousemetric");

    metric.innerHTML = [0, 1, 2, 3].reduce((acc, val) => {
      let p = points_metadata[e][val];

      if (val == 2) {
        p = META_EXTENSIONS[p];
      }

      return acc + `<span>${META_METADATA[val]}: ${p}</span> `;
    }, "");
  });

  function parseDate(input, format) {
    format = format || "dd.mm.yyyy";
    let parts = input.match(/(\d+)/g),
      i = 0,
      fmt = {};

    format.replace(/(yyyy|dd|mm|hh|rr|ss)/g, function (part) {
      fmt[part] = i++;
    });
    return new Date(
      parts[fmt["yyyy"]],
      parts[fmt["mm"]] - 1,
      parts[fmt["dd"]],
      parts[fmt["hh"]],
      parts[fmt["rr"]],
      parts[fmt["ss"]]
    ).toLocaleString("en-us", {
      dateStyle: "medium",
      timeStyle: "medium",
      hour12: false,
    });
  }

  let META_EXTENSIONS = [];

  //echarts
  document.getElementById("loading").style.display = "flex";

  fetch(DATAURL + "hist_extensions.json")
    .then((res) => res.json())
    .then((stats) => {
      fetch(DATAURL + "extensions.json")
        .then((res) => res.json())
        .then((keys) => {
          META_EXTENSIONS = keys;

          renderEcharts(
            "echart_extensions",
            stats,

            //TODO improve initial color scale
            (d, i) => (i < CLASS_COLORS.length ? CLASS_COLORS[i] : "black"),

            keys
          );
        }).catch((e) => {
          console.error("Error loading extensions.json, hiding the histogram", e);
          document.getElementById("echart_extensions").parentNode.style.display = "none";
        });
    });

  fetch(DATAURL + "hist_methods_count.json")
    .then((res) => res.json())
    .then((stats) => {
      renderEcharts(
        "echart_methods_count",
        stats.map((d) => d[1]),

        //TODO improve initial color scale
        (d, i) => (i < CLASS_COLORS.length ? CLASS_COLORS[i] : "black"),

        stats.map((d) => d[0])
      );
    });

  fetch(DATAURL + "hist_years.json")
    .then((res) => res.json())
    .then((stats) => {
      renderEcharts(
        "echart_years",
        stats,

        (d, i) => CLASS_COLORS[i % CLASS_COLORS.length]
      );
    });

  fetch(DATAURL + "hist_delta_methods_counts.json")
    .then((res) => res.json())
    .then((stats) => {
      renderEcharts(
        "echart_delta",
        stats,

        (d, i) => DELTA_COLORS[i % DELTA_COLORS.length],

        ["<0", "0", ">0"]
      );
    });

  function renderEcharts(id, stats, colormap, keys) {
    let chart = echarts.init(document.getElementById(id));
    // resize the chart

    let option = {
      grid: {
        top: 30,
        right: 0,
        bottom: 80,
        left: 0,
        containLabel: true,
      },
      dataZoom: [
        {
          id: "dataZoomX",
          type: "slider",
          xAxisIndex: [0],
          filterMode: "filter",
        },
      ],
      xAxis: {
        type: "category",
        data: keys || Object.keys(stats),
      },
      yAxis: {
        type: "value",
      },
      series: [
        {
          data: Object.values(stats).map((d, i) => ({
            value: d,
            itemStyle: {
              color: colormap(d, i),
            },
          })),
          type: "bar",
        },
      ],
    };

    chart.setOption(option);

    chart.resize();

    //not sure about this
    new ResizeObserver(() => chart.resize()).observe(document.querySelector("#"+id));

    //this helps a bit
    window.addEventListener("resize", () => {
      chart.resize();
    });

    const picker = document.querySelector("#echart_color" + id);
    const radio = document.querySelector("#radio_" + id);

    let last_clicked_data_index;

    picker.addEventListener("input", function (e) {
      if (last_clicked_data_index !== undefined) {
        option.series[0].data[last_clicked_data_index].itemStyle.color =
          e.target.value;
        chart.setOption(option);

        recolor();
      }
    });

    radio.addEventListener("change", function (e) {
      last_clicked_data_index = e.target.value;
      id = e.target.value;
      recolor();
    });

    const debounce = (func, delay) => {
      let timeoutId;
      return (...args) => {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(() => func.apply(this, args), delay);
      };
    };

    chart.on(
      "click",
      debounce(function (params) {
        // console.log(params);

        picker.value = params.color;

        last_clicked_data_index = params.dataIndex;
        radio.checked = true;

        recolor();
      }, 500)
    );

    function recolor() {
      // switchMetadata(META_METADATA.indexOf(id.replace("echart_","")));

      if (id === "echart_years") {
        switchMetadata(1);
      }

      if (id === "echart_delta") {
        switchMetadata(3);
      }

      if (id === "echart_methods_count") {
        switchMetadata(0);
      }

      if (id === "echart_extensions") {
        switchMetadata(2);
      }

      let COLOR = option.series[0].data.map((d) => d.itemStyle.color);
      scatterplot.set({ colorBy: "valueZ", pointColor: COLOR });

      option.series[0].data.forEach(((d, i) => {
        console.log(`\\definecolor{cy${option.xAxis.data[i]}}{HTML}{${d.itemStyle.color}}`);
      }))
    }

    window.addEventListener("resize", () => {
      chart.resize();
    });
  }

  let state = localStorage.getItem("state");
  if (state) {
    state = JSON.parse(state);

    //reload only if not set through URL (may be null)
    if (ASORT == undefined) {
      document.querySelector("#artifact").value = state.artifact
        ? state.artifact
        : "age";
    }
    if (TSORT == undefined) {
      document.querySelector("#time").value = state.time
        ? state.time
        : "absolute";
    }

    document.querySelector("#transition").value = state.transition
      ? state.transition
      : 2;
    //these may cause the repeated draw warning
    // document.querySelector("#time").dispatchEvent(new Event('input'));
    // document.querySelector("#artifact").dispatchEvent(new Event('input'));

    document.querySelector("#threshold").value = state.threshold;
    document.querySelector("#thresholdMin").value = state.thresholdMin;
    document.querySelector("#thresholdMax").value = state.thresholdMax;

    document.querySelector("#colorMin").value = state.colorMin;
    document.querySelector("#colorMax").value = state.colorMax;
    document.querySelector("#colorThreshold").value = state.colorThreshold;
    document.querySelector("#threshold_txt").value = state.threshold;
    document.querySelector("#threshold_Min_txt").value = state.thresholdMin;
    document.querySelector("#threshold_Max_txt").value = state.thresholdMax;

    // document.querySelector("#colorMin").dispatchEvent(new Event('input'));
    // document.querySelector("#colorMax").dispatchEvent(new Event('input'));
    // document.querySelector("#colorThreshold").dispatchEvent(new Event('input'));
    // document.querySelector("#threshold").dispatchEvent(new Event('input'));
    // document.querySelector("#thresholdMin").dispatchEvent(new Event('input'));
    // document.querySelector("#thresholdMax").dispatchEvent(new Event('input'));
    // document.querySelector("#threshold_txt").dispatchEvent(new Event('input'));
    // document.querySelector("#threshold_Min_txt").dispatchEvent(new Event('input'));
    // document.querySelector("#threshold_Max_txt").dispatchEvent(new Event('input'));

    // console.log(state);
  }

  switchPoints();

  function saveState() {

    function radio2color() {
      return document.querySelector("#radio_echart_years").checked ? "year" :
        document.querySelector("#radio_echart_extensions").checked ? "ext" :
          document.querySelector("#radio_echart_delta").checked ? "delta" :
            document.querySelector("#radio_echart_methods_count").checked ? "metric" : COLOR;
    }

    let state = {
      time: document.querySelector("#time").value,
      artifact: document.querySelector("#artifact").value,
      color: radio2color(),
      transition: document.querySelector("#transition").value,

      threshold: document.querySelector("#threshold").value,
      thresholdMin: document.querySelector("#thresholdMin").value,
      thresholdMax: document.querySelector("#thresholdMax").value,
      colorMin: document.querySelector("#colorMin").value,
      colorMax: document.querySelector("#colorMax").value,
      colorThreshold: document.querySelector("#colorThreshold").value,
    };
    localStorage.setItem("state", JSON.stringify(state));

    window.location.hash = `time=${state.time}&artifact=${state.artifact}&color=${state.color}`;
    // window.history.pushState(state, "Scatevo", `?dataset=${DATASET}&time=${state.time}&artifact=${state.artifact}`);
  }

  window.addEventListener("beforeunload", saveState);

  
  window.setColor = function (color) {
    scatterplot.set({ pointColor: color });
  };

  window.makeGallery = function () {
    function onLoaded() {
      console.log("loaded", index);

      saveAsPng(() => {
        console.log("png saved", index, source[index]);

        if (index < source.length) {
          index++;
          done();
        } else {
          console.log("gallery done");
          document.removeEventListener("loaded", onLoaded);
        }
      });
    }

    document.addEventListener("loaded", onLoaded);

    console.log("gallery start");
    index = 0;
    done();
  }; //makeGallery
});

// function g() {

//   //loop through to generate the pngs for the gallery
//   document.querySelector("#next").dispatchEvent(new Event('click'));
//   document.querySelector("#png").dispatchEvent(new Event('click'));

// }

// g();

function updateValue(val) {
  document.getElementById("current-val").textContent = val;
}

document.addEventListener("DOMContentLoaded", () => {
  const input = document.getElementById("transition");
  updateValue(input.value);
});
