const IMAGES = `
evoscat-age-absolute.png
evoscat-age-normage.png
evoscat-age-normage_center.png
evoscat-age-normage_reverse.png
evoscat-age-normtime.png
evoscat-commit_similar_age-absolute.png
evoscat-commit_similar_age-normage.png
evoscat-commit_similar_age-normage_center.png
evoscat-commit_similar_age-normage_reverse.png
evoscat-commit_similar_age-normtime.png
evoscat-commit_similar_date-absolute.png
evoscat-commit_similar_date-normage.png
evoscat-commit_similar_date-normage_center.png
evoscat-commit_similar_date-normage_reverse.png
evoscat-commit_similar_date-normtime.png
evoscat-commit_similar_normalage-absolute.png
evoscat-commit_similar_normalage-normage.png
evoscat-commit_similar_normalage-normage_center.png
evoscat-commit_similar_normalage-normage_reverse.png
evoscat-commit_similar_normalage-normtime.png
evoscat-count-absolute.png
evoscat-count-normage.png
evoscat-count-normage_center.png
evoscat-count-normage_reverse.png
evoscat-count-normtime.png
evoscat-delta_avg-absolute.png
evoscat-delta_avg-normage.png
evoscat-delta_avg-normage_center.png
evoscat-delta_avg-normage_reverse.png
evoscat-delta_avg-normtime.png
evoscat-delta_class_number-absolute.png
evoscat-delta_class_number-normage.png
evoscat-delta_class_number-normage_center.png
evoscat-delta_class_number-normage_reverse.png
evoscat-delta_class_number-normtime.png
evoscat-delta_methods_wave2_count-absolute.png
evoscat-delta_methods_wave2_count-normage.png
evoscat-delta_methods_wave2_count-normage_center.png
evoscat-delta_methods_wave2_count-normage_reverse.png
evoscat-delta_methods_wave2_count-normtime.png
evoscat-delta_methods_wave_count-absolute.png
evoscat-delta_methods_wave_count-normage.png
evoscat-delta_methods_wave_count-normage_center.png
evoscat-delta_methods_wave_count-normage_reverse.png
evoscat-delta_methods_wave_count-normtime.png
evoscat-delta_sum-absolute.png
evoscat-delta_sum-normage.png
evoscat-delta_sum-normage_center.png
evoscat-delta_sum-normage_reverse.png
evoscat-delta_sum-normtime.png
evoscat-double2_delta2-absolute.png
evoscat-double2_delta2-normage.png
evoscat-double2_delta2-normage_center.png
evoscat-double2_delta2-normage_reverse.png
evoscat-double2_delta2-normtime.png
evoscat-double_delta-absolute.png
evoscat-double_delta-normage.png
evoscat-double_delta-normage_center.png
evoscat-double_delta-normage_reverse.png
evoscat-double_delta-normtime.png
evoscat-double_delta2-absolute.png
evoscat-double_delta2-normage.png
evoscat-double_delta2-normage_center.png
evoscat-double_delta2-normage_reverse.png
evoscat-double_delta2-normtime.png
evoscat-ext_path-absolute.png
evoscat-ext_path-normage.png
evoscat-ext_path-normage_center.png
evoscat-ext_path-normage_reverse.png
evoscat-ext_path-normtime.png
evoscat-file_path-absolute.png
evoscat-file_path-normage.png
evoscat-file_path-normage_center.png
evoscat-file_path-normage_reverse.png
evoscat-file_path-normtime.png
evoscat-first-absolute.png
evoscat-first-normage.png
evoscat-first-normage_center.png
evoscat-first-normage_reverse.png
evoscat-first-normtime.png
evoscat-index-absolute.png
evoscat-index-normage.png
evoscat-index-normage_center.png
evoscat-index-normage_reverse.png
evoscat-index-normtime.png
evoscat-last-absolute.png
evoscat-last-normage.png
evoscat-last-normage_center.png
evoscat-last-normage_reverse.png
evoscat-last-normtime.png
evoscat-methods_count-absolute.png
evoscat-methods_count-normage.png
evoscat-methods_count-normage_center.png
evoscat-methods_count-normage_reverse.png
evoscat-methods_count-normtime.png
evoscat-methods_count_avg-absolute.png
evoscat-methods_count_avg-normage.png
evoscat-methods_count_avg-normage_center.png
evoscat-methods_count_avg-normage_reverse.png
evoscat-methods_count_avg-normtime.png
evoscat-methods_count_first-absolute.png
evoscat-methods_count_first-normage.png
evoscat-methods_count_first-normage_center.png
evoscat-methods_count_first-normage_reverse.png
evoscat-methods_count_first-normtime.png
evoscat-methods_count_last-absolute.png
evoscat-methods_count_last-normage.png
evoscat-methods_count_last-normage_center.png
evoscat-methods_count_last-normage_reverse.png
evoscat-methods_count_last-normtime.png
evoscat-methods_similar_count-absolute.png
evoscat-methods_similar_count-normage.png
evoscat-methods_similar_count-normage_center.png
evoscat-methods_similar_count-normage_reverse.png
evoscat-methods_similar_count-normtime.png
evoscat-methods_wave_count-absolute.png
evoscat-methods_wave_count-normage.png
evoscat-methods_wave_count-normage_center.png
evoscat-methods_wave_count-normage_reverse.png
evoscat-methods_wave_count-normtime.png
evoscat-mid-absolute.png
evoscat-mid-normage.png
evoscat-mid-normage_center.png
evoscat-mid-normage_reverse.png
evoscat-mid-normtime.png
evoscat-ndatesum-absolute.png
evoscat-ndatesum-normage.png
evoscat-ndatesum-normage_center.png
evoscat-ndatesum-normage_reverse.png
evoscat-ndatesum-normtime.png
evoscat-short_extension-absolute.png
evoscat-short_extension-normage.png
evoscat-short_extension-normage_center.png
evoscat-short_extension-normage_reverse.png
evoscat-short_extension-normtime.png
evoscat-wave-absolute.png
evoscat-wave-normage.png
evoscat-wave-normage_center.png
evoscat-wave-normage_reverse.png
evoscat-wave-normtime.png
`.split("\n").filter((i) => i.length > 0).map((i) => i.trim());

function init(dataset) {

    let gallery = document.querySelector("section.gallery");

    if (!gallery) {
        console.error("Gallery element not found");
        return;
    }

    function load(colors) {

        IMAGES.forEach((src) => {
            colors.forEach(color => {

                let a = document.createElement("a");
                a.href = src2href(src);
                let img = document.createElement("img");
                img.onerror = () => console.error(`Failed to load image: ${img.src}`);
                img.src = `img-${color}/` + src.replace("evoscat-", "evoscat-" + dataset + "-");    
                a.appendChild(img);
                gallery.appendChild(a);

                console.log(src, a.href); // Debug

                function src2href(src) {
                    let parts = src.split("-");

                    // img/scatevo_cpython_absolute_age.png

                    let artifact = parts[1];
                    let time = parts[2].replace('.png', '');

                    let href = "/evoscat/?dataset=" + dataset + "#time=" + time + "&artifact=" + artifact + "&color=" + color;

                    console.log(src, href);

                    return href;

                };

            });

        });

    }

    load(["delta"]);
    load(["year"]);
    load(["ext"]);
    load(["delta", "year", "ext"]);

}
