// process.stdin.setEncoding('utf8');

const StringDecoder = require('string_decoder').StringDecoder;
let decoder = new StringDecoder('utf-8');

let buffer = Buffer.from('');
let expecting = 'header';
let remainingContentBytes = 0;
// let remainingContentChars = 0;
let currentObject = {};

// let readBytes = 0;
// let readChars = 0;

// Event listener for incoming data chunks
process.stdin.on('data', (chunk) => {
    let chunk_length = chunk.length; //bytes

    // readBytes += chunk_length;

    // let decoded_chunk = decoder.write(chunk); //characters

    // readChars += decoded_chunk.length;

    // if (chunk_length != decoded_chunk.length) {
    //     console.log("mismatch", chunk_length,decoded_chunk.length);
    // }

    buffer = Buffer.concat([buffer, chunk]);

    // buffer += decoded_chunk;

    while (buffer.length > 0) {
        if (expecting === 'header') {
            const newlineIndex = buffer.indexOf('\n');
            if (newlineIndex === -1) break;

            const headerLine = decoder.write(buffer.subarray(0, newlineIndex));
            buffer = buffer.subarray(newlineIndex + 1);

            const parts = headerLine.split(' ');

            const sha = parts[0];
            const typeOrMissing = parts[1];

            if (typeOrMissing === 'missing') {
                console.log(`${sha} -1 -1`);
                // console.warn(`Object ${sha} is missing.`);
                // optionally emit an event or handle however you like
                // this may hang if the last entry has been removed
                continue; // move on to next header
            }

            const size = parseInt(parts[2], 10);
            currentObject = { sha, type: typeOrMissing, size };
            remainingContentBytes = size;

            expecting = 'content';
        }

        if (expecting === 'content') {
            if (buffer.length < remainingContentBytes) break;

            const content = decoder.write(buffer.subarray(0, remainingContentBytes));
            buffer = buffer.subarray(remainingContentBytes);

            currentObject.content = content;
            //   console.log(`Object:`, currentObject); // or handle however needed

            if (currentObject.sha.length > 0) {
                console.log(`${currentObject.sha} ${currentObject.size} ${content.split("\n").length}`);

                currentObject = {};
            }

            expecting = 'header';
        }
    }
});

// Event listener for stream end
process.stdin.on('end', () => {
    if (buffer.length > 0) {
        console.log(`Remaining: ${buffer}`);
    }
    // console.log('Done reading from stdin.');
});
