import commonjs from '@rollup/plugin-commonjs';
import { terser } from 'rollup-plugin-terser';
import { nodeResolve } from '@rollup/plugin-node-resolve';
import copy from 'rollup-plugin-copy';

export default {
    input: 'script.js',
    output: [{
            dir: 'dist',
            format: 'es'
        },
        {
            file: 'dist/script.js',
            format: 'es',
            plugins: [nodeResolve()]
        }
    ],
    plugins: [nodeResolve(),commonjs(),
    copy({
      targets: [
        { src: 'node_modules/echarts/dist/echarts.min.js', dest: 'dist' }
      ]
    })
    ]
};``