const fs = require('fs-extra');

const INPUT = process.argv[2];

const time_log = ('' + fs.readFileSync(INPUT+".time.log")).trim();
console.log(time_log.length);

const input_log = ('' + fs.readFileSync(INPUT+".input.log")).trim();
console.log(input_log.length);
const output_log = ('' + fs.readFileSync(INPUT+".output.log")).trim();
console.log(output_log.length);

const time_a = time_log.split("\n").map(l=>l.trim());

const time_index = {}
const author_index = {}
time_a.forEach(line => {

    let parts = line.split(' ');

    if (line.indexOf(",") > 0)  {
        parts = line.split(",");

        const commitHash = parts[0];

        const timestamp = parts[parts.length-1];

        time_index[commitHash] = timestamp;

        parts.pop();
        parts.shift();

        author_index[commitHash] = parts.join(",");

    } else {

        const commitHash = parts[0];

        const timestamp = parts.slice(1).join(' ');

        time_index[commitHash] = timestamp;

    }
})

const input_a = input_log.split("\n");
const output_a = output_log.split("\n");

let result = [[
    'sha',
    'commit_date',
    'filename',
    'bytes',
    'loc',
    'author'
]];

let has_authors = Object.keys(author_index).length > 0;
if (!has_authors) {
    result[0].pop();
}

input_a.forEach((line,i)=>{

    const parts = line.split(':');

    const commitHash = parts[0];

    const filename = parts.slice(1).join(':');

    const output_parts = output_a[i].split(" ");

    let entry = [
        commitHash,
        time_index[commitHash],
        '"'+filename.replaceAll("\"","\"\"")+'"',
        output_parts[1],
        output_parts[2]
    ]

    if (has_authors) {
        entry.push('"'+author_index[commitHash].replaceAll("\"","\"\"")+'"')
    }

    result.push(entry);

})

try {
    fs.writeFileSync('commit_file_sizes_'+INPUT.replace("output/","") + '.join.csv', result.map(l=>l.join(",")).join("\n"));

} catch(e) {

    //write line by line if CSV does not fit in a string

    result.map(l=>l.join(",")).forEach(line => {

        fs.appendFileSync('commit_file_sizes_'+INPUT.replace("output/","") + '.join.csv', line+"\n");

    });

}

