const readline = require('readline');
const { execSync } = require('child_process');

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout,
  terminal: false // disable stdout prompt behavior
});

const REPO = process.argv[2];

rl.on('line', (line) => {

  line = line.trim();

    if (line.length === 0) return;

    const parts = line.split(',');

    const commitHash = parts[0];

    try {

        const output = execSync(`git diff-tree --no-commit-id --name-only -r ${commitHash}`, {cwd: REPO, timeout: 3333}).toString();

        output.split('\n').filter(line => line.trim() !== '').forEach(file => {
            console.log(`${commitHash}:${file}`);
        })
    } catch (err) {
        console.error(`Failed to get file list at ${commitHash}: ${err}`);
    }

//   console.log(`Received line: ${line}`);
});