import { parse } from "csv-parse";

import fs from 'fs-extra';

const parser = parse({ columns: true,
    skip_empty_lines: true});

let records = ['api_spec_id,commit_date,methods_count'];

parser.on("readable", function () {
  let record;
  while ((record = parser.read()) !== null) {
    records.push([record.api_spec_id, record.commit_date, record["structureSize.operations"]].join(','));
  }
  console.log(records.length);
});


const INPUT_CSV = 'oas.commits.metrics.csv';

fs.createReadStream(INPUT_CSV).pipe(parser);

parser.on("end", function () {

    fs.writeFileSync('oas.commits.metrics.clean.csv', records.join('\n'));

    console.log('CSV file written successfully as oas.commits.metrics.clean.csv');

});